/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers.epson;

import ro.atreides.print.printers.AsciiPrinter;
import ro.atreides.utils.gui.Validators;

public class TMU220
extends AsciiPrinter {
    protected String bonFont;
    protected String titleFont;

    public TMU220() {
        this.bonFont = this.config.getString("bonFont");
        this.titleFont = this.config.getString("titleFont");
        if (!Validators.correctString(this.bonFont)) {
            this.bonFont = "normal";
        }
        if (!Validators.correctString(this.titleFont)) {
            this.titleFont = "normal";
        }
    }

    @Override
    protected String getTitleStartFontSelection() {
        String s = "";
        if (this.titleFont.equalsIgnoreCase("tall")) {
            s = s + '\u001b';
            s = s + "!";
            s = s + '\u0010';
        }
        return s;
    }

    @Override
    public String getTitleStopFontSelection() {
        String s = "";
        if (this.titleFont.equalsIgnoreCase("tall")) {
            s = s + '\u001b';
            s = s + "!";
            s = s + '\u0001';
        }
        return s;
    }

    @Override
    protected String getBonStartFontSelection() {
        int x = 0;
        if (this.bonFont.equals("tall")) {
            x = 16;
        } else if (this.bonFont.equals("wide")) {
            x = 32;
        } else if (this.bonFont.equals("double")) {
            x = 48;
        }
        String s = "";
        s = s + '\u001b';
        s = s + "!";
        s = s + (char)x;
        return s;
    }

    @Override
    protected String getCharacterTableSelection() {
        String s = "";
        s = s + '\u001b';
        s = s + "t";
        s = s + '\u0000';
        return s;
    }

    @Override
    public String getAutocutterSequence() {
        String s = "";
        s = s + '\u001d';
        s = s + "V";
        s = s + 'B';
        s = s + '\u0000';
        return s;
    }

    @Override
    public String getBonStopFontSelection() {
        String s = "";
        s = s + '\u001b';
        s = s + "!";
        s = s + '\u0001';
        return s;
    }

    @Override
    public String getTotalStartFontSelection() {
        int x = 16;
        String s = "";
        s = s + '\u001b';
        s = s + "!";
        s = s + (char)x;
        return s;
    }

    @Override
    public String getTotalStopFontSelection() {
        String s = "";
        s = s + '\u001b';
        s = s + "!";
        s = s + '\u0001';
        return s;
    }

    @Override
    public int getTallFontCharsPerLine() {
        return this.config.getInt("printerEpsonTmu220TallCharsPerLine", 32);
    }

    @Override
    protected String getLogoCommand() {
        return "";
    }
}

