/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.tests;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.RepaintManager;
import ro.atreides.utils.Logger;
import sun.print.PageableDoc;

public class PrintUtilities
implements Printable,
Pageable {
    private Component componentToBePrinted;

    public static void printComponent(PrintRequestAttributeSet attrSet, PrintService printer, DocFlavor flavor, Component c) {
        new PrintUtilities(c).print(attrSet, printer, flavor, c);
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pf = new PageFormat();
        return pf;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public void print(PrintRequestAttributeSet attrSet, PrintService printer, DocFlavor flavor, Component c) {
        PageableDoc myDoc = new PageableDoc(this);
        DocPrintJob job = printer.createPrintJob();
        try {
            job.print(myDoc, attrSet);
        }
        catch (PrintException pe) {
            Logger.logException(this, (Exception)pe);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(g2d);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

