/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.productie.MasaProductie;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.productie.ProductieInterface;
import ro.atreides.productie.db.ProductieDao;
import ro.atreides.productie.gui.ProductieWaiterInterface;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.users.WaiterSelection2Interface;
import ro.atreides.users.gui.WaitersSelection2;
import ro.atreides.utils.AtrFloat;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.messaging.Messenger;
import ro.atreides.utils.multilang.LangRoAll;

public class ProductieLogic
extends EventGenerator {
    private static ProductieLogic instance;
    private ConnectionPool pool;
    private ProductieInterface prodInterface;
    public static ProductieWaiterInterface waiterInterface;
    private int productieTimeout;
    private int productieAlertSeconds = 30;
    private String productieAlertCommand = "";
    private Vector readIds = new Vector();
    private Vector writeIds = new Vector();
    private Vector showStatuses = new Vector();
    private Vector modifyStatuses = new Vector();
    private Vector free1Filters = new Vector();
    private long lastAlert = System.currentTimeMillis();
    private boolean servitTriggersNota;
    private boolean servitTriggersIncasat;
    private boolean controllerMode;
    private boolean cumulateProducts;

    private ProductieLogic() {
        this.pool = ConnectionPool.getInstance();
        waiterInterface = new ProductieWaiterInterface(){

            @Override
            public boolean canModifyProductie(int idOwner, int currentUser, int idSectie) {
                return ProductieLogic.this.writeIds.contains(idSectie);
            }
        };
    }

    public static synchronized ProductieLogic getInstance() {
        if (instance == null) {
            instance = new ProductieLogic();
        }
        return instance;
    }

    private synchronized ProductieDao getProductieDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ProductieDao dao = null;
        while (dao == null) {
            dao = (ProductieDao)this.pool.getDao(ProductieDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ProductieDao.class.getName(), connection);
        }
        return dao;
    }

    public void setControllerMode(boolean controllerMode) {
        this.controllerMode = controllerMode;
    }

    public void setServitTriggersIncasat(boolean servitTriggersIncasat) {
        this.servitTriggersIncasat = servitTriggersIncasat;
    }

    public void setServitTriggersNota(boolean servitTriggersNota) {
        this.servitTriggersNota = servitTriggersNota;
    }

    public Vector getReadIds() {
        return this.readIds;
    }

    public void setReadIds(Vector readIds) {
        this.readIds = readIds;
    }

    public Vector getWriteIds() {
        return this.writeIds;
    }

    public void setWriteIds(Vector writeIds) {
        this.writeIds = writeIds;
    }

    public void setShowStatuses(Vector showStatuses) {
        this.showStatuses = showStatuses;
    }

    public void setModifyStatuses(Vector modifyStatuses) {
        this.modifyStatuses = modifyStatuses;
    }

    public void setFree1Filters(Vector free1Filters) {
        this.free1Filters = free1Filters;
    }

    public ProductieInterface getProdInterface() {
        return this.prodInterface;
    }

    public void setProdInterface(ProductieInterface prodInterface) {
        this.prodInterface = prodInterface;
    }

    public void addProductieNoCommit(String free1, String free2, int idUser, int idSectie, int idSubcategory, int idProdus, int idPlatou, double cantitate, double pret, String detalii, int idOrder, long dateadd) throws SQLException {
        this.getProductieDao().addProductie(free1, free2, idUser, idSectie, idSubcategory, idProdus, idPlatou, cantitate, detalii, pret, idOrder, new Timestamp(dateadd));
    }

    public void updateDateForOrderIdNoCommit(Timestamp newDate, int idOrder) throws SQLException {
        this.getProductieDao().updateDateForOrderId(newDate, idOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDay() {
        try {
            this.getProductieDao().processDay();
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private Timestamp getStartAt() {
        long millis = 0L;
        Timestamp startAt = new Timestamp(DateUtils.addMillisToDate(new Date(), millis).getTime());
        return startAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllForSectii(Vector idSectii, String masa, String servire) {
        Vector<Object> result = new Vector();
        try {
            result = this.getProductieDao().getAllForSectieAndMasaAndServire(idSectii, masa, servire, this.getStartAt());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllForMasa(Vector<Integer> sectii, String masa) {
        Vector<Object> result = new Vector<Object>();
        try {
            Vector servires = this.getProductieDao().getOrdineServire(masa);
            for (String servire : servires) {
                result.add(servire);
                Vector<ProductieEntry> items = this.getProductieDao().getAllForSectieAndMasaAndServire(sectii, masa, servire, this.getStartAt());
                for (ProductieEntry prodEntry : items) {
                    if (!this.showStatuses.contains(prodEntry.getStatus())) continue;
                    result.add(prodEntry);
                }
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ProductieEntry> getByWaiter(int idWaiter, Vector sectii) {
        Vector<ProductieEntry> result = new Vector<ProductieEntry>();
        try {
            int idSectie1;
            int idSectie2 = idSectie1 = ((Integer)sectii.get(0)).intValue();
            if (sectii.size() >= 2) {
                idSectie2 = (Integer)sectii.get(1);
            }
            result = this.getProductieDao().getByWaiter(idWaiter, idSectie1, idSectie2, this.cumulateProducts);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptata(ProductieEntry pe) {
        if (pe.getIdProductie() <= 0) {
            try {
                this.setStatusToMany(7, pe.getIdProduct(), pe.getDetalii(), pe.getStatus());
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        } else {
            this.acceptata(pe.getIdProductie(), pe.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptata(int idProductie, int oldStatus) {
        try {
            this.setStatus(7, idProductie, oldStatus);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuzata(ProductieEntry pe, Vector idSectii) {
        if (pe.getIdProductie() <= 0) {
            try {
                this.setStatusToMany(8, pe.getIdProduct(), pe.getDetalii(), pe.getStatus());
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        } else {
            this.refuzata(pe.getIdProductie(), idSectii, pe.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuzata(int idProductie, Vector idSectii, int oldStatus) {
        try {
            this.setStatus(8, idProductie, oldStatus);
            ProductieEntry pe = this.getProductieDao().getById(idProductie);
            String message = Utils.getString3Decimals(pe.getCantitate()) + " * " + pe.getProdus() + " REFUZATA";
            long expiry = System.currentTimeMillis() + 60000L;
            Messenger.getInstance().addMessage(this.getChannel(idProductie, (Integer)idSectii.get(0), pe.getIdUser()), message, expiry);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inLucru(ProductieEntry pe) {
        if (pe.getIdProductie() <= 0) {
            try {
                this.setStatusToMany(6, pe.getIdProduct(), pe.getDetalii(), pe.getStatus());
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        } else {
            this.inLucru(pe.getIdProductie(), pe.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inLucru(int idProductie, int oldStatus) {
        try {
            this.setStatus(6, idProductie, oldStatus);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminata(ProductieEntry pe, Vector idSectii) {
        if (pe.getIdProductie() <= 0) {
            try {
                this.setStatusToMany(5, pe.getIdProduct(), pe.getDetalii(), pe.getStatus());
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        } else {
            this.terminata(pe.getIdProductie(), idSectii, pe.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminata(Vector<ProductieEntry> entries) {
        try {
            Hashtable<Integer, Integer> usersToNotify = new Hashtable<Integer, Integer>();
            for (ProductieEntry entry : entries) {
                this.setStatus(5, entry.getIdProductie(), entry.getStatus());
                usersToNotify.put(entry.getIdUser(), entry.getIdUser());
            }
            long expiry = System.currentTimeMillis() + 1800000L;
            for (Integer idUser : usersToNotify.keySet()) {
                Messenger.getInstance().addMessage("pda_" + idUser, "Bucatarie", expiry);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminata(int idProductie, Vector idSectii, int oldStatus) {
        try {
            this.setStatus(5, idProductie, oldStatus);
            ProductieEntry pe = this.getProductieDao().getById(idProductie);
            String message = Utils.getString3Decimals(pe.getCantitate()) + " * " + pe.getProdus() + " PREPARATA";
            long expiry = System.currentTimeMillis() + 1800000L;
            Messenger.getInstance().addMessage(this.getChannel(idProductie, (Integer)idSectii.get(0), pe.getIdUser()), message, expiry);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servita(Vector<ProductieEntry> selectedItems, String masa, String ospatar) {
        try {
            this.servitaNoCommit(selectedItems, masa, ospatar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void servitaNoCommit(Vector<ProductieEntry> selectedItems, String masa, String ospatar) throws SQLException {
        if (selectedItems.size() > 0) {
            Vector<PrinterBonItem> livrareItems = new Vector<PrinterBonItem>();
            double totalBon = 0.0;
            Hashtable<Integer, Integer> usersToNotify = new Hashtable<Integer, Integer>();
            for (ProductieEntry item : selectedItems) {
                this.setStatus(4, item.getIdProductie(), item.getStatus());
                PrinterBonItem pbi = new PrinterBonItem(item.getProdus(), Utils.getString2Decimals(item.getCantitate()), Utils.getString2Decimals(item.getValoare()), "", item.getIdSubcategory(), null);
                totalBon += item.getValoare();
                livrareItems.add(pbi);
                usersToNotify.put(item.getIdUser(), item.getIdUser());
            }
            long expiry = System.currentTimeMillis() + 1800000L;
            for (Integer idUser : usersToNotify.keySet()) {
                Messenger.getInstance().addMessage("pda_" + idUser, "Bucatarie", expiry);
            }
            String dataBon = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
            PrintLogic.getInstance().printBonLivrare(livrareItems, ospatar, masa, dataBon, totalBon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean servitaQuick(Vector<ProductieEntry> selectedItems) {
        if (selectedItems.size() > 0) {
            Hashtable<String, Vector<ProductieEntry>> splitByTableAndUser = new Hashtable<String, Vector<ProductieEntry>>();
            boolean mustCommit = true;
            try {
                for (ProductieEntry pe : selectedItems) {
                    int idUser = pe.getIdUser();
                    User u = UsersLogic.getInstance().getUserByIdNoCommit(idUser);
                    String masa = pe.getLiber();
                    String key = masa + "_" + u.getName() + "_" + pe.getIdOrder();
                    Vector<ProductieEntry> items = (Vector<ProductieEntry>)splitByTableAndUser.get(key);
                    if (items == null) {
                        items = new Vector<ProductieEntry>();
                    }
                    items.add(pe);
                    splitByTableAndUser.put(key, items);
                }
                String dataBon = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                for (String key : splitByTableAndUser.keySet()) {
                    Vector items = (Vector)splitByTableAndUser.get(key);
                    Vector data = Utils.splitString(key, '_');
                    Vector<PrinterBonItem> livrareItems = new Vector<PrinterBonItem>();
                    String masa = (String)data.get(0);
                    String numeOspatar = (String)data.get(1);
                    String orderId = (String)data.get(2);
                    double totalBon = 0.0;
                    int idOrder = Integer.parseInt(orderId);
                    if (this.servitTriggersIncasat || this.servitTriggersNota) {
                        final AtrFloat idUser = new AtrFloat();
                        idUser.setValue(-1.0);
                        WaitersSelection2 waitersPanel = new WaitersSelection2(null, this.controllerMode, Config.getInstance().getBooleanNoCommit("requestPasswordForWaitersSelection"), Config.getInstance().getBooleanNoCommit("allowPasswords"), Config.getInstance().getIntNoCommit("waitersPerLine"), Config.getInstance().getIntNoCommit("codAutentificareLength"), Config.getInstance().getIntNoCommit("touchSelectorFontSize"));
                        GridBagConstraints c = new GridBagConstraints();
                        c.fill = 1;
                        c.anchor = 10;
                        c.insets = new Insets(1, 1, 1, 1);
                        c.weightx = 1.0;
                        c.weighty = 1.0;
                        c.gridx = 0;
                        c.gridy = 0;
                        final JDialog dia2 = DialogUtils.getJDialog(waitersPanel, GuiUtils.currentFrame, LangRoAll.utilizator, 1.1);
                        waitersPanel.setParent(new WaiterSelection2Interface(){

                            @Override
                            public void waiterSelected(User loginUser) {
                                if (loginUser != null) {
                                    idUser.setValue(loginUser.getId());
                                }
                                dia2.dispose();
                            }
                        });
                        waitersPanel.setTipLocatie(1);
                        waitersPanel.refreshButtons();
                        dia2.setVisible(true);
                        boolean bl = mustCommit = idUser.getValue() > 0.0;
                        if (mustCommit) {
                            int userInt = (int)idUser.getValue();
                            if (this.servitTriggersNota) {
                                boolean bl2 = mustCommit = mustCommit && this.prodInterface.notaFromProductie(idOrder, userInt);
                            }
                            if (this.servitTriggersIncasat) {
                                boolean bl3 = mustCommit = mustCommit && this.prodInterface.incasatFromProductie(idOrder, userInt);
                            }
                        }
                    }
                    if (!mustCommit) continue;
                    for (ProductieEntry item : items) {
                        this.setStatus(4, item.getIdProductie(), item.getStatus());
                        PrinterBonItem pbi = new PrinterBonItem(item.getProdus(), Utils.getString2Decimals(item.getCantitate()), Utils.getString2Decimals(item.getValoare()), "", item.getIdSubcategory(), null);
                        totalBon += item.getValoare();
                        livrareItems.add(pbi);
                    }
                    PrintLogic.getInstance().printBonLivrare(livrareItems, numeOspatar, masa, dataBon, totalBon);
                }
                if (mustCommit) {
                    this.pool.commit();
                } else {
                    this.pool.rollBack();
                }
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
            if (!mustCommit) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Utilizator incorect", LangRoAll.operatieEsuata);
            }
            return mustCommit;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servita(Vector<ProductieEntry> selectedItems) {
        if (selectedItems.size() > 0) {
            Hashtable<String, Vector<ProductieEntry>> splitByTableAndUser = new Hashtable<String, Vector<ProductieEntry>>();
            try {
                for (ProductieEntry item : selectedItems) {
                    Vector<Integer> ids = this.getProductieDao().getIdsForProductDetaliiStatus(item.getIdProduct(), item.getDetalii(), item.getStatus());
                    for (Integer id : ids) {
                        ProductieEntry pe = this.getProductieDao().getById(id);
                        int idUser = pe.getIdUser();
                        User u = UsersLogic.getInstance().getUserByIdNoCommit(idUser);
                        String masa = pe.getLiber();
                        String key = masa + "_" + u.getName();
                        Vector<ProductieEntry> items = (Vector<ProductieEntry>)splitByTableAndUser.get(key);
                        if (items == null) {
                            items = new Vector<ProductieEntry>();
                        }
                        items.add(pe);
                        splitByTableAndUser.put(key, items);
                    }
                }
                for (String key : splitByTableAndUser.keySet()) {
                    Vector items = (Vector)splitByTableAndUser.get(key);
                    Vector data = Utils.splitString(key, '_');
                    String masa = (String)data.get(0);
                    String numeOspatar = (String)data.get(1);
                    this.servitaNoCommit(items, masa, numeOspatar);
                }
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        }
    }

    private String getChannel(int idProductie, int idSectie, int idUser) {
        return "productie_" + idSectie + "_" + idUser + "_" + idProductie;
    }

    private void setStatus(int status, int idProductie, int oldStatus) throws SQLException {
        if (this.modifyStatuses.size() <= 0 || this.modifyStatuses.contains(oldStatus)) {
            this.getProductieDao().updateStatus(status, idProductie, -1, -1);
        }
    }

    private void setStatusToMany(int newStatus, int idProdus, String detalii, int oldStatus) throws SQLException {
        this.getProductieDao().updateStatusToMany(newStatus, idProdus, detalii, oldStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishByUserAndStatus(int idUser, int oldStatus) {
        try {
            if (this.writeIds.size() > 0) {
                int id1;
                int id2 = id1 = ((Integer)this.writeIds.get(0)).intValue();
                if (this.writeIds.size() > 1) {
                    id2 = (Integer)this.writeIds.get(1);
                }
                Vector<ProductieEntry> allProductiiToDelete = this.getProductieDao().getByWaiter(idUser, id1, id2, false);
                for (int i = 0; i < allProductiiToDelete.size(); ++i) {
                    ProductieEntry productieEntry = allProductiiToDelete.elementAt(i);
                    this.getProductieDao().updateStatus(4, productieEntry.getIdProductie(), idUser, oldStatus);
                }
                this.pool.commit();
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteAll() throws SQLException {
        this.getProductieDao().deleteAll();
    }

    public Vector<MasaProductie> getComenzi(Vector idSectie) {
        return this.getComenzi(idSectie, this.showStatuses, this.free1Filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<MasaProductie> getComenzi(Vector idSectie, Vector<Integer> showStatuses, Vector<String> free1Filters) {
        Vector<MasaProductie> comenzi = new Vector<MasaProductie>();
        try {
            Timestamp startAt = this.getStartAt();
            Vector<MasaProductie> allComenzi = this.getProductieDao().getComenzi(idSectie, showStatuses, startAt);
            Map<String, MasaProductie> temp = Collections.synchronizedMap(new LinkedHashMap());
            for (MasaProductie mp : allComenzi) {
                String key = mp.getMasa() + "_" + mp.getUser() + "_" + mp.getUserName();
                boolean matchedForFree1Filters = false;
                if (free1Filters.size() == 0) {
                    matchedForFree1Filters = true;
                }
                for (String free1Filter : free1Filters) {
                    if (!mp.getMasa().matches(".*" + free1Filter + ".*")) continue;
                    matchedForFree1Filters = true;
                    break;
                }
                if (!matchedForFree1Filters) continue;
                int currentStatus = mp.getStatus();
                if (mp.isNou()) {
                    mp.setAlertLevel(MasaProductie.ALERT_LEVELS.PRODUSE_NEVAZUTE.getLevel());
                } else {
                    switch (currentStatus) {
                        case 6: {
                            mp.setAlertLevel(MasaProductie.ALERT_LEVELS.ALL_PROCESSING.getLevel());
                            break;
                        }
                        case 1: {
                            mp.setAlertLevel(MasaProductie.ALERT_LEVELS.PRODUSE_NEVAZUTE.getLevel());
                            break;
                        }
                        case 5: {
                            mp.setAlertLevel(MasaProductie.ALERT_LEVELS.ALL_GATA.getLevel());
                            break;
                        }
                        case 7: {
                            mp.setAlertLevel(MasaProductie.ALERT_LEVELS.ALL_PROCESSING.getLevel());
                        }
                    }
                }
                MasaProductie existing = (MasaProductie)temp.get(key);
                if (existing != null) {
                    int existingAlertLevel = existing.getAlertLevel();
                    if (existingAlertLevel >= mp.getAlertLevel()) continue;
                    existing.setAlertLevel(mp.getAlertLevel());
                    continue;
                }
                temp.put(key, mp);
            }
            for (String s : temp.keySet()) {
                comenzi.add((MasaProductie)temp.get(s));
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return comenzi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void comandaVazuta(Vector idSectii, String free1) {
        try {
            this.getProductieDao().comandaVazuta(idSectii, free1);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetails(int idProductie) {
        String s = "";
        try {
            ProductieEntry result = this.getProductieDao().getById(idProductie);
            if (result != null) {
                s = this.prodInterface.getDetails(result.getIdProduct());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return s;
    }

    public Vector getWaiters() {
        return this.prodInterface.getWaiters();
    }

    public int getProductieTimeout() {
        return this.productieTimeout;
    }

    public void setProductieTimeout(int productieTimeout) {
        this.productieTimeout = productieTimeout;
    }

    public int getProductieAlertSeconds() {
        return this.productieAlertSeconds;
    }

    public void setProductieAlertSeconds(int productieAlertSeconds) {
        this.productieAlertSeconds = productieAlertSeconds;
    }

    public String getProductieAlertCommand() {
        return this.productieAlertCommand;
    }

    public void setProductieAlertCommand(String productieAlertCommand) {
        this.productieAlertCommand = productieAlertCommand;
    }

    public void triggerAlerts(Vector newData) {
        if (this.productieAlertSeconds > 0 && Validators.correctString(this.productieAlertCommand) && this.lastAlert + (long)(this.productieAlertSeconds * 1000) < System.currentTimeMillis()) {
            boolean mustAlert = false;
            for (int i = 0; i < newData.size(); ++i) {
                MasaProductie masaProductie = (MasaProductie)newData.elementAt(i);
                if (!masaProductie.isNou()) continue;
                mustAlert = true;
                break;
            }
            if (mustAlert) {
                try {
                    Process onlineProcess = Runtime.getRuntime().exec(this.productieAlertCommand);
                    this.lastAlert = System.currentTimeMillis();
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
        }
    }

    public boolean isCumulateProducts() {
        return this.cumulateProducts;
    }

    public void setCumulateProducts(boolean cumulateProducts) {
        this.cumulateProducts = cumulateProducts;
    }
}

