/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.productie.MasaProductie;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;

public class ProductieDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement updateStatus;
    private PreparedStatement getAllForSectieAndFree1AndFree2;
    private PreparedStatement processDay;
    private PreparedStatement getById;
    private PreparedStatement deleteAll;
    private PreparedStatement getComenzi;
    private PreparedStatement getOrdineServire;
    private PreparedStatement comandaVazuta;
    private PreparedStatement updateStatusToMany;
    private PreparedStatement getIdsForProductDetaliiAndStatus;
    private PreparedStatement updateDateForOrderId;
    String workingStatus = "1,7,6,5";
    private Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public ProductieDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.updateDateForOrderId = this.connection.prepareStatement("update productie set data = ? where id_order = ?");
        this.comandaVazuta = this.connection.prepareStatement("update productie set viewed = 9 where viewed = 1 and ( id_sectie = ? OR id_sectie = ? ) and free1 = ?");
        this.getOrdineServire = this.connection.prepareStatement("select distinct free2 from productie where free1 = ? and status in (" + this.workingStatus + ")");
        this.getComenzi = this.connection.prepareStatement("select free1, login, productie.viewed as vazut, productie.status as stare, users.name as nume_user from productie inner join users on id_user = users.id where productie.status in (" + this.workingStatus + ")" + " and ( productie.id_Sectie = ? OR productie.id_sectie = ?) " + " and productie.data <= ?" + " order by data, free1");
        this.add = this.connection.prepareStatement("insert into productie(free1, free2, id_user, id_sectie, id_subcategorie, id_produs, id_platou, cantitate, detalii, status, viewed, valoare, id_order, data) values (?, ?, ?, ?, ?, ?, ?, ?, ?, 1, 1, ?, ?, ?)");
        String s = "select productie.*, categories.label as categorie, subcategories.label as subcategorie, products.sectie_label as nume_produs from productie inner join categories on productie.id_sectie = categories.id inner join subcategories on productie.id_subcategorie = subcategories.id inner join products on productie.id_produs = products.id";
        this.getAllForSectieAndFree1AndFree2 = this.connection.prepareStatement(s + " where productie.status in (" + this.workingStatus + ")" + " and ( id_sectie = ? OR id_sectie = ? )" + " and free1 = ?" + " and free2 = ?" + " and productie.data <= ?" + " order by productie.id_platou, productie.data");
        this.getById = this.connection.prepareStatement(s + " where productie.id = ?");
        this.processDay = this.connection.prepareStatement("update productie set status = 3 where status != 2");
        this.updateStatus = this.connection.prepareStatement("update productie set status = ?  where (id = ? or ? = -1) and (id_user = ? or ? = -1) and (status = ? or ? = -1)");
        this.deleteAll = this.connection.prepareStatement("delete from productie");
        this.updateStatusToMany = this.connection.prepareStatement("update productie set status = ?, viewed = 9 where id_produs = ? and detalii = ? and status = ?");
        this.getIdsForProductDetaliiAndStatus = this.connection.prepareStatement("select * from productie where id_produs = ? and detalii = ? and status = ?");
    }

    public void updateDateForOrderId(Timestamp newDate, int idOrder) throws SQLException {
        this.updateDateForOrderId.setTimestamp(1, newDate);
        this.updateDateForOrderId.setInt(2, idOrder);
        this.updateDateForOrderId.execute();
    }

    public void comandaVazuta(Vector idSectii, String free1) throws SQLException {
        this.comandaVazuta.setInt(1, (Integer)idSectii.get(0));
        this.comandaVazuta.setInt(2, (Integer)idSectii.get(1));
        this.comandaVazuta.setString(3, free1);
        this.comandaVazuta.execute();
    }

    public void deleteAll() throws SQLException {
        this.deleteAll.execute();
    }

    public ProductieEntry getById(int idProductie) throws SQLException {
        ProductieEntry result = null;
        this.getById.setInt(1, idProductie);
        ResultSet rs = this.getById.executeQuery();
        if (rs.next()) {
            result = this.getFromRS(rs, -2, false);
        }
        rs.close();
        return result;
    }

    public Vector<ProductieEntry> getByWaiter(int idWaiter, int idSectie1, int idSectie2, boolean summQuantity) throws SQLException {
        Vector<ProductieEntry> result = new Vector<ProductieEntry>();
        String s = "select";
        if (!summQuantity) {
            s = s + " productie.free1, productie.id_user, ";
        }
        s = s + " productie.id_sectie, productie.id_subcategorie, productie.id_produs, productie.valoare,";
        if (!summQuantity) {
            s = s + " productie.id_platou, productie.id_order, ";
        }
        s = summQuantity ? s + " sum(productie.cantitate) as cantitate," : s + " productie.cantitate,";
        s = s + " productie.detalii, productie.status,";
        if (!summQuantity) {
            s = s + " productie.data, productie.id,";
        }
        s = s + " categories.label as categorie, subcategories.label as subcategorie, products.sectie_label as nume_produs from productie inner join categories on productie.id_sectie = categories.id inner join subcategories on productie.id_subcategorie = subcategories.id inner join products on productie.id_produs = products.id where 1=1 ";
        if (!summQuantity && idWaiter > 0) {
            s = s + " and id_user = " + idWaiter;
        }
        s = s + " and ( id_sectie = " + idSectie1 + " OR id_sectie = " + idSectie2 + " )";
        s = s + " and productie.status in ( " + this.workingStatus + " ) ";
        s = summQuantity ? s + " group by id_sectie, id_subcategorie, id_produs, detalii, productie.status, categories.label, subcategories.label, products.sectie_label, productie.valoare" : s + " order by productie.data";
        ResultSet rs = SqlUtils.executeQuery(s, ConnectionPool.getInstance().requestConnection().getConnection());
        while (rs.next()) {
            ProductieEntry pe = this.getFromRS(rs, -2, summQuantity);
            result.add(pe);
        }
        rs.close();
        return result;
    }

    private ProductieEntry getFromRS(ResultSet rs, int lastPlatou, boolean cummulate) throws SQLException {
        ProductieEntry add = new ProductieEntry();
        add.setLiber("");
        if (!cummulate) {
            add.setLiber(rs.getString("free1"));
            int currentPlatou = rs.getInt("id_platou");
            add.setIdPlatou(currentPlatou);
            add.setIdUser(rs.getInt("id_user"));
            add.setOra(Formatters.TIME_FORMAT.format(rs.getTimestamp("data")));
            if (currentPlatou > 0 && currentPlatou == lastPlatou) {
                add.setOra("        ");
            }
            add.setIdProductie(rs.getInt("id"));
            add.setIdOrder(rs.getInt("id_order"));
        }
        add.setIdSectie(rs.getInt("id_sectie"));
        add.setIdSubcategory(rs.getInt("id_subcategorie"));
        add.setIdProduct(rs.getInt("id_produs"));
        add.setCantitate(rs.getDouble("cantitate"));
        add.setDetalii(rs.getString("detalii"));
        add.setStatus(rs.getInt("status"));
        add.setSubcategorie(rs.getString("subcategorie"));
        add.setProdus(rs.getString("nume_produs"));
        add.setPret(rs.getDouble("valoare"));
        return add;
    }

    public Vector<ProductieEntry> getAllForSectieAndMasaAndServire(Vector<Integer> idSectii, String free1, String free2, Timestamp startAt) throws SQLException {
        Vector<ProductieEntry> result = new Vector<ProductieEntry>();
        this.getAllForSectieAndFree1AndFree2.setInt(1, idSectii.get(0));
        this.getAllForSectieAndFree1AndFree2.setInt(2, idSectii.get(1));
        this.getAllForSectieAndFree1AndFree2.setString(3, free1);
        this.getAllForSectieAndFree1AndFree2.setString(4, free2);
        this.getAllForSectieAndFree1AndFree2.setTimestamp(5, startAt);
        ResultSet rs = this.getAllForSectieAndFree1AndFree2.executeQuery();
        int lastPlatou = -1;
        while (rs.next()) {
            ProductieEntry add = this.getFromRS(rs, lastPlatou, false);
            result.add(add);
            lastPlatou = add.getIdPlatou();
        }
        rs.close();
        return result;
    }

    public Vector<MasaProductie> getComenzi(Vector idSectii, Vector<Integer> statuses, Timestamp startAt) throws SQLException {
        Vector<MasaProductie> result = new Vector<MasaProductie>();
        this.getComenzi.setInt(1, (Integer)idSectii.get(0));
        this.getComenzi.setInt(2, (Integer)idSectii.get(1));
        this.getComenzi.setTimestamp(3, startAt);
        ResultSet rs = this.getComenzi.executeQuery();
        while (rs.next()) {
            boolean nou;
            int status = rs.getInt("stare");
            if (!statuses.contains(status)) continue;
            MasaProductie mp = new MasaProductie();
            mp.setMasa(rs.getString("free1"));
            mp.setUser(rs.getString("login"));
            mp.setUserName(rs.getString("nume_user"));
            int c3 = rs.getInt("vazut");
            boolean bl = nou = c3 == 1;
            if (nou) {
                mp.setNou(nou);
            }
            mp.setStatus(status);
            result.add(mp);
        }
        rs.close();
        return result;
    }

    public Vector getOrdineServire(String free1) throws SQLException {
        Vector<String> result = new Vector<String>();
        this.getOrdineServire.setString(1, free1);
        ResultSet rs = this.getOrdineServire.executeQuery();
        while (rs.next()) {
            String ordine = rs.getString(1);
            result.add(ordine);
        }
        rs.close();
        return result;
    }

    public void addProductie(String free1, String free2, int idUser, int idSectie, int idSubcategory, int idProdus, int idPlatou, double cantitate, String detalii, double valoare, int idOrder, Timestamp dateadd) throws SQLException {
        this.add.setString(1, free1);
        this.add.setString(2, free2);
        this.add.setInt(3, idUser);
        this.add.setInt(4, idSectie);
        this.add.setInt(5, idSubcategory);
        this.add.setInt(6, idProdus);
        this.add.setInt(7, idPlatou);
        this.add.setDouble(8, cantitate);
        this.add.setString(9, detalii);
        this.add.setDouble(10, valoare);
        this.add.setInt(11, idOrder);
        this.add.setTimestamp(12, dateadd);
        this.add.execute();
    }

    public void processDay() throws SQLException {
        this.processDay.execute();
    }

    public void updateStatus(int newStatus, int idProductie, int idUser, int oldStatus) throws SQLException {
        this.updateStatus.setInt(1, newStatus);
        this.updateStatus.setInt(2, idProductie);
        this.updateStatus.setInt(3, idProductie);
        this.updateStatus.setInt(4, idUser);
        this.updateStatus.setInt(5, idUser);
        this.updateStatus.setInt(6, oldStatus);
        this.updateStatus.setInt(7, oldStatus);
        this.updateStatus.execute();
    }

    public void updateStatusToMany(int newStatus, int idProdus, String detalii, int oldStatus) throws SQLException {
        this.updateStatusToMany.setInt(1, newStatus);
        this.updateStatusToMany.setInt(2, idProdus);
        this.updateStatusToMany.setString(3, detalii);
        this.updateStatusToMany.setInt(4, oldStatus);
        this.updateStatusToMany.execute();
    }

    public Vector<Integer> getIdsForProductDetaliiStatus(int idProdus, String detalii, int oldStatus) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getIdsForProductDetaliiAndStatus.setInt(1, idProdus);
        this.getIdsForProductDetaliiAndStatus.setString(2, detalii);
        this.getIdsForProductDetaliiAndStatus.setInt(3, oldStatus);
        ResultSet rs = this.getIdsForProductDetaliiAndStatus.executeQuery();
        while (rs.next()) {
            int id = rs.getInt(1);
            result.add(id);
        }
        rs.close();
        return result;
    }
}

