/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.ProductieMese;
import ro.atreides.productie.gui.ProductiePanel;
import ro.atreides.utils.ReflectedJPanel;

public class ProductieMain
extends ReflectedJPanel {
    private ProductiePanel masaPanel;
    private ProductieMese comenziPanel;

    public ProductieMain() {
        ProductieLogic pl = ProductieLogic.getInstance();
        this.masaPanel = new ProductiePanel();
        this.masaPanel.setLogic(pl);
        this.masaPanel.setIdSectii(pl.getReadIds());
        this.masaPanel.setParent(this);
        this.comenziPanel = new ProductieMese();
        this.comenziPanel.setLogic(pl);
        this.comenziPanel.setIdSectii(pl.getReadIds());
        this.comenziPanel.setParent(this);
    }

    @Override
    public void doStuff() {
        this.comenziPanel.doStuff();
        this.masaPanel.doStuff();
        this.switchToComenzi();
    }

    private void switchPanel(JPanel newPanel) {
        this.setVisible(false);
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)newPanel, c);
        this.setVisible(true);
    }

    public void switchToComenzi() {
        this.comenziPanel.forceRefresh();
        this.switchPanel(this.comenziPanel);
    }

    public void switchToMasa(String masa, String ospatar) {
        this.masaPanel.setMasa(ProductieLogic.getInstance().getReadIds(), masa, this, ospatar);
        this.switchPanel(this.masaPanel);
    }
}

