/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import ro.atreides.productie.MasaProductie;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.MeseProductieCellRenderer;
import ro.atreides.productie.gui.ProductieMain;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class ProductieMese
extends AbstractListPanel {
    private Thread thread;
    private ProductieLogic logic = ProductieLogic.getInstance();
    private Vector idSectii = this.logic.getReadIds();
    private static final int FONT_SIZE = 36;
    private ProductieMain parent;

    public void forceRefresh() {
        this.thread.interrupt();
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.comanda};
    }

    @Override
    public Vector buildData() {
        return this.logic.getComenzi(this.idSectii);
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(1);
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Object o = data.elementAt(rowIndex);
                MasaProductie pe = (MasaProductie)o;
                return pe;
            }
        });
        return this.tm;
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.setFont(new Font(null, 0, 36));
        this.table.setTableHeader(null);
        this.table.setRowHeight(36);
        MeseProductieCellRenderer cellRenderer = new MeseProductieCellRenderer(this.tm);
        GuiUtils.updateJTableColumns(this.table, cellRenderer);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Object o = ProductieMese.this.tm.getObjectAt(selRow);
                MasaProductie pe = (MasaProductie)o;
                ProductieMese.this.parent.switchToMasa(pe.getMasa(), pe.getUserName());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Vector newData = ProductieMese.this.buildData();
                    ProductieMese.this.tm.refresh(newData);
                    ProductieMese.this.logic.triggerAlerts(newData);
                }
            }
        });
        this.thread.start();
    }

    public void setParent(ProductieMain parent) {
        this.parent = parent;
    }

    public Vector getIdSectie() {
        return this.idSectii;
    }

    public void setIdSectii(Vector idSectii) {
        this.idSectii = idSectii;
    }

    public void setLogic(ProductieLogic logic) {
        this.logic = logic;
    }
}

