/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.GolesteDialog;
import ro.atreides.productie.gui.GolireBean;
import ro.atreides.productie.gui.ProductieCellRenderer;
import ro.atreides.productie.gui.ProductieWaiterInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class QuickSmallProductiePanel
extends JPanel {
    private int idUser;
    private int fontSize;
    private ProductieLogic logic;
    private AbstractListPanel alp;
    private Vector readOnlySectii;
    private Vector readWriteSectii;
    private ProductieWaiterInterface waiterInterface;
    private String username;

    public QuickSmallProductiePanel(int fontSize, ProductieLogic logic, Vector readOnlySectii, Vector readWriteSectii, ProductieWaiterInterface waiterInterface) {
        this.fontSize = fontSize;
        this.logic = logic;
        this.readOnlySectii = readOnlySectii;
        this.readWriteSectii = readWriteSectii;
        this.waiterInterface = waiterInterface;
        this.display();
    }

    public void setUser(int idUser, String username) {
        this.idUser = idUser;
        this.username = username;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.alp = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        ProductieEntry pe = (ProductieEntry)data.elementAt(rowIndex);
                        return pe.getLiber() + " - " + pe.toString();
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                Vector<ProductieEntry> data = QuickSmallProductiePanel.this.logic.getByWaiter(QuickSmallProductiePanel.this.idUser, QuickSmallProductiePanel.this.readOnlySectii);
                return data;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{""};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.setRowHeight(QuickSmallProductiePanel.this.fontSize);
                this.table.setFont(new Font(null, 0, QuickSmallProductiePanel.this.fontSize));
                this.table.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        Object o = tm.getObjectAt(selRow);
                        if (o instanceof String) {
                            return;
                        }
                        ProductieEntry pe = (ProductieEntry)o;
                        Vector<ProductieEntry> v = new Vector<ProductieEntry>();
                        v.add(pe);
                        if (QuickSmallProductiePanel.this.waiterInterface.canModifyProductie(QuickSmallProductiePanel.this.idUser, QuickSmallProductiePanel.this.idUser, pe.getIdSectie())) {
                            QuickSmallProductiePanel.this.logic.servita(v, "", QuickSmallProductiePanel.this.username);
                        }
                        this.refreshTable();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }
        };
        c.gridwidth = 2;
        this.alp.doStuff();
        this.add((Component)this.alp, c);
        c.weighty = 0.0;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        JButton goleste = new JButton("Goleste");
        goleste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<GolireBean> optiuni = new Vector<GolireBean>();
                if (QuickSmallProductiePanel.this.readWriteSectii.size() > 0) {
                    GolireBean gb1 = new GolireBean(5, "Terminate");
                    optiuni.add(gb1);
                    GolireBean gb2 = new GolireBean(6, "In lucru");
                    optiuni.add(gb2);
                    GolireBean gb3 = new GolireBean(1, "Noi");
                    optiuni.add(gb3);
                    GolireBean gb4 = new GolireBean(-1, LangRoAll.toate);
                    optiuni.add(gb4);
                    GolesteDialog dialog = new GolesteDialog(4, optiuni);
                    int sel = dialog.getSelected();
                    QuickSmallProductiePanel.this.logic.finishByUserAndStatus(QuickSmallProductiePanel.this.idUser, sel);
                }
                QuickSmallProductiePanel.this.refreshData();
            }
        });
        this.add((Component)goleste, c);
        ProductieCellRenderer cellRenderer = new ProductieCellRenderer(this.alp.getTm());
        GuiUtils.updateJTableColumns(this.alp.getJTable(), cellRenderer);
    }

    private void zoomIn() {
        JDialog bigDialog = DialogUtils.getJDialogOKButton(this, GuiUtils.currentFrame, "Detalii", 1.5);
        bigDialog.setVisible(true);
    }

    public void refreshData() {
        this.alp.refreshTable();
    }
}

