/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.GolesteDialog;
import ro.atreides.productie.gui.GolireBean;
import ro.atreides.productie.gui.ProductieCellRenderer;
import ro.atreides.productie.gui.ProductieWaiterInterface;
import ro.atreides.productie.gui.SimpleProductieMain;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class SimpleProductiePanel
extends JPanel {
    protected int idUser;
    protected int fontSize;
    protected String userName;
    protected SimpleProductieMain parent;
    protected JButton zoom;
    protected ProductieLogic logic;
    protected AbstractListPanel alp;
    protected Vector readOnlySectii;
    protected Vector readWriteSectii;
    protected ProductieWaiterInterface waiterInterface;

    public SimpleProductiePanel(int idUser, String userName, SimpleProductieMain parent, int fontSize, ProductieLogic logic, Vector readOnlySectii, Vector readWriteSectii, ProductieWaiterInterface waiterInterface) {
        this.idUser = idUser;
        this.userName = userName;
        this.parent = parent;
        this.fontSize = fontSize;
        this.logic = logic;
        this.readOnlySectii = readOnlySectii;
        this.readWriteSectii = readWriteSectii;
        this.waiterInterface = waiterInterface;
        this.display();
    }

    protected void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.alp = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        ProductieEntry pe = (ProductieEntry)data.elementAt(rowIndex);
                        return pe.toString();
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return this.tm;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                Vector<ProductieEntry> data = SimpleProductiePanel.this.logic.getByWaiter(SimpleProductiePanel.this.idUser, SimpleProductiePanel.this.readOnlySectii);
                return data;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{SimpleProductiePanel.this.userName};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.setRowHeight(SimpleProductiePanel.this.fontSize);
                this.table.setFont(new Font(null, 0, SimpleProductiePanel.this.fontSize));
                this.table.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        Object o = tm.getObjectAt(selRow);
                        if (o instanceof String) {
                            return;
                        }
                        ProductieEntry pe = (ProductieEntry)o;
                        switch (pe.getStatus()) {
                            case 1: {
                                if (!SimpleProductiePanel.this.waiterInterface.canModifyProductie(SimpleProductiePanel.this.idUser, SimpleProductiePanel.this.idUser, pe.getIdSectie())) break;
                                SimpleProductiePanel.this.logic.inLucru(pe.getIdProductie(), pe.getStatus());
                                break;
                            }
                            case 6: {
                                if (!SimpleProductiePanel.this.waiterInterface.canModifyProductie(SimpleProductiePanel.this.idUser, SimpleProductiePanel.this.idUser, pe.getIdSectie())) break;
                                SimpleProductiePanel.this.logic.terminata(pe.getIdProductie(), SimpleProductiePanel.this.readOnlySectii, pe.getStatus());
                                break;
                            }
                            case 5: {
                                Vector<ProductieEntry> v = new Vector<ProductieEntry>();
                                v.add(pe);
                                if (!SimpleProductiePanel.this.waiterInterface.canModifyProductie(SimpleProductiePanel.this.idUser, SimpleProductiePanel.this.idUser, pe.getIdSectie())) break;
                                SimpleProductiePanel.this.logic.servita(v, "", SimpleProductiePanel.this.userName);
                                break;
                            }
                        }
                        this.refreshTable();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }
        };
        c.gridwidth = 2;
        this.alp.doStuff();
        this.add((Component)this.alp, c);
        c.weighty = 0.0;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        JButton goleste = new JButton("Goleste");
        goleste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<GolireBean> optiuni = new Vector<GolireBean>();
                if (SimpleProductiePanel.this.readWriteSectii.size() > 0) {
                    GolireBean gb1 = new GolireBean(5, "Terminate");
                    optiuni.add(gb1);
                    GolireBean gb2 = new GolireBean(6, "In lucru");
                    optiuni.add(gb2);
                    GolireBean gb3 = new GolireBean(1, "Noi");
                    optiuni.add(gb3);
                    GolireBean gb4 = new GolireBean(-1, LangRoAll.toate);
                    optiuni.add(gb4);
                    GolesteDialog dialog = new GolesteDialog(4, optiuni);
                    int sel = dialog.getSelected();
                    SimpleProductiePanel.this.logic.finishByUserAndStatus(SimpleProductiePanel.this.idUser, sel);
                }
            }
        });
        this.add((Component)goleste, c);
        if (this.parent != null) {
            ++c.gridx;
            this.zoom = new JButton("Mare");
            this.zoom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (SimpleProductiePanel.this.zoom.getText().equalsIgnoreCase("Mare")) {
                        SimpleProductiePanel.this.zoomIn();
                    } else {
                        SimpleProductiePanel.this.zoomOut();
                    }
                }
            });
            this.add((Component)this.zoom, c);
        }
        ProductieCellRenderer cellRenderer = new ProductieCellRenderer(this.alp.getTm());
        GuiUtils.updateJTableColumns(this.alp.getJTable(), cellRenderer);
    }

    protected void zoomIn() {
        this.zoom.setText("Mic");
        this.parent.zoomInPanel(this);
    }

    protected void zoomOut() {
        this.zoom.setText("Mare");
        this.parent.zoomOut();
    }

    public void refreshData() {
        this.alp.refreshTable();
    }
}

