/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo;

import java.util.Date;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;

public class PromotionPeriod {
    public static final int INTRE_DATE = 1;
    public static final int INTRE_ORE = 2;
    public static final int PERMANENT = 3;
    public static final long O_Zi = 86400000L;
    private Date start;
    private Date stop;
    private int tip;
    private String weekDays;

    public PromotionPeriod(Date start, Date stop, int tip, String weekDays) {
        this.tip = tip;
        this.start = start;
        this.stop = stop;
        this.weekDays = weekDays;
    }

    public boolean isPromotionActive(long date) {
        return PromotionPeriod.isPromotionActive(this.weekDays, this.tip, Formatters.TIME_FORMAT.format(this.start), Formatters.TIME_FORMAT.format(this.stop), new Date(date));
    }

    public static boolean isPromotionActive(String weekDays, int tip, String oraStart, String oraStop, Date currentTime) {
        Date tempStartD = DateUtils.setTimeToDate2(new Date(), oraStart);
        Date tempStopD = DateUtils.setTimeToDate2(new Date(), oraStop);
        tempStopD = DateUtils.addMinutesToDate(tempStopD, 1);
        tempStopD = DateUtils.addMillisToDate(tempStopD, -1L);
        boolean activeInDay = DateUtils.checkDayOfWeek(weekDays, currentTime.getTime());
        if (!activeInDay) {
            return false;
        }
        boolean result = false;
        switch (tip) {
            case 3: {
                result = true;
                break;
            }
            case 2: {
                if (tempStopD.before(tempStartD)) {
                    tempStopD = DateUtils.advanceOneDay(tempStopD);
                }
            }
            case 1: {
                result = currentTime.after(tempStartD) && currentTime.before(tempStopD);
                break;
            }
        }
        return result;
    }

    public Date getStart() {
        return this.start;
    }

    public String getStartAsString() {
        if (this.tip == 1) {
            return Formatters.DATE_FORMAT.format(this.start);
        }
        if (this.tip == 2) {
            return Formatters.TIME_FORMAT.format(this.start);
        }
        return "-";
    }

    public Date getStop() {
        return this.stop;
    }

    public String getStopAsString() {
        if (this.tip == 1) {
            return Formatters.DATE_FORMAT.format(this.stop);
        }
        if (this.tip == 2) {
            return Formatters.TIME_FORMAT.format(this.stop);
        }
        return "-";
    }

    public int getTip() {
        return this.tip;
    }

    public String toString() {
        return this.tip + " " + this.getStartAsString() + " " + this.getStopAsString() + " (" + this.weekDays + ")";
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(String weekDays) {
        this.weekDays = weekDays;
    }
}

