/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo;

import ro.atreides.promo.PriceProvider;
import ro.atreides.promo.PriceWrapper;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;

public class PromotionPriceProviderImpl
implements PriceProvider {
    private PromotionLogic promoLogic = PromotionLogic.getInstance();

    @Override
    public PriceWrapper getPriceForProduct(int idProduct, int idSubcat, int idCat, int idPromotie, double normalPrice, long saleDate, double orderValue, boolean allowHappyHour) {
        PriceWrapper pw;
        Promotion p;
        PriceWrapper price = new PriceWrapper(normalPrice, -1, 0.0);
        if (idPromotie != -1 && (p = this.promoLogic.getPromotionById(idPromotie)) != null && (pw = p.getPw(idProduct, idSubcat, idCat, normalPrice, saleDate, orderValue)) != null) {
            price = pw;
            return price;
        }
        if (allowHappyHour) {
            Promotion bestChoicePromo = null;
            for (Promotion element : this.promoLogic.getPromotions()) {
                PriceWrapper pw2;
                if (!element.isPublicPromotion() || (pw2 = element.getPw(idProduct, idSubcat, idCat, normalPrice, saleDate, orderValue)) == null || !element.isStrongerThan(bestChoicePromo, idCat, idSubcat, idProduct, orderValue)) continue;
                price = pw2;
                bestChoicePromo = element;
            }
        }
        return price;
    }
}

