/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.PremiuInstantView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionElement;
import ro.atreides.utils.db.DaoInterface;

public class PromotionsImpl
implements DaoInterface {
    private PreparedStatement selectAllPromotions;
    private PreparedStatement selectAllFidelitatePromotions;
    private PreparedStatement selectAllPromotionElementsForPromotion;
    private PreparedStatement addPromotion;
    private PreparedStatement addPromotionElement;
    private PreparedStatement deletePromotion;
    private PreparedStatement deletePromotionElementsForPromotion;
    private PreparedStatement updatePromotion;
    private PreparedStatement getAllPromotiiClient;
    private PreparedStatement addPromotiiClient;
    private PreparedStatement deletePromotiiClient;
    private PreparedStatement getPromotieClientForCard;
    private PreparedStatement getPromotieById;
    private PreparedStatement deleteAllPromotions;
    private PreparedStatement deleteAllPromotionsElements;
    private PreparedStatement deleteAllPromotionsClient;
    private PreparedStatement addPremiuInstant;
    private PreparedStatement deletePremiuInstant;
    private PreparedStatement getPremiiInstant;
    private PreparedStatement getPromotiiClientByIdClientCard;
    private PreparedStatement addPromotiiClientCuCodSync;
    private PreparedStatement deletePromotiiClientByCodSync;
    private PreparedStatement getPromotiiClientByIdClient;
    private PreparedStatement getPromotiiClientByIdClientV2;
    private PreparedStatement getPromotionByLabel;
    private PreparedStatement updatePromotieClientByIdPromotie;
    private PreparedStatement cardClientExists;
    private PreparedStatement setCodSyncForCard;
    private Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public PromotionsImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Vector getPremiiInstant() throws SQLException {
        Vector<PremiuInstantView> result = new Vector<PremiuInstantView>();
        ResultSet rs = this.getPremiiInstant.executeQuery();
        while (rs.next()) {
            PremiuInstantView piv = new PremiuInstantView(rs.getDouble("valoare"), rs.getString("premiu"), rs.getInt("id"), rs.getInt("numar_zile"));
            result.add(piv);
        }
        rs.close();
        return result;
    }

    public void deletePremiuInstant(int id) throws SQLException {
        this.deletePremiuInstant.setInt(1, id);
        this.deletePremiuInstant.execute();
    }

    public void addPremiuInstant(String premiu, double valoare, int zile) throws SQLException {
        this.addPremiuInstant.setString(1, premiu);
        this.addPremiuInstant.setDouble(2, valoare);
        this.addPremiuInstant.setInt(3, zile);
        this.addPremiuInstant.execute();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.setCodSyncForCard = this.connection.prepareStatement("update promotii_clienti set cod_sync = ? where id = ?");
        this.getPremiiInstant = this.connection.prepareStatement("select * from premii_instant");
        this.deletePremiuInstant = this.connection.prepareStatement("delete from premii_instant where id = ?");
        this.addPremiuInstant = this.connection.prepareStatement("insert into premii_instant ( premiu, valoare, numar_zile ) values ( ? , ? , ? )");
        this.deleteAllPromotionsClient = this.connection.prepareStatement("delete from promotii_clienti");
        this.deleteAllPromotionsElements = this.connection.prepareStatement("delete from promotions_elements");
        this.deletePromotionElementsForPromotion = this.connection.prepareStatement("delete from promotions_elements where id_promotie = ?");
        this.deleteAllPromotions = this.connection.prepareStatement("delete from promotions");
        this.selectAllPromotions = this.connection.prepareStatement("select * from promotions where status = 1");
        this.selectAllFidelitatePromotions = this.connection.prepareStatement("select * from promotions where public_promotion = 'false' and status = 1");
        this.selectAllPromotionElementsForPromotion = this.connection.prepareStatement("select * from promotions_elements where id_promotie = ?");
        this.addPromotion = this.connection.prepareStatement("insert into promotions ( type, period_type, starttime, stoptime, label, public_promotion, status, days_in_week ) values (  ?, ?, ?, ?, ?, ?, 1 , ? )");
        this.addPromotionElement = this.connection.prepareStatement("insert into promotions_elements (id_promotie, id_category, id_subcategory, id_product, value, order_minim_value) values (?, ?, ?, ?, ?, ?)");
        this.deletePromotion = this.connection.prepareStatement("update promotions set status = 2 where id = ?");
        this.updatePromotion = this.connection.prepareStatement("update promotions set type = ? , period_type = ?, starttime = ?, stoptime = ?, label = ?, public_promotion = ?, days_in_week = ? where id = ?");
        this.getPromotieById = this.connection.prepareStatement("select * from promotions where id = ?");
        String selectMare = "select persoane_fizice.nume || ' ' || persoane_fizice.prenume as pers_fizica, persoane_juridice.nume as societate, promotions.label as promo_name, promotii_clienti.id as id, promotii_clienti.card as card, promotii_clienti.card_stop as card_stop, promotii_clienti.cod_sync as cod_sync_card, promotions.id as id_promotie, coalesce(clienti.id, -1) as id_client from promotii_clienti inner join promotions on promotii_clienti.id_promotie = promotions.id left outer join clienti on promotii_clienti.id_client = clienti.id left outer join persoane_fizice on clienti.idPersFizica = persoane_fizice.id left outer join persoane_juridice on clienti.idPersJuridica = persoane_juridice.id";
        this.getAllPromotiiClient = this.connection.prepareStatement(selectMare);
        this.addPromotiiClient = this.connection.prepareStatement("insert into promotii_clienti ( id_client, id_promotie, card, card_stop ) values ( ?, ?, ?, ?)", 1);
        this.deletePromotiiClient = this.connection.prepareStatement("delete from promotii_clienti where id = ?");
        this.getPromotieClientForCard = this.connection.prepareStatement(selectMare + " where" + " promotii_clienti.card <= ?" + " and promotii_clienti.card_stop >= ?" + " order by id_client desc");
        this.getPromotiiClientByIdClientCard = this.connection.prepareStatement("select * from promotii_clienti where id_client = ? and id_promotie = ? and card = ? and card_stop = ?");
        this.addPromotiiClientCuCodSync = this.connection.prepareStatement("insert into promotii_clienti ( id_client, id_promotie, card, card_stop, cod_sync, dateadded ) values ( ?, ?, ?, ?, ?, ?)");
        this.deletePromotiiClientByCodSync = this.connection.prepareStatement("delete from promotii_clienti where cod_sync = ?");
        this.getPromotiiClientByIdClient = this.connection.prepareStatement("select * from promotii_clienti where id_client = ?");
        this.getPromotionByLabel = this.connection.prepareStatement("select * from promotions where label = ?");
        this.updatePromotieClientByIdPromotie = this.connection.prepareStatement("update promotii_clienti set card = ?, card_stop = ? where id = ?");
        this.getPromotiiClientByIdClientV2 = this.connection.prepareStatement(selectMare + " where promotii_clienti.id_client = ?");
        this.cardClientExists = this.connection.prepareStatement("select * from promotii_clienti where promotii_clienti.card <= ? and promotii_clienti.card_stop >=?");
    }

    public void updateCodSyncForCard(String codSync, int idCard) throws SQLException {
        this.setCodSyncForCard.setString(1, codSync);
        this.setCodSyncForCard.setInt(2, idCard);
        this.setCodSyncForCard.execute();
    }

    public void deleteAllPromotions() throws SQLException {
        this.deleteAllPromotionsElements.execute();
        this.deleteAllPromotions.execute();
    }

    public void deletePromotionsElementsForPromotion(int idPromotion) throws SQLException {
        this.deletePromotionElementsForPromotion.setInt(1, idPromotion);
        this.deletePromotionElementsForPromotion.execute();
    }

    public void deleteAllPromotiiClienti() throws SQLException {
        this.deleteAllPromotionsClient.execute();
    }

    public Vector<ClientPromotieView> getPromotieClientForCard(String card) throws SQLException {
        Vector<ClientPromotieView> result = new Vector<ClientPromotieView>();
        this.getPromotieClientForCard.setString(1, card);
        this.getPromotieClientForCard.setString(2, card);
        ResultSet rs = this.getPromotieClientForCard.executeQuery();
        while (rs.next()) {
            ClientPromotieView cpv = this.getClientPromotieFromResultSet(rs);
            result.add(cpv);
        }
        rs.close();
        return result;
    }

    public Vector<ClientPromotieView> getAllPromotiiClient() throws SQLException {
        Vector<ClientPromotieView> result = new Vector<ClientPromotieView>();
        ResultSet rs = this.getAllPromotiiClient.executeQuery();
        while (rs.next()) {
            ClientPromotieView cpv = this.getClientPromotieFromResultSet(rs);
            result.add(cpv);
        }
        rs.close();
        return result;
    }

    private ClientPromotieView getClientPromotieFromResultSet(ResultSet rs) throws SQLException {
        ClientPromotieView cpv = new ClientPromotieView();
        String societate = rs.getString("societate");
        if (societate != null) {
            cpv.setClient(societate);
        } else {
            cpv.setClient(rs.getString("pers_fizica"));
        }
        cpv.setId(rs.getInt("id"));
        cpv.setIdClient(rs.getInt("id_client"));
        cpv.setIdPromotie(rs.getInt("id_promotie"));
        cpv.setPromotie(rs.getString("promo_name"));
        cpv.setCodStart(rs.getString("card"));
        cpv.setCodStop(rs.getString("card_stop"));
        return cpv;
    }

    public void deletePromotiiClient(int id) throws SQLException {
        this.deletePromotiiClient.setInt(1, id);
        this.deletePromotiiClient.execute();
    }

    public int addPromotiiClient(int idClient, int idPromotie, String cardStart, String cardStop) throws SQLException {
        this.addPromotiiClient.setInt(1, idClient);
        this.addPromotiiClient.setInt(2, idPromotie);
        this.addPromotiiClient.setString(3, cardStart);
        this.addPromotiiClient.setString(4, cardStop);
        this.addPromotiiClient.execute();
        int result = -1;
        ResultSet rs = this.addPromotiiClient.getGeneratedKeys();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addPromotion(Promotion toAdd) throws SQLException {
        this.addPromotion.setInt(1, toAdd.getType());
        this.addPromotion.setInt(2, toAdd.getPeriod().getTip());
        this.addPromotion.setTimestamp(3, new Timestamp(toAdd.getPeriod().getStart().getTime()));
        this.addPromotion.setTimestamp(4, new Timestamp(toAdd.getPeriod().getStop().getTime()));
        this.addPromotion.setString(5, toAdd.getLabel());
        this.addPromotion.setString(6, toAdd.isPublicPromotion() + "");
        this.addPromotion.setString(7, toAdd.getPeriod().getWeekDays());
        this.addPromotion.execute();
    }

    public void addPromotionElement(int idPromotion, PromotionElement toAdd) throws SQLException {
        this.addPromotionElement.setInt(1, idPromotion);
        this.addPromotionElement.setInt(2, toAdd.getCategory());
        this.addPromotionElement.setInt(3, toAdd.getSubcat());
        this.addPromotionElement.setInt(4, toAdd.getProduct());
        this.addPromotionElement.setDouble(5, toAdd.getValue());
        this.addPromotionElement.setDouble(6, toAdd.getOrderMinimValue());
        this.addPromotionElement.execute();
    }

    public void updatePromotion(Promotion toAdd) throws SQLException {
        this.updatePromotion.setInt(1, toAdd.getType());
        this.updatePromotion.setInt(2, toAdd.getPeriod().getTip());
        this.updatePromotion.setTimestamp(3, new Timestamp(toAdd.getPeriod().getStart().getTime()));
        this.updatePromotion.setTimestamp(4, new Timestamp(toAdd.getPeriod().getStop().getTime()));
        this.updatePromotion.setString(5, toAdd.getLabel());
        this.updatePromotion.setString(6, toAdd.isPublicPromotion() + "");
        this.updatePromotion.setString(7, toAdd.getPeriod().getWeekDays());
        this.updatePromotion.setInt(8, toAdd.getId());
        this.updatePromotion.execute();
    }

    public Promotion getPromotionById(int id) throws SQLException {
        Promotion p = null;
        this.getPromotieById.setInt(1, id);
        ResultSet rs = this.getPromotieById.executeQuery();
        if (rs.next()) {
            p = this.getPromotionFromResultSet(rs);
        }
        rs.close();
        return p;
    }

    public Vector<Promotion> getPromotions() throws SQLException {
        Vector<Promotion> result = new Vector<Promotion>();
        ResultSet rs = this.selectAllPromotions.executeQuery();
        while (rs.next()) {
            Promotion p = this.getPromotionFromResultSet(rs);
            result.add(p);
        }
        rs.close();
        return result;
    }

    public Vector<Promotion> getFidelitatePromotions() throws SQLException {
        Vector<Promotion> result = new Vector<Promotion>();
        ResultSet rs = this.selectAllFidelitatePromotions.executeQuery();
        while (rs.next()) {
            Promotion p = this.getPromotionFromResultSet(rs);
            result.add(p);
        }
        rs.close();
        return result;
    }

    private PromotionElement getPromotionElementFromResultSet(ResultSet rs) throws SQLException {
        PromotionElement p = new PromotionElement();
        int catId = rs.getInt("id_category");
        p.setCategory(catId);
        int subcategoryId = rs.getInt("id_subcategory");
        p.setSubcat(subcategoryId);
        int productId = rs.getInt("id_product");
        p.setProduct(productId);
        p.setValue(rs.getDouble("value"));
        p.setOrderMinimValue(rs.getDouble("order_minim_value"));
        return p;
    }

    private Promotion getPromotionFromResultSet(ResultSet rs) throws SQLException {
        Timestamp start = rs.getTimestamp("starttime");
        Timestamp stop = rs.getTimestamp("stoptime");
        Promotion p = new Promotion(new Integer(rs.getInt("id")), rs.getString("label"), rs.getInt("type"), start, stop, rs.getInt("period_type"), rs.getString("days_in_week"));
        boolean publicPromotion = Boolean.valueOf(rs.getString("public_promotion"));
        p.setPublicPromotion(publicPromotion);
        Vector<PromotionElement> elements = new Vector<PromotionElement>();
        this.selectAllPromotionElementsForPromotion.setInt(1, p.getId());
        ResultSet rs2 = this.selectAllPromotionElementsForPromotion.executeQuery();
        while (rs2.next()) {
            PromotionElement el = this.getPromotionElementFromResultSet(rs2);
            elements.add(el);
        }
        rs2.close();
        p.setPromoElements(elements);
        return p;
    }

    public void deletePromotion(int promotionId) throws SQLException {
        this.deletePromotion.setInt(1, promotionId);
        this.deletePromotion.execute();
    }

    public boolean getPromotiiClientByIdClientCard(int idClient, int idPromotie, String cardStart, String cardStop) throws SQLException {
        this.getPromotiiClientByIdClientCard.setInt(1, idClient);
        this.getPromotiiClientByIdClientCard.setInt(2, idPromotie);
        this.getPromotiiClientByIdClientCard.setString(3, cardStart);
        this.getPromotiiClientByIdClientCard.setString(4, cardStop);
        ResultSet rs = this.getPromotiiClientByIdClientCard.executeQuery();
        boolean result = false;
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public void addPromotiiClientCuCodSync(int idClient, int idPromotie, String cardStart, String cardStop, String codSync, Timestamp dateadded) throws SQLException {
        this.addPromotiiClientCuCodSync.setInt(1, idClient);
        this.addPromotiiClientCuCodSync.setInt(2, idPromotie);
        this.addPromotiiClientCuCodSync.setString(3, cardStart);
        this.addPromotiiClientCuCodSync.setString(4, cardStop);
        this.addPromotiiClientCuCodSync.setString(5, codSync);
        this.addPromotiiClientCuCodSync.setTimestamp(6, dateadded);
        this.addPromotiiClientCuCodSync.execute();
    }

    public void deletePromotiiClientByCodSync(String codSync) throws SQLException {
        this.deletePromotiiClientByCodSync.setString(1, codSync);
        this.deletePromotiiClientByCodSync.execute();
    }

    public Vector<ClientPromotieView> getPromotiiClientByIdClient(int idClient) throws SQLException {
        Vector<ClientPromotieView> result = new Vector<ClientPromotieView>();
        this.getPromotiiClientByIdClient.setInt(1, idClient);
        ResultSet rs = this.getPromotiiClientByIdClient.executeQuery();
        while (rs.next()) {
            ClientPromotieView cpv = new ClientPromotieView();
            cpv.setId(rs.getInt("id"));
            cpv.setIdClient(rs.getInt("id_client"));
            cpv.setIdPromotie(rs.getInt("id_promotie"));
            cpv.setCodStart(rs.getString("card"));
            cpv.setCodStop(rs.getString("card_stop"));
            cpv.setCodSyncCard(rs.getString("cod_sync"));
            cpv.setDateadded(rs.getTimestamp("dateadded"));
            result.add(cpv);
        }
        return result;
    }

    public Promotion getPromotionByLabel(String label) throws SQLException {
        Promotion p = null;
        this.getPromotionByLabel.setString(1, label);
        ResultSet rs = this.getPromotionByLabel.executeQuery();
        if (rs.next()) {
            p = this.getPromotionFromResultSet(rs);
        }
        return p;
    }

    public void updatePromotieClient(int idPromotieClient, String cardstart, String cardstop) throws SQLException {
        this.updatePromotieClientByIdPromotie.setString(1, cardstart);
        this.updatePromotieClientByIdPromotie.setString(2, cardstop);
        this.updatePromotieClientByIdPromotie.setInt(3, idPromotieClient);
        this.updatePromotieClientByIdPromotie.executeUpdate();
    }

    @Deprecated
    public Vector<ClientPromotieView> getPromotiiClientByIdClientV2(int idClient) throws SQLException {
        Vector<ClientPromotieView> cpvs = new Vector<ClientPromotieView>();
        this.getPromotiiClientByIdClientV2.setInt(1, idClient);
        ResultSet rs = this.getPromotiiClientByIdClientV2.executeQuery();
        while (rs.next()) {
            ClientPromotieView cpv = this.getClientPromotieFromResultSet(rs);
            cpvs.add(cpv);
        }
        return cpvs;
    }

    public boolean cardClientExists(String card) throws SQLException {
        this.cardClientExists.setString(1, card);
        this.cardClientExists.setString(2, card);
        ResultSet rs = this.cardClientExists.executeQuery();
        return rs.next();
    }
}

