/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.promo.PremiuInstantView;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PremiiInstantPanel
extends ReflectedJPanel {
    private JButton adauga;
    private AbstractTM model;
    private PromotionLogic logic = PromotionLogic.getInstance();
    private JTextField premiuField;
    private JTextField valoareField;
    private JTextField numarZileField;

    public PremiiInstantPanel() {
        this.display();
    }

    @Override
    public void doStuff() {
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getAddEditPanel(), c);
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        AbstractListPanel list = this.getListPanel();
        list.doStuff();
        this.add((Component)list, c);
    }

    private JPanel getAddEditPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Premiu"), c);
        ++c.gridx;
        this.premiuField = new JTextField(10);
        result.add((Component)this.premiuField, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.valoare), c);
        ++c.gridx;
        this.valoareField = new JTextField(10);
        result.add((Component)this.valoareField, c);
        ++c.gridx;
        result.add((Component)new JLabel("Numar zile"), c);
        ++c.gridx;
        this.numarZileField = new JTextField(10);
        result.add((Component)this.numarZileField, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String premiu = PremiiInstantPanel.this.premiuField.getText();
                if (!Validators.correctString(premiu)) {
                    PremiiInstantPanel.this.premiuField.requestFocus();
                    return;
                }
                String valoareS = PremiiInstantPanel.this.valoareField.getText();
                if (!Validators.correctDouble(valoareS)) {
                    PremiiInstantPanel.this.valoareField.requestFocus();
                    PremiiInstantPanel.this.valoareField.setText("");
                    return;
                }
                String zileS = PremiiInstantPanel.this.numarZileField.getText();
                if (!Validators.correctDouble(zileS)) {
                    PremiiInstantPanel.this.numarZileField.requestFocus();
                    PremiiInstantPanel.this.numarZileField.setText("");
                    return;
                }
                PremiiInstantPanel.this.logic.addPremiu(premiu, Utils.parseDouble(valoareS), Integer.parseInt(zileS));
                PremiiInstantPanel.this.model.refresh(PremiiInstantPanel.this.logic.getPremiiInstant());
                PremiiInstantPanel.this.premiuField.setText("");
                PremiiInstantPanel.this.valoareField.setText("");
                PremiiInstantPanel.this.numarZileField.setText("");
            }
        });
        result.add((Component)this.adauga, c);
        result.setBorder(new TitledBorder("Adaugare"));
        return result;
    }

    private AbstractListPanel getListPanel() {
        final AbstractListPanel lista = new AbstractListPanel(){
            String[] columns = new String[]{"Premiu", LangRoAll.valoare, "Numar zile"};

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                PremiiInstantPanel.this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        PremiuInstantView p = (PremiuInstantView)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return p.getPremiu();
                            }
                            case 1: {
                                return Utils.getString2Decimals(p.getValoare());
                            }
                            case 2: {
                                return "" + p.getNumarZile();
                            }
                        }
                        return null;
                    }
                });
                return PremiiInstantPanel.this.model;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(this.columns.length);
            }

            @Override
            public Vector buildData() {
                return PremiiInstantPanel.this.logic.getPremiiInstant();
            }

            @Override
            public String[] buildColumns() {
                return this.columns;
            }
        };
        lista.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object arg0) {
                if (DialogUtils.confirmDialog(lista, "Doriti sa stergeti acest premiu", LangRoAll.confirmare)) {
                    PremiuInstantView v = (PremiuInstantView)arg0;
                    PremiiInstantPanel.this.logic.deletePremiu(v.getId());
                    PremiiInstantPanel.this.model.refresh(PremiiInstantPanel.this.logic.getPremiiInstant());
                }
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        lista.setBorder(new TitledBorder("Premii instant"));
        return lista;
    }
}

