/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PromotiiClientiList
extends ReflectedJPanel
implements CleanupRequired {
    private JComboBox clienti;
    private JComboBox promotii;
    private JButton adauga;
    private JButton importPromotiiClient;
    private JButton search;
    private AbstractTM model;
    private PromotionLogic logic;
    private ClientLogic clientLogic;
    private Vector<ClientPromotieView> allDataForTable = new Vector();
    private final JComponent parent = this;

    public PromotiiClientiList() {
        this.logic = PromotionLogic.getInstance();
        this.display();
        this.allDataForTable = this.logic.getPromotiiClientSorted();
        this.clientLogic = ClientLogic.getInstance();
        this.clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "PromotiiClientiList_persJuridice";
            }

            @Override
            public void dataChanged() {
                PromotiiClientiList.this.refreshClienti();
            }
        }, 42);
        this.clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "PromotiiClientiList_persFizice";
            }

            @Override
            public void dataChanged() {
                PromotiiClientiList.this.refreshClienti();
            }
        }, 41);
        this.logic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "PromotiiClientiList_promotii";
            }

            @Override
            public void dataChanged() {
                PromotiiClientiList.this.refreshPromotii();
            }
        }, 8);
        this.refreshClienti();
        this.refreshPromotii();
    }

    @Override
    public void doStuff() {
    }

    private void refreshClienti() {
        ComboUtils.replaceItemsForCombo(this.clienti, this.clientLogic.getAllClientsSorted());
    }

    private void refreshPromotii() {
        ComboUtils.replaceItemsForCombo(this.promotii, this.logic.getPromotions(), false);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getSearchPanel(), c);
        ++c.gridy;
        c.weighty = 2.0;
        AbstractListPanel list = this.getListPanel();
        list.doStuff();
        this.add((Component)list, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.add((Component)this.getAddEditPanel(), c);
        ++c.gridx;
        c.gridheight = 1;
        c.gridwidth = 1;
        this.add((Component)this.getButtonsPanel(), c);
    }

    private JPanel getAddEditPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clienti = new JComboBox();
        result.add((Component)this.clienti, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.promotie), c);
        ++c.gridx;
        this.promotii = new JComboBox();
        result.add((Component)this.promotii, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel("Card start"), c);
        ++c.gridx;
        final JTextField cardStart = new JTextField(10);
        result.add((Component)cardStart, c);
        ++c.gridx;
        result.add((Component)new JLabel("Card stop"), c);
        ++c.gridx;
        final JTextField cardStop = new JTextField(10);
        result.add((Component)cardStop, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Promotion p = (Promotion)PromotiiClientiList.this.promotii.getSelectedItem();
                int clientId = -1;
                if (ComboUtils.anythingButAllSelected(PromotiiClientiList.this.clienti)) {
                    Client c = (Client)PromotiiClientiList.this.clienti.getSelectedItem();
                    clientId = c.getId();
                } else if (VpConfig.getInstance().clientRequirementOnAsociereCard) {
                    DialogUtils.errorDialog(PromotiiClientiList.this.parent, "Selectati un client", LangRoAll.nuPotContinua);
                    return;
                }
                String start = cardStart.getText();
                if (!Validators.correctString(start)) {
                    start = "";
                    DialogUtils.errorDialog(PromotiiClientiList.this.parent, "Completati card start", LangRoAll.nuPotContinua);
                    cardStart.requestFocus();
                    return;
                }
                if (p != null) {
                    String stop = cardStop.getText();
                    if (stop == null) {
                        stop = "";
                    }
                    stop = !stop.equals("") ? start : start;
                    PromotiiClientiList.this.logic.addPromotionClient(clientId, p.getId(), start, stop);
                    PromotiiClientiList.this.refreshTableFromDatabase(true);
                    cardStart.setText("");
                    cardStop.setText("");
                }
            }
        });
        result.add((Component)this.adauga, c);
        result.setBorder(new TitledBorder("Adaugare"));
        return result;
    }

    private AbstractListPanel getListPanel() {
        final AbstractListPanel lista = new AbstractListPanel(){
            String[] columns = new String[]{LangRoAll.client, LangRoAll.promotie, "Cod start", "Cod stop"};

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                PromotiiClientiList.this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                        ClientPromotieView p = (ClientPromotieView)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 2: {
                                String codstart = (String)aValue;
                                if (codstart.equalsIgnoreCase(p.getCodStart())) break;
                                p.setCodStart(codstart);
                                PromotiiClientiList.this.logic.updatePromotieClient(p);
                                PromotiiClientiList.this.model.fireTableDataChanged();
                                break;
                            }
                            case 3: {
                                String codstop = (String)aValue;
                                if (codstop.equalsIgnoreCase(p.getCodStop())) break;
                                p.setCodStop(codstop);
                                PromotiiClientiList.this.logic.updatePromotieClient(p);
                                PromotiiClientiList.this.model.fireTableDataChanged();
                            }
                        }
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return columnIndex == 2 || columnIndex == 3;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        ClientPromotieView p = (ClientPromotieView)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return p.getClient();
                            }
                            case 1: {
                                return p.getPromotie();
                            }
                            case 2: {
                                return p.getCodStart();
                            }
                            case 3: {
                                return p.getCodStop();
                            }
                        }
                        return null;
                    }
                });
                return PromotiiClientiList.this.model;
            }

            @Override
            public JPanel getBottomPanel() {
                final JPanel result = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 10;
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridheight = 1;
                c.insets = new Insets(2, 2, 2, 2);
                c.gridx = 0;
                c.gridy = 0;
                JButton generareCarduri = new JButton("Generare carduri fidelitate");
                generareCarduri.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        PromotionLogic.getInstance().generateCarduriFidelitate(result);
                    }
                });
                result.add((Component)generareCarduri, c);
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(this.columns.length);
            }

            @Override
            public Vector buildData() {
                return PromotiiClientiList.this.logic.getPromotiiClientSorted();
            }

            @Override
            public String[] buildColumns() {
                return this.columns;
            }
        };
        lista.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object arg0) {
                lista.getJTable().editingCanceled(new ChangeEvent(arg0));
                if (DialogUtils.confirmDialog(lista, "Doriti sa stergeti aceste carduri", LangRoAll.confirmare)) {
                    ClientPromotieView v = (ClientPromotieView)arg0;
                    PromotiiClientiList.this.logic.deletePromotionClient(v.getId());
                    Vector dataAfterSearch = PromotiiClientiList.this.model.getData();
                    dataAfterSearch.remove(v);
                    PromotiiClientiList.this.allDataForTable.remove(v);
                    PromotiiClientiList.this.model.refresh(dataAfterSearch);
                }
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        lista.setBorder(new TitledBorder("Promotii-clienti"));
        return lista;
    }

    @Override
    public void cleanup() {
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.insets = new Insets(1, 2, 1, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.importPromotiiClient = new JButton("Import promotii clienti");
        this.importPromotiiClient.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem importExcel = new JMenuItem("Import din EXCEL");
                importExcel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Importam promotii clienti din Excel ", LangRoAll.confirmare)) {
                            String inputFile = FileDialog.getLoadDialogLocation(GuiUtils.currentFrame, "Selectati fisierul de importat", "xls");
                            if (inputFile != null) {
                                PromotiiClientiList.this.logic.importPromotiiClientFromExcel(new File(inputFile));
                            }
                            PromotiiClientiList.this.refreshTableFromDatabase(true);
                        }
                    }
                });
                popup.add(importExcel);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)this.importPromotiiClient, c);
        ++c.gridy;
        JButton generareCarduri = new JButton("Generare carduri fidelitate");
        generareCarduri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PromotionLogic.getInstance().generateCarduriFidelitate(GuiUtils.currentFrame);
            }
        });
        result.add((Component)generareCarduri, c);
        result.setBorder(new TitledBorder("Actiuni"));
        return result;
    }

    private JPanel getSearchPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "[][grow][grow][grow][]"));
        JLabel numeLabel = new JLabel("Nume");
        final JTextField numeText = new JTextField();
        this.search = new JButton("Search");
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromotiiClientiList.this.refreshTableFromDatabase(true);
                String text = numeText.getText().toLowerCase();
                if (text != null && !text.isEmpty()) {
                    Vector<ClientPromotieView> result = new Vector<ClientPromotieView>();
                    for (ClientPromotieView cpv : PromotiiClientiList.this.allDataForTable) {
                        String client = cpv.getClient().toLowerCase();
                        String codstart = cpv.getCodStart();
                        String codstop = cpv.getCodStop();
                        if (!client.contains(text) && !codstart.contains(text) && !codstop.contains(text)) continue;
                        result.add(cpv);
                    }
                    PromotiiClientiList.this.model.refresh(result);
                }
            }
        });
        numeText.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        PromotiiClientiList.this.search.doClick();
                        break;
                    }
                    case 27: {
                        numeText.setText("");
                        PromotiiClientiList.this.refreshTableFromDatabase(true);
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        numeText.setToolTipText("<html><b>Enter</b> - pentru a efectua o cautare<br><b>Escape</b> - pentru a reveni la lista initiala</html>");
        result.add(numeLabel);
        result.add((Component)numeText, "span 3, growx");
        result.add((Component)this.search, "growx");
        result.setBorder(new TitledBorder("Cautare"));
        return result;
    }

    private void refreshTableFromDatabase(boolean needsDatabaseRefresh) {
        if (needsDatabaseRefresh) {
            this.allDataForTable = this.logic.getPromotiiClientSorted();
        }
        this.model.refresh(this.allDataForTable);
    }
}

