/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.promo.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.PromotionPeriod;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PromotionsPanel
extends AbstractListPanel
implements CleanupRequired {
    private PromotionLogic promotionLogic = PromotionLogic.getInstance();
    private EventListener promotionsListener = new EventListener(){

        @Override
        public void dataChanged() {
            PromotionsPanel.this.refreshTable();
        }

        @Override
        public String getName() {
            return "PromotionsPanel";
        }
    };
    private AbstractTM model;

    public PromotionsPanel() {
        this.promotionLogic.addListener(this.promotionsListener, 8);
        this.init();
        this.display();
    }

    @Override
    public void cleanup() {
        this.promotionLogic.removeListener(this.promotionsListener);
    }

    private void init() {
    }

    @Override
    public String[] buildColumns() {
        String[] _columnNames = new String[]{LangRoAll.denumire, LangRoAll.tip, "Perioada", LangRoAll.fidelitate};
        return _columnNames;
    }

    @Override
    public Vector buildData() {
        return this.promotionLogic.getPromotions();
    }

    @Override
    public Class[] buildTypes() {
        Class[] columnTypes = new Class[]{String.class, String.class, String.class, Boolean.class};
        return columnTypes;
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Promotion p = (Promotion)data.elementAt(rowIndex);
                if (p == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return p.getLabel();
                    }
                    case 1: {
                        return p.getTypeName();
                    }
                    case 2: {
                        PromotionPeriod pp = p.getPeriod();
                        return pp.getStartAsString() + " - " + pp.getStopAsString() + " (" + pp.getWeekDays() + ")";
                    }
                    case 3: {
                        return new Boolean(!p.isPublicPromotion());
                    }
                }
                return null;
            }
        });
        return this.model;
    }

    @Override
    public void doStuff() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = PromotionsPanel.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    Promotion p = (Promotion)PromotionsPanel.this.tm.getObjectAt(selRow);
                    PromotionsPanel.this.action.doubleClicked(p);
                }
            }
        });
    }
}

