/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.clinicabase;

import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class AnalizeReportEntry {
    private int idPersFizica;
    private int idPersJuridica;
    private int idProdus;
    private int status;
    private int id;
    private int idBiletTrimitere;
    private int idOrder;
    private double rezultatAnaliza;
    private double limitaMinima;
    private double limitaMaxima;
    private double pret;
    private boolean externa;
    private String numePersFizica;
    private String numePersJuridica;
    private String numeProdus;
    private String numeStatus;
    private String numeCaterogie;
    private String numeCasaSanatate;
    private String codBare;
    private Vector events;
    private Timestamp data;
    private boolean isSelected;
    private boolean isCompleted;

    public double getPret() {
        return this.pret;
    }

    public void setPret(double pret) {
        this.pret = pret;
    }

    public int getIdOrder() {
        return this.idOrder;
    }

    public void setIdOrder(int idOrder) {
        this.idOrder = idOrder;
    }

    public int getIdBiletTrimitere() {
        return this.idBiletTrimitere;
    }

    public void setIdBiletTrimitere(int idBiletTrimitere) {
        this.idBiletTrimitere = idBiletTrimitere;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getIdPersFizica() {
        return this.idPersFizica;
    }

    public void setIdPersFizica(int idPersFizica) {
        this.idPersFizica = idPersFizica;
    }

    public int getIdPersJuridica() {
        return this.idPersJuridica;
    }

    public void setIdPersJuridica(int idPersJuridica) {
        this.idPersJuridica = idPersJuridica;
    }

    public int getIdProdus() {
        return this.idProdus;
    }

    public void setIdProdus(int idProdus) {
        this.idProdus = idProdus;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getRezultatAnaliza() {
        return this.rezultatAnaliza;
    }

    public void setRezultatAnaliza(double rezultatAnaliza) {
        this.rezultatAnaliza = rezultatAnaliza;
    }

    public double getLimitaMinima() {
        return this.limitaMinima;
    }

    public void setLimitaMinima(double limitaMinima) {
        this.limitaMinima = limitaMinima;
    }

    public double getLimitaMaxima() {
        return this.limitaMaxima;
    }

    public void setLimitaMaxima(double limitaMaxima) {
        this.limitaMaxima = limitaMaxima;
    }

    public boolean isExterna() {
        return this.externa;
    }

    public void setExterna(boolean externa) {
        this.externa = externa;
    }

    public String getNumePersFizica() {
        return this.numePersFizica;
    }

    public void setNumePersFizica(String numePersFizica) {
        this.numePersFizica = numePersFizica;
    }

    public String getNumePersJuridica() {
        return this.numePersJuridica;
    }

    public void setNumePersJuridica(String numePersJuridica) {
        this.numePersJuridica = numePersJuridica;
    }

    public String getNumeProdus() {
        return this.numeProdus;
    }

    public void setNumeProdus(String numeProdus) {
        this.numeProdus = numeProdus;
    }

    public String getNumeStatus() {
        return this.numeStatus;
    }

    public void setNumeStatus(String numeStatus) {
        this.numeStatus = numeStatus;
    }

    public String getNumeCaterogie() {
        return this.numeCaterogie;
    }

    public void setNumeCaterogie(String numeCaterogie) {
        this.numeCaterogie = numeCaterogie;
    }

    public String getNumeCasaSanatate() {
        return this.numeCasaSanatate;
    }

    public void setNumeCasaSanatate(String numeCasaSanatate) {
        this.numeCasaSanatate = numeCasaSanatate;
    }

    public String getCodBare() {
        return this.codBare;
    }

    public void setCodBare(String codBare) {
        this.codBare = codBare;
    }

    public Vector getEvents() {
        return this.events;
    }

    public void setEvents(Vector events) {
        this.events = events;
    }

    public String getRezultatAsString() {
        return Utils.getString6Decimals(this.rezultatAnaliza);
    }

    public String getValoriNormale() {
        return Utils.getString6Decimals(this.limitaMinima) + " - " + Utils.getString6Decimals(this.limitaMaxima);
    }

    public String getDataComenzii() {
        return Formatters.DATE_FORMAT_RO.format(this.data);
    }

    public Timestamp getData() {
        return this.data;
    }

    public void setData(Timestamp data) {
        this.data = data;
    }

    public String getTooltip(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        if (Validators.correctString(this.numePersFizica)) {
            result.append(lineSeparator);
            result.append("Pacient: " + this.numePersFizica);
        }
        if (Validators.correctString(this.numePersJuridica)) {
            result.append(lineSeparator);
            result.append("Companie: " + this.numePersJuridica);
        }
        if (Validators.correctString(this.numeProdus)) {
            result.append(lineSeparator);
            result.append("Analiza: " + this.numeProdus);
        }
        if (Validators.correctString(this.numeStatus)) {
            result.append(lineSeparator);
            result.append("Status: " + this.numeStatus);
        }
        result.append(lineSeparator);
        result.append("Externa: " + (this.externa ? "DA" : "NU"));
        result.append(lineSeparator);
        result.append("Categorie: " + this.numeCaterogie);
        if (Validators.correctString(this.numeCasaSanatate)) {
            result.append(lineSeparator);
            result.append("Casa Sanatate: " + this.numeCasaSanatate);
        }
        if (Validators.correctString(this.codBare)) {
            result.append(lineSeparator);
            result.append("Cod bare: " + this.codBare);
        }
        if (Validators.correctString(this.getDataComenzii())) {
            result.append(lineSeparator);
            result.append("Data: " + this.getDataComenzii());
        }
        return result.toString();
    }
}

