/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.clinicabase;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.restaurant.clinicabase.AnalizeReportEntry;
import ro.atreides.restaurant.clinicabase.BiletTrimitere;
import ro.atreides.restaurant.clinicabase.ComisionReportEntry;
import ro.atreides.restaurant.clinicabase.DayProgram;
import ro.atreides.restaurant.clinicabase.Diagnostic;
import ro.atreides.restaurant.clinicabase.Functie;
import ro.atreides.restaurant.clinicabase.Medic;
import ro.atreides.restaurant.clinicabase.MedicProcent;
import ro.atreides.restaurant.gui.clinica.ProgramareEntry;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.sql.SqlUtils;

public class ClinicaDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addMedic;
    private PreparedStatement updateMedic;
    private PreparedStatement deleteMedic;
    private PreparedStatement getMedicById;
    private PreparedStatement getAllMedici;
    private PreparedStatement addFunctie;
    private PreparedStatement updateFunctie;
    private PreparedStatement deleteFunctie;
    private PreparedStatement getFunctii;
    private PreparedStatement getDiagnostice;
    private PreparedStatement getDiagnosticByCod;
    private PreparedStatement addDiagnostic;
    private PreparedStatement updateDiagnostic;
    private PreparedStatement deleteDiagnostic;
    private PreparedStatement addMedicProcent;
    private PreparedStatement updateMedicProcentById;
    private PreparedStatement updateMedicProcent;
    private PreparedStatement deleteMedicProcent;
    private PreparedStatement getProcenteByMedicId;
    private PreparedStatement getMedicProcentById;
    private PreparedStatement getAllProcente;
    private PreparedStatement getCountProcentByMedicAndCategoryId;
    private PreparedStatement addMedicProgram;
    private PreparedStatement updateMedicProgram;
    private PreparedStatement getProgramByMedicId;
    private PreparedStatement addProgramare;
    private PreparedStatement addProgramareReferrers;
    private PreparedStatement deleteVizita;
    private PreparedStatement isMedicBusy;
    private PreparedStatement isMedicPresent;
    private PreparedStatement getProgramariForDay;
    private PreparedStatement setProcessing;
    private PreparedStatement addBiletTrimitere;
    private PreparedStatement updateBiletTrimitere;
    private PreparedStatement linkBiletTrimitereToOrder;
    private PreparedStatement getBiletTrimitereForOrder;
    private PreparedStatement addAnaliza;
    private PreparedStatement setValoareForAnaliza;
    private PreparedStatement updateStatusForAnaliza;
    private PreparedStatement getRaportComisionMedici;

    public ClinicaDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getRaportComisionMedici = this.connection.prepareStatement("select products.label as produs, subcategories.label as categorie, sum(sales.quantity_float) as cantitate, sales.ppu as pret, procente.procent as procent_comision from medici inner join medici_users on medici.id = medici_users.id_medic inner join procente on medici.id = procente.id_medic inner join sales on medici_users.id_user = sales.id_user2 inner join products on sales.id_product = products.id inner join subcategories on sales.id_product = subcategories.id inner join orders on sales.id_order = orders.id where orders.closedate >= ? and orders.closedate < ? and (sales.id_user2 = ? or ? = -1) group by products.label, subcategories.label, sales.ppu, procente.procent");
        this.updateStatusForAnaliza = this.connection.prepareStatement("update clinica_analize set status = ? where id = ?");
        this.addMedic = this.connection.prepareStatement("insert into medici ( nume, prenume, id_functie, loc_munca, telefon, telefon_mobil, adresa) values ( ?, ?, ?, ?, ?, ?,?)");
        this.updateMedic = this.connection.prepareStatement("update medici set nume = ?, prenume = ?, id_functie = ?, loc_munca = ?, telefon = ?, telefon_mobil = ?, adresa = ? where id = ?");
        this.deleteMedic = this.connection.prepareStatement("update  medici set status = 2 where id = ?");
        this.getMedicById = this.connection.prepareStatement("select m.*,f.name as numeFunctie from medici m inner join functie f on m.id_functie = f.id where m.id = ?");
        this.getAllMedici = this.connection.prepareStatement("select m.*, f.name as numeFunctie from medici m left outer join functie f on m.id_functie = f.id where m.status = 1 order by nume, prenume");
        this.updateMedicProgram = this.connection.prepareStatement("update program_medici set ora_start = ?, ora_stop = ? where id = ?");
        this.getProgramByMedicId = this.connection.prepareStatement("select program_medici.* from medici  left outer join program_medici on medici.id = program_medici.id_medic where medici.id = ? and an = ? and week = ? and zi_saptamana = ?");
        this.addMedicProgram = this.connection.prepareStatement("insert into program_medici ( id_medic, ora_start, ora_stop, zi_saptamana, an, week) values ( ?, ?, ?, ?, ?, ? )");
        this.addFunctie = this.connection.prepareStatement("insert into functie ( name ) values (?)");
        this.updateFunctie = this.connection.prepareStatement("update functie set name = ? where id = ?");
        this.deleteFunctie = this.connection.prepareStatement("delete from functie where id = ?");
        this.getFunctii = this.connection.prepareStatement("select * from functie order by name");
        this.getDiagnostice = this.connection.prepareStatement("select * from clinica_diagnostice order by name");
        this.getDiagnosticByCod = this.connection.prepareStatement("select * from clinica_diagnostice where cod = ?");
        this.addDiagnostic = this.connection.prepareStatement("insert into clinica_diagnostice ( name, cod ) values (?, ?)");
        this.updateDiagnostic = this.connection.prepareStatement("update clinica_diagnostice set name = ?, cod = ? where id = ?");
        this.deleteDiagnostic = this.connection.prepareStatement("delete from clinica_diagnostice where id = ?");
        this.addMedicProcent = this.connection.prepareStatement("insert into procente ( id_medic, id_category, procent) values ( ?, ?, ?)");
        this.updateMedicProcentById = this.connection.prepareStatement("update procente set procent = ? where id = ?");
        this.updateMedicProcent = this.connection.prepareStatement("update procente set procent = ? where id_medic = ? and id_category = ?");
        this.deleteMedicProcent = this.connection.prepareStatement("delete from procente where id = ?");
        this.getProcenteByMedicId = this.connection.prepareStatement("select p.*, m.nume || ' ' || m.prenume as numeMedic, c.label as categoryName from procente p inner join medici m on (p.id_medic = m.id) inner join categories c on (p.id_category = c.id) where p.id_medic = ?");
        this.getMedicProcentById = this.connection.prepareStatement("select p.*, m.nume || ' ' || m.prenume as numeMedic, c.label as categoryName from procente p inner join medici m on (p.id_medic = m.id) inner join categories c on (p.id_category = c.id) where p.id = ?");
        this.getAllProcente = this.connection.prepareStatement("select p.*, m.nume || ' ' || m.prenume as numeMedic, c.label as categoryName from procente p inner join medici m on (p.id_medic = m.id) inner join categories c on (p.id_category = c.id) order by numeMedic, categoryName");
        this.getCountProcentByMedicAndCategoryId = this.connection.prepareStatement("select count(*) from procente where id_medic = ? and id_category = ?");
        this.isMedicPresent = this.connection.prepareStatement("select * from program_medici where zi_saptamana = ? and id_medic = ? and an = ? and week = ?");
        this.isMedicBusy = this.connection.prepareStatement("select * from vizite where vizite.data_vizita < ? and vizite.stopVizita > ? and id_medic = ?");
        this.addProgramare = this.connection.prepareStatement("insert into vizite ( id_pacient, id_medic, id_specialitate, data_vizita, durata, stopVizita, status, consultatie ) values ( ?, ?, ?, ?, ?, ?, 1, ?)");
        this.addProgramareReferrers = this.connection.prepareStatement("insert into referrers ( idVizita, idMedic ) values ( ?, ? )");
        this.deleteVizita = this.connection.prepareStatement("update vizite set status = 2 where id = ?");
        this.getProgramariForDay = this.connection.prepareStatement("select vizite.*, medici.nume || ' ' || medici.prenume as medic, subcategories.label as specializare, persoane_fizice.nume || ' ' || persoane_fizice.prenume as pacient from vizite inner join subcategories on vizite.id_specialitate = subcategories.id inner join medici on vizite.id_medic = medici.id inner join persoane_fizice on vizite.id_pacient = persoane_fizice.id where data_vizita < ? and stopVizita > ? and (   vizite.status = 1   or vizite.status = 6 ) and (?=-1 or vizite.id_medic = ?) order by medici.nume, medici.prenume, data_vizita");
        this.setProcessing = this.connection.prepareStatement("update vizite set status = 6 where id = ?");
        this.addBiletTrimitere = this.connection.prepareStatement("insert into clinica_bilete_trimitere (id_platitor, id_pachet_cas, serie, numar, cod_diagnostic, diagnostic, cod_parafa, cod_asigurat, id_file) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.updateBiletTrimitere = this.connection.prepareStatement("update clinica_bilete_trimitere set id_platitor = ? ,id_pachet_cas = ? ,serie = ? ,numar = ? ,cod_diagnostic = ? ,diagnostic = ? ,cod_parafa = ? ,cod_asigurat = ? ,id_file = ? where id = ?");
        this.linkBiletTrimitereToOrder = this.connection.prepareStatement("insert into clinica_orders_bilete ( id_order, id_bilet) values (?, ?)");
        this.getBiletTrimitereForOrder = this.connection.prepareStatement("select clinica_bilete_trimitere.id_platitor, clinica_bilete_trimitere.id_pachet_cas, clinica_bilete_trimitere.serie, clinica_bilete_trimitere.numar, clinica_bilete_trimitere.cod_diagnostic, clinica_bilete_trimitere.diagnostic, clinica_bilete_trimitere.cod_parafa, clinica_bilete_trimitere.cod_asigurat, clinica_bilete_trimitere.id, coalesce(clinica_bilete_trimitere.id_file, -1) as id_file from clinica_bilete_trimitere inner join clinica_orders_bilete on clinica_orders_bilete.id_bilet = clinica_bilete_trimitere.id where id_order = ?");
        this.addAnaliza = this.connection.prepareStatement("insert into clinica_analize ( id_sale, externa ) values ( ?, ?) ");
        this.setValoareForAnaliza = this.connection.prepareStatement("update clinica_analize set valoare = ? where id = ?");
    }

    public void addMedic(String nume, String prenume, int functie, String locMunca, String telefon, String telefonMobil, String adresa) throws SQLException {
        this.addMedic.setString(1, nume);
        this.addMedic.setString(2, prenume);
        this.addMedic.setInt(3, functie);
        this.addMedic.setString(4, locMunca);
        this.addMedic.setString(5, telefon);
        this.addMedic.setString(6, telefonMobil);
        this.addMedic.setString(7, adresa);
        this.addMedic.execute();
    }

    public void updateMedic(Medic toUpdate) throws SQLException {
        this.updateMedic.setString(1, toUpdate.getNume());
        this.updateMedic.setString(2, toUpdate.getPrenume());
        this.updateMedic.setInt(3, toUpdate.getIdFunctie());
        this.updateMedic.setString(4, toUpdate.getLocMunca());
        this.updateMedic.setString(5, toUpdate.getTelefon());
        this.updateMedic.setString(6, toUpdate.getTelefonMobil());
        this.updateMedic.setString(7, toUpdate.getAdresa());
        this.updateMedic.setInt(8, toUpdate.getId());
        this.updateMedic.execute();
    }

    public void deleteMedic(Medic toDelete) throws SQLException {
        this.deleteMedic.setInt(1, toDelete.getId());
        this.deleteMedic.execute();
    }

    public Medic getMedicById(int id) throws SQLException {
        this.getMedicById.setInt(1, id);
        ResultSet rs = this.getMedicById.executeQuery();
        if (rs.next()) {
            return ClinicaDao.getMedicFromRS(rs);
        }
        return null;
    }

    public Vector getAllMedici() throws SQLException {
        Vector<Medic> result = new Vector<Medic>();
        ResultSet rs = this.getAllMedici.executeQuery();
        while (rs.next()) {
            Medic toAdd = ClinicaDao.getMedicFromRS(rs);
            result.add(toAdd);
        }
        return result;
    }

    public static Medic getMedicFromRS(ResultSet rs) throws SQLException {
        Medic md = new Medic(rs.getString("nume"), rs.getString("prenume"), rs.getString("numeFunctie"), rs.getString("loc_munca"), rs.getString("telefon"), rs.getString("telefon_mobil"), rs.getString("adresa"), rs.getInt("id"), rs.getInt("id_functie"));
        return md;
    }

    public void addFunctie(String name) throws SQLException {
        this.addFunctie.setString(1, name);
        this.addFunctie.execute();
    }

    public void updateFunctie(Functie toUpdate) throws SQLException {
        this.updateFunctie.setString(1, toUpdate.getName());
        this.updateFunctie.setInt(2, toUpdate.getIdFunctie());
        this.updateFunctie.execute();
    }

    public void deleteFunctie(Functie toDelete) throws SQLException {
        this.deleteFunctie.setInt(1, toDelete.getIdFunctie());
        this.deleteFunctie.execute();
    }

    public Vector getFunctii() throws SQLException {
        Vector<Functie> result = new Vector<Functie>();
        ResultSet rs = this.getFunctii.executeQuery();
        while (rs.next()) {
            Functie toAdd = this.getFunctieFromRS(rs);
            result.add(toAdd);
        }
        return result;
    }

    private Functie getFunctieFromRS(ResultSet rs) throws SQLException {
        Functie pl = new Functie(rs.getInt("id"), rs.getString("name"));
        return pl;
    }

    public Vector getDiagnostice() throws SQLException {
        Vector<Diagnostic> result = new Vector<Diagnostic>();
        ResultSet rs = this.getDiagnostice.executeQuery();
        while (rs.next()) {
            Diagnostic toAdd = this.getDiagnosticeFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Diagnostic getDiagnosticByCod(String cod) throws SQLException {
        Diagnostic result = null;
        this.getDiagnosticByCod.setString(1, cod);
        ResultSet rs = this.getDiagnosticByCod.executeQuery();
        if (rs.next()) {
            result = this.getDiagnosticeFromRS(rs);
        }
        rs.close();
        return result;
    }

    public void addDiagnostic(String name, String cod) throws SQLException {
        this.addDiagnostic.setString(1, name);
        this.addDiagnostic.setString(2, cod);
        this.addDiagnostic.execute();
    }

    public void updateDiagnostic(Diagnostic toUpdate) throws SQLException {
        this.updateDiagnostic.setString(1, toUpdate.getName());
        this.updateDiagnostic.setString(2, toUpdate.getCod());
        this.updateDiagnostic.setInt(3, toUpdate.getIdDiagnostic());
        this.updateDiagnostic.execute();
    }

    public void deleteDiagnostic(Diagnostic toDelete) throws SQLException {
        this.deleteDiagnostic.setInt(1, toDelete.getIdDiagnostic());
        this.deleteDiagnostic.execute();
    }

    private Diagnostic getDiagnosticeFromRS(ResultSet rs) throws SQLException {
        Diagnostic pl = new Diagnostic(rs.getInt("id"), rs.getString("name"), rs.getString("cod"));
        return pl;
    }

    public void addMedicProcent(int idMedic, int idCategory, double procent) throws SQLException {
        this.addMedicProcent.setInt(1, idMedic);
        this.addMedicProcent.setInt(2, idCategory);
        this.addMedicProcent.setDouble(3, procent);
        this.addMedicProcent.execute();
    }

    public void updateMedicProcentById(MedicProcent toUpdate) throws SQLException {
        this.updateMedicProcentById.setDouble(1, toUpdate.getProcent());
        this.updateMedicProcentById.setInt(2, toUpdate.getId());
        this.updateMedicProcentById.execute();
    }

    public void updateMedicProcent(int idMedic, int idCategory, double procent) throws SQLException {
        this.updateMedicProcent.setDouble(1, procent);
        this.updateMedicProcent.setInt(2, idMedic);
        this.updateMedicProcent.setInt(3, idCategory);
        this.updateMedicProcent.execute();
    }

    public void deleteMedicProcent(MedicProcent toDelete) throws SQLException {
        this.deleteMedicProcent.setInt(1, toDelete.getId());
        this.deleteMedicProcent.execute();
    }

    public Vector getProcenteByMedicId(int idMedic) throws SQLException {
        Vector<MedicProcent> result = new Vector<MedicProcent>();
        this.getProcenteByMedicId.setInt(1, idMedic);
        ResultSet rs = this.getProcenteByMedicId.executeQuery();
        while (rs.next()) {
            MedicProcent toAdd = this.getMedicProcentFromRS(rs);
            result.add(toAdd);
        }
        return result;
    }

    public MedicProcent getMedicProcentById(int id) throws SQLException {
        this.getMedicProcentById.setInt(1, id);
        ResultSet rs = this.getMedicProcentById.executeQuery();
        if (rs.next()) {
            return this.getMedicProcentFromRS(rs);
        }
        return null;
    }

    public Vector getAllProcente() throws SQLException {
        Vector<MedicProcent> result = new Vector<MedicProcent>();
        ResultSet rs = this.getAllProcente.executeQuery();
        while (rs.next()) {
            MedicProcent toAdd = this.getMedicProcentFromRS(rs);
            result.add(toAdd);
        }
        return result;
    }

    private MedicProcent getMedicProcentFromRS(ResultSet rs) throws SQLException {
        MedicProcent mp = new MedicProcent(rs.getInt("id"), rs.getInt("id_medic"), rs.getString("numeMedic"), rs.getInt("id_category"), rs.getString("categoryName"), rs.getDouble("procent"));
        return mp;
    }

    public int getCountProcentByMedicAndCategoryId(int idMedic, int idCategory) throws SQLException {
        this.getCountProcentByMedicAndCategoryId.setInt(1, idMedic);
        this.getCountProcentByMedicAndCategoryId.setInt(2, idCategory);
        ResultSet rs = this.getCountProcentByMedicAndCategoryId.executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public void setVizitaProcessing(int idVizita) throws SQLException {
        this.setProcessing.setInt(1, idVizita);
        this.setProcessing.execute();
    }

    public Vector getProgramariForDay(Timestamp start, Timestamp stop, int idMedic) throws SQLException {
        Vector<ProgramareEntry> result = new Vector<ProgramareEntry>();
        this.getProgramariForDay.setTimestamp(1, stop);
        this.getProgramariForDay.setTimestamp(2, start);
        this.getProgramariForDay.setInt(3, idMedic);
        this.getProgramariForDay.setInt(4, idMedic);
        ResultSet rs = this.getProgramariForDay.executeQuery();
        while (rs.next()) {
            ProgramareEntry pe = new ProgramareEntry();
            pe.setIdMedic(rs.getInt("id_medic"));
            pe.setIdPacient(rs.getInt("id_pacient"));
            pe.setIdProgramare(rs.getInt("id"));
            pe.setIdSpecializare(rs.getInt("id_specialitate"));
            pe.setMedic(rs.getString("medic"));
            pe.setSpecializare(rs.getString("specializare"));
            pe.setPacient(rs.getString("pacient"));
            pe.setConsultatie(rs.getString("consultatie"));
            pe.setStatus(rs.getInt("status"));
            Timestamp d = rs.getTimestamp("data_vizita");
            pe.setOra(Formatters.TIME_FORMAT.format(d));
            result.add(pe);
        }
        return result;
    }

    public boolean isMedicBusy(Timestamp start, Timestamp stop, int idMedic) throws SQLException {
        this.isMedicBusy.setTimestamp(1, stop);
        this.isMedicBusy.setTimestamp(2, start);
        this.isMedicBusy.setInt(3, idMedic);
        ResultSet rs = this.isMedicBusy.executeQuery();
        return rs.next();
    }

    public DayProgram isMedicPresent(int idZiSaptamana, int idMedic, int an, int week) throws SQLException {
        this.isMedicPresent.setInt(1, idZiSaptamana);
        this.isMedicPresent.setInt(2, idMedic);
        this.isMedicPresent.setInt(3, an);
        this.isMedicPresent.setInt(4, week);
        ResultSet rs = this.isMedicPresent.executeQuery();
        if (rs.next()) {
            return this.getMedicProgramFromRS(rs);
        }
        return null;
    }

    public void deleteVizita(int id) throws SQLException {
        this.deleteVizita.setInt(1, id);
        this.deleteVizita.execute();
    }

    public void addProgramare(int idMedic, int idPacient, int idSpecializare, Timestamp startDate, Timestamp stopDate, int durata, String consultatie) throws SQLException {
        this.addProgramare.setInt(1, idPacient);
        this.addProgramare.setInt(2, idMedic);
        this.addProgramare.setInt(3, idSpecializare);
        this.addProgramare.setTimestamp(4, startDate);
        this.addProgramare.setInt(5, durata);
        this.addProgramare.setTimestamp(6, stopDate);
        this.addProgramare.setString(7, consultatie);
        this.addProgramare.execute();
    }

    public void addProgramareReferrers(int idVizita, int idMedic) throws SQLException {
        this.addProgramareReferrers.setInt(1, idVizita);
        this.addProgramareReferrers.setInt(2, idMedic);
        this.addProgramareReferrers.execute();
    }

    public void addMedicProgram(int idMedic, int idZi, Time oraStart, Time oraStop, int an, int week) throws SQLException {
        this.addMedicProgram.setInt(1, idMedic);
        if (oraStart != null) {
            this.addMedicProgram.setTime(2, oraStart);
        } else {
            this.addMedicProgram.setNull(2, 92);
        }
        if (oraStop != null) {
            this.addMedicProgram.setTime(3, oraStop);
        } else {
            this.addMedicProgram.setNull(3, 92);
        }
        this.addMedicProgram.setInt(4, idZi);
        this.addMedicProgram.setInt(5, an);
        this.addMedicProgram.setInt(6, week);
        this.addMedicProgram.execute();
    }

    public void updateMedicProgram(int id, Time oraStart, Time oraStop) throws SQLException {
        if (oraStart != null) {
            this.updateMedicProgram.setTime(1, oraStart);
        } else {
            this.updateMedicProgram.setNull(1, 92);
        }
        if (oraStop != null) {
            this.updateMedicProgram.setTime(2, oraStop);
        } else {
            this.updateMedicProgram.setNull(2, 92);
        }
        this.updateMedicProgram.setInt(3, id);
        this.updateMedicProgram.execute();
    }

    public DayProgram[] getProgramByMedicId(int idMedic, int an, int week) throws SQLException {
        DayProgram[] result = new DayProgram[7];
        for (int i = 0; i < 7; ++i) {
            DayProgram toAdd;
            this.getProgramByMedicId.setInt(1, idMedic);
            this.getProgramByMedicId.setInt(2, an);
            this.getProgramByMedicId.setInt(3, week);
            this.getProgramByMedicId.setInt(4, i + 1);
            ResultSet rs = this.getProgramByMedicId.executeQuery();
            if (!rs.next()) continue;
            result[i] = toAdd = this.getMedicProgramFromRS(rs);
        }
        return result;
    }

    private DayProgram getMedicProgramFromRS(ResultSet rs) throws SQLException {
        DayProgram mp = new DayProgram();
        mp.setId(rs.getInt("id"));
        mp.setIdDay(rs.getInt("zi_saptamana"));
        mp.setStart(rs.getTime("ora_start"));
        mp.setStop(rs.getTime("ora_stop"));
        return mp;
    }

    public void addBiletTrimitere(int idPlatitor, int idPachetCAS, String serie, String numar, String codDiagnostic, String diagnostic, String codParafa, String codAsigurat, int idFile) throws SQLException {
        this.addBiletTrimitere.setInt(1, idPlatitor);
        this.addBiletTrimitere.setInt(2, idPachetCAS);
        this.addBiletTrimitere.setString(3, serie);
        this.addBiletTrimitere.setString(4, numar);
        this.addBiletTrimitere.setString(5, codDiagnostic);
        this.addBiletTrimitere.setString(6, diagnostic);
        this.addBiletTrimitere.setString(7, codParafa);
        this.addBiletTrimitere.setString(8, codAsigurat);
        if (idFile > 0) {
            this.addBiletTrimitere.setInt(9, idFile);
        } else {
            this.addBiletTrimitere.setNull(9, 4);
        }
        this.addBiletTrimitere.execute();
    }

    public void updateBiletTrimitere(int idPlatitor, int idPachetCAS, String serie, String numar, String codDiagnostic, String diagnostic, String codParafa, String codAsigurat, int idBiletTrimitere, int idFile) throws SQLException {
        this.updateBiletTrimitere.setInt(1, idPlatitor);
        this.updateBiletTrimitere.setInt(2, idPachetCAS);
        this.updateBiletTrimitere.setString(3, serie);
        this.updateBiletTrimitere.setString(4, numar);
        this.updateBiletTrimitere.setString(5, codDiagnostic);
        this.updateBiletTrimitere.setString(6, diagnostic);
        this.updateBiletTrimitere.setString(7, codParafa);
        this.updateBiletTrimitere.setString(8, codAsigurat);
        if (idFile > 0) {
            this.updateBiletTrimitere.setInt(9, idFile);
        } else {
            this.updateBiletTrimitere.setNull(9, 4);
        }
        this.updateBiletTrimitere.setInt(10, idBiletTrimitere);
        this.updateBiletTrimitere.execute();
    }

    public void linkBiletToOrder(int idOrder, int idBilet) throws SQLException {
        this.linkBiletTrimitereToOrder.setInt(1, idOrder);
        this.linkBiletTrimitereToOrder.setInt(2, idBilet);
        this.linkBiletTrimitereToOrder.execute();
    }

    public BiletTrimitere getBiletTrimitereForOrder(int idOrder) throws SQLException {
        BiletTrimitere result = null;
        this.getBiletTrimitereForOrder.setInt(1, idOrder);
        ResultSet rs = this.getBiletTrimitereForOrder.executeQuery();
        if (rs.next()) {
            result = new BiletTrimitere();
            result.setIdPlatitor(rs.getInt("id_platitor"));
            result.setIdPachet(rs.getInt("id_pachet_cas"));
            result.setSerie(rs.getString("serie"));
            result.setNumar(rs.getString("numar"));
            result.setCodDiagnostic(rs.getString("cod_diagnostic"));
            result.setDenumireDiagnostic(rs.getString("diagnostic"));
            result.setCodParafa(rs.getString("cod_parafa"));
            result.setCodAsigurat(rs.getString("cod_asigurat"));
            result.setId(rs.getInt("id"));
            result.setIdFile(rs.getInt("id_file"));
        }
        rs.close();
        return result;
    }

    private Vector getOrdersForBileteTrimitere(Hashtable criteria, int what, boolean siNoteDeschise) throws SQLException {
        String type1;
        Date stop;
        Date start;
        String s = " select orders.id as id from orders inner join clinica_orders_bilete on orders.id = clinica_orders_bilete.id_order inner join clinica_bilete_trimitere on clinica_orders_bilete.id_bilet = clinica_bilete_trimitere.id where (status = 4 or status = 3";
        if (siNoteDeschise) {
            s = s + " or status = 5 or status = 1";
        }
        s = s + ")";
        User waiter = (User)criteria.get("user_fo");
        if (waiter != null) {
            s = s + " and id_user = " + waiter.getId();
        }
        if ((start = (Date)criteria.get(Constants.START_KEY)) != null) {
            s = s + " and closedate >= '" + new Timestamp(start.getTime()) + "'";
        }
        if ((stop = (Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and closedate <= '" + new Timestamp(stop.getTime()) + "'";
        }
        if ((type1 = (String)criteria.get("BILET_NUMAR")) != null) {
            s = s + " and clinica_bilete_trimitere.numar = '" + type1 + "'";
        }
        if ((type1 = (String)criteria.get("BILET_SERIE")) != null) {
            s = s + " and clinica_bilete_trimitere.serie = '" + type1 + "'";
        }
        if ((type1 = (String)criteria.get("BILET_COD_PARAFA")) != null) {
            s = s + " and clinica_bilete_trimitere.cod_parafa = '" + type1 + "'";
        }
        if ((type1 = (String)criteria.get("BILET_COD_ASIGURAT")) != null) {
            s = s + " and clinica_bilete_trimitere.cod_asigurat = '" + type1 + "'";
        }
        if ((type1 = (String)criteria.get("BILET_COD_DIAGNOSTIC")) != null) {
            s = s + " and clinica_bilete_trimitere.cod_diagnostic = '" + type1 + "'";
        }
        if ((type1 = (String)criteria.get("BILET_PLATITOR")) != null) {
            s = s + " and clinica_bilete_trimitere.id_platitor = " + type1;
        }
        if ((type1 = (String)criteria.get("BILET_CLIENT")) != null) {
            s = s + " and orders.id_client = " + type1;
        }
        switch (what) {
            case 2: {
                s = s + " and fiscal='true' ";
                break;
            }
            case 3: {
                s = s + " and (fiscal='false' or fiscal is null)";
                break;
            }
        }
        System.out.println("executing query : " + s);
        Logger.logDebugVerbose(this, "executing query : " + s);
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<Integer> result = new Vector<Integer>();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        return result;
    }

    public Vector getRaportBileteTrimitere(Hashtable criteria, boolean siNoteDeschise, int what) throws SQLException {
        Vector ids = this.getOrdersForBileteTrimitere(criteria, what, siNoteDeschise);
        if (ids.size() == 0 || ids.size() > 48000) {
            return new Vector();
        }
        String s = "select users.name as waiter, users.id as waiter_id, sum(sales.quantity_float) as cantitate, sum(sales.quantity_float) * sales.ppu as suma, sum(sales.quantity_float) * sales.discount as discount_suma, tables.label || ' ' || locations.name as masa, products.label as nume_produs, sales.id_product as id_product, orders.closedate, orders.opendate, orders.id as id_order, orders.fiscal as fiscal, tables.id as id_table, locations.id as id_location from orders inner join sales on orders.id = sales.id_order inner join products on sales.id_product = products.id inner join users on orders.id_user = users.id inner join tables on orders.id_table = tables.id inner join locations on tables.id_locatie = locations.id";
        String s2 = Utils.getSqlInSequence(ids);
        s = s + " where id_order in " + s2;
        s = s + " group by users.name, users.id, sales.ppu, sales.discount, tables.label, products.label, orders.closedate, orders.opendate, orders.id, orders.fiscal, tables.id, sales.id_product, locations.id, locations.name order by closedate desc";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<NoteView> result = new Vector<NoteView>();
        String lastTable = "";
        Timestamp lastCloseDate = null;
        NoteView currentNota = null;
        while (rs.next()) {
            NoteView nv = new NoteView();
            nv.setCantitate(rs.getDouble("cantitate"));
            int idProduct = rs.getInt("id_product");
            String produs = rs.getString("nume_produs");
            nv.setIdProdus(idProduct);
            nv.setProdus(produs);
            String newTable = rs.getString("waiter") + "," + rs.getString("masa");
            Timestamp t1 = rs.getTimestamp("closedate");
            if (t1 == null) {
                t1 = rs.getTimestamp("opendate");
            }
            if (!lastTable.equalsIgnoreCase(newTable) || !lastCloseDate.equals(t1)) {
                nv.setOspatarMasa(newTable);
                lastTable = newTable;
                lastCloseDate = t1;
                nv.setData(t1);
                currentNota = nv;
            }
            double suma = rs.getDouble("suma");
            nv.setSuma(suma);
            nv.setDiscount(rs.getDouble("discount_suma"));
            nv.setIdOrder(rs.getInt("id_order"));
            nv.setIdTable(rs.getInt("id_table"));
            nv.setIdWaiter(rs.getInt("waiter_id"));
            boolean fiscal = false;
            String s1 = rs.getString("fiscal");
            if (Validators.correctString(s1) && s1.equalsIgnoreCase("true")) {
                fiscal = true;
            }
            nv.setFiscal(fiscal);
            currentNota.setTotalNota(currentNota.getTotalNota() + suma);
            result.add(nv);
        }
        rs.close();
        return result;
    }

    public Vector getAnalizeReport(Hashtable criteria, int idSectieAnalize, int idMinAttribute, int idMaxAtrribute) throws SQLException {
        Object product;
        Date stop;
        String s = "select (select(value) from mapping_product_attribute where mapping_product_attribute.id_product = products.id and mapping_product_attribute.id_attribute = " + idMinAttribute + ") as min_value," + " (select(value) from mapping_product_attribute where" + " mapping_product_attribute.id_product = products.id and mapping_product_attribute.id_attribute = " + idMaxAtrribute + ") as max_value," + " coalesce( char(clinica_analize.valoare), ' ') as rezultat_analiza," + " products.label as nume_produs," + " subcategories.label as nume_categorie," + " sales.saledate as data_comanda," + " orders.id as id_order," + " sales.ppu as pret," + " products.id as id_produs," + " clinica_analize.externa as is_externa," + " persoane_fizice.id as id_pers_fizica," + " persoane_fizice.id_pers_juridica as id_companie," + " persoane_fizice.nume || ' ' || persoane_fizice.prenume as nume_pacient," + " clinica_analize.id as id_analiza," + " clinica_analize.status as status_analiza," + " coalesce(clinica_bilete_trimitere.id, " + -1 + ") as id_bilet_trimitere" + " from" + " clinica_analize" + " inner join sales on clinica_analize.id_sale = sales.id" + " inner join orders on sales.id_order = orders.id" + " inner join products on sales.id_product = products.id" + " inner join subcategories on products.id_subcategory = subcategories.id" + " inner join clienti on orders.id_client = clienti.id" + " inner join persoane_fizice on clienti.idpersfizica = persoane_fizice.id" + " left outer join clinica_orders_bilete on orders.id = clinica_orders_bilete.id_order" + " left outer join clinica_bilete_trimitere on clinica_orders_bilete.id_bilet = clinica_bilete_trimitere.id" + " where subcategories.id_category = " + idSectieAnalize;
        Date start = (Date)criteria.get(Constants.START_KEY);
        if (start != null) {
            s = s + " and sales.saledate >= '" + new Timestamp(start.getTime()) + "'";
        }
        if ((stop = (Date)criteria.get(Constants.STOP_KEY)) != null) {
            s = s + " and sales.saledate <= '" + new Timestamp(stop.getTime()) + "'";
        }
        if (criteria.get("Categorie") != null) {
            Categorie subcat = (Categorie)criteria.get("Categorie");
            s = s + " and subcategories.id = " + subcat.getId();
        }
        if (criteria.get("Product") != null) {
            product = (Integer)criteria.get("Product");
            s = s + " and products.id = " + product;
        }
        if (criteria.get("Bilet trimitere") != null) {
            product = (String)criteria.get("Bilet trimitere");
            s = s + " and clinica_bilete_trimitere.numar = '" + (String)product + "'";
        }
        if (criteria.get("Casa sanatate") != null) {
            Integer casaSanatate = (Integer)criteria.get("Casa sanatate");
            s = s + " and clinica_bilete_trimitere.id_platitor = " + casaSanatate;
        }
        if (criteria.get("Locala / Externa") != null) {
            String s1 = (String)criteria.get("Locala / Externa");
            if (s1.equalsIgnoreCase("Externa")) {
                s = s + " and clinica_analize.externa = 1";
            } else if (s1.equalsIgnoreCase("Locala")) {
                s = s + " and clinica_analize.externa = 0";
            }
        }
        if (criteria.get("Status analiza") != null) {
            Integer status = (Integer)criteria.get("Status analiza");
            s = s + " and clinica_analize.status = " + status;
        }
        if (criteria.get("Cod bare comanda") != null) {
            product = (String)criteria.get("Cod bare comanda");
            s = s + " and orders.barcode = '" + (String)product + "'";
        }
        if (criteria.get("Pacient") != null) {
            Client pf = (Client)criteria.get("Pacient");
            s = s + " and orders.id_client = " + pf.getId();
        } else if (criteria.get("Angajati ids") != null) {
            Vector ids = (Vector)criteria.get("Angajati ids");
            String inSeq = Utils.getSqlInSequence(ids);
            s = s + " and orders.id_client in " + inSeq;
        }
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        Vector<AnalizeReportEntry> result = new Vector<AnalizeReportEntry>();
        while (rs.next()) {
            AnalizeReportEntry are = new AnalizeReportEntry();
            are.setExterna(rs.getInt("is_externa") == 1);
            are.setIdPersFizica(rs.getInt("id_pers_fizica"));
            are.setNumePersFizica(rs.getString("nume_pacient"));
            are.setIdProdus(rs.getInt("id_produs"));
            are.setNumeProdus(rs.getString("nume_produs"));
            double minValue = rs.getDouble("min_value");
            are.setLimitaMinima(minValue);
            double maxValue = rs.getDouble("max_value");
            are.setLimitaMaxima(maxValue);
            are.setNumeCaterogie(rs.getString("nume_categorie"));
            are.setId(rs.getInt("id_analiza"));
            are.setStatus(rs.getInt("status_analiza"));
            are.setIdBiletTrimitere(rs.getInt("id_bilet_trimitere"));
            are.setIdOrder(rs.getInt("id_order"));
            are.setPret(rs.getDouble("pret"));
            String s1 = rs.getString("rezultat_analiza");
            if (Validators.correctDouble(s1)) {
                String s3;
                double rezult = Utils.parseDouble(s1);
                are.setRezultatAnaliza(rezult);
                are.setCompleted(true);
                if (criteria.get("Rezultat") != null && ((s3 = (String)criteria.get("Rezultat")).equalsIgnoreCase("Normal") ? rezult > maxValue || rezult < minValue : (s3.equalsIgnoreCase("Anormal") ? rezult <= maxValue && rezult >= minValue : (s3.equalsIgnoreCase("Hiper") ? rezult <= maxValue : s3.equalsIgnoreCase("Hipo") && rezult >= minValue)))) {
                    continue;
                }
            } else {
                are.setRezultatAnaliza(0.0);
                are.setCompleted(false);
            }
            are.setData(rs.getTimestamp("data_comanda"));
            if (!are.isCompleted() && criteria.get("Rezultat") != null) continue;
            result.add(are);
        }
        rs.close();
        return result;
    }

    public void addAnaliza(int idSale, boolean externa) throws SQLException {
        this.addAnaliza.setInt(1, idSale);
        this.addAnaliza.setInt(2, externa ? 1 : 0);
        this.addAnaliza.execute();
    }

    public void setValoareToAnaliza(int id, double valoare) throws SQLException {
        this.setValoareForAnaliza.setDouble(1, valoare);
        this.setValoareForAnaliza.setInt(2, id);
        this.setValoareForAnaliza.execute();
    }

    public void updateStatusForAnaliza(int id, int status) throws SQLException {
        this.updateStatusForAnaliza.setInt(1, status);
        this.updateStatusForAnaliza.setInt(2, id);
        this.updateStatusForAnaliza.execute();
    }

    public Vector getComisionMediciReport(int idMedic, Timestamp start, Timestamp stop) throws SQLException {
        Vector<ComisionReportEntry> result = new Vector<ComisionReportEntry>();
        this.getRaportComisionMedici.setTimestamp(1, start);
        this.getRaportComisionMedici.setTimestamp(2, stop);
        this.getRaportComisionMedici.setInt(3, idMedic);
        this.getRaportComisionMedici.setInt(4, idMedic);
        ResultSet rs = this.getRaportComisionMedici.executeQuery();
        while (rs.next()) {
            ComisionReportEntry cre = new ComisionReportEntry();
            cre.setCantitate(rs.getDouble("cantitate"));
            cre.setCategorie(rs.getString("categorie"));
            cre.setPret(rs.getDouble("pret"));
            cre.setProdus(rs.getString("produs"));
            double procent = rs.getDouble("procent_comision");
            cre.setValoare(cre.getPret() * cre.getCantitate());
            cre.setComision(cre.getValoare() * procent / 100.0);
            result.add(cre);
        }
        rs.close();
        return result;
    }
}

