/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.RaportProductieEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportProductiePanel
extends AbstractReportPanel {
    private double valProdCuTva;
    private JLabel valProdCuTvaLabel;
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    protected DoubleClicked action;
    public static final String[] columns = new String[]{"Nr prod", LangRoAll.data, LangRoAll.produs, "Cant", "Pret vz cu tva", LangRoAll.valoare};

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(Constants.START_KEY, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(Constants.STOP_KEY, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportProductieEntry e = (RaportProductieEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getIdProductie();
                    }
                    case 1: {
                        return e.getData();
                    }
                    case 2: {
                        return e.getProdus();
                    }
                    case 3: {
                        return Utils.getString3Decimals(e.getCantitate());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getPretCuTva());
                    }
                    case 5: {
                        return Utils.getString2Decimals(e.getValoareCuTva());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total valoare cu tva"), c);
        ++c.gridx;
        this.valProdCuTvaLabel = new JLabel("");
        result.add((Component)this.valProdCuTvaLabel, c);
        return result;
    }

    @Override
    public String getName() {
        return "Raport productie";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getRaportProductie(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    public void updateTotals(Vector items) {
        this.valProdCuTva = 0.0;
        for (RaportProductieEntry element : items) {
            this.valProdCuTva += element.getValoareCuTva();
        }
        this.valProdCuTvaLabel.setText(Utils.getString2Decimals(this.valProdCuTva));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    RaportProductieEntry entry = (RaportProductieEntry)o;
                    try {
                        int column = 0;
                        sheet.addCell((WritableCell)new Number(column, row, (double)entry.getIdProductie()));
                        Label label = new Label(++column, row, entry.getData());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getCantitate()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getPretCuTva()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getValoareCuTva()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RaportProductiePanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                if (column == 2) {
                    return 6;
                }
                if (column == 1) {
                    return 3;
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 5: {
                        return RaportProductiePanel.this.valProdCuTvaLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return RaportProductiePanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return RaportProductiePanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                RaportProductieEntry sqv = (RaportProductieEntry)row;
                switch (column) {
                    case 0: {
                        return " " + sqv.getIdProductie();
                    }
                    case 1: {
                        return sqv.getData();
                    }
                    case 2: {
                        return sqv.getProdus();
                    }
                    case 3: {
                        return Utils.getString3Decimals(sqv.getCantitate());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sqv.getPretCuTva());
                    }
                    case 5: {
                        return Utils.getString3Decimals(sqv.getValoareCuTva());
                    }
                }
                return null;
            }
        };
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final RaportProductieEntry rpe = (RaportProductieEntry)RaportProductiePanel.this.data.elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        RaportProductiePanel.this.action.doubleClicked(rpe);
                        popup.setVisible(false);
                    }
                });
                popup.add(modifica);
                popup.setInvoker(RaportProductiePanel.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

