/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Order;
import ro.atreides.utils.gui.CenteredJDialog;

public class ReprintDialog
extends CenteredJDialog {
    private Order selected;
    private Table table;

    public ReprintDialog(int butonsPerLine, Vector note) {
        super("Retiparire note recente");
        this.display(note, butonsPerLine);
    }

    private void display(Vector note, int butonsPerLine) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel firstFocus = new JLabel("");
        this.add((Component)firstFocus, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        for (final Order element : note) {
            final Table t = RestLogic.getInstance().getTableById(element.getTable());
            String table1 = RestLogic.getInstance().getFullNameForTable(t.getLabel(), t.getIdLocatie());
            JButton buton = new JButton("<html><center>" + table1 + "<br>" + Formatters.TIME_FORMAT.format(element.getStopTime()) + "</center></html>");
            buton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReprintDialog.this.selected = element;
                    ReprintDialog.this.table = t;
                    ReprintDialog.this.dispose();
                }
            });
            buton.setFocusable(false);
            this.add((Component)buton, c);
            ++c.gridx;
            if (c.gridx != butonsPerLine) continue;
            c.gridx = 0;
            ++c.gridy;
        }
        this.pack();
        firstFocus.requestFocusInWindow();
        this.center(2.0, 2.0);
        this.setVisible(true);
    }

    public Order getSelected() {
        return this.selected;
    }

    public Table getTable() {
        return this.table;
    }
}

