/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.SectieMagazieEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class SectiiMagaziiPanel
extends AbstractListPanel {
    private AbstractTM tm;
    private String[] columns;
    private Vector magazii;

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                SectieMagazieEntry mp = (SectieMagazieEntry)data.elementAt(rowIndex);
                if (columnIndex > 0) {
                    boolean b = (Boolean)aValue;
                    Object magazie = SectiiMagaziiPanel.this.magazii.get(columnIndex - 1);
                    Vector mpValues = mp.getValues();
                    if (VpConfig.getInstance().selectMultipleMagazii) {
                        if (!b) {
                            mpValues.remove(magazie);
                        }
                    } else {
                        mpValues.clear();
                    }
                    if (b) {
                        mpValues.add(magazie);
                    }
                    SectiiMagaziiPanel.this.tm.fireTableDataChanged();
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex > 0;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                SectieMagazieEntry mp = (SectieMagazieEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return mp.getSectie() + "-" + mp.getLocatie();
                    }
                }
                return mp.containsMagazie(SectiiMagaziiPanel.this.columns[columnIndex]);
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel actiuni = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final SectiiMagaziiPanel parent = this;
        JButton valideaza = new JButton(LangRoAll.salveaza);
        valideaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ok = SectiiMagaziiPanel.this.isAllCompleted();
                if (!ok) {
                    ok = DialogUtils.confirmDialog(parent, "Exista sectii fara o magazie asociata. Daca continuati, nu se va efectua scaderea de stoc pentru aceste sectii.", "Doriti sa continuati");
                }
                if (ok) {
                    RestLogic.getInstance().saveSectieMagaziiEntries(SectiiMagaziiPanel.this.tm.getData());
                    DialogUtils.okDialog(parent, "Daca modulul DESCARCARE este pe alt computer, OBLIGATORIU SI URGENT Restart la ACEL computer/soft !!", LangRoAll.atentie);
                    DialogUtils.okDialog(parent, "Operatie efectuata", LangRoAll.succes);
                }
            }
        });
        actiuni.add((Component)valideaza, c);
        actiuni.setBorder(new TitledBorder(LangRoAll.actiuni));
        return actiuni;
    }

    private boolean isAllCompleted() {
        for (SectieMagazieEntry element : this.tm.getData()) {
            if (element.isMagazieSet()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector buildData() {
        return RestLogic.getInstance().getSectieMagazieEntries();
    }

    @Override
    public String[] buildColumns() {
        this.magazii = StockLogic.getInstance().getMagazii();
        this.columns = new String[this.magazii.size() + 1];
        this.columns[0] = LangRoAll.sectie;
        int i = 1;
        for (Magazie element : this.magazii) {
            this.columns[i] = element.getLabel();
            ++i;
        }
        return this.columns;
    }

    @Override
    public Class[] buildTypes() {
        Class[] types = new Class[this.columns.length];
        types[0] = String.class;
        for (int i = 1; i < types.length; ++i) {
            types[i] = Boolean.class;
        }
        return types;
    }

    @Override
    public void doStuff() {
        this.display();
    }

    public Vector getData() {
        return this.tm.getData();
    }
}

