/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.CenteredJDialog;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class SeparaProduseDialog
extends CenteredJDialog {
    private RestLogic logic;
    private Table source;
    private Hashtable salesHash = new Hashtable();
    private Hashtable tmHash = new Hashtable();
    private Hashtable<JTable, Integer> clientIndexHash = new Hashtable();
    private Vector<JButton> leftButtons = new Vector();
    private Vector<JButton> rightButtons = new Vector();
    private JTable leftTable;
    private JTable rightTable;
    private static final String titlePrefix = "Separa produse";
    private int clientIndexLeft = -1;
    private int clientIndexRight = -1;
    private boolean isDesfasuratLeft = false;
    private boolean isDesfasuratRight = false;
    private JButton unasciateBtnLeft;
    private JButton unasciateBtnRight;

    public SeparaProduseDialog(RestLogic logic, Table source) {
        super(titlePrefix);
        this.logic = logic;
        this.source = source;
        this.display();
    }

    private JPanel getClientIndexSelector(final ClientIndexSelected inter, int butonsPerLine, final Vector<JButton> buttons) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        Order order = this.logic.getOpenOrderAtTable(this.source);
        int maxClients = RestLogic.getInstance().getMaxClientsForOrder(order, new Vector<Sale>());
        if (maxClients < 0) {
            maxClients = VpConfig.getInstance().touch2NumarScauneDefault;
        }
        maxClients += 2;
        Vector<String> options = new Vector<String>();
        options.add(LangRoAll.toate);
        options.add("<html><center>Produse<br>Neasociate</center></html>");
        for (int i = 1; i <= maxClients; ++i) {
            options.add("" + i);
        }
        for (final String option : options) {
            final JButton btn = new JButton("<html><center>&nbsp;<br>" + option + "<br>&nbsp;</center></html>");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeparaProduseDialog.this.clearAllButtonsBG(buttons);
                    btn.setForeground(Color.RED);
                    inter.selected(option);
                }
            });
            btn.setFocusable(false);
            result.add((Component)btn, c);
            buttons.add(btn);
            ++c.gridx;
            if (c.gridx != butonsPerLine) continue;
            c.gridx = 0;
            ++c.gridy;
        }
        return result;
    }

    private void clearAllButtonsBG(Vector<JButton> buttons) {
        for (JButton button : buttons) {
            button.setForeground(Color.BLACK);
        }
    }

    private JButton getBtnNeasociat(Vector<JButton> buttons) {
        for (JButton button : buttons) {
            if (!button.getText().contains("<html><center>Produse<br>Neasociate</center></html>")) continue;
            return button;
        }
        return null;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        JPanel leftButtons = this.getClientIndexSelector(new ClientIndexSelected(){

            @Override
            public void selected(String option) {
                if (option.equalsIgnoreCase(LangRoAll.toate)) {
                    SeparaProduseDialog.this.clientIndexLeft = -1;
                } else if (option.equalsIgnoreCase("<html><center>Produse<br>Neasociate</center></html>")) {
                    SeparaProduseDialog.this.clientIndexLeft = 0;
                } else {
                    SeparaProduseDialog.this.clientIndexLeft = Integer.parseInt(option);
                }
                SeparaProduseDialog.this.clientIndexHash.put(SeparaProduseDialog.this.leftTable, SeparaProduseDialog.this.clientIndexLeft);
                SeparaProduseDialog.this.refresh();
            }
        }, 5, this.leftButtons);
        this.add((Component)leftButtons, c);
        ++c.gridx;
        JPanel rightButtons = this.getClientIndexSelector(new ClientIndexSelected(){

            @Override
            public void selected(String option) {
                if (option.equalsIgnoreCase(LangRoAll.toate)) {
                    SeparaProduseDialog.this.clientIndexRight = -1;
                } else if (option.equalsIgnoreCase("<html><center>Produse<br>Neasociate</center></html>")) {
                    SeparaProduseDialog.this.clientIndexRight = 0;
                } else {
                    SeparaProduseDialog.this.clientIndexRight = Integer.parseInt(option);
                }
                SeparaProduseDialog.this.clientIndexHash.put(SeparaProduseDialog.this.rightTable, SeparaProduseDialog.this.clientIndexRight);
                SeparaProduseDialog.this.refresh();
            }
        }, 5, this.rightButtons);
        this.add((Component)rightButtons, c);
        ++c.gridy;
        c.gridx = 0;
        final JButton leftDesfasurat = new JButton(this.getAdunatDesfasuratButtonName(this.isDesfasuratLeft));
        leftDesfasurat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeparaProduseDialog.this.isDesfasuratLeft = !SeparaProduseDialog.this.isDesfasuratLeft;
                leftDesfasurat.setText(SeparaProduseDialog.this.getAdunatDesfasuratButtonName(SeparaProduseDialog.this.isDesfasuratLeft));
                SeparaProduseDialog.this.refresh();
            }
        });
        leftDesfasurat.setForeground(Color.RED);
        this.add((Component)leftDesfasurat, c);
        ++c.gridx;
        final JButton rightDesfasurat = new JButton(this.getAdunatDesfasuratButtonName(this.isDesfasuratRight));
        rightDesfasurat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeparaProduseDialog.this.isDesfasuratRight = !SeparaProduseDialog.this.isDesfasuratRight;
                rightDesfasurat.setText(SeparaProduseDialog.this.getAdunatDesfasuratButtonName(SeparaProduseDialog.this.isDesfasuratRight));
                SeparaProduseDialog.this.refresh();
            }
        });
        rightDesfasurat.setForeground(Color.RED);
        this.add((Component)rightDesfasurat, c);
        ++c.gridy;
        c.gridx = 0;
        this.leftTable = this.getTableWithButtons(this.source);
        JScrollPane scroll = new JScrollPane(this.leftTable);
        this.add((Component)scroll, c);
        ++c.gridx;
        this.rightTable = this.getTableWithButtons(this.source);
        JScrollPane scroll2 = new JScrollPane(this.rightTable);
        this.add((Component)scroll2, c);
        ++c.gridy;
        c.gridx = 0;
        JButton allToRight = new JButton(">>");
        allToRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector data = (Vector)SeparaProduseDialog.this.salesHash.get(SeparaProduseDialog.this.leftTable);
                int newClientIndex = (Integer)SeparaProduseDialog.this.clientIndexHash.get(SeparaProduseDialog.this.rightTable);
                for (int i = 0; i < data.size(); ++i) {
                    Sale o = (Sale)data.elementAt(i);
                    SeparaProduseDialog.this.logic.setClientIndexToSale1(o, newClientIndex);
                }
                SeparaProduseDialog.this.refresh();
            }
        });
        this.add((Component)allToRight, c);
        ++c.gridx;
        JButton allToLeft = new JButton("<<");
        allToLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector data = (Vector)SeparaProduseDialog.this.salesHash.get(SeparaProduseDialog.this.rightTable);
                int newClientIndex = (Integer)SeparaProduseDialog.this.clientIndexHash.get(SeparaProduseDialog.this.leftTable);
                for (int i = 0; i < data.size(); ++i) {
                    Sale o = (Sale)data.elementAt(i);
                    SeparaProduseDialog.this.logic.setClientIndexToSale1(o, newClientIndex);
                }
                SeparaProduseDialog.this.refresh();
            }
        });
        this.add((Component)allToLeft, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SeparaProduseDialog.this.dispose();
            }
        });
        ok.setForeground(Color.RED);
        this.add((Component)ok, c);
        this.unasciateBtnLeft = this.getBtnNeasociat(this.leftButtons);
        if (this.unasciateBtnLeft != null) {
            this.unasciateBtnLeft.doClick();
        }
        this.unasciateBtnRight = this.getBtnNeasociat(this.rightButtons);
        if (this.unasciateBtnRight != null) {
            this.unasciateBtnRight.doClick();
        }
        this.pack();
        this.center(2.0, 2.0);
        this.setVisible(true);
    }

    private String getAdunatDesfasuratButtonName(boolean isDesfasurat) {
        if (isDesfasurat) {
            return "Adunat";
        }
        return "Desfasurat";
    }

    private JTable getTableWithButtons(Table sourceTable) {
        AbstractTM sourceTm = new AbstractTM(new String[]{LangRoAll.produs, LangRoAll.cantitate}, new Class[]{String.class, String.class}, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Sale o = (Sale)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        String s = o.getProductName();
                        String mp = o.getModPreparare();
                        if (Validators.correctString(mp)) {
                            s = s + " (" + mp + ")";
                        }
                        return s;
                    }
                    case 1: {
                        return o.getQuantity();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        final JTable table = new JTable(sourceTm);
        this.tmHash.put(table, sourceTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                Vector data = (Vector)SeparaProduseDialog.this.salesHash.get(table);
                if (selRow != -1) {
                    Sale o = (Sale)data.elementAt(selRow);
                    System.out.println("sale ids : " + o.getIdSales());
                    JTable target = null;
                    if (table == SeparaProduseDialog.this.leftTable) {
                        target = SeparaProduseDialog.this.rightTable;
                    }
                    if (table == SeparaProduseDialog.this.rightTable) {
                        target = SeparaProduseDialog.this.leftTable;
                    }
                    int targetClientIndex = (Integer)SeparaProduseDialog.this.clientIndexHash.get(target);
                    int sourceClientIndex = (Integer)SeparaProduseDialog.this.clientIndexHash.get(table);
                    if (sourceClientIndex == targetClientIndex) {
                        return;
                    }
                    if (targetClientIndex == -1) {
                        return;
                    }
                    if (sourceClientIndex == -1) {
                        return;
                    }
                    boolean mustAct = false;
                    int modifiers = e.getModifiers();
                    if ((modifiers & 4) > 0 || (modifiers & 8) > 0) {
                        String value = DialogUtils.inputDialog(GuiUtils.currentFrame, Utils.getString3Decimals(o.getCantitateMarcata()), "Cantitatea");
                        if (Validators.correctDouble(value)) {
                            double quantity = Utils.parseDouble(value);
                            if (SeparaProduseDialog.this.logic.splitSale(o, quantity, targetClientIndex)) {
                                mustAct = true;
                            }
                        }
                    } else {
                        SeparaProduseDialog.this.logic.setClientIndexToSale1(o, targetClientIndex);
                        mustAct = true;
                    }
                    if (mustAct) {
                        SeparaProduseDialog.this.refresh();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        GuiUtils.updateJTableRowSize(table, VpConfig.getInstance().touchTableFontSize);
        return table;
    }

    private void refresh() {
        Order order = this.logic.getOpenOrderAtTable(this.source);
        ScreenSaleInterface leftInterface = new ScreenSaleInterface();
        Vector<Sale> sales = this.logic.getSales(order.getId(), !this.isDesfasuratLeft, -1, leftInterface, this.clientIndexLeft);
        this.salesHash.put(this.leftTable, sales);
        AbstractTM left = (AbstractTM)this.tmHash.get(this.leftTable);
        left.refresh(sales);
        ScreenSaleInterface rightInterface = new ScreenSaleInterface();
        sales = this.logic.getSales(order.getId(), !this.isDesfasuratRight, -1, rightInterface, this.clientIndexRight);
        this.salesHash.put(this.rightTable, sales);
        AbstractTM right = (AbstractTM)this.tmHash.get(this.rightTable);
        right.refresh(sales);
    }

    static interface ClientIndexSelected {
        public void selected(String var1);
    }
}

