/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class ShowRecipeDialog
extends AbstractListPanel {
    private int chosenIngredient;
    private int idProduct;
    private int idLanguage;
    private RestLogic logic;
    private JDialog dialog;
    private double chosenIngredientQuantity;

    public ShowRecipeDialog(int idProduct, int idLanguage) {
        this.idLanguage = idLanguage;
        this.idProduct = idProduct;
        this.logic = RestLogic.getInstance();
    }

    public double getChosenIngredientQuantity() {
        return this.chosenIngredientQuantity;
    }

    public void setChosenIngredientQuantity(double chosenIngredientQuantity) {
        this.chosenIngredientQuantity = chosenIngredientQuantity;
    }

    public int getChosenIngredient() {
        return this.chosenIngredient;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                NewRecipeEntry e = (NewRecipeEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getName();
                    }
                    case 1: {
                        return Utils.getString3Decimals(e.getQuantity());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public Vector buildData() {
        return this.logic.getRecipesForProdusReteta(this.idProduct, this.idLanguage);
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Ingredient", LangRoAll.cantitate};
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, String.class};
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow;
                if (e.getClickCount() == 2 && (selRow = ShowRecipeDialog.this.table.rowAtPoint(e.getPoint())) != -1) {
                    NewRecipeEntry obj = (NewRecipeEntry)ShowRecipeDialog.this.tm.getObjectAt(selRow);
                    if (DialogUtils.confirmDialog(ShowRecipeDialog.this.table, "Alegem " + obj.getName(), LangRoAll.confirmare)) {
                        ShowRecipeDialog.this.chosenIngredient = obj.getIdStock();
                        ShowRecipeDialog.this.chosenIngredientQuantity = obj.getQuantity();
                        ShowRecipeDialog.this.dialog.dispose();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }
}

