/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.achizitii;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.achizitii.AchizitiiProdusePanel;
import ro.atreides.restaurant.gui.achizitii.NecesarReportEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class AchizitiiNecesarReport
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.produs, "UM", "Necesar", "Existent", "De achizitionat"};
    private ReportInterface reportInterface;
    private AchizitiiProdusePanel produsePanel;

    public AchizitiiProdusePanel getProdusePanel() {
        return this.produsePanel;
    }

    public void setProdusePanel(AchizitiiProdusePanel produsePanel) {
        this.produsePanel = produsePanel;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        return new Hashtable();
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                NecesarReportEntry e = (NecesarReportEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getProdus();
                    }
                    case 1: {
                        return e.getUm();
                    }
                    case 2: {
                        return Utils.getString2Decimals(e.getNecesar());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getExistent());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getDeAchizitionat());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public String getName() {
        return "Necesar";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getNecesarReport(this.produsePanel.getProduse(), this.whatToPrint);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    NecesarReportEntry entry = (NecesarReportEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getUm());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(2, row, entry.getNecesar()));
                        sheet.addCell((WritableCell)new Number(3, row, entry.getExistent()));
                        sheet.addCell((WritableCell)new Number(4, row, entry.getDeAchizitionat()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return AchizitiiNecesarReport.this.getName();
                }
            }, new Hashtable());
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return AchizitiiNecesarReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return new Hashtable();
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                NecesarReportEntry e = (NecesarReportEntry)row;
                switch (column) {
                    case 0: {
                        return e.getProdus();
                    }
                    case 1: {
                        return e.getUm();
                    }
                    case 2: {
                        return Utils.getString2Decimals(e.getNecesar());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getExistent());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getDeAchizitionat());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }
}

