/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.achizitii;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.PreparareEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class AchizitiiProdusePanel
extends JPanel {
    private RestLogic logic;
    private StockLogic stockLogic = StockLogic.getInstance();
    private FilterableComboBoxModel xStocksComboModel;
    private XComboBox produse;
    private JTextField time;
    private JTextField cantitate;
    private JButton adauga;
    private JLabel totalFacturaCuTva;
    private AbstractTM itemsTm;
    private double totalGeneral;
    public static final String[] columns = new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare};

    public AchizitiiProdusePanel() {
        this.logic = RestLogic.getInstance();
        this.init();
        this.logic.setAchizitiiPanel(this);
    }

    private void init() {
        this.xStocksComboModel = new FilterableComboBoxModel(RestLogic.getInstance().getAllRetetaProducts(false));
        this.produse = new XComboBox(this.xStocksComboModel);
        this.produse.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel total = this.getTotalFacturaPanel();
        this.add((Component)total, c);
        ++c.gridx;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        JPanel dateProdus = this.getProdusPanel();
        ++c.gridx;
        result.add((Component)dateProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        JPanel nirTable = this.getTablePanel();
        result.add((Component)nirTable, c);
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AchizitiiProdusePanel.this.refreshProductsCombo();
            }

            @Override
            public String getName() {
                return "AchizitiiProdusePanel_products";
            }
        }, 2);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AchizitiiProdusePanel.this.refreshProductsCombo();
            }

            @Override
            public String getName() {
                return "AddBonConsumPanel_stocks";
            }
        }, 26);
        return result;
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.produse, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cantitate = new JTextField(10);
        result.add((Component)this.cantitate, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AchizitiiProdusePanel.this.addEntry();
            }
        });
        result.add((Component)this.adauga, c);
        this.refreshProductsCombo();
        this.initFields();
        return result;
    }

    private void refreshProductsCombo() {
        Vector<Product> products = this.logic.getAllRetetaProducts(false);
        this.xStocksComboModel.refresh(products);
    }

    private void initFields() {
        this.cantitate.setText("");
    }

    private JPanel getTotalFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.total));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalFacturaCuTva = new JLabel("0");
        result.add((Component)this.totalFacturaCuTva, c);
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        JButton renunta = new JButton("Cleanup");
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AchizitiiProdusePanel.this.resetFields();
            }
        });
        result.add((Component)renunta, c);
        return result;
    }

    private void resetFields() {
        this.initFields();
        Vector data = this.itemsTm.getData();
        if (data != null) {
            data.removeAllElements();
        }
        this.itemsTm.fireTableDataChanged();
        this.totalGeneral = 0.0;
        this.updateTotals();
    }

    public void addEntry(int idProduct, double cantitate) {
        Product p = NomeclaturaLogic.getInstance().getProductById(idProduct);
        int idReteta = this.logic.getIdReteta(p.getId());
        PreparareEntry pp = new PreparareEntry();
        double price = this.logic.getPriceForProductCommit(idProduct);
        double value = cantitate * price;
        boolean found = false;
        Vector items = this.itemsTm.getData();
        for (int i = 0; i < items.size() && !found; ++i) {
            PreparareEntry o = (PreparareEntry)items.elementAt(i);
            if (o.getIdProdusReteta() != idReteta) continue;
            o.setCantitate(o.getCantitate() + cantitate);
            o.setValoareVanzare(o.getValoareVanzare() + value);
            found = true;
        }
        if (!found) {
            pp.setCantitate(cantitate);
            pp.setProdus(p.getName());
            pp.setPretVanzare(price);
            pp.setValoareVanzare(value);
            pp.setIdProdusReteta(idReteta);
            items.add(pp);
        }
        this.totalGeneral += value;
        Vector v = this.itemsTm.getData();
        Collections.sort(v);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    private void addEntry() {
        double cant = 0.0;
        Product p = (Product)this.produse.getSelectedItem();
        int idReteta = this.logic.getIdReteta(p.getId());
        if (idReteta <= 0) {
            DialogUtils.errorDialog(this, "Nu puteti prepara decat produse cu reteta", LangRoAll.nuPotContinua);
            return;
        }
        String cantS = this.cantitate.getText();
        if (!Validators.correctDouble(cantS)) {
            DialogUtils.errorDialog(this, "Cantitatea trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        cant = Utils.parseDouble(cantS);
        if (cant <= 0.0) {
            DialogUtils.errorDialog(this, "Cantitatea trebuie sa fie > 0", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        PreparareEntry pp = new PreparareEntry();
        double price = this.logic.getPriceForProductCommit(p.getId());
        double value = cant * price;
        boolean found = false;
        Vector items = this.itemsTm.getData();
        for (int i = 0; i < items.size() && !found; ++i) {
            PreparareEntry o = (PreparareEntry)items.elementAt(i);
            if (o.getIdProdusReteta() != idReteta) continue;
            o.setCantitate(o.getCantitate() + cant);
            o.setValoareVanzare(o.getValoareVanzare() + value);
            found = true;
        }
        if (!found) {
            pp.setCantitate(cant);
            pp.setProdus(p.getName());
            pp.setPretVanzare(price);
            pp.setValoareVanzare(value);
            pp.setIdProdusReteta(idReteta);
            items.add(pp);
        }
        this.totalGeneral += value;
        Vector v = this.itemsTm.getData();
        Collections.sort(v);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    private void updateTotals() {
        this.totalGeneral = 0.0;
        Vector d = this.itemsTm.getData();
        for (int i = 0; i < d.size(); ++i) {
            PreparareEntry pp = (PreparareEntry)d.elementAt(i);
            this.totalGeneral += pp.getValoareVanzare();
        }
        this.totalFacturaCuTva.setText(Utils.getString2Decimals(this.totalGeneral));
    }

    private JPanel getTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.produse));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PreparareEntry p = (PreparareEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return p.getProdus();
                    }
                    case 1: {
                        return Utils.getString3Decimals(p.getCantitate());
                    }
                    case 2: {
                        return Utils.getString2Decimals(p.getValoareVanzare());
                    }
                }
                return null;
            }
        });
        final AchizitiiProdusePanel panel = this;
        JTable table = new JTable(this.itemsTm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(panel, "Doriti sa stergeti aceasta inregistrare", LangRoAll.confirmare)) {
                    AchizitiiProdusePanel.this.eraseEntry(selRow);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        return result;
    }

    private void eraseEntry(int selRow) {
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
    }

    public void doStuff() {
    }

    public void cleanup() {
    }

    public Vector getProduse() {
        return this.itemsTm.getData();
    }
}

