/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.articole;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.admin.articole.ArticolBean;
import ro.atreides.restaurant.gui.admin.recipe.AddRecipePanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.StockInput;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;

public class ArticoleReport
extends AbstractReportPanel
implements CleanupRequired {
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static final String[] columns = new String[]{LangRoAll.tip, LangRoAll.sectie, LangRoAll.categorie, LangRoAll.produs, LangRoAll.pret, LangRoAll.tva, LangRoAll.uzIntern};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, Double.class, Double.class, Boolean.class};
    private XComboBox produseXCombo;
    private FilterableComboBoxModel produseXComboModel;
    private MultiboxList tip;
    private MultiboxList sectii;
    private MultiboxList categorii;
    private MultiboxList tags;
    private MultiboxList uzIntern;
    private MultiboxList productie;
    private MultiboxList tva;
    private static Comparator uzIntern_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            boolean c1 = ((ArticolBean)o1).isUzIntern();
            boolean c2 = ((ArticolBean)o2).isUzIntern();
            if (c1 && !c2) {
                return -1;
            }
            if (c2 && !c1) {
                return 1;
            }
            return 0;
        }
    };
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((ArticolBean)o1).getNume();
            String c2 = ((ArticolBean)o2).getNume();
            return c1.compareToIgnoreCase(c2);
        }
    };
    private static Comparator tip_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((ArticolBean)o1).getType().toString();
            String c2 = ((ArticolBean)o2).getType().toString();
            int result = c1.compareToIgnoreCase(c2);
            return result;
        }
    };
    private static Comparator sectie_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((ArticolBean)o1).getSectie();
            String c2 = ((ArticolBean)o2).getSectie();
            int result = c1.compareToIgnoreCase(c2);
            return result;
        }
    };
    private static Comparator category_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((ArticolBean)o1).getCategorie();
            String c2 = ((ArticolBean)o2).getCategorie();
            int result = c1.compareToIgnoreCase(c2);
            return result;
        }
    };
    private static Comparator price_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((ArticolBean)o1).getPretVanzare();
            double c2 = ((ArticolBean)o2).getPretVanzare();
            int result = (int)(c1 - c2);
            return result;
        }
    };
    private static Comparator tva_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            double c1 = ((ArticolBean)o1).getCotaTva();
            double c2 = ((ArticolBean)o2).getCotaTva();
            int result = (int)(c1 - c2);
            return result;
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, ArticolBean> searchCriteria = new Hashtable<String, ArticolBean>();
        this.printCriteria.clear();
        if (!this.sectii.isAllSelected()) {
            Vector selectedSectii = this.sectii.getSelectedItems();
            this.fillCriteriaFields(selectedSectii, Constants.SECTIE_KEY, this.printCriteria, searchCriteria);
        }
        if (!this.categorii.isAllSelected()) {
            Vector selectedCategories = this.categorii.getSelectedItems();
            this.fillCriteriaFields(selectedCategories, "Categorie", this.printCriteria, searchCriteria);
        }
        if (ComboUtils.anythingButAllSelected(this.produseXCombo)) {
            ArticolBean articolBean = (ArticolBean)this.produseXCombo.getSelectedItem();
            searchCriteria.put("Articol", articolBean);
            this.printCriteria.put("Articol", articolBean);
        }
        if (!this.tip.isAllSelected()) {
            Vector selectedTypes = this.tip.getSelectedItems();
            this.fillCriteriaFields(selectedTypes, "tip_produs_key", this.printCriteria, searchCriteria);
        }
        if (!this.productie.isAllSelected()) {
            Vector selectedProductie = this.productie.getSelectedItems();
            this.fillCriteriaFields(selectedProductie, "Productie", this.printCriteria, searchCriteria);
        }
        if (!this.uzIntern.isAllSelected()) {
            Vector selectedUzes = this.uzIntern.getSelectedItems();
            this.fillCriteriaFields(selectedUzes, "Uz intern", this.printCriteria, searchCriteria);
        }
        if (!this.tags.isAllSelected()) {
            Vector selectedTags = this.tags.getSelectedItems();
            this.fillCriteriaFields(selectedTags, "", this.printCriteria, searchCriteria);
        }
        if (!this.tva.isAllSelected()) {
            Vector selectedTva = this.tva.getSelectedItems();
            this.fillCriteriaFields(selectedTva, "TVA", this.printCriteria, searchCriteria);
        }
        return searchCriteria;
    }

    private void fillCriteriaFields(Vector items, String key, Hashtable printCriteria, Hashtable searchCriteria) {
        printCriteria.put(key, items);
        searchCriteria.put(key, items);
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getAllArticole(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ArticolBean sve = (ArticolBean)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, sve.getType().toString());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Label(++column, row, sve.getSectie()));
                        sheet.addCell((WritableCell)new Label(++column, row, sve.getCategorie()));
                        sheet.addCell((WritableCell)new Label(++column, row, sve.getNume()));
                        sheet.addCell((WritableCell)new Number(++column, row, sve.getPretVanzare()));
                        sheet.addCell((WritableCell)new Number(++column, row, sve.getCotaTva()));
                        sheet.addCell((WritableCell)new Label(++column, row, sve.isUzIntern() ? "Uz intern" : ""));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return ArticoleReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Articole";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                ArticolBean pe = (ArticolBean)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 4: {
                        Double f = (Double)aValue;
                        pe.setPretVanzare(f);
                        RestLogic.getInstance().updatePriceForArticolBean(pe);
                        ArticoleReport.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                        ArticoleReport.this.refreshTotalPanel();
                        break;
                    }
                    case 6: {
                        Boolean b = (Boolean)aValue;
                        pe.setUzIntern(b);
                        RestLogic.getInstance().updateUzInternForArticolBean(pe);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 6 || columnIndex == 4;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ArticolBean pe = (ArticolBean)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return pe.getType().toString();
                    }
                    case 1: {
                        return pe.getSectie();
                    }
                    case 2: {
                        return pe.getCategorie();
                    }
                    case 3: {
                        return pe.getNume();
                    }
                    case 4: {
                        return pe.getPretVanzare();
                    }
                    case 5: {
                        return pe.getCotaTva();
                    }
                    case 6: {
                        return pe.isUzIntern();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        final ArticoleReport panel = this;
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        JButton deselectAll = new JButton("Reseteaza selectia");
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(panel, "Selectia curenta se va pierde. Continuam", LangRoAll.confirmare)) {
                    return;
                }
                ArticoleReport.this.table.clearSelection();
            }
        });
        result.add(deselectAll);
        JButton actiuni = new JButton("Actiuni");
        actiuni.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem retetePdf = new JMenuItem(Utils.getTranslation(LangRoAll.printRetete));
                    retetePdf.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Vector<ArticolBean> reteteSelectate = new Vector<ArticolBean>();
                            int[] selectedRows = ArticoleReport.this.table.getSelectedRows();
                            for (int i = 0; i < selectedRows.length; ++i) {
                                reteteSelectate.add((ArticolBean)ArticoleReport.this.data.get(selectedRows[i]));
                            }
                            String path = RestLogic.getInstance().printReteteSelected(reteteSelectate);
                            if (path != null) {
                                DialogUtils.okDialog(panel, LangRoAll.fisierulAFostSalvatLaLocatia + path, LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(panel, LangRoAll.operatieEsuata, LangRoAll.eroare);
                            }
                        }
                    });
                    popup.add(retetePdf);
                    popup.setInvoker(ArticoleReport.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        result.add((Component)actiuni, "wrap");
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        ArticolBean.UZINTERN_TYPE[] valuesUz;
        ArticolBean.PRODUCTIE_TYPE[] valuesProd;
        ArticolBean.ARTICOL_TYPE[] values;
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        result.add(new JLabel(Utils.getTranslation(LangRoAll.produs)));
        this.produseXComboModel = new FilterableComboBoxModel(RestLogic.getInstance().getAllArticole());
        this.produseXCombo = new XComboBox(this.produseXComboModel);
        this.produseXCombo.setXcomboSearchMinCharsLocal(3);
        result.add((Component)this.produseXCombo, "growx, span 8, wrap");
        result.add(new JLabel(LangRoAll.sectie));
        Vector<Sectie> allSectii = NomeclaturaLogic.getInstance().getAllSectii();
        Collections.sort(allSectii, new Comparator<Sectie>(){

            @Override
            public int compare(Sectie o1, Sectie o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.sectii = new MultiboxList(allSectii, 10);
        this.sectii.setSelectedItems(allSectii, true);
        result.add((Component)this.sectii, "growx");
        result.add(new JLabel(LangRoAll.categorie));
        final Vector allCategorii = NomeclaturaLogic.getInstance().getCategorii();
        NomeclaturaLogic.getInstance().setSectieName2Categories(allCategorii);
        Collections.sort(allCategorii, new Comparator<Categorie>(){

            @Override
            public int compare(Categorie o1, Categorie o2) {
                int i = o1.getNumeSectie().compareToIgnoreCase(o2.getNumeSectie());
                if (i != 0) {
                    return i;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.categorii = new MultiboxList(allCategorii, 10);
        this.categorii.setSelectedItems(allCategorii, true);
        result.add((Component)this.categorii, "span 3, growx");
        result.add(new JLabel(LangRoAll.tva));
        Vector<Tva> allTva = TvaLogic.getInstance().getTvas();
        this.tva = new MultiboxList(allTva, 10);
        this.tva.setSelectedItems(allTva, true);
        result.add((Component)this.tva, "wrap");
        final Map<Sectie, Vector<Categorie>> categoriesBySectii = NomeclaturaLogic.getInstance().arrangeCategoriesBySectii(allCategorii);
        this.sectii.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                Vector selectedItems = ArticoleReport.this.sectii.getSelectedItems();
                ArticoleReport.this.categorii.setSelectedItem(allCategorii, false);
                Vector selectedCategories = new Vector();
                for (Sectie sectie : selectedItems) {
                    selectedCategories.addAll((Collection)categoriesBySectii.get(sectie));
                }
                ArticoleReport.this.categorii.setSelectedItem(selectedCategories, true);
            }
        });
        this.sectii.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Sectie item = (Sectie)e.getItem();
                        Vector<Categorie> toModify = new Vector<Categorie>();
                        for (Categorie categorie : allCategorii) {
                            if (!categorie.getNumeSectie().equals(item.getName())) continue;
                            toModify.add(categorie);
                        }
                        for (Categorie categorie : toModify) {
                            ArticoleReport.this.categorii.selectItem(categorie.toString(), e.getStateChange() == 1);
                        }
                    }
                });
            }
        });
        result.add(new JLabel(LangRoAll.tip));
        Vector<ArticolBean.ARTICOL_TYPE> tipList = new Vector<ArticolBean.ARTICOL_TYPE>();
        for (ArticolBean.ARTICOL_TYPE value : values = ArticolBean.ARTICOL_TYPE.values()) {
            tipList.add(value);
        }
        this.tip = new MultiboxList(tipList, 10);
        this.tip.setSelectedItems(tipList, true);
        result.add(this.tip);
        result.add(new JLabel(LangRoAll.productie));
        Vector<ArticolBean.PRODUCTIE_TYPE> productieList = new Vector<ArticolBean.PRODUCTIE_TYPE>();
        for (ArticolBean.PRODUCTIE_TYPE value : valuesProd = ArticolBean.PRODUCTIE_TYPE.values()) {
            productieList.add(value);
        }
        this.productie = new MultiboxList(productieList, 10);
        this.productie.setSelectedItems(productieList, true);
        result.add(this.productie);
        result.add(new JLabel(LangRoAll.uzIntern));
        Vector<ArticolBean.UZINTERN_TYPE> uzInternList = new Vector<ArticolBean.UZINTERN_TYPE>();
        for (ArticolBean.UZINTERN_TYPE value : valuesUz = ArticolBean.UZINTERN_TYPE.values()) {
            uzInternList.add(value);
        }
        this.uzIntern = new MultiboxList(uzInternList, 10);
        this.uzIntern.setSelectedItems(uzInternList, true);
        result.add(this.uzIntern);
        result.add(new JLabel(LangRoAll.tags));
        Vector<Tag> allTags = TagsLogic.getInstance().getAllTags();
        this.tags = new MultiboxList(allTags, 10);
        this.tags.setSelectedItems(allTags, true);
        result.add((Component)this.tags, "wrap");
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 1;
                    }
                    case 6: {
                        return 1;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return "Nr. Articole";
                    }
                    case 3: {
                        return "" + ArticoleReport.this.data.size();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return ArticoleReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ArticoleReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ArticolBean sve = (ArticolBean)row;
                switch (column) {
                    case 0: {
                        return sve.getType().toString();
                    }
                    case 1: {
                        return sve.getSectie();
                    }
                    case 2: {
                        return sve.getCategorie();
                    }
                    case 3: {
                        return sve.getNume();
                    }
                    case 4: {
                        return Utils.getString2Decimals(sve.getPretVanzare());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sve.getCotaTva());
                    }
                    case 6: {
                        return sve.isUzIntern() ? "DA" : "";
                    }
                }
                return null;
            }
        };
        this.table.setSelectionMode(2);
        final ArticoleReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = ArticoleReport.this.table.rowAtPoint(e.getPoint());
                int selCol = ArticoleReport.this.table.columnAtPoint(e.getPoint());
                if (selRow != -1 && selCol == 3) {
                    ArticolBean articol = (ArticolBean)ArticoleReport.this.data.get(selRow);
                    JPopupMenu popup = null;
                    switch (articol.getType()) {
                        case RETETA_SAU_SERVICIU: {
                            popup = ArticoleReport.this.buildPopupForReteta(articol, parent);
                            break;
                        }
                        case MARFA: {
                            popup = ArticoleReport.this.buildPopupForMarfa(articol, parent);
                            break;
                        }
                        case MATERIE_PRIMA: {
                            popup = ArticoleReport.this.buildPopupForMateriePrima(articol, parent);
                        }
                    }
                    popup.setInvoker(ArticoleReport.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private JPopupMenu buildPopupForMarfa(final ArticolBean articol, final Component parent) {
        final JPopupMenu popup = this.buildPopupMateriePrimaMarfaGeneric(articol, parent);
        JMenuItem toIngredient = new JMenuItem(Utils.getTranslation(LangRoAll.transformaInMateriePrima, new String[0]));
        popup.add(toIngredient);
        toIngredient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInMateriePrima, new String[0]), LangRoAll.confirmare)) {
                    StockLogic.getInstance().toIngredient(articol.getIdStock());
                    ArticoleReport.this.raport();
                }
                popup.setVisible(false);
            }
        });
        JMenuItem toReteta = new JMenuItem(Utils.getTranslation(LangRoAll.transformaInReteta, new String[0]));
        popup.add(toReteta);
        toReteta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInReteta, new String[0]), LangRoAll.confirmare)) {
                    boolean adaugaReteta = DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.adaugamStoculInReteta, new String[0]), LangRoAll.confirmare);
                    boolean stergeStoc = false;
                    if (!adaugaReteta) {
                        stergeStoc = DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.stergemStocul, new String[0]), LangRoAll.confirmare);
                    }
                    int idStoc = articol.getIdStock();
                    StockLogic stockLogic = StockLogic.getInstance();
                    Product p = stockLogic.getProductForStock(idStoc);
                    double price = stockLogic.getCatalogPriceForStock(idStoc);
                    boolean ok = stockLogic.getStockInterface().transformaProdusFinitInReteta(articol.getIdStock(), p.getId(), price, stergeStoc, adaugaReteta, parent);
                    if (ok) {
                        ArticoleReport.this.raport();
                    }
                }
                popup.setVisible(false);
            }
        });
        return popup;
    }

    private JPopupMenu buildPopupForMateriePrima(final ArticolBean articol, final Component parent) {
        final JPopupMenu popup = this.buildPopupMateriePrimaMarfaGeneric(articol, parent);
        JMenuItem toFinit = new JMenuItem(LangRoAll.transformaInMarfa);
        popup.add(toFinit);
        toFinit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInMarfa, new String[0]), LangRoAll.confirmare)) {
                    Product existingProduct = NomeclaturaLogic.getInstance().getProductByName(articol.getNume());
                    boolean allowProduseDuplicate = Config.getInstance().getBoolean("allowProduseDuplicate");
                    if (existingProduct != null && !allowProduseDuplicate) {
                        DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.existaUnProdusCuAcestNume), LangRoAll.nuPotContinua);
                    } else {
                        StockLogic stockLogic = StockLogic.getInstance();
                        stockLogic.toProdusFinit(articol.getIdStock(), articol.getNume());
                        Stock s = stockLogic.getStockById(articol.getIdStock());
                        ArticoleReport.this.editeazaMarfaSauMateriePrima(s, articol);
                    }
                    popup.setVisible(false);
                }
            }
        });
        return popup;
    }

    private void editeazaMarfaSauMateriePrima(Stock stock, ArticolBean articolBean) {
        StockInput stockInput = new StockInput();
        final JDialog jDialog = DialogUtils.getJDialog(stockInput, GuiUtils.currentFrame, "MODIFICA MARFA SAU MATERIE PRIMA \"" + stock.getLabel() + "\"", 1.2, true);
        stockInput.setObjectToEdit(stock, articolBean, -1);
        stockInput.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                jDialog.dispose();
                ArticoleReport.this.raport();
            }
        });
        jDialog.setVisible(true);
    }

    private JPopupMenu buildPopupMateriePrimaMarfaGeneric(final ArticolBean articol, final Component parent) {
        final StockLogic stockLogic = StockLogic.getInstance();
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem edit = new JMenuItem(LangRoAll.modifica);
        popup.add(edit);
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Stock s = stockLogic.getStockById(articol.getIdStock());
                ArticoleReport.this.editeazaMarfaSauMateriePrima(s, articol);
                popup.setVisible(false);
            }
        });
        JMenuItem folosireStock = new JMenuItem(Utils.getTranslation(LangRoAll.folosireInRetete, new String[0]));
        popup.add(folosireStock);
        folosireStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String folosit = stockLogic.getDeleteImpedimentsString(stockLogic.getDeleteImpediments(articol.getIdStock()));
                DialogUtils.okDialog(parent, folosit, articol.getNume() + " : " + Utils.getTranslation(LangRoAll.folosireInRetete, new String[0]));
                popup.setVisible(false);
            }
        });
        JMenuItem stergeStock = new JMenuItem(Utils.getTranslation(LangRoAll.stergeStoc, new String[0]));
        popup.add(stergeStock);
        stergeStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean action = false;
                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.stergemStocul, new String[0]), LangRoAll.confirmare)) {
                    action = stockLogic.deleteStock(articol.getIdStock(), parent);
                }
                popup.setVisible(false);
                if (action) {
                    ArticoleReport.this.raport();
                    StockLogic.getInstance().updatePowerSearchStocks(articol.getIdStock(), new Vector<String>());
                }
            }
        });
        return popup;
    }

    private JPopupMenu buildPopupForReteta(final ArticolBean articol, final Component parent) {
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
        JMenuItem toMarfa = new JMenuItem(LangRoAll.transformaInMarfa);
        JMenuItem preview = new JMenuItem(LangRoAll.previewReteta);
        JMenuItem print = new JMenuItem(LangRoAll.printReteta);
        popup.add(modifica);
        popup.add(preview);
        popup.add(print);
        popup.add(toMarfa);
        modifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArticoleReport.this.editRecipe(articol);
                popup.setVisible(false);
            }
        });
        toMarfa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.transformamInMarfa, new String[0]), LangRoAll.confirmare)) {
                    int idReteta = RestLogic.getInstance().getIdReteta(articol.getIdProdus());
                    RestLogic.getInstance().transformaRetetaInProdusFinit(idReteta, articol.getIdProdus());
                    popup.setVisible(false);
                    ArticoleReport.this.raport();
                }
            }
        });
        preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestLogic.getInstance().previewReteta(articol.getIdProdus());
                popup.setVisible(false);
            }
        });
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestLogic.getInstance().printReteta(articol.getIdProdus());
                popup.setVisible(false);
            }
        });
        return popup;
    }

    private void editRecipe(ArticolBean toEdit) {
        int idSectie = toEdit.getIdSectie();
        Sectie s = NomeclaturaLogic.getInstance().getSectieById(idSectie);
        AddRecipePanel panel = new AddRecipePanel(s);
        Product product = NomeclaturaLogic.getInstance().getProductById(toEdit.getIdProdus());
        panel.setProduct(product);
        JDialog jDialog = DialogUtils.getJDialog(panel, GuiUtils.currentFrame, "MODIFICA " + toEdit.getNume(), 1.2, true);
        panel.setParentDialog(jDialog);
        jDialog.setVisible(true);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return tip_sorter;
            }
            case 1: {
                return sectie_sorter;
            }
            case 2: {
                return category_sorter;
            }
            case 3: {
                return product_sorter;
            }
            case 4: {
                return price_sorter;
            }
            case 5: {
                return tva_sorter;
            }
            case 6: {
                return uzIntern_sorter;
            }
        }
        return null;
    }

    @Override
    public void cleanup() {
    }
}

