/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.meniuri;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.Optiune;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.gui.admin.meniuri.MeniuriPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.util.CompareUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class AddMeniuPanel
extends ReflectedJPanel {
    private RestLogic logic = RestLogic.getInstance();
    private MeniuriPanel listaPanel;
    private JTabbedPane parent;
    private Meniu meniuCurent;
    private EventListener productsListener = new EventListener(){

        @Override
        public void dataChanged() {
            AddMeniuPanel.this.rebuildProductsCombo();
        }

        @Override
        public String getName() {
            return "AddMeniuPanelProducts";
        }
    };
    private JComboBox optiuni;
    private JComboBox produse;
    private JComboBox categorii;
    private JTextField numeMeniu;
    private JTextField pretOptiune;
    private JTextField cantitate;
    private JTextField zile;
    private JTextField oraStart;
    private JTextField oraStop;
    private JCheckBox activMeniu;
    private AbstractListPanel produsePanel;

    public AddMeniuPanel() {
        this.logic.addListener(this.productsListener, 2);
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getNumePanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.getButtonsPanel(), c);
        c.weighty = 1.0;
        c.gridy = 0;
        c.gridx = 1;
        c.gridheight = 2;
        this.add((Component)this.getProdusePanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        this.add((Component)this.getTablePanel(), c);
    }

    private JPanel getNumePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        this.numeMeniu = new JTextField(10);
        panel.add((Component)this.numeMeniu, c);
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel("Zile saptamana (*,1,2..)"), c);
        ++c.gridx;
        this.zile = new JTextField(10);
        panel.add((Component)this.zile, c);
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel("Ora start (HH:mm)"), c);
        ++c.gridx;
        this.oraStart = new JTextField(10);
        panel.add((Component)this.oraStart, c);
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel("Ora stop (HH:mm)"), c);
        ++c.gridx;
        this.oraStop = new JTextField(10);
        panel.add((Component)this.oraStop, c);
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel("Activ"), c);
        ++c.gridx;
        this.activMeniu = new JCheckBox();
        this.activMeniu.setSelected(true);
        panel.add((Component)this.activMeniu, c);
        panel.setBorder(new TitledBorder(LangRoAll.meniu));
        return panel;
    }

    private void saveMenu() {
        String label = this.numeMeniu.getText();
        if (!Validators.correctString(label)) {
            DialogUtils.errorDialog(this, "Completati numele meniului", LangRoAll.nuPotContinua);
            this.numeMeniu.requestFocus();
            return;
        }
        String s1 = this.zile.getText();
        if (!Validators.correctString(s1)) {
            DialogUtils.errorDialog(this, "Completati zilele saptamanii (*,1,2..)", LangRoAll.nuPotContinua);
            this.zile.requestFocus();
            return;
        }
        String s2 = this.oraStart.getText();
        if (!Validators.correctDate(s2, Formatters.TIME_FORMAT)) {
            DialogUtils.errorDialog(this, "Completati corect ora", LangRoAll.nuPotContinua);
            this.oraStart.requestFocus();
            return;
        }
        String s3 = this.oraStop.getText();
        if (!Validators.correctDate(s3, Formatters.TIME_FORMAT)) {
            DialogUtils.errorDialog(this, "Completati corect ora", LangRoAll.nuPotContinua);
            this.oraStop.requestFocus();
            return;
        }
        if (this.meniuCurent == null) {
            int idMeniu = this.logic.addMeniu(label, s1, s2, s3, "");
            if (idMeniu > 0) {
                this.meniuCurent = this.logic.getMeniuById(idMeniu);
            } else {
                DialogUtils.errorDialog(this, "Nu am adaugat meniul", LangRoAll.eroare);
            }
        } else {
            this.logic.updateMeniu(label, this.activMeniu.isSelected(), this.meniuCurent.getId(), s1, s2, s3);
            this.setMeniuCurent(null);
        }
    }

    private JPanel getProdusePanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill", "[][][]"));
        Dimension max = new Dimension(200, 200);
        panel.setPreferredSize(max);
        panel.setMaximumSize(max);
        JLabel optiuneLabel = new JLabel("Optiune");
        panel.add(optiuneLabel);
        this.optiuni = new JComboBox();
        panel.add((Component)this.optiuni, "span 2, growx, wrap");
        this.produse = new JComboBox();
        JLabel categorieLabel = new JLabel(LangRoAll.categorie);
        panel.add(categorieLabel);
        this.categorii = new JComboBox();
        this.categorii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(AddMeniuPanel.this.categorii)) {
                    Categorie subcat = (Categorie)AddMeniuPanel.this.categorii.getSelectedItem();
                    Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(subcat);
                    ComboUtils.replaceItemsForCombo(AddMeniuPanel.this.produse, products);
                } else {
                    AddMeniuPanel.this.rebuildProductsCombo();
                }
            }
        });
        panel.add((Component)this.categorii, "span 2, growx, wrap");
        JLabel produsLabel = new JLabel(LangRoAll.produs);
        panel.add(produsLabel);
        panel.add((Component)this.produse, "span 2, growx, wrap");
        Dimension dimension = new Dimension(500, 30);
        this.produse.setMaximumSize(dimension);
        JLabel cantitateLabel = new JLabel(LangRoAll.cantitate);
        panel.add(cantitateLabel);
        this.cantitate = new JTextField(10);
        panel.add((Component)this.cantitate, "span 2, growx, wrap");
        JLabel pretUnitarLabel = new JLabel("Pret unitar");
        panel.add(pretUnitarLabel);
        this.pretOptiune = new JTextField(10);
        panel.add((Component)this.pretOptiune, "span 2, growx, wrap");
        JButton adauga = new JButton("Adauga produs");
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!Validators.correctDouble(AddMeniuPanel.this.pretOptiune.getText())) {
                    DialogUtils.errorDialog(AddMeniuPanel.this.parent, "Pret incorect", LangRoAll.nuPotContinua);
                    AddMeniuPanel.this.pretOptiune.requestFocus();
                    AddMeniuPanel.this.pretOptiune.selectAll();
                    return;
                }
                if (!Validators.correctDouble(AddMeniuPanel.this.pretOptiune.getText())) {
                    DialogUtils.errorDialog(AddMeniuPanel.this.parent, "Pret incorect", LangRoAll.nuPotContinua);
                    AddMeniuPanel.this.cantitate.requestFocus();
                    AddMeniuPanel.this.cantitate.selectAll();
                    return;
                }
                double pret = Utils.parseDouble(AddMeniuPanel.this.pretOptiune.getText());
                double cant = Utils.parseDouble(AddMeniuPanel.this.cantitate.getText());
                Optiune om = (Optiune)AddMeniuPanel.this.optiuni.getSelectedItem();
                int idProduct = -1;
                int idCategory = -1;
                if (ComboUtils.anythingButAllSelected(AddMeniuPanel.this.produse)) {
                    Product p = (Product)AddMeniuPanel.this.produse.getSelectedItem();
                    idProduct = p.getId();
                } else if (ComboUtils.anythingButAllSelected(AddMeniuPanel.this.categorii)) {
                    Categorie c = (Categorie)AddMeniuPanel.this.categorii.getSelectedItem();
                    idCategory = c.getId();
                }
                if (om != null && (idProduct > 0 || idCategory > 0)) {
                    if (AddMeniuPanel.this.meniuCurent == null) {
                        AddMeniuPanel.this.saveMenu();
                    }
                    AddMeniuPanel.this.logic.addOptiuneProdus(AddMeniuPanel.this.meniuCurent.getId(), idCategory, idProduct, om.getId(), pret, cant);
                    AddMeniuPanel.this.produsePanel.refreshTable();
                    AddMeniuPanel.this.pretOptiune.setText("");
                    AddMeniuPanel.this.cantitate.setText("");
                }
            }
        });
        panel.add((Component)adauga, "span 3, growx");
        panel.setBorder(new TitledBorder("Adaugare produse"));
        return panel;
    }

    private JPanel getTablePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final AddMeniuPanel parent = this;
        this.produsePanel = new AbstractListPanel(){

            @Override
            public String[] buildColumns() {
                return new String[]{"Optiune", LangRoAll.pret, LangRoAll.categorie, LangRoAll.produs, LangRoAll.cantitate};
            }

            @Override
            public Vector buildData() {
                Vector<Object> produse = new Vector();
                if (AddMeniuPanel.this.meniuCurent != null) {
                    int idMeniu = AddMeniuPanel.this.meniuCurent.getId();
                    produse = AddMeniuPanel.this.logic.getOptiuniProdus(idMeniu, -1);
                }
                return produse;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(5);
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        OptiuneProdus op = (OptiuneProdus)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return op.getOptiune();
                            }
                            case 1: {
                                return Utils.getString2Decimals(op.getPret());
                            }
                            case 2: {
                                return op.getCategorie();
                            }
                            case 3: {
                                return op.getProduct();
                            }
                            case 4: {
                                return Utils.getString2Decimals(op.getCantitate());
                            }
                        }
                        return null;
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return this.tm;
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        int selRow = table.rowAtPoint(e.getPoint());
                        if (selRow != -1 && e.getClickCount() == 2) {
                            OptiuneProdus re = (OptiuneProdus)tm.getObjectAt(selRow);
                            if (DialogUtils.confirmDialog(parent, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                                AddMeniuPanel.this.logic.deleteOptiuneProdus(re.getId());
                                AddMeniuPanel.this.produsePanel.refreshTable();
                            }
                        }
                    }
                });
            }
        };
        this.produsePanel.doStuff();
        this.produsePanel.refreshTable();
        panel.add((Component)this.produsePanel, c);
        panel.setBorder(new TitledBorder("Tabel meniu"));
        return panel;
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final AddMeniuPanel parent = this;
        JButton save = new JButton(LangRoAll.salveaza);
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddMeniuPanel.this.saveMenu();
            }
        });
        panel.add((Component)save, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddMeniuPanel.this.meniuCurent != null && DialogUtils.confirmDialog(parent, "Doriti sa stergeti acest meniu", LangRoAll.confirmare)) {
                    AddMeniuPanel.this.logic.deleteMeniu(AddMeniuPanel.this.meniuCurent.getId());
                    AddMeniuPanel.this.setMeniuCurent(null);
                }
            }
        });
        panel.add((Component)sterge, c);
        ++c.gridx;
        JButton inapoi = new JButton(LangRoAll.renunta);
        inapoi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddMeniuPanel.this.setMeniuCurent(null);
            }
        });
        panel.add((Component)inapoi, c);
        panel.setBorder(new TitledBorder(LangRoAll.actiuni));
        return panel;
    }

    public void rebuildProductsCombo() {
        this.produse.removeAllItems();
        Vector<Product> sorted = new Vector<Product>(NomeclaturaLogic.getInstance().getAllProducts(-1));
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CompareUtils.compareProductsByName(o1, o2);
            }
        });
        ComboUtils.replaceItemsForCombo(this.produse, sorted);
    }

    public Meniu getMeniuCurent() {
        return this.meniuCurent;
    }

    public void setMeniuCurent(Meniu meniuCurent) {
        this.meniuCurent = meniuCurent;
        if (meniuCurent == null) {
            this.numeMeniu.setText("");
            this.zile.setText("*");
            this.oraStart.setText("");
            this.oraStop.setText("");
            this.activMeniu.setSelected(true);
            this.parent.setSelectedComponent(this.listaPanel);
        } else {
            this.numeMeniu.setText(meniuCurent.getLabel());
            this.activMeniu.setSelected(meniuCurent.isActiv());
            this.zile.setText(meniuCurent.getZile());
            this.oraStart.setText(meniuCurent.getOraStart());
            this.oraStop.setText(meniuCurent.getOraStop());
        }
        this.produsePanel.refreshTable();
    }

    public MeniuriPanel getListaPanel() {
        return this.listaPanel;
    }

    public void setListaPanel(MeniuriPanel listaPanel) {
        this.listaPanel = listaPanel;
    }

    public RestLogic getLogic() {
        return this.logic;
    }

    public void setLogic(RestLogic logic) {
        this.logic = logic;
    }

    @Override
    public JTabbedPane getParent() {
        return this.parent;
    }

    public void setParent(JTabbedPane parent) {
        this.parent = parent;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.optiuni, (Collection)this.logic.getAllOptiuni(), false);
        this.rebuildProductsCombo();
        ComboUtils.replaceItemsForCombo(this.categorii, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder());
    }
}

