/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.meniuri;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.gui.admin.meniuri.AddMeniuPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public class MeniuriPanel
extends ReflectedJPanel {
    private RestLogic logic = RestLogic.getInstance();
    private AddMeniuPanel editPanel;
    private JTabbedPane parent;
    private AbstractTM _tableModel;
    private JTable _table;
    private EventListener meniuriListener = new EventListener(){

        @Override
        public void dataChanged() {
            MeniuriPanel.this._tableModel.refresh(MeniuriPanel.this.logic.getAllMeniuri());
        }

        @Override
        public String getName() {
            return "MeniuriPanel";
        }
    };

    public MeniuriPanel() {
        this.logic.addListener(this.meniuriListener, 401);
        this.init();
        this.display();
        this._tableModel.refresh(this.logic.getAllMeniuri());
    }

    public void setEditPanel(AddMeniuPanel editPanel) {
        this.editPanel = editPanel;
    }

    public void setLogic(RestLogic logic) {
        this.logic = logic;
    }

    public void setParent(JTabbedPane parent) {
        this.parent = parent;
    }

    @Override
    public void doStuff() {
    }

    private void init() {
        String[] columns = new String[]{"Nume", "Activ"};
        this._tableModel = new AbstractTM(columns, new Class[]{String.class, Boolean.class}, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                if (columnIndex == 1) {
                    Meniu rp = (Meniu)data.elementAt(rowIndex);
                    Boolean b = (Boolean)aValue;
                    MeniuriPanel.this.logic.updateMeniu(rp.getLabel(), b, rp.getId(), rp.getZile(), rp.getOraStart(), rp.getOraStop());
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Meniu rp = (Meniu)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return rp.getLabel();
                    }
                    case 1: {
                        return new Boolean(rp.isActiv());
                    }
                }
                return null;
            }
        });
        this._table = new JTable(this._tableModel);
        this._table.setSelectionMode(0);
        this._table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = MeniuriPanel.this._table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    Meniu re = (Meniu)MeniuriPanel.this._tableModel.getObjectAt(selRow);
                    MeniuriPanel.this.editMeniu(re);
                }
            }
        });
    }

    private void editMeniu(Meniu m) {
        this.editPanel.setMeniuCurent(m);
        this.parent.setSelectedComponent(this.editPanel);
    }

    private void display() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.add((Component)new JScrollPane(this._table), c);
    }
}

