/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.multiserver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.admin.multiserver.MultiServerBean;
import ro.atreides.restaurant.gui.admin.multiserver.MultiServerPanel;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.HttpUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;

public class MultiServerLogic {
    private static MultiServerLogic instance;

    private MultiServerLogic() {
    }

    public static synchronized MultiServerLogic getInstance() {
        if (instance == null) {
            instance = new MultiServerLogic();
        }
        return instance;
    }

    public void asyncRefresh(final MultiServerPanel.MultiServerAsyncRefresh inter, final MultiServerBean serverBean) {
        new Thread(){

            @Override
            public void run() {
                MultiServerBean newData = MultiServerLogic.this.refreshServer(serverBean);
                inter.refresh(newData);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiServerBean refreshServer(MultiServerBean serverBean) {
        int port = serverBean.getPort();
        String ip = serverBean.getIp();
        String url = "http://" + ip + ":" + port + "/system/multiservergetdata?password=" + "ParolawebservicedevEr";
        String result = HttpUtils.getHttpPage(url);
        String xmlFile = FileUtils.getTempDir() + File.separator + ip + "_" + port + ".xml";
        final MultiServerBean newData = new MultiServerBean();
        try {
            FileUtils.writeTextToFile(xmlFile, result);
            try {
                Utils.importXml(new DefaultHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        try {
                            TextUtils.loadAttributesBySetters(newData, attributes);
                        }
                        catch (IllegalAccessException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        catch (InvocationTargetException e) {
                            Logger.logException(this, (Exception)e);
                        }
                    }
                }, xmlFile);
            }
            catch (SAXException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        newData.setIp(ip);
        newData.setPort(port);
        newData.setName(serverBean.getName());
        return newData;
    }

    public boolean closeDay(MultiServerBean serverBean) {
        int port = serverBean.getPort();
        String ip = serverBean.getIp();
        String url = "http://" + ip + ":" + port + "/system/shiftclose?password=" + "ParolawebservicedevEr";
        String result = HttpUtils.getHttpPage(url);
        return result != null && result.equalsIgnoreCase("OK");
    }

    public boolean closeOpenOrders(MultiServerBean serverBean) {
        int port = serverBean.getPort();
        String ip = serverBean.getIp();
        String url = "http://" + ip + ":" + port + "/system/multiservercloseopenorders?password=" + "ParolawebservicedevEr";
        String result = HttpUtils.getHttpPage(url);
        return result != null && result.equalsIgnoreCase("OK");
    }

    public Vector<MultiServerBean> getInitialData() {
        Vector<MultiServerBean> result = new Vector<MultiServerBean>();
        String allIps = VpConfig.getInstance().multiServerInstallClientIps;
        Vector s1 = Utils.splitString(allIps, ';');
        for (String s2 : s1) {
            Vector s3 = Utils.splitString(s2, '=');
            if (s3.size() != 3) continue;
            String nume = (String)s3.get(0);
            String ip = (String)s3.get(1);
            String ps = (String)s3.get(2);
            int port = Integer.parseInt(ps);
            MultiServerBean b = new MultiServerBean();
            b.setName(nume);
            b.setIp(ip);
            b.setPort(port);
            result.add(b);
        }
        return result;
    }
}

