/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.admin.recipe;

import java.util.Collection;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NotEnoughIngredientsException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.multilang.LangRoAll;

public class AddRecipeTableModel
extends AbstractTableModel {
    public static String[] _columnNames = new String[]{"Ingredient", LangRoAll.cantitate, "Unitate", LangRoAll.pret, LangRoAll.valoare};
    public static Class[] _columnTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
    private Vector _recipeItems = null;

    public AddRecipeTableModel(Collection recipes, RestLogic logic) {
        this.updateTable(recipes);
    }

    private void updateTable(Collection data) {
        this._recipeItems = data == null ? new Vector() : new Vector(data);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return _columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this._recipeItems.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        double pret;
        NewRecipeEntry iq;
        block14: {
            if (this._recipeItems == null) {
                return null;
            }
            if (rowIndex >= this._recipeItems.size() || columnIndex >= _columnNames.length) {
                return null;
            }
            Object obj = this._recipeItems.elementAt(rowIndex);
            iq = (NewRecipeEntry)obj;
            pret = 0.0;
            if (iq.getIdProduct() > 0) {
                try {
                    int idReteta = RestLogic.getInstance().getIdReteta(iq.getIdProduct());
                    if (idReteta > 0) {
                        Vector stack = new Vector();
                        pret = RestLogic.getInstance().getPretIngredienteCommit(idReteta, new NotEnoughIngredientsException(), stack);
                        break block14;
                    }
                    int idStock = RestLogic.getInstance().getIdStock(iq.getIdProduct());
                    pret = ContaLogic.getInstance().getPretAchizitieForStock(idStock, iq.getQuantity(), VpConfig.getInstance().calculPretUseCurrentLot);
                }
                catch (NotEnoughIngredientsException e) {
                    Logger.logException(this, (Exception)e);
                }
            } else {
                pret = ContaLogic.getInstance().getPretAchizitieForStock(iq.getIdStock(), iq.getQuantity(), VpConfig.getInstance().calculPretUseCurrentLot);
            }
        }
        switch (columnIndex) {
            case 0: {
                return iq.getName();
            }
            case 1: {
                return Utils.getString6Decimals(iq.getQuantity());
            }
            case 2: {
                return iq.getUm();
            }
            case 3: {
                return Utils.getString2Decimals(pret);
            }
            case 4: {
                return Utils.getString2Decimals(iq.getQuantity() * pret);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= _columnTypes.length) {
            return String.class;
        }
        return _columnTypes[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= _columnNames.length) {
            return "";
        }
        return _columnNames[columnIndex];
    }

    public void addIngredient(int idStock, double quantity, String name, String um) {
        NewRecipeEntry iq = new NewRecipeEntry();
        iq.setIdStock(idStock);
        iq.setQuantity(quantity);
        iq.setName(name);
        iq.setUm(um);
        this._recipeItems.add(iq);
        this.fireTableDataChanged();
    }

    public void addProduct(int idProduct, double quantity, String name, String um) {
        NewRecipeEntry iq = new NewRecipeEntry();
        iq.setQuantity(quantity);
        iq.setIdProduct(idProduct);
        iq.setName(name);
        iq.setUm(um);
        this._recipeItems.add(iq);
        this.fireTableDataChanged();
    }

    public Object getIngredientAtRow(int row) {
        return this._recipeItems.get(row);
    }

    public void removeAllIngredients() {
        this._recipeItems = new Vector();
        this.fireTableDataChanged();
    }

    public Vector getRecipeItems() {
        return this._recipeItems;
    }

    public void setIngredients(Vector ingredients) {
        this._recipeItems = ingredients;
        this.fireTableDataChanged();
    }

    public void removeIngredient(Object item) {
        this._recipeItems.remove(item);
    }
}

