/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;

public class AnalizeCheckboxChooserPanel
extends JPanel {
    private Vector chosenProducts = new Vector();

    public AnalizeCheckboxChooserPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        JTabbedPane tabs = new JTabbedPane();
        Vector categories = ClinicaLogic.getInstance().getCategoriiAnalize();
        for (int i = 0; i < categories.size(); ++i) {
            Categorie categorie = (Categorie)categories.elementAt(i);
            JPanel p1 = this.buildCategoriePanel(categorie);
            JScrollPane scroll = new JScrollPane(p1, 20, 30);
            tabs.add(categorie.getName(), scroll);
        }
        this.add((Component)tabs, c);
    }

    private JPanel buildCategoriePanel(Categorie cat) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        Vector analize = NomeclaturaLogic.getInstance().getProductsForCategorie(cat);
        for (int i = 0; i < analize.size(); ++i) {
            final Product product = (Product)analize.elementAt(i);
            final JCheckBox check = new JCheckBox(product.getName(), false);
            check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (check.isSelected()) {
                        AnalizeCheckboxChooserPanel.this.chosenProducts.add(product);
                    } else {
                        AnalizeCheckboxChooserPanel.this.chosenProducts.remove(product);
                    }
                }
            });
            if (i % VpConfig.getInstance().clinicaAnalizeChooserItemsPerLine == 0 && i > 0) {
                c.gridx = 0;
                ++c.gridy;
            } else {
                ++c.gridx;
            }
            result.add((Component)check, c);
        }
        return result;
    }

    public Vector getChosenProducts() {
        return this.chosenProducts;
    }
}

