/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.clinicabase.AnalizeReportEntry;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.gui.clinica.AnalizeCellRenderer;
import ro.atreides.restaurant.gui.clinica.IstoricClientPanel;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class AnalizeReport
extends AbstractReportPanel
implements CleanupRequired {
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JComboBox _subCategoryComboBox;
    private JComboBox _productsComboBox;
    private JComboBox statusCombo;
    private JComboBox clientiPersJuridice;
    private JComboBox angajati;
    private JComboBox externaLocalaCombo;
    private JComboBox valoare;
    private JComboBox casaSanatate;
    private JTextField codBareComanda;
    private JTextField nrBiletTrimitere;
    private JLabel _subcategoryLabel;
    private JLabel _productsLabel;
    private JLabel statusLabel;
    private Vector selectedItems = new Vector();
    private JLabel numarLabel;
    private JLabel selectateLabel;
    private JButton stergeSelectia;
    private JButton invertSelection;
    private JButton tiparesteBuletinAnalize;
    private JButton valideazaAnalize;
    private JButton exportAnalize;
    private AnalizeCellRenderer cellRenderer;
    private static final String[] columns = new String[]{"Pacient", LangRoAll.produs, "Rezultat", "Valori normale", "Externa", LangRoAll.data};
    private static final Class[] types = new Class[]{String.class, String.class, Double.class, String.class, Boolean.class, String.class};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.angajati)) {
            if (ComboUtils.anythingButAllSelected(this.angajati)) {
                Object c2 = this.angajati.getSelectedItem();
                result.put("Pacient", c2);
                this.printCriteria.put("Pacient", c2);
            } else {
                this.printCriteria.remove("Pacient");
            }
        }
        if (ComboUtils.anythingButAllSelected(this.clientiPersJuridice)) {
            ClientPersJuridica companie = (ClientPersJuridica)this.clientiPersJuridice.getSelectedItem();
            Vector angajati = ClientLogic.getInstance().getAnjagati(companie.getIdPersJuridica());
            Vector<Integer> ids = new Vector<Integer>();
            for (int i = 0; i < angajati.size(); ++i) {
                ClientPersFizica clientPersFizica = (ClientPersFizica)angajati.elementAt(i);
                ids.add(clientPersFizica.getId());
            }
            result.put("Angajati ids", ids);
            this.printCriteria.put("Companie", companie);
        } else {
            this.printCriteria.remove("Companie");
        }
        if (ComboUtils.anythingButAllSelected(this._subCategoryComboBox)) {
            Categorie subcat = (Categorie)this._subCategoryComboBox.getSelectedItem();
            result.put("Categorie", subcat);
            this.printCriteria.put(LangRoAll.categorie, subcat.getName());
        } else {
            this.printCriteria.remove(LangRoAll.categorie);
        }
        if (ComboUtils.anythingButAllSelected(this._productsComboBox)) {
            Product p = (Product)this._productsComboBox.getSelectedItem();
            result.put("Product", p.getId());
            this.printCriteria.put(LangRoAll.produs, p.getName());
        } else {
            this.printCriteria.remove(LangRoAll.produs);
        }
        String s1 = this.nrBiletTrimitere.getText();
        if (Validators.correctString(s1)) {
            result.put("Bilet trimitere", s1);
            this.printCriteria.put("Bilet trimitere", s1);
        } else {
            this.printCriteria.remove("Bilet trimitere");
        }
        String tip = (String)this.externaLocalaCombo.getSelectedItem();
        result.put("Locala / Externa", tip);
        this.printCriteria.put("Locala / Externa", tip);
        if (ComboUtils.anythingButAllSelected(this.casaSanatate)) {
            Client selected = (Client)this.casaSanatate.getSelectedItem();
            result.put("Casa sanatate", selected.getId());
            this.printCriteria.put("Casa sanatate", selected.toString());
        } else {
            this.printCriteria.remove("Casa sanatate");
        }
        String s2 = this.codBareComanda.getText();
        if (Validators.correctString(s2)) {
            result.put("Cod bare comanda", s2);
            this.printCriteria.put("Cod bare comanda", s2);
        } else {
            this.printCriteria.remove("Cod bare comanda");
        }
        if (ComboUtils.anythingButAllSelected(this.valoare)) {
            String s3 = (String)this.valoare.getSelectedItem();
            result.put("Rezultat", s3);
            this.printCriteria.put("Rezultat", s3);
        } else {
            this.printCriteria.remove("Rezultat");
        }
        if (ComboUtils.anythingButAllSelected(this.statusCombo)) {
            String s3 = (String)this.statusCombo.getSelectedItem();
            int value = ClinicaLogic.getValueForStatusAnaliza(s3);
            result.put("Status analiza", value);
            this.printCriteria.put("Status analiza", s3);
        } else {
            this.printCriteria.remove("Status analiza");
        }
        return result;
    }

    @Override
    public void printReport() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printPreview() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClinicaLogic.getInstance().getAnalizeReport(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    @Override
    public String getName() {
        return "Analize";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                AnalizeReportEntry se = (AnalizeReportEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 2: {
                        Double toSet = (Double)aValue;
                        se.setCompleted(true);
                        se.setRezultatAnaliza(toSet);
                        ClinicaLogic.getInstance().setValoareForAnaliza(se.getId(), toSet);
                        AnalizeReport.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                AnalizeReportEntry se = (AnalizeReportEntry)AnalizeReport.this.data.elementAt(rowIndex);
                if (columnIndex == 2) {
                    if (se.getStatus() == 5 || se.getStatus() == 5) {
                        return false;
                    }
                    if (se.getStatus() == 4) {
                        return UsersLogic.getInstance().isUserInGroup(AdministrationPanel.loggedUser.getId(), "group_sef_laborator");
                    }
                    return true;
                }
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                AnalizeReportEntry se = (AnalizeReportEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getNumePersFizica();
                    }
                    case 1: {
                        return se.getNumeProdus();
                    }
                    case 2: {
                        return se.getRezultatAnaliza();
                    }
                    case 3: {
                        return se.getValoriNormale();
                    }
                    case 4: {
                        return new Boolean(se.isExterna());
                    }
                    case 5: {
                        return se.getDataComenzii();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Nr linii"), c);
        ++c.gridx;
        this.numarLabel = new JLabel("");
        result.add((Component)this.numarLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Selectate"), c);
        ++c.gridx;
        this.selectateLabel = new JLabel("");
        result.add((Component)this.selectateLabel, c);
        final AnalizeReport parent = this;
        ++c.gridx;
        ++c.gridx;
        this.invertSelection = new JButton("Invert selection");
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected = 0;
                for (int i = 0; i < AnalizeReport.this.data.size(); ++i) {
                    AnalizeReportEntry pve = (AnalizeReportEntry)AnalizeReport.this.data.elementAt(i);
                    if (pve.isSelected()) {
                        pve.setSelected(false);
                        AnalizeReport.this.selectedItems.remove(pve);
                    } else {
                        AnalizeReport.this.selectedItems.add(pve);
                        pve.setSelected(true);
                    }
                    if (!pve.isSelected()) continue;
                    ++selected;
                }
                AnalizeReport.this.selectateLabel.setText(selected + "");
                AnalizeReport.this.tm.fireTableDataChanged();
            }
        });
        result.add((Component)this.invertSelection, c);
        ++c.gridx;
        this.stergeSelectia = new JButton("Sterge selectia");
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AnalizeReport.this.clearSelection();
            }
        });
        result.add((Component)this.stergeSelectia, c);
        ++c.gridx;
        this.tiparesteBuletinAnalize = new JButton("Tipareste buletin analiza");
        this.tiparesteBuletinAnalize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<AnalizeReportEntry> analizeFinalizate = new Vector<AnalizeReportEntry>();
                for (int i = 0; i < AnalizeReport.this.selectedItems.size(); ++i) {
                    AnalizeReportEntry analizeReportEntry = (AnalizeReportEntry)AnalizeReport.this.selectedItems.elementAt(i);
                    if (analizeReportEntry.getStatus() != 4 && analizeReportEntry.getStatus() != 5) continue;
                    analizeFinalizate.add(analizeReportEntry);
                }
                String text = "Tiparim " + analizeFinalizate.size() + " analize";
                if (DialogUtils.confirmDialog(parent, text, LangRoAll.confirmare)) {
                    Hashtable<Integer, Vector<AnalizeReportEntry>> all = new Hashtable<Integer, Vector<AnalizeReportEntry>>();
                    for (int i = 0; i < analizeFinalizate.size(); ++i) {
                        AnalizeReportEntry analizeReportEntry = (AnalizeReportEntry)analizeFinalizate.elementAt(i);
                        int idPacient = analizeReportEntry.getIdPersFizica();
                        Vector<AnalizeReportEntry> analizeForPacient = (Vector<AnalizeReportEntry>)all.get(idPacient);
                        if (analizeForPacient == null) {
                            analizeForPacient = new Vector<AnalizeReportEntry>();
                            all.put(idPacient, analizeForPacient);
                        }
                        analizeForPacient.add(analizeReportEntry);
                    }
                    Iterator iter = all.keySet().iterator();
                    while (iter.hasNext()) {
                        int idPacient = (Integer)iter.next();
                        Vector analize = (Vector)all.get(idPacient);
                        ClientPersFizica cpf = ClientLogic.getInstance().getPersFizicaById(idPacient);
                        ClinicaLogic.getInstance().tiparesteRezultatAnalize(cpf, analize);
                    }
                    DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                    AnalizeReport.this.stergeSelectia.doClick();
                }
            }
        });
        result.add((Component)this.tiparesteBuletinAnalize, c);
        ++c.gridx;
        this.valideazaAnalize = new JButton("Valideaza analize");
        this.valideazaAnalize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (UsersLogic.getInstance().isUserInGroup(AdministrationPanel.loggedUser.getId(), "group_sef_laborator")) {
                    Vector<AnalizeReportEntry> analizeFinalizate = new Vector<AnalizeReportEntry>();
                    for (int i = 0; i < AnalizeReport.this.selectedItems.size(); ++i) {
                        AnalizeReportEntry analizeReportEntry = (AnalizeReportEntry)AnalizeReport.this.selectedItems.elementAt(i);
                        if (analizeReportEntry.getStatus() != 4) continue;
                        analizeFinalizate.add(analizeReportEntry);
                    }
                    String text = "Validam " + analizeFinalizate.size() + " analize finalizate";
                    if (DialogUtils.confirmDialog(parent, text, LangRoAll.confirmare)) {
                        for (int i = 0; i < analizeFinalizate.size(); ++i) {
                            AnalizeReportEntry analizeReportEntry = (AnalizeReportEntry)analizeFinalizate.elementAt(i);
                            ClinicaLogic.getInstance().setStatusForAnaliza(analizeReportEntry.getId(), 5);
                        }
                        DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                    }
                } else {
                    DialogUtils.errorDialog(parent, "Nu aveti acces la aceasta functie", LangRoAll.nuPotContinua);
                }
                AnalizeReport.this.stergeSelectia.doClick();
            }
        });
        result.add((Component)this.valideazaAnalize, c);
        ++c.gridx;
        this.exportAnalize = new JButton("Export analize");
        this.exportAnalize.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem exportXmlCAS = new JMenuItem("SIUI XML");
                exportXmlCAS.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (ComboUtils.anythingButAllSelected(AnalizeReport.this.casaSanatate)) {
                            ClinicaLogic.getInstance().exportAnalizeToSiui(AnalizeReport.this.data, AnalizeReport.this.casaSanatate.getSelectedItem().toString(), AnalizeReport.this.dateSelector.getDates()[0], AnalizeReport.this.dateSelector.getDates()[1]);
                            DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                        } else {
                            DialogUtils.errorDialog(parent, "Alegeti o casa de sanatate", LangRoAll.nuPotContinua);
                        }
                    }
                });
                popup.add(exportXmlCAS);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)this.exportAnalize, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Bilet"), c);
        ++c.gridx;
        this.nrBiletTrimitere = new JTextField(10);
        result.add((Component)this.nrBiletTrimitere, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.comanda), c);
        ++c.gridx;
        this.codBareComanda = new JTextField(10);
        result.add((Component)this.codBareComanda, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel("Companie"), c);
        ++c.gridx;
        this.clientiPersJuridice = new JComboBox();
        result.add((Component)this.clientiPersJuridice, c);
        ++c.gridx;
        result.add((Component)new JLabel("CAS"), c);
        ++c.gridx;
        this.casaSanatate = new JComboBox();
        result.add((Component)this.casaSanatate, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Pacient"), c);
        ++c.gridx;
        this.angajati = new JComboBox();
        result.add((Component)this.angajati, c);
        ++c.gridx;
        result.add((Component)new JLabel("Rezultat"), c);
        ++c.gridx;
        this.valoare = new JComboBox();
        result.add((Component)this.valoare, c);
        c.gridx = 0;
        ++c.gridy;
        this._subcategoryLabel = new JLabel(LangRoAll.categorie);
        this._subCategoryComboBox = new JComboBox();
        result.add((Component)this._subcategoryLabel, c);
        ++c.gridx;
        result.add((Component)this._subCategoryComboBox, c);
        ++c.gridx;
        this._productsLabel = new JLabel("Analiza");
        this._productsComboBox = new JComboBox();
        this._productsComboBox.setPrototypeDisplayValue("111111111111111111111111111111111");
        result.add((Component)this._productsLabel, c);
        ++c.gridx;
        result.add((Component)this._productsComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        this.statusLabel = new JLabel(LangRoAll.status);
        result.add((Component)this.statusLabel, c);
        ++c.gridx;
        this.statusCombo = new JComboBox();
        result.add((Component)this.statusCombo, c);
        ++c.gridx;
        result.add((Component)new JLabel("Externa"), c);
        ++c.gridx;
        this.externaLocalaCombo = new JComboBox();
        result.add((Component)this.externaLocalaCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        this.numarLabel.setText(this.data.size() + "");
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            if (column.getHeaderValue().equals("Externa")) continue;
            column.setCellRenderer(this.cellRenderer);
        }
    }

    @Override
    public void doStuff() {
        this.cellRenderer = new AnalizeCellRenderer(this.tm);
        this.updateJTableColumns(this.table);
        this.table.setSelectionMode(0);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    default: 
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    default: 
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return AnalizeReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return AnalizeReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                SalesEntry ie = (SalesEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getDataOra();
                    }
                    case 1: {
                        return ie.getCategory();
                    }
                    case 2: {
                        return ie.getSubcategory();
                    }
                    case 3: {
                        return ie.getProduct();
                    }
                    case 4: {
                        return Utils.getString3Decimals(ie.getQuantity());
                    }
                    case 5: {
                        return Utils.getString2Decimals(ie.getPrice());
                    }
                    case 6: {
                        return Utils.getString2Decimals(ie.getTotalValue());
                    }
                    case 7: {
                        return ie.getPromotion();
                    }
                }
                return null;
            }
        };
        ComboUtils.replaceItemsForCombo(this.clientiPersJuridice, ClientLogic.getInstance().getClientiPersJuridice());
        this.clientiPersJuridice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(AnalizeReport.this.clientiPersJuridice)) {
                    ClientPersJuridica cpj = (ClientPersJuridica)AnalizeReport.this.clientiPersJuridice.getSelectedItem();
                    Vector angajati1 = ClientLogic.getInstance().getAnjagati(cpj.getIdPersJuridica());
                    ComboUtils.replaceItemsForCombo(AnalizeReport.this.angajati, angajati1);
                } else {
                    ComboUtils.replaceItemsForCombo(AnalizeReport.this.angajati, ClientLogic.getInstance().getClientiPersFizice());
                }
            }
        });
        ComboUtils.replaceItemsForCombo(this.casaSanatate, ClinicaLogic.getInstance().getCaseSanatate());
        ComboUtils.replaceItemsForCombo(this._subCategoryComboBox, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1));
        this.rebuildAllProducts();
        this._subCategoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(AnalizeReport.this._subCategoryComboBox)) {
                    Categorie subcat = (Categorie)AnalizeReport.this._subCategoryComboBox.getSelectedItem();
                    Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(subcat);
                    ComboUtils.replaceItemsForCombo(AnalizeReport.this._productsComboBox, products);
                } else {
                    AnalizeReport.this.rebuildAllProducts();
                }
            }
        });
        this.statusCombo.addItem("All");
        this.statusCombo.addItem("Noua");
        this.statusCombo.addItem("In lucru");
        this.statusCombo.addItem("Lipsa proba");
        this.statusCombo.addItem("Finalizata");
        this.statusCombo.addItem("Validata");
        this.statusCombo.addItem("Predata");
        this.statusCombo.addItem("Nefinalizata");
        this.externaLocalaCombo.addItem("All");
        this.externaLocalaCombo.addItem("Externa");
        this.externaLocalaCombo.addItem("Locala");
        this.valoare.addItem("All");
        this.valoare.addItem("Normal");
        this.valoare.addItem("Anormal");
        this.valoare.addItem("Hiper");
        this.valoare.addItem("Hipo");
        final AnalizeReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final AnalizeReportEntry pve = (AnalizeReportEntry)AnalizeReport.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!pve.isSelected()) {
                        AnalizeReport.this.selectedItems.add(pve);
                        AnalizeReport.this.selectateLabel.setText(AnalizeReport.this.selectedItems.size() + "");
                    } else {
                        AnalizeReport.this.selectedItems.remove(pve);
                        AnalizeReport.this.selectateLabel.setText(AnalizeReport.this.selectedItems.size() + "");
                    }
                    pve.setSelected(!pve.isSelected());
                    AnalizeReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem inLucru = new JMenuItem("In lucru");
                    inLucru.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            AnalizeReport.this.schimbaStatus(pve.getId(), 2, parent, "In lucru");
                        }
                    });
                    JMenuItem lipsaProba = new JMenuItem("Lipsa proba");
                    lipsaProba.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            AnalizeReport.this.schimbaStatus(pve.getId(), 3, parent, "Lipsa proba");
                        }
                    });
                    JMenuItem valideaza = new JMenuItem("Validata");
                    valideaza.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            AnalizeReport.this.schimbaStatus(pve.getId(), 5, parent, "Validata");
                        }
                    });
                    JMenuItem tiparesteBuletin = new JMenuItem("Tipareste buletin analiza");
                    tiparesteBuletin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            AnalizeReport.this.schimbaStatus(pve.getId(), 5, parent, "Predata");
                        }
                    });
                    JMenuItem nefinalizata = new JMenuItem("Nefinalizata");
                    nefinalizata.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            AnalizeReport.this.schimbaStatus(pve.getId(), 6, parent, "Nefinalizata");
                        }
                    });
                    JMenuItem istoricClient = new JMenuItem("Istoric client");
                    istoricClient.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            ClientPersFizica cpf = (ClientPersFizica)ClientLogic.getInstance().getClientById(pve.getIdPersFizica());
                            IstoricClientPanel icp = new IstoricClientPanel(cpf);
                            JDialog dialog = DialogUtils.getJDialog(icp, GuiUtils.currentFrame, "Alegere analize", 1.1);
                            dialog.setVisible(true);
                        }
                    });
                    switch (pve.getStatus()) {
                        case 1: {
                            popup.add(inLucru);
                            popup.add(lipsaProba);
                            break;
                        }
                        case 2: {
                            popup.add(nefinalizata);
                            break;
                        }
                        case 3: {
                            popup.add(inLucru);
                            popup.add(nefinalizata);
                            break;
                        }
                        case 4: {
                            if (!UsersLogic.getInstance().isUserInGroup(AdministrationPanel.loggedUser.getId(), "group_sef_laborator")) break;
                            popup.add(valideaza);
                            break;
                        }
                        case 5: {
                            popup.add(tiparesteBuletin);
                        }
                    }
                    popup.add(istoricClient);
                    popup.setInvoker(AnalizeReport.this.table);
                    valideaza.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "AnalizeReport_persJuridice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(AnalizeReport.this.clientiPersJuridice, ClientLogic.getInstance().getClientiPersJuridice());
            }
        }, 42);
    }

    private void schimbaStatus(int idAnaliza, int newStatus, Component parent, String newStatusString) {
        if (DialogUtils.confirmDialog(parent, "Schimbam status analiza la " + newStatusString, "Confirma")) {
            ClinicaLogic.getInstance().setStatusForAnaliza(idAnaliza, newStatus);
            DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
        } else {
            DialogUtils.errorDialog(parent, LangRoAll.operatieEsuata, LangRoAll.eroare);
        }
    }

    private void rebuildAllProducts() {
        Vector<Product> all = NomeclaturaLogic.getInstance().getAllProducts(1);
        Collections.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = ((Product)o1).getName();
                String c2 = ((Product)o2).getName();
                return c1.compareToIgnoreCase(c2);
            }
        });
        ComboUtils.replaceItemsForCombo(this._productsComboBox, all);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
    }

    private void clearSelection() {
        this.selectedItems.clear();
        this.selectateLabel.setText("0");
        for (int i = 0; i < this.data.size(); ++i) {
            AnalizeReportEntry analizeReportEntry = (AnalizeReportEntry)this.data.elementAt(i);
            analizeReportEntry.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }
}

