/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.clinicabase.BiletTrimitere;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.Diagnostic;
import ro.atreides.utils.Client;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class BiletTrimiterePanel
extends JPanel {
    private XComboBox platitori;
    private FilterableComboBoxModel platitoriComboModel;
    private JComboBox pachete;
    private JTextField serie;
    private JTextField numar;
    private JTextField codDiagnostic;
    private JTextField denDiagnostic;
    private JTextField codParafa;
    private JTextField codAsigurat;
    private JButton ataseazaScan;
    private JButton okButton;
    private JButton cancelButton;
    private JDialog dialog;
    private boolean save;
    private boolean edit;
    private int idBiletTrimitere;
    private int idFile;

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public BiletTrimiterePanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        final BiletTrimiterePanel parent = this;
        c.gridy = 0;
        c.gridx = 0;
        this.add((Component)new JLabel("Platitor"), c);
        ++c.gridx;
        this.platitoriComboModel = new FilterableComboBoxModel(ClinicaLogic.getInstance().getCaseSanatate());
        this.platitori = new XComboBox(this.platitoriComboModel, true);
        this.platitori.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.add((Component)this.platitori, c);
        this.platitoriComboModel.refresh(ClinicaLogic.getInstance().getCaseSanatate());
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Pachete CAS"), c);
        ++c.gridx;
        this.pachete = new JComboBox();
        ComboUtils.replaceItemsForCombo(this.pachete, (Collection)ClinicaLogic.getInstance().getPacheteCAS(), false);
        this.add((Component)this.pachete, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Serie"), c);
        ++c.gridx;
        this.serie = new JTextField(10);
        this.add((Component)this.serie, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Numar"), c);
        ++c.gridx;
        this.numar = new JTextField(10);
        this.add((Component)this.numar, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Cod diagnostic"), c);
        ++c.gridx;
        this.codDiagnostic = new JTextField(10);
        this.add((Component)this.codDiagnostic, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Diagnostic"), c);
        ++c.gridx;
        this.denDiagnostic = new JTextField(10);
        this.add((Component)this.denDiagnostic, c);
        this.codDiagnostic.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Diagnostic d = ClinicaLogic.getInstance().getDiagnosticByCod(BiletTrimiterePanel.this.codDiagnostic.getText());
                if (d != null) {
                    BiletTrimiterePanel.this.denDiagnostic.setText(d.getName());
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Cod parafa"), c);
        ++c.gridx;
        this.codParafa = new JTextField(10);
        this.add((Component)this.codParafa, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Cod asigurat"), c);
        ++c.gridx;
        this.codAsigurat = new JTextField(10);
        this.add((Component)this.codAsigurat, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.ataseazaScan = new JButton("Incarca biletul");
        this.add((Component)this.ataseazaScan, c);
        this.ataseazaScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String selectedFile = FileDialog.getLoadDialogLocation(null, "Selectati fisierul", "gif,png,jpg,tiff,tif,bmp,jpeg,pdf");
                if (selectedFile != null) {
                    BiletTrimiterePanel.this.idFile = ClinicaLogic.getInstance().incarcaBiletTrimitere(selectedFile);
                }
            }
        });
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.okButton = new JButton(LangRoAll.salveaza);
        this.add((Component)this.okButton, c);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (BiletTrimiterePanel.this.platitori.getSelectedItem() == null) {
                    DialogUtils.errorDialog(parent, "Completati casa de sanatate", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.platitori.requestFocus();
                    return;
                }
                ClientPersJuridica platitor = (ClientPersJuridica)BiletTrimiterePanel.this.platitori.getSelectedItem();
                double credit = platitor.getCredit();
                double valueThisMonth = ClinicaLogic.getInstance().getCreditConsumatThisMonth(platitor);
                if (valueThisMonth > credit && !DialogUtils.confirmDialog(parent, "Credit depasit in luna in curs!! Continuam", "ATENTIE !!!")) {
                    return;
                }
                if (BiletTrimiterePanel.this.pachete.getSelectedItem() == null) {
                    DialogUtils.errorDialog(parent, "Completati tipul de pachet", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.pachete.requestFocus();
                    return;
                }
                if (!Validators.correctString(BiletTrimiterePanel.this.serie.getText())) {
                    DialogUtils.errorDialog(parent, "Completati seria biletului", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.serie.requestFocus();
                    return;
                }
                if (!Validators.correctInteger(BiletTrimiterePanel.this.numar.getText())) {
                    DialogUtils.errorDialog(parent, "Completati numarul biletului", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.numar.requestFocus();
                    return;
                }
                if (!Validators.correctString(BiletTrimiterePanel.this.codDiagnostic.getText())) {
                    DialogUtils.errorDialog(parent, "Completati codul de diagnostic", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.codDiagnostic.requestFocus();
                    return;
                }
                if (!Validators.correctString(BiletTrimiterePanel.this.denDiagnostic.getText())) {
                    DialogUtils.errorDialog(parent, "Completati denumire diagnostic", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.denDiagnostic.requestFocus();
                    return;
                }
                if (!Validators.correctString(BiletTrimiterePanel.this.codParafa.getText())) {
                    DialogUtils.errorDialog(parent, "Completati cod parafa", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.codParafa.requestFocus();
                    return;
                }
                if (!Validators.correctString(BiletTrimiterePanel.this.codAsigurat.getText())) {
                    DialogUtils.errorDialog(parent, "Completati cod asigurat", LangRoAll.nuPotContinua);
                    BiletTrimiterePanel.this.codAsigurat.requestFocus();
                    return;
                }
                BiletTrimiterePanel.this.save = true;
                if (BiletTrimiterePanel.this.dialog != null) {
                    BiletTrimiterePanel.this.dialog.dispose();
                }
            }
        });
        ++c.gridx;
        this.cancelButton = new JButton(LangRoAll.renunta);
        this.add((Component)this.cancelButton, c);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BiletTrimiterePanel.this.save = false;
                if (BiletTrimiterePanel.this.dialog != null) {
                    BiletTrimiterePanel.this.dialog.dispose();
                }
            }
        });
    }

    public boolean isSave() {
        return this.save;
    }

    public int getIdPlatitor() {
        Client platitor = (Client)this.platitori.getSelectedItem();
        return platitor.getId();
    }

    public String getSerie() {
        return this.serie.getText();
    }

    public String getNumar() {
        return this.numar.getText();
    }

    public String getCodDiagnostic() {
        return this.codDiagnostic.getText();
    }

    public String getDiagnostic() {
        return this.denDiagnostic.getText();
    }

    public String getCodParafa() {
        return this.codParafa.getText();
    }

    public String getCodAsigurat() {
        return this.codAsigurat.getText();
    }

    public String getScanFile() {
        return "";
    }

    public int getIdPachetCAS() {
        Product p = (Product)this.pachete.getSelectedItem();
        return p.getId();
    }

    public void setBiletToEdit(BiletTrimitere bt) {
        int idPlatitor = bt.getIdPlatitor();
        Client c = ClientLogic.getInstance().getClientById(idPlatitor);
        this.platitori.setSelectedItem(c);
        int idPachet = bt.getIdPachet();
        Product p = NomeclaturaLogic.getInstance().getProductById(idPachet);
        this.pachete.setSelectedItem(p);
        this.serie.setText(bt.getSerie());
        this.numar.setText(bt.getNumar());
        this.codDiagnostic.setText(bt.getCodDiagnostic());
        this.denDiagnostic.setText(bt.getDenumireDiagnostic());
        this.codAsigurat.setText(bt.getCodAsigurat());
        this.codParafa.setText(bt.getCodParafa());
        this.idBiletTrimitere = bt.getId();
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public int getIdBiletTrimitere() {
        return this.idBiletTrimitere;
    }

    public void setIdBiletTrimitere(int idBiletTrimitere) {
        this.idBiletTrimitere = idBiletTrimitere;
    }

    public int getIdFile() {
        return this.idFile;
    }

    public void setIdFile(int idFile) {
        this.idFile = idFile;
    }
}

