/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.ComisionReportEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ComisionMediciReport
extends AbstractReportPanel {
    private JLabel ospatarLabel;
    private JComboBox medicCombo;
    private JMultilineLabel totalLabel;
    private JMultilineLabel totalComisionLabel;
    private RestLogic logic;
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static final String[] columns = new String[]{LangRoAll.categorie, LangRoAll.produs, LangRoAll.unitati, LangRoAll.pret, LangRoAll.valoare, LangRoAll.comision};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};

    public ComisionMediciReport() {
        this.logic = RestLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.medicCombo)) {
            User u = (User)this.medicCombo.getSelectedItem();
            result.put(Constants.WAITER_KEY, Integer.valueOf(u.getId()));
            this.printCriteria.put(Constants.WAITER_KEY, u.getName());
        } else {
            result.put(Constants.WAITER_KEY, Integer.valueOf(-1));
            this.printCriteria.remove(Constants.WAITER_KEY);
        }
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.pdfReportInterface, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ClinicaLogic.getInstance().getComisionReport(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    @Override
    public String getName() {
        return LangRoAll.comision;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ComisionReportEntry cre = (ComisionReportEntry)data.elementAt(rowIndex);
                if (cre == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return cre.getCategorie();
                    }
                    case 1: {
                        return cre.getProdus();
                    }
                    case 2: {
                        return Utils.getString2Decimals(cre.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(cre.getPret());
                    }
                    case 4: {
                        return Utils.getString2Decimals(cre.getValoare());
                    }
                    case 5: {
                        return Utils.getString2Decimals(cre.getComision());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.totalLabel = new JMultilineLabel();
        this.totalLabel.setText(LangRoAll.total);
        result.add((Component)this.totalLabel, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.ospatarLabel = new JLabel("Medic");
        categPanel.add((Component)this.ospatarLabel, c);
        ++c.gridx;
        this.medicCombo = new JComboBox();
        categPanel.add((Component)this.medicCombo, c);
        return categPanel;
    }

    @Override
    public void refreshTotalPanel() {
        double total = 0.0;
        double comision = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            ComisionReportEntry comisionReportEntry = (ComisionReportEntry)this.data.elementAt(i);
            total += comisionReportEntry.getValoare();
            comision += comisionReportEntry.getComision();
        }
        this.totalLabel.setText(LangRoAll.total + " " + Utils.getString2Decimals(total) + " " + LangRoAll.comision + Utils.getString2Decimals(comision));
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.medicCombo, (Collection)RestLogic.getInstance().getWaiters(), false);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

