/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.Diagnostic;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class DiagnosticePanel
extends ReflectedJPanel {
    private JTextField _Diagnostic;
    private JTextField _cod;
    private AbstractTM model;
    private ClinicaLogic logic = ClinicaLogic.getInstance();
    private Diagnostic diagnostic = null;

    @Override
    public void doStuff() {
        this.dysplay();
    }

    private AbstractListPanel getListaDiagnosticPanel() {
        AbstractListPanel result = new AbstractListPanel(){

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                DiagnosticePanel.this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        Diagnostic f = (Diagnostic)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return f.getCod();
                            }
                            case 1: {
                                return f.getName();
                            }
                        }
                        return null;
                    }
                });
                return DiagnosticePanel.this.model;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(2);
            }

            @Override
            public Vector buildData() {
                return DiagnosticePanel.this.logic.getDiagnostice();
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Cod Diagnostic", "Denumire Diagnostic"};
            }
        };
        result.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                Diagnostic f = (Diagnostic)o;
                DiagnosticePanel.this.setDiagnostic(f);
            }

            @Override
            public void doubleClicked(Object o) {
                Diagnostic f = (Diagnostic)o;
                DiagnosticePanel.this.setDiagnostic(f);
            }
        });
        return result;
    }

    private void setDiagnostic(Diagnostic f) {
        this.diagnostic = f;
        this._Diagnostic.setText(f.getName());
        this._cod.setText(f.getCod());
    }

    private JPanel getDiagnosticPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Cod Diagnostic"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._cod = new JTextField();
        result.add((Component)this._cod, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nume Diagnostic"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this._Diagnostic = new JTextField();
        result.add((Component)this._Diagnostic, c);
        c.weightx = 0.0;
        ++c.gridx;
        JButton _adauga = new JButton("Adauga / Salveaza");
        _adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Validators.correctString(DiagnosticePanel.this._Diagnostic.getText())) {
                    DiagnosticePanel.this._Diagnostic.requestFocus();
                    return;
                }
                String nume = DiagnosticePanel.this._Diagnostic.getText();
                if (!Validators.correctString(DiagnosticePanel.this._cod.getText())) {
                    DiagnosticePanel.this._cod.requestFocus();
                    return;
                }
                String cod = DiagnosticePanel.this._cod.getText();
                if (DiagnosticePanel.this.diagnostic == null) {
                    DiagnosticePanel.this.logic.addDiagnostic(nume, cod);
                } else {
                    DiagnosticePanel.this.diagnostic.setName(nume);
                    DiagnosticePanel.this.diagnostic.setCod(cod);
                    DiagnosticePanel.this.logic.updateDiagnostic(DiagnosticePanel.this.diagnostic);
                    DiagnosticePanel.this.diagnostic = null;
                }
                DiagnosticePanel.this.model.refresh(DiagnosticePanel.this.logic.getDiagnostice());
                DiagnosticePanel.this.resetDiagnosticPanel();
            }
        });
        result.add((Component)_adauga, c);
        ++c.gridx;
        JButton _delete = new JButton(LangRoAll.sterge);
        _delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DiagnosticePanel.this.diagnostic != null) {
                    DiagnosticePanel.this.logic.deleteDiagnostic(DiagnosticePanel.this.diagnostic);
                }
                DiagnosticePanel.this.resetDiagnosticPanel();
                DiagnosticePanel.this.diagnostic = null;
                DiagnosticePanel.this.model.refresh(DiagnosticePanel.this.logic.getDiagnostice());
            }
        });
        result.add((Component)_delete, c);
        ++c.gridx;
        JButton _cancel = new JButton(LangRoAll.renunta);
        _cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticePanel.this.resetDiagnosticPanel();
                DiagnosticePanel.this.diagnostic = null;
            }
        });
        result.add((Component)_cancel, c);
        result.setBorder(new TitledBorder("Diagnostic"));
        return result;
    }

    private void dysplay() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        JPanel cabinet = this.getDiagnosticPanel();
        this.add((Component)cabinet, c);
        ++c.gridy;
        c.weighty = 1.0;
        AbstractListPanel pl = this.getListaDiagnosticPanel();
        pl.doStuff();
        pl.setBorder(new TitledBorder("Diagnostice"));
        this.add((Component)pl, c);
    }

    private void resetDiagnosticPanel() {
        this._Diagnostic.setText("");
        this._cod.setText("");
    }
}

