/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.Functie;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class FunctiePanel
extends ReflectedJPanel {
    private JTextField _functie;
    private AbstractTM model;
    private ClinicaLogic logic = ClinicaLogic.getInstance();
    private Functie functie = null;

    @Override
    public void doStuff() {
        this.dysplay();
    }

    private AbstractListPanel getListaFunctiiPanel() {
        AbstractListPanel result = new AbstractListPanel(){

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                FunctiePanel.this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        Functie f = (Functie)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return f.getName();
                            }
                        }
                        return null;
                    }
                });
                return FunctiePanel.this.model;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(2);
            }

            @Override
            public Vector buildData() {
                return FunctiePanel.this.logic.getFunctii();
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Functie"};
            }
        };
        result.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                Functie f = (Functie)o;
                FunctiePanel.this.setFunctie(f);
            }

            @Override
            public void doubleClicked(Object o) {
                Functie f = (Functie)o;
                FunctiePanel.this.setFunctie(f);
            }
        });
        return result;
    }

    private void setFunctie(Functie f) {
        this.functie = f;
        this._functie.setText(f.getName());
    }

    private JPanel getFunctiePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Functie"), c);
        ++c.gridx;
        this._functie = new JTextField();
        result.add((Component)this._functie, c);
        ++c.gridx;
        JButton _adauga = new JButton("Adauga / Salveaza");
        _adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nume = FunctiePanel.this._functie.getText();
                if (!Validators.correctString(FunctiePanel.this._functie.getText())) {
                    FunctiePanel.this._functie.requestFocus();
                    return;
                }
                if (FunctiePanel.this.functie == null) {
                    FunctiePanel.this.logic.addFunctie(nume);
                } else {
                    FunctiePanel.this.functie.setName(nume);
                    FunctiePanel.this.logic.updateFunctie(FunctiePanel.this.functie);
                    FunctiePanel.this.functie = null;
                }
                FunctiePanel.this.model.refresh(FunctiePanel.this.logic.getFunctii());
                FunctiePanel.this.resetFunctiePanel();
            }
        });
        result.add((Component)_adauga, c);
        ++c.gridx;
        JButton _delete = new JButton(LangRoAll.sterge);
        _delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctiePanel.this.functie != null) {
                    FunctiePanel.this.logic.deleteFunctie(FunctiePanel.this.functie);
                }
                FunctiePanel.this.resetFunctiePanel();
                FunctiePanel.this.functie = null;
                FunctiePanel.this.model.refresh(FunctiePanel.this.logic.getFunctii());
            }
        });
        result.add((Component)_delete, c);
        ++c.gridx;
        JButton _cancel = new JButton(LangRoAll.renunta);
        _cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctiePanel.this.resetFunctiePanel();
                FunctiePanel.this.functie = null;
            }
        });
        result.add((Component)_cancel, c);
        result.setBorder(new TitledBorder("Functie"));
        return result;
    }

    private void dysplay() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        JPanel cabinet = this.getFunctiePanel();
        this.add((Component)cabinet, c);
        ++c.gridy;
        c.weighty = 1.0;
        AbstractListPanel pl = this.getListaFunctiiPanel();
        pl.doStuff();
        pl.setBorder(new TitledBorder("Lista functii"));
        this.add((Component)pl, c);
    }

    private void resetFunctiePanel() {
        this._functie.setText("");
    }
}

