/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.Functie;
import ro.atreides.restaurant.clinicabase.Medic;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class MedicPanel
extends ReflectedJPanel {
    private JTextField _nume;
    private JTextField _prenume;
    private JTextField _locMunca;
    private JTextField _telefon;
    private JTextField _telefonMobil;
    private JTextField _adresa;
    private JComboBox _functie;
    private AbstractTM model;
    private ClinicaLogic logic = ClinicaLogic.getInstance();
    private Medic medic = null;

    @Override
    public void doStuff() {
        this.dysplay();
    }

    private void refreshFunctii() {
        this._functie.removeAllItems();
        for (Functie element : this.logic.getFunctii()) {
            this._functie.addItem(element);
        }
    }

    private AbstractListPanel getListaMediciPanel() {
        AbstractListPanel result = new AbstractListPanel(){

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                MedicPanel.this.model = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        Medic p = (Medic)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return p.getNume();
                            }
                            case 1: {
                                return p.getPrenume();
                            }
                            case 2: {
                                return p.getFunctie();
                            }
                            case 3: {
                                return p.getLocMunca();
                            }
                            case 4: {
                                return p.getTelefon();
                            }
                            case 5: {
                                return p.getTelefonMobil();
                            }
                            case 6: {
                                return p.getAdresa();
                            }
                        }
                        return null;
                    }
                });
                return MedicPanel.this.model;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(7);
            }

            @Override
            public Vector buildData() {
                return MedicPanel.this.logic.getAllMedici();
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Nume", "Prenume", "Functie", "Loc munca", "Telefon", "Telefon mobil", "Adresa"};
            }
        };
        result.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                Medic m = (Medic)o;
                MedicPanel.this.setMedic(m);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                Medic m = (Medic)o;
                MedicPanel.this.setMedic(m);
            }
        });
        return result;
    }

    private void setMedic(Medic m) {
        this.medic = m;
        this._nume.setText(m.getNume());
        this._prenume.setText(m.getPrenume());
        this._functie.setSelectedItem(m.getFunctie());
        this._locMunca.setText(m.getLocMunca());
        this._adresa.setText(m.getAdresa());
        this._telefon.setText(m.getTelefon());
        this._telefonMobil.setText(m.getTelefonMobil());
    }

    private JPanel medicPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Nume:"), c);
        ++c.gridx;
        this._nume = new JTextField();
        result.add((Component)this._nume, c);
        ++c.gridx;
        result.add((Component)new JLabel("Prenume:"), c);
        ++c.gridx;
        this._prenume = new JTextField();
        result.add((Component)this._prenume, c);
        ++c.gridx;
        result.add((Component)new JLabel("Functie:"), c);
        ++c.gridx;
        this._functie = new JComboBox();
        this.refreshFunctii();
        result.add((Component)this._functie, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel("Loc munca:"), c);
        ++c.gridx;
        this._locMunca = new JTextField();
        result.add((Component)this._locMunca, c);
        ++c.gridx;
        result.add((Component)new JLabel("Adresa:"), c);
        ++c.gridx;
        this._adresa = new JTextField();
        result.add((Component)this._adresa, c);
        ++c.gridx;
        result.add((Component)new JLabel("Telefon:"), c);
        ++c.gridx;
        this._telefon = new JTextField();
        result.add((Component)this._telefon, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel("Telefon mobil:"), c);
        ++c.gridx;
        this._telefonMobil = new JTextField();
        result.add((Component)this._telefonMobil, c);
        c.gridx = 3;
        JButton Adauga = new JButton("Adauga / Salveaza");
        Adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nume = MedicPanel.this._nume.getText();
                String prenume = MedicPanel.this._prenume.getText();
                String locMunca = MedicPanel.this._locMunca.getText();
                String telefon = MedicPanel.this._telefon.getText();
                String telMobil = MedicPanel.this._telefonMobil.getText();
                String adresa = MedicPanel.this._adresa.getText();
                Functie functie = (Functie)MedicPanel.this._functie.getSelectedItem();
                if (!Validators.correctString(nume)) {
                    MedicPanel.this._nume.requestFocus();
                    return;
                }
                if (!Validators.correctString(prenume)) {
                    MedicPanel.this._prenume.requestFocus();
                    return;
                }
                if (MedicPanel.this.medic == null) {
                    MedicPanel.this.logic.addMedic(nume, prenume, functie.getIdFunctie(), locMunca, telefon, telMobil, adresa);
                } else {
                    MedicPanel.this.medic.setNume(nume);
                    MedicPanel.this.medic.setPrenume(prenume);
                    MedicPanel.this.medic.setIdFunctie(functie.getIdFunctie());
                    MedicPanel.this.medic.setLocMunca(locMunca);
                    MedicPanel.this.medic.setTelefon(telefon);
                    MedicPanel.this.medic.setTelefonMobil(telMobil);
                    MedicPanel.this.medic.setAdresa(adresa);
                    MedicPanel.this.logic.updateMedic(MedicPanel.this.medic);
                    MedicPanel.this.medic = null;
                }
                MedicPanel.this.model.refresh(MedicPanel.this.logic.getAllMedici());
                MedicPanel.this.resetMedicPanel();
            }
        });
        result.add((Component)Adauga, c);
        ++c.gridx;
        JButton delete = new JButton(LangRoAll.sterge);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MedicPanel.this.medic != null) {
                    MedicPanel.this.logic.deleteMedic(MedicPanel.this.medic);
                }
                MedicPanel.this.resetMedicPanel();
                MedicPanel.this.medic = null;
                MedicPanel.this.model.refresh(MedicPanel.this.logic.getAllMedici());
            }
        });
        result.add((Component)delete, c);
        ++c.gridx;
        JButton cancel = new JButton(LangRoAll.renunta);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedicPanel.this.resetMedicPanel();
                MedicPanel.this.medic = null;
            }
        });
        result.add((Component)cancel, c);
        result.setBorder(new TitledBorder("Medic"));
        return result;
    }

    private void dysplay() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        JPanel medic = this.medicPanel();
        this.add((Component)medic, c);
        ++c.gridy;
        c.weighty = 1.0;
        AbstractListPanel pl = this.getListaMediciPanel();
        pl.doStuff();
        pl.setBorder(new TitledBorder("Lista medici"));
        this.add((Component)pl, c);
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                MedicPanel.this.refreshFunctii();
            }

            @Override
            public String getName() {
                return "Medici_functie";
            }
        }, 74);
        this.refreshFunctii();
    }

    private void resetMedicPanel() {
        this._functie.setSelectedIndex(0);
        this._nume.setText("");
        this._prenume.setText("");
        this._locMunca.setText("");
        this._telefon.setText("");
        this._telefonMobil.setText("");
        this._adresa.setText("");
    }
}

