/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.Medic;
import ro.atreides.restaurant.clinicabase.MedicProcent;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class MediciProcentePanel
extends ReflectedJPanel {
    private JTextField _procent;
    private JComboBox _medic;
    private JComboBox _categorie;
    private ClinicaLogic logic = ClinicaLogic.getInstance();
    private NomeclaturaLogic nomenclaturaLogic = NomeclaturaLogic.getInstance();
    private MedicProcent medicProcent = null;
    private AbstractTM modelProcent;

    public MediciProcentePanel() {
        this.dysplay();
    }

    private void refreshMedici() {
        this._medic.removeAllItems();
        for (Medic element : this.logic.getAllMedici()) {
            this._medic.addItem(element);
        }
    }

    private void refreshCategories() {
        this._categorie.removeAllItems();
        for (Sectie element : this.nomenclaturaLogic.getAllSectii()) {
            this._categorie.addItem(element);
        }
    }

    private JPanel procentPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Medic:"), c);
        ++c.gridx;
        this._medic = new JComboBox();
        result.add((Component)this._medic, c);
        ++c.gridx;
        result.add((Component)new JLabel("Categorie:"), c);
        ++c.gridx;
        this._categorie = new JComboBox();
        result.add((Component)this._categorie, c);
        ++c.gridx;
        result.add((Component)new JLabel("Procent:"), c);
        ++c.gridx;
        this._procent = new JTextField();
        result.add((Component)this._procent, c);
        c.gridx = 3;
        ++c.gridy;
        JButton Adauga = new JButton("Adauga / Salveaza");
        Adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Medic medic = (Medic)MediciProcentePanel.this._medic.getSelectedItem();
                int idMedic = medic.getId();
                Sectie cat = (Sectie)MediciProcentePanel.this._categorie.getSelectedItem();
                int idSectie = cat.getId();
                if (!Validators.correctDouble(MediciProcentePanel.this._procent.getText())) {
                    MediciProcentePanel.this.resetMedicProcentPanel();
                    MediciProcentePanel.this._procent.requestFocus();
                    return;
                }
                double procent = Utils.parseDouble(MediciProcentePanel.this._procent.getText());
                if (MediciProcentePanel.this.medicProcent == null) {
                    MediciProcentePanel.this.logic.addMedicProcent(idMedic, idSectie, procent);
                } else {
                    MediciProcentePanel.this.medicProcent.setIdCategory(idSectie);
                    MediciProcentePanel.this.medicProcent.setIdMedic(idMedic);
                    MediciProcentePanel.this.medicProcent.setProcent(procent);
                    MediciProcentePanel.this.logic.updateMedicProcentById(MediciProcentePanel.this.medicProcent);
                    MediciProcentePanel.this.medicProcent = null;
                }
                MediciProcentePanel.this.modelProcent.refresh(MediciProcentePanel.this.logic.getAllProcente());
                MediciProcentePanel.this.resetMedicProcentPanel();
            }
        });
        result.add((Component)Adauga, c);
        ++c.gridx;
        JButton delete = new JButton(LangRoAll.sterge);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MediciProcentePanel.this.medicProcent != null) {
                    MediciProcentePanel.this.logic.deleteMedicProcent(MediciProcentePanel.this.medicProcent);
                }
                MediciProcentePanel.this.resetMedicProcentPanel();
                MediciProcentePanel.this.medicProcent = null;
                MediciProcentePanel.this.modelProcent.refresh(MediciProcentePanel.this.logic.getAllProcente());
            }
        });
        result.add((Component)delete, c);
        ++c.gridx;
        JButton cancel = new JButton(LangRoAll.renunta);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediciProcentePanel.this.resetMedicProcentPanel();
                MediciProcentePanel.this.medicProcent = null;
            }
        });
        result.add((Component)cancel, c);
        result.setBorder(new TitledBorder("Procente"));
        return result;
    }

    private void resetMedicProcentPanel() {
        this._medic.setSelectedIndex(0);
        this._categorie.setSelectedIndex(0);
        this._procent.setText("");
    }

    private AbstractListPanel medicProcentePanel() {
        AbstractListPanel result = new AbstractListPanel(){

            @Override
            public void doStuff() {
                this.display();
            }

            @Override
            public AbstractTM buildTableModel() {
                MediciProcentePanel.this.modelProcent = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        MedicProcent p = (MedicProcent)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return p.getNumeMedic();
                            }
                            case 1: {
                                return p.getCategoryName();
                            }
                            case 2: {
                                return p.getProcent() + "";
                            }
                        }
                        return null;
                    }
                });
                return MediciProcentePanel.this.modelProcent;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(7);
            }

            @Override
            public Vector buildData() {
                return MediciProcentePanel.this.logic.getAllProcente();
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Medic", LangRoAll.categorie, "Procent"};
            }
        };
        result.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                MedicProcent m = (MedicProcent)o;
                MediciProcentePanel.this.setMedicProcent(m);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                MedicProcent m = (MedicProcent)o;
                MediciProcentePanel.this.setMedicProcent(m);
            }
        });
        return result;
    }

    private void setMedicProcent(MedicProcent m) {
        this.medicProcent = m;
        this._medic.setSelectedItem(m.getNumeMedic());
        this._categorie.setSelectedItem(m.getCategoryName());
        this._procent.setText(m.getProcent() + "");
    }

    private void dysplay() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.procentPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        AbstractListPanel pl = this.medicProcentePanel();
        pl.doStuff();
        pl.setBorder(new TitledBorder("Lista medici procente"));
        this.add((Component)pl, c);
        this.nomenclaturaLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                MediciProcentePanel.this.refreshCategories();
            }

            @Override
            public String getName() {
                return "MediciProcente_categories";
            }
        }, 1);
        this.logic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                MediciProcentePanel.this.refreshMedici();
            }

            @Override
            public String getName() {
                return "MediciProcente_medici";
            }
        }, 71);
        this.refreshCategories();
        this.refreshMedici();
    }

    @Override
    public void doStuff() {
    }
}

