/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.clinica;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.clinicabase.ClinicaLogic;
import ro.atreides.restaurant.clinicabase.MedicProgram;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.SimpleDateSelector;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class ProgramMediciPanel
extends AbstractListPanel {
    private ClinicaLogic logic = ClinicaLogic.getInstance();
    private int currentYear;
    private int currentWeek;
    private JLabel weekLabel;
    private JLabel yearLabel;

    @Override
    public String[] buildColumns() {
        return new String[]{"Medic", "Luni", "Marti", "Miercuri", "Joi", "Vineri", "Sambata", "Duminica"};
    }

    @Override
    public Vector buildData() {
        return this.logic.getProgramMedici(this.currentYear, this.currentWeek);
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Saptamana "), c);
        ++c.gridx;
        this.weekLabel = new JLabel("");
        result.add((Component)this.weekLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Anul "), c);
        ++c.gridx;
        this.yearLabel = new JLabel("");
        result.add((Component)this.yearLabel, c);
        ++c.gridx;
        final SimpleDateSelector sds = new SimpleDateSelector(false);
        sds.selectDay();
        result.add(sds);
        ++c.gridx;
        JButton raport = new JButton("Raport");
        raport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Date[] dates = sds.getDates();
                Date start = dates[0];
                ProgramMediciPanel.this.setLabelsForDate(start);
                ProgramMediciPanel.this.refreshTable();
            }
        });
        result.add((Component)raport, c);
        this.setLabelsForDate(new Date());
        ++c.gridx;
        JButton adaugare = new JButton(LangRoAll.salveaza);
        adaugare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (MedicProgram element : ProgramMediciPanel.this.tm.getData()) {
                    ProgramMediciPanel.this.logic.saveMedicProgram(element, ProgramMediciPanel.this.currentYear, ProgramMediciPanel.this.currentWeek);
                }
            }
        });
        result.add((Component)adaugare, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private void setLabelsForDate(Date start) {
        this.currentYear = DateUtils.getYear(start);
        this.currentWeek = DateUtils.getWeekInYear(start);
        this.weekLabel.setText("" + this.currentWeek);
        this.yearLabel.setText("" + this.currentYear);
    }

    @Override
    public AbstractTM buildTableModel() {
        final ProgramMediciPanel parent = this;
        AbstractTM tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                String value;
                MedicProgram mp = (MedicProgram)data.elementAt(rowIndex);
                if (!mp.setTimesFromString(columnIndex - 1, value = (String)aValue, ProgramMediciPanel.this.currentYear, ProgramMediciPanel.this.currentWeek)) {
                    DialogUtils.errorDialog(parent, "Verificati datele", "Format incorect");
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex > 0;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                MedicProgram mp = (MedicProgram)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return mp.getNumeMedic();
                    }
                }
                return mp.getTimeAsString(columnIndex - 1);
            }
        });
        return tm;
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

