/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.erpsales;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.asteriskjava.util.DateUtil;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.promo.PriceWrapper;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.HotelOrderSaleInterface;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.erpsales.ErpLivrariTableModel;
import ro.atreides.restaurant.gui.livrari.LivrariMainPanel;
import ro.atreides.restaurant.gui.livrari.LivrariOrderPanel;
import ro.atreides.restaurant.gui.livrari.LivrariTableModel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.FisaMagazieEntry;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.InformatieMagazieProdus;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ColorProvider;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.keypad.VirtualKeypad2;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteLogic;

public class ErpSalesOrderPanel
extends LivrariOrderPanel {
    private DefaultTableModel detaliiModel;
    private DefaultTableModel fisaMagazieModel;
    private InformatieMagazieProdus infoMagazieProdus = new InformatieMagazieProdus();
    private Vector<FisaMagazieEntry> fisaMagazieForProduct = new Vector();
    private JTable tabelDetalii;
    private JLabel comandaLabel;
    private JLabel nrComandaLabel;
    private double currentProductPrice;

    public ErpSalesOrderPanel(RestLogic logic, LivrariMainPanel main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau, boolean marcajOnly) {
        super(logic, main, config, sectii, autoMarcaj, deleteAllPlateau, marcajOnly);
    }

    @Override
    protected JPanel getProductSearchPanel() {
        this.productsQuantity = new JTextField(5);
        this.productsPrice = new JTextField(10);
        this.availableQuantity = new JTextField(10);
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill", "[][grow][][][][]"));
        JLabel produseLabel = new JLabel(LangRoAll.produs);
        result.add(produseLabel);
        this.produseCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ErpSalesOrderPanel.this.produseCombo.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ErpSalesOrderPanel.this.refreshTablesDetails();
            }
        });
        result.add((Component)this.produseCombo, "growx");
        JLabel productsQuantityLabel = new JLabel(LangRoAll.cantitate);
        result.add(productsQuantityLabel);
        this.productsQuantity.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(ErpSalesOrderPanel.this.productsQuantity);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add(this.productsQuantity);
        JLabel productsPriceLabel = new JLabel(LangRoAll.pret);
        result.add(productsPriceLabel);
        this.productsPrice.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(ErpSalesOrderPanel.this.productsPrice);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add(this.productsPrice);
        this.productsAddButton = new JButton(LangRoAll.adauga);
        this.productsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                User user;
                String pr;
                Product p = (Product)ErpSalesOrderPanel.this.produseCombo.getSelectedItem();
                if (p == null) {
                    ErpSalesOrderPanel.this.produseCombo.requestFocus();
                    return;
                }
                String pq = ErpSalesOrderPanel.this.productsQuantity.getText();
                if (!Validators.correctDouble(pq)) {
                    ErpSalesOrderPanel.this.productsQuantity.setText("1");
                    ErpSalesOrderPanel.this.productsQuantity.requestFocus();
                }
                if (!Validators.correctDouble(pr = ErpSalesOrderPanel.this.productsPrice.getText())) {
                    ErpSalesOrderPanel.this.productsPrice.setText("");
                    ErpSalesOrderPanel.this.productsPrice.requestFocus();
                }
                double price = Utils.parseDouble(pr);
                double q = Utils.parseDouble(pq);
                boolean priceModified = false;
                if (ErpSalesOrderPanel.this.currentProductPrice != price) {
                    priceModified = true;
                }
                if (priceModified && (user = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, true, true)) == null) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "User incorect", LangRoAll.nuPotContinua);
                    ErpSalesOrderPanel.this.produseCombo.requestFocus();
                    return;
                }
                boolean b = ErpSalesOrderPanel.this.productHasReducere(p, price);
                ErpSalesOrderPanel.this.addLaPrecomanda(p, q, price, GuiUtils.currentFrame, "", b ? true : priceModified);
                ErpSalesOrderPanel.this.productsPrice.setText("");
                ErpSalesOrderPanel.this.productsQuantity.setText("1");
                ErpSalesOrderPanel.this.produseCombo.clearAllText();
                ErpSalesOrderPanel.this.produseCombo.setSelectedItem(null);
                ErpSalesOrderPanel.this.clearTablesRefresh();
                ErpSalesOrderPanel.this.produseCombo.requestFocus();
            }
        });
        this.productsAddButton.setMnemonic(65);
        result.add(this.productsAddButton);
        FocusTraversalPolicy focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    ErpSalesOrderPanel.this.updateProductPriceField();
                    ErpSalesOrderPanel.this.refreshTablesDetails();
                    return ErpSalesOrderPanel.this.productsQuantity;
                }
                if (aComponent.equals(ErpSalesOrderPanel.this.productsQuantity)) {
                    return ErpSalesOrderPanel.this.productsPrice;
                }
                if (aComponent.equals(ErpSalesOrderPanel.this.productsPrice)) {
                    return ErpSalesOrderPanel.this.productsAddButton;
                }
                if (aComponent.equals(ErpSalesOrderPanel.this.productsAddButton)) {
                    ErpSalesOrderPanel.this.updateProductName();
                    return ErpSalesOrderPanel.this.produseCombo;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return ErpSalesOrderPanel.this.produseCombo;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return ErpSalesOrderPanel.this.produseCombo;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return ErpSalesOrderPanel.this.productsAddButton;
            }
        };
        result.setFocusCycleRoot(true);
        result.setFocusTraversalPolicy(focus);
        return result;
    }

    @Override
    protected String getModPreparare(String modPreparare, Product p) {
        return NomeclaturaLogic.getInstance().getAllBarcodesForProductAsString(p.getId());
    }

    public JScrollPane buildTableDetaliiProdus() {
        this.detaliiModel = new DefaultTableModel(){

            @Override
            public int getRowCount() {
                return 4;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Detalii";
                }
                return "Valori";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (rowIndex) {
                    case 0: {
                        if (columnIndex == 0) {
                            return "In magazie";
                        }
                        return Utils.getString3Decimals(ErpSalesOrderPanel.this.infoMagazieProdus.getInMagazie());
                    }
                    case 1: {
                        if (columnIndex == 0) {
                            return "Disponibil de facturat";
                        }
                        return Utils.getString3Decimals(ErpSalesOrderPanel.this.infoMagazieProdus.getDisponibilDeFacturat());
                    }
                    case 2: {
                        if (columnIndex == 0) {
                            return "Comenzi ferme clienti";
                        }
                        return Utils.getString3Decimals(ErpSalesOrderPanel.this.infoMagazieProdus.getComenziFerme());
                    }
                    case 3: {
                        if (columnIndex == 0) {
                            return "Comenzi ferme furnizori";
                        }
                        return Utils.getString3Decimals(ErpSalesOrderPanel.this.infoMagazieProdus.getComandat());
                    }
                }
                return null;
            }
        };
        this.tabelDetalii = new JTable(this.detaliiModel);
        JScrollPane result = new JScrollPane(this.tabelDetalii);
        result.setBorder(new TitledBorder("Detalii"));
        return result;
    }

    public JScrollPane buildTableFisaMagazieProdus() {
        final String[] columns = new String[]{"Data", "Client", "Document", "Intrat", "Iesit", "Status"};
        Product p = (Product)this.produseCombo.getSelectedItem();
        this.fisaMagazieForProduct = StockLogic.getInstance().getFisaMagazieProdusForTableDesc(p);
        this.fisaMagazieModel = new DefaultTableModel(){

            @Override
            public int getRowCount() {
                return ErpSalesOrderPanel.this.fisaMagazieForProduct.size();
            }

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return columns[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                FisaMagazieEntry fisaMagazieEntry = (FisaMagazieEntry)ErpSalesOrderPanel.this.fisaMagazieForProduct.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fisaMagazieEntry.getData();
                    }
                    case 1: {
                        if (fisaMagazieEntry.getIdClient() != -1) {
                            Client clientById = ClientLogic.getInstance().getClientById(fisaMagazieEntry.getIdClient());
                            if (clientById != null) {
                                return clientById;
                            }
                            return "";
                        }
                    }
                    case 2: {
                        if (fisaMagazieEntry.getDocument().equalsIgnoreCase("Anterior")) {
                            return "in Magazie";
                        }
                        return fisaMagazieEntry.getDocument();
                    }
                    case 3: {
                        return fisaMagazieEntry.getIntrata();
                    }
                    case 4: {
                        return fisaMagazieEntry.getIesita();
                    }
                    case 5: {
                        if (fisaMagazieEntry.getComandaType() == StockLogic.COMANDA_TYPE.EFECTUAT) {
                            return "Efectuat";
                        }
                        if (fisaMagazieEntry.getComandaType() == StockLogic.COMANDA_TYPE.TEMPORARA) {
                            return "Neconfirmat";
                        }
                        if (fisaMagazieEntry.getIntrata() > 0.0) {
                            return "Comandat furnizori";
                        }
                        return "Comanda ferma";
                    }
                }
                return null;
            }
        };
        JTable fisaMagazieTabel = new JTable(this.fisaMagazieModel);
        JScrollPane result = new JScrollPane(fisaMagazieTabel);
        result.setBorder(new TitledBorder("FisaMagazie"));
        return result;
    }

    @Override
    protected JPanel getSelectorPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fillx", "", "[130:130:130][grow][grow]"));
        JScrollPane detalii = this.buildTableDetaliiProdus();
        result.add((Component)detalii, "growx, wrap");
        JScrollPane fisa = this.buildTableFisaMagazieProdus();
        result.add((Component)fisa, "grow, spany 2");
        return result;
    }

    private void refreshTablesDetails() {
        Product prod = (Product)this.produseCombo.getSelectedItem();
        this.refreshTablesDetailsForProduct(prod);
    }

    private void refreshTablesDetailsForProduct(Product prod) {
        if (prod != null) {
            this.infoMagazieProdus = StockLogic.getInstance().getDetaliiProdusForTableNew(prod.getId(), this.order);
            this.detaliiModel.fireTableDataChanged();
            this.fisaMagazieForProduct = StockLogic.getInstance().getFisaMagazieProdusForTableDesc(prod);
            this.fisaMagazieModel.fireTableDataChanged();
        }
    }

    public void clearTablesRefresh() {
        this.infoMagazieProdus = new InformatieMagazieProdus();
        this.fisaMagazieForProduct.removeAllElements();
        this.detaliiModel.fireTableDataChanged();
        this.detaliiModel.fireTableStructureChanged();
        this.fisaMagazieModel.fireTableDataChanged();
    }

    @Override
    protected ColorProvider getColorProvider(final LivrariTableModel livrariTm) {
        return new ColorProvider(){

            @Override
            public Color getColorForLine(int line, AbstractTableModel tm) {
                int salesSize = livrariTm.getRowCount();
                if (line < salesSize) {
                    Sale te = livrariTm.getEntryAtRow(line);
                    if (!te.isPrinted()) {
                        if (te.isSelectedForIntermediara()) {
                            return Color.YELLOW;
                        }
                        if (te.isFacturata()) {
                            return Color.RED;
                        }
                    } else {
                        return Color.GREEN;
                    }
                }
                return Color.WHITE;
            }
        };
    }

    @Override
    protected void display() {
        JPanel selector;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)this.getDetaliiPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.getPrecomandaPanel(), LangRoAll.precomanda);
        this.tabs.add((Component)this.getComandaPanel(), LangRoAll.comanda);
        this.add((Component)this.tabs, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.getRightPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        boolean xComboSearchInProduct = Config.getInstance().getBoolean("XComboSearchInProduct");
        this.produseCombo = new XComboBox(new FilterableComboBoxModel(NomeclaturaLogic.getInstance().getPowerSearchProducts(-1)), xComboSearchInProduct);
        this.produseCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        if (this.config.touch2ShowProductsFilter) {
            JPanel productSearch = this.getProductSearchPanel();
            this.add((Component)productSearch, c);
            ++c.gridy;
        }
        if ((selector = this.getSelectorPanel()) != null) {
            c.weighty = 2.0;
            this.add((Component)selector, c);
        }
    }

    @Override
    protected JPanel getRightPanel() {
        final ErpSalesOrderPanel panel = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        final ErpSalesOrderPanel parent = this;
        this.platouButton = this.getPlatouButton();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.kp = new VirtualKeypad2(VpConfig.getInstance().touchSelectorFontSize, true);
        result.add((Component)this.kp, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.marcaj = this.getMarcajButton(panel);
        result.add((Component)this.marcaj, c);
        ++c.gridx;
        this.incasat = this.getIncasatButton(parent);
        result.add((Component)this.incasat, c);
        ++c.gridy;
        c.gridx = 0;
        JButton oferta = new JButton("Oferta");
        oferta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErpSalesOrderPanel.this.order != null) {
                    if (ErpSalesOrderPanel.this.order.getIdClient() > 0) {
                        Hashtable<Object, Object> criteria = new Hashtable<Object, Object>();
                        criteria.put("Oferta", "true");
                        criteria.put(6, "true");
                        criteria.put("Numar oferta", ErpSalesOrderPanel.this.order.getId());
                        Object valutaObj = DialogUtils.getItemChooserDialog(ValuteLogic.getInstance().getAllValute(), 1, false);
                        if (valutaObj == null) {
                            return;
                        }
                        Valuta valutaSelectata = (Valuta)valutaObj;
                        criteria.put("Valuta", valutaSelectata);
                        ErpSalesOrderPanel.this.facturareDinFrontOffice(parent, ErpSalesOrderPanel.this.order, ErpSalesOrderPanel.this.waiter, ErpSalesOrderPanel.this.config, criteria, true);
                        if (DialogUtils.confirmDialog(panel, "Ati Facturat ok", LangRoAll.confirmare)) {
                            ErpSalesOrderPanel.this.logic.updateStatusForOrder(ErpSalesOrderPanel.this.order, 6);
                        }
                    } else {
                        DialogUtils.errorDialog(parent, "Alegeti un client", LangRoAll.nuPotContinua);
                    }
                }
            }
        });
        result.add((Component)oferta, c);
        ++c.gridx;
        JButton comandaFerma = new JButton("<html><center>Comanda<br>Ferma</center></html>");
        comandaFerma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErpSalesOrderPanel.this.order != null) {
                    if (ErpSalesOrderPanel.this.order.getIdClient() > 0) {
                        if (!ErpSalesOrderPanel.this.logic.orderHasComandaFerma(ErpSalesOrderPanel.this.order)) {
                            Hashtable<Object, Object> criteria = new Hashtable<Object, Object>();
                            criteria.put("Comanda ferma", "true");
                            criteria.put(6, "true");
                            criteria.put("Numar oferta", ErpSalesOrderPanel.this.order.getId());
                            ErpSalesOrderPanel.this.facturareDinFrontOffice(parent, ErpSalesOrderPanel.this.order, ErpSalesOrderPanel.this.waiter, ErpSalesOrderPanel.this.config, criteria, true);
                            if (DialogUtils.confirmDialog(panel, "Ati Facturat ok", LangRoAll.confirmare)) {
                                ErpSalesOrderPanel.this.logic.updateStatusForOrder(ErpSalesOrderPanel.this.order, 5);
                            }
                        } else {
                            DialogUtils.errorDialog(parent, "Exista deja o comanda ferma", LangRoAll.nuPotContinua);
                        }
                    } else {
                        DialogUtils.errorDialog(parent, "Alegeti un client", LangRoAll.nuPotContinua);
                    }
                }
            }
        });
        result.add((Component)comandaFerma, c);
        ++c.gridy;
        c.gridx = 0;
        JButton selectiePentruFacturare = new JButton("<html><center>Selectie<br>Facturare</center></html>");
        selectiePentruFacturare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErpSalesOrderPanel.this.buildSalesForFacturare();
            }
        });
        result.add((Component)selectiePentruFacturare, c);
        ++c.gridx;
        JButton facturareButton = new JButton("<html><center>Facturare</center></html>");
        facturareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErpSalesOrderPanel.this.order != null && ErpSalesOrderPanel.this.order.getIdClient() > 0) {
                    if (ErpSalesOrderPanel.this.isAnySaleSelected()) {
                        Hashtable<String, Object> criteria = new Hashtable<String, Object>();
                        criteria.put("Active", "true");
                        Valuta v = ValuteLogic.getInstance().getValutaPrincipala();
                        if (v != null) {
                            criteria.put("Valuta", v);
                        }
                        ErpSalesOrderPanel.this.buildCriteriaWithProductsQuantity(criteria);
                        ErpSalesOrderPanel.this.facturareDinFrontOffice(parent, ErpSalesOrderPanel.this.order, ErpSalesOrderPanel.this.waiter, ErpSalesOrderPanel.this.config, criteria, true);
                        if (DialogUtils.confirmDialog(panel, "Ati Facturat ok", LangRoAll.confirmare)) {
                            Vector selectedSales = ErpSalesOrderPanel.this.getSelectedSales();
                            ErpSalesOrderPanel.this.logic.splitSalesForFacturareIfNecessary(ErpSalesOrderPanel.this.order, selectedSales);
                            ErpSalesOrderPanel.this.logic.setSalesFacturate(selectedSales);
                            ErpSalesOrderPanel.this.logic.reproceseazaStocRezervat(ErpSalesOrderPanel.this.order, selectedSales);
                            ErpSalesOrderPanel.this.refreshOrderSales();
                        }
                    } else {
                        DialogUtils.okDialog(parent, "Nu sunt produse selectate pentru facturare", LangRoAll.eroare);
                    }
                }
            }
        });
        result.add((Component)facturareButton, c);
        ++c.gridy;
        c.gridx = 0;
        JButton selectiePentruLivrare = new JButton("<html><center>Selectie<br>Livrare</center></html>");
        selectiePentruLivrare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErpSalesOrderPanel.this.buildSalesForLivrare();
            }
        });
        result.add((Component)selectiePentruLivrare, c);
        ++c.gridx;
        JButton livrareButton = new JButton("<html><center>Livrare</center></html>");
        livrareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErpSalesOrderPanel.this.isAnySaleSelected()) {
                    if (DialogUtils.confirmDialog(panel, "Ati selectat ok produsele pentru livrare", LangRoAll.confirmare)) {
                        ErpSalesOrderPanel.this.logic.setSalesPrinted(ErpSalesOrderPanel.this.getSelectedSales());
                        ErpSalesOrderPanel.this.refreshOrderSales();
                        ErpSalesOrderPanel.this.readyForIncasat();
                    }
                } else {
                    DialogUtils.okDialog(parent, "Nu sunt produse selectate pentru livrare", LangRoAll.eroare);
                }
            }
        });
        result.add((Component)livrareButton, c);
        return result;
    }

    public void facturareDinFrontOffice(Component parent, Order order, User waiter, VpConfig config, Hashtable criteria, boolean addTva) {
        if (order != null) {
            if (order.getIdClient() > 0) {
                Hashtable<Object, Object> h = new Hashtable<Object, Object>();
                h.put("id_order_key", order.getId());
                if (criteria.get(6) != null) {
                    h.put(6, "true");
                }
                Vector<NoteView> newData = RestLogic.getInstance().getNote(h, true, 1);
                User emitent = waiter;
                if (config.touch2FacturaRequestEmitent) {
                    emitent = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, true, true);
                }
                Magazie magazieDefault = StockLogic.getInstance().getMagazii().get(0);
                if (emitent != null) {
                    if (criteria != null) {
                        Vector<NoteView> availableNotes = newData;
                        if (criteria.get("Active") != null) {
                            availableNotes = this.getAvailableNoteViewBasedOnCriteria(newData, criteria);
                        }
                        for (NoteView noteView : availableNotes) {
                            noteView.setMagazieForFacturare(magazieDefault);
                            if (!addTva) continue;
                            int idProdus = noteView.getIdProdus();
                            Product p = NomeclaturaLogic.getInstance().getProductById(idProdus);
                            Categorie categorie = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                            Tva tva = TvaLogic.getInstance().getTvaById(categorie.getIdTva());
                            double suma = noteView.getSuma();
                            noteView.setSuma(suma *= 1.0 + tva.getCota());
                        }
                        AddFacturaDialog dialog = new AddFacturaDialog(true, parent, availableNotes, order.getIdClient(), emitent, criteria);
                    } else {
                        for (NoteView noteView : newData) {
                            noteView.setMagazieForFacturare(magazieDefault);
                        }
                        AddFacturaDialog dialog = new AddFacturaDialog(true, parent, newData, order.getIdClient(), emitent);
                    }
                }
            } else {
                DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            }
        } else {
            DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
        }
    }

    private Vector<NoteView> getAvailableNoteViewBasedOnCriteria(Vector<NoteView> allNote, Hashtable criteria) {
        Vector<NoteView> noteViews = new Vector<NoteView>();
        for (NoteView nota : allNote) {
            Vector cantitate;
            int idProdus = nota.getIdProdus();
            Object o = criteria.get(idProdus);
            if (o == null || (cantitate = (Vector)o).size() <= 0) continue;
            Double cantitatePrima = (Double)cantitate.get(0);
            if (cantitatePrima.doubleValue() != nota.getCantitate()) {
                double ppu = nota.getSuma() / nota.getCantitate();
                nota.setSuma(ppu * cantitatePrima);
                nota.setCantitate(cantitatePrima);
            }
            noteViews.add(nota);
            cantitate.remove(0);
        }
        return noteViews;
    }

    private void buildSalesForFacturare() {
        ErpSalesOrderPanel parent = this;
        this.clearSelection();
        Vector<Sale> sales = RestLogic.getInstance().buildSalesForFacturareGUI(parent, this.logic.getSales(this.order.getId(), false, -1, new HotelOrderSaleInterface()), this.order);
        this.orderTm.updateTable(sales);
    }

    private void buildCriteriaWithProductsQuantity(Hashtable criteria) {
        Vector allSales = this.orderTm.getAllSales();
        for (Sale sale : allSales) {
            if (!sale.isSelectedForIntermediara()) continue;
            Vector total = (Vector)criteria.get(sale.getIdProduct());
            if (total == null) {
                criteria.put(sale.getIdProduct(), new Vector());
            }
            ((Vector)criteria.get(sale.getIdProduct())).add(sale.getCantitateMarcata());
        }
    }

    private void buildSalesForLivrare() {
        this.clearSelection();
        Vector allSales = this.orderTm.getAllSales();
        for (Sale sale : allSales) {
            if (!sale.isFacturata() || sale.isPrinted() || sale.isSelectedForIntermediara()) continue;
            sale.setSelectedForIntermediara(true);
        }
        this.orderTm.updateTable(allSales);
    }

    private void clearSelection() {
        for (Sale sale : this.orderTm.getAllSales()) {
            sale.setSelectedForIntermediara(false);
        }
    }

    private Vector<Sale> getSelectedSales() {
        Vector allSales = this.orderTm.getAllSales();
        Vector<Sale> selectedSales = new Vector<Sale>();
        for (Sale sale : allSales) {
            if (!sale.isSelectedForIntermediara()) continue;
            selectedSales.add(sale);
        }
        return selectedSales;
    }

    private boolean isAnySaleSelected() {
        Vector allSales = this.orderTm.getAllSales();
        for (Sale sale : allSales) {
            if (!sale.isSelectedForIntermediara()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void refreshOrderSales() {
        this.orderTm.updateTable(this.logic.getSales(this.order.getId(), true, -1, new HotelOrderSaleInterface()));
    }

    @Override
    protected MouseListener getOrderTableMouseListener(final Component panel) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = ErpSalesOrderPanel.this.orderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 0: {
                        Product produs = NomeclaturaLogic.getInstance().getProductById(s.getIdProduct());
                        ErpSalesOrderPanel.this.refreshTablesDetailsForProduct(produs);
                        break;
                    }
                    case 1: {
                        if (ErpSalesOrderPanel.this.order != null && ErpSalesOrderPanel.this.order.isLaPlata() && !((ErpSalesOrderPanel)ErpSalesOrderPanel.this).config.allowStergereAfterNota) {
                            DialogUtils.errorDialog(panel, LangRoAll.nuPutetiEfectuaReturDupaNota, LangRoAll.nuPotContinua);
                            return;
                        }
                        if (!((ErpSalesOrderPanel)ErpSalesOrderPanel.this).config.allowRetur) break;
                        double toDelete = s.getCantitateMarcata();
                        if (ErpSalesOrderPanel.this.kp.getValue() > 0.0) {
                            toDelete = ErpSalesOrderPanel.this.kp.getValue();
                            ErpSalesOrderPanel.this.kp.reset();
                        }
                        if (toDelete > s.getCantitateMarcata()) {
                            toDelete = s.getCantitateMarcata();
                        }
                        if (s.getIdPlatou() > 0 && ErpSalesOrderPanel.this.deleteAllPlateau) {
                            ErpSalesOrderPanel.this.deleteAllPlateau(toDelete, panel, s);
                            break;
                        }
                        ErpSalesOrderPanel.this.deleteSingleProduct(toDelete, panel, s, selRow);
                        break;
                    }
                    case 2: {
                        s.setSelectedForIntermediara(!s.isSelectedForIntermediara());
                        t.repaint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    @Override
    public void setTable(Table t, User w, Order o, boolean fromMarcaj, boolean fromRefresh) {
        super.setTable(t, w, o, fromMarcaj, fromRefresh);
        this.clearTablesRefresh();
    }

    @Override
    protected JPanel getDetaliiPanel() {
        super.getDetaliiPanel();
        Font font = new Font(null, 1, VpConfig.getInstance().touch2ClientFontSize);
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        this.comandaLabel = new JLabel("");
        this.comandaLabel.setForeground(Color.RED);
        this.comandaLabel.setFont(font);
        result.add(this.comandaLabel);
        this.nrComandaLabel = new JLabel("");
        this.nrComandaLabel.setForeground(Color.RED);
        this.nrComandaLabel.setFont(font);
        result.add(this.nrComandaLabel);
        result.add(this.clientText);
        result.add(this.promoText);
        return result;
    }

    @Override
    protected void setFields(Table t, User w) {
        super.setFields(t, w);
        String tipOrder = "";
        String orderid = "";
        if (this.order != null) {
            switch (this.order.getStatus()) {
                case 1: {
                    tipOrder = "Cerere";
                    break;
                }
                case 5: {
                    tipOrder = "Comanda ferma";
                    break;
                }
                case 6: {
                    tipOrder = "Oferta";
                    break;
                }
            }
            orderid = this.order.getId() + "";
        }
        this.nrComandaLabel.setText(orderid);
        this.comandaLabel.setText(tipOrder);
        this.setPromotionText();
    }

    private boolean orderHasProduseNefacturare() {
        Vector allSales = this.orderTm.getAllSales();
        for (Sale sale : allSales) {
            if (sale.isFacturata()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JButton getIncasatButton(final JPanel parent) {
        JButton incasat = new JButton("<html><center>Inchide<br>Comanda&nbsp;</center></html>");
        incasat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RestLogic.getInstance().needPlatiCheckingAtIncasat(ErpSalesOrderPanel.this.order) && !ErpSalesOrderPanel.this.logic.isTotalOrderEqualWithTotalPlati(ErpSalesOrderPanel.this.order)) {
                    DialogUtils.errorDialog(parent, LangRoAll.tipurileDePlataNuAcopera, LangRoAll.nuPotContinua);
                    return;
                }
                if (ErpSalesOrderPanel.this.orderHasProduseNefacturare()) {
                    DialogUtils.errorDialog(parent, "Exista produse nefacturate", LangRoAll.nuPotContinua);
                    return;
                }
                ErpSalesOrderPanel.this.incasat();
                ErpSalesOrderPanel.this.main.nota(ErpSalesOrderPanel.this.order);
            }
        });
        incasat.setEnabled(false);
        return incasat;
    }

    @Override
    protected LivrariTableModel getOrderTM() {
        return new ErpLivrariTableModel();
    }

    @Override
    protected LivrariTableModel getPreorderTM() {
        return new ErpLivrariTableModel();
    }

    @Override
    protected void updateProductPriceField() {
        Product p = (Product)this.produseCombo.getSelectedItem();
        if (p != null) {
            double priceForProduct = RestLogic.getInstance().getPriceForProductCommit(p.getId());
            int idPromotie = this.order.getIdPromotie();
            if (idPromotie != -1) {
                long saleDate = DateUtil.getDate().getTime();
                Promotion promotie = PromotionLogic.getInstance().getPromotionById(idPromotie);
                Sectie sectie = NomeclaturaLogic.getInstance().getSectieByCategoryId(p.getIdCategorie());
                PriceWrapper pw = promotie.getPw(p.getId(), p.getIdCategorie(), sectie.getId(), priceForProduct, saleDate, Double.valueOf(this.totalOrder.getText()));
                priceForProduct = pw.getPrice();
            }
            this.currentProductPrice = FloatUtils.roundFloat(priceForProduct, VpConfig.getInstance().frontOfficeRoundDecimals);
            this.productsPrice.setText(Utils.getStringXDecimals(priceForProduct, VpConfig.getInstance().frontOfficeRoundDecimals));
        }
    }

    @Override
    public void readyForIncasat() {
        Vector salesPrecomanda = this.preorderTm.getAllSales();
        Vector allSales = this.orderTm.getAllSales();
        boolean allProductsLivrate = true;
        if (salesPrecomanda.size() > 0) {
            allProductsLivrate = false;
        }
        Iterator iterator = allSales.iterator();
        while (iterator.hasNext() && allProductsLivrate) {
            Sale next = (Sale)iterator.next();
            if (next.isPrinted()) continue;
            allProductsLivrate = false;
        }
        this.incasat.setEnabled(allProductsLivrate);
    }

    @Override
    protected void addLaPrecomanda(Product p, double quantity, double pret, Component panel, String modPreparare, boolean ignoresPromotion) {
        super.addLaPrecomanda(p, quantity, pret, panel, modPreparare, ignoresPromotion);
        this.readyForIncasat();
    }

    @Override
    protected void deleteSingleProduct(double toDelete, Component panel, Sale s, int selRow) {
        super.deleteSingleProduct(toDelete, panel, s, selRow);
        this.readyForIncasat();
    }

    private boolean productHasReducere(Product p, double price) {
        double priceForProduct = RestLogic.getInstance().getPriceForProductCommit(p.getId());
        return price != priceForProduct;
    }
}

