/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.erpsales;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.DocumenteClient;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IncasareClientView;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public class IstoricClientPanel
extends JPanel {
    private Client client;

    public IstoricClientPanel(Client client) {
        this.client = client;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        JPanel datepacient = this.buildDatePacient();
        datepacient.setBorder(new TitledBorder("Date client"));
        this.add((Component)datepacient, c);
        ++c.gridx;
        JPanel documente = this.buildIstoricPanel();
        documente.setBorder(new TitledBorder("Istoric"));
        this.add((Component)documente, c);
    }

    private JPanel buildDatePacient() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel numeL = new JLabel("Nume");
        result.add((Component)numeL, c);
        ++c.gridx;
        JLabel nume = new JLabel(this.client.toString());
        result.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        numeL = new JLabel("Cod");
        result.add((Component)numeL, c);
        ++c.gridx;
        String cod = "";
        cod = this.client instanceof ClientPersFizica ? ClientLogic.getInstance().getCNPForClient((ClientPersFizica)this.client) : ((ClientPersJuridica)this.client).getCui();
        nume = new JLabel(cod);
        result.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel varstaL = new JLabel("Vechime");
        result.add((Component)varstaL, c);
        ++c.gridx;
        String vechimea = DateUtils.getDiferentaIntreOre(this.client.getLastUpdated().getTime(), System.currentTimeMillis());
        JLabel varsta = new JLabel(vechimea);
        result.add((Component)varsta, c);
        ++c.gridy;
        c.gridx = 0;
        numeL = new JLabel("Valoare cont - total");
        result.add((Component)numeL, c);
        ++c.gridx;
        double total = RestLogic.getInstance().getTotalIncasari(this.client, DateUtils.getStartOfDays());
        nume = new JLabel(Utils.getString2Decimals(total));
        result.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        numeL = new JLabel("Valoare cont - 6 luni");
        result.add((Component)numeL, c);
        ++c.gridx;
        total = RestLogic.getInstance().getTotalIncasari(this.client, DateUtils.addDaysToDate(new Date(), -180));
        nume = new JLabel(Utils.getString2Decimals(total));
        result.add((Component)nume, c);
        return result;
    }

    private JPanel buildComentarii() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        Vector<IncasareClientView> orders = RestLogic.getInstance().getIncasariByIdClient(this.client.getId());
        AbstractTM tm = new AbstractTM(new String[]{"Observatii"}, Utils.getStringClass(1), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IncasareClientView icv = (IncasareClientView)data.get(rowIndex);
                Order o = RestLogic.getInstance().getOrderById(icv.getIdOrder());
                String detalii = o.getDetalii();
                return detalii;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        JTable items = new JTable(tm);
        tm.refresh(orders);
        JScrollPane scroll = new JScrollPane(items);
        result.add((Component)scroll, c);
        return result;
    }

    private JPanel buildIstoricVanzari() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        return result;
    }

    private JPanel buildIstoricPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Observatii", this.buildComentarii());
        tabs.addTab("Documente generate", this.buildDocumenteGeneratePanel());
        tabs.addTab("Istoric", this.buildIstoricVanzari());
        result.add((Component)tabs, c);
        return result;
    }

    private JPanel buildDocumenteGeneratePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        Vector documente = ClientLogic.getInstance().getDocumenteClient(this.client.getId());
        final AbstractTM tm = new AbstractTM(new String[]{"Data", "Tip document", "Titlu"}, Utils.getStringClass(3), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                DocumenteClient dv = (DocumenteClient)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(dv.getData());
                    }
                    case 1: {
                        return dv.getCategorieDocument();
                    }
                    case 2: {
                        return dv.getTitle();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        JTable items = new JTable(tm);
        tm.refresh(documente);
        JScrollPane scroll = new JScrollPane(items);
        result.add((Component)scroll, c);
        items.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(final MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem open = new JMenuItem("Open");
                open.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        DocumenteClient pve = (DocumenteClient)tm.getObjectAt(selRow);
                        DocumenteLogic.getInstance().openFile(pve.getIdFile(), "123.odt");
                    }
                });
                popup.add(open);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        return result;
    }
}

