/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.festive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.festive.FestiveTabel1Bean;
import ro.atreides.restaurant.gui.festive.FestiveTabel1Entry;
import ro.atreides.restaurant.gui.festive.Servire;
import ro.atreides.restaurant.logic.FestiveLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class FestiveTabel1
extends AbstractListPanel {
    private Vector servire;
    private int idEvent;

    public FestiveTabel1(Vector servire, int idEvent) {
        this.servire = servire;
        this.idEvent = idEvent;
    }

    private int getNoOfColumns() {
        return this.servire.size() + 11;
    }

    @Override
    public String[] buildColumns() {
        int size = this.getNoOfColumns();
        String[] result = new String[size];
        int i = 0;
        result[i] = LangRoAll.produs;
        for (i = 1; i <= this.servire.size(); ++i) {
            Servire o = (Servire)this.servire.elementAt(i - 1);
            result[i] = o.getLabel();
        }
        result[i] = "C Normata";
        result[++i] = "C Normala";
        result[++i] = "Pret inreg";
        result[++i] = "Val inreg normata";
        result[++i] = "Pret nou";
        result[++i] = "Val pret nou normata";
        result[++i] = "Dif val normata";
        result[++i] = "Val pret inreg normala";
        result[++i] = "Val pret nou normala";
        result[++i] = "Diff val normala";
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                double f = Utils.parseDouble((String)aValue);
                FestiveTabel1Entry fe = (FestiveTabel1Entry)data.elementAt(rowIndex);
                if (columnIndex == 0) {
                    return;
                }
                int feluri = FestiveTabel1.this.servire.size();
                if (columnIndex <= feluri) {
                    Vector beans = fe.getItems();
                    FestiveTabel1Bean b = (FestiveTabel1Bean)beans.elementAt(columnIndex - 1);
                    b.setCantitate(f);
                    FestiveLogic.getInstance().updateTabel1(fe.getIdProdus(), b.getIdServire(), FestiveTabel1.this.idEvent, f, fe.getPretNou());
                } else if (columnIndex == feluri + 5) {
                    fe.setPretNou(f);
                    FestiveLogic.getInstance().updatePret(FestiveTabel1.this.idEvent, fe.getIdProdus(), f);
                }
                fe.compute();
                FestiveTabel1.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return false;
                }
                int feluri = FestiveTabel1.this.servire.size();
                if (columnIndex <= feluri) {
                    return true;
                }
                return columnIndex == feluri + 5;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FestiveTabel1Entry fe = (FestiveTabel1Entry)data.elementAt(rowIndex);
                return FestiveTabel1.this.getValueAtRow(fe, columnIndex);
            }
        });
        return this.tm;
    }

    private String getValueAtRow(FestiveTabel1Entry fe, int columnIndex) {
        if (columnIndex == 0) {
            return fe.getProdus();
        }
        int feluri = this.servire.size();
        if (columnIndex <= feluri) {
            Vector beans = fe.getItems();
            FestiveTabel1Bean b = (FestiveTabel1Bean)beans.elementAt(columnIndex - 1);
            return Utils.getString3Decimals(b.getCantitate());
        }
        if (columnIndex == feluri + 1) {
            return Utils.getString3Decimals(fe.getCantNormata());
        }
        if (columnIndex == feluri + 2) {
            return Utils.getString3Decimals(fe.getCantNormala());
        }
        if (columnIndex == feluri + 3) {
            return Utils.getString2Decimals(fe.getPretInreg());
        }
        if (columnIndex == feluri + 4) {
            return Utils.getString2Decimals(fe.getValInregNormata());
        }
        if (columnIndex == feluri + 5) {
            return Utils.getString2Decimals(fe.getPretNou());
        }
        if (columnIndex == feluri + 6) {
            return Utils.getString2Decimals(fe.getValNouNormata());
        }
        if (columnIndex == feluri + 7) {
            return Utils.getString2Decimals(fe.getDiffNormata());
        }
        if (columnIndex == feluri + 8) {
            return Utils.getString2Decimals(fe.getValInregNormala());
        }
        if (columnIndex == feluri + 9) {
            return Utils.getString2Decimals(fe.getValNouNormala());
        }
        if (columnIndex == feluri + 10) {
            return Utils.getString2Decimals(fe.getDiffNormala());
        }
        return "";
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        JButton print = new JButton(LangRoAll.print);
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                final Hashtable printCriteria = new Hashtable();
                ReportInterface reportInterface = new ReportInterface(){

                    @Override
                    public int getColumnCount() {
                        return FestiveTabel1.this.buildColumns().length;
                    }

                    @Override
                    public int getColumnSize(int column) {
                        return 1;
                    }

                    @Override
                    public String getColumnName(int column) {
                        return FestiveTabel1.this.buildColumns()[column];
                    }

                    @Override
                    public String getReportTitle() {
                        return "Tabel 1 - Lista necesar";
                    }

                    @Override
                    public Hashtable getCriteria() {
                        return printCriteria;
                    }

                    @Override
                    public boolean isLandscape() {
                        return true;
                    }

                    @Override
                    public String getCellContent(Object row, int column) {
                        return FestiveTabel1.this.getValueAtRow((FestiveTabel1Entry)row, column);
                    }

                    @Override
                    public String getTotal(int column) {
                        return "";
                    }
                };
                String pdfFile = PrintLogic.getInstance().buildReportPdfText(FestiveTabel1.this.tm.getData(), reportInterface);
                PrintLogic.getInstance().printPreview(pdfFile);
            }
        });
        result.add((Component)print, c);
        return result;
    }

    @Override
    public Vector buildData() {
        Vector data = FestiveLogic.getInstance().getFestive1ForEveniment(this.idEvent);
        return data;
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.getNoOfColumns());
    }

    @Override
    public void doStuff() {
        this.display(true);
    }

    public void cleanup() {
        this.tm.refresh(new Vector());
    }
}

