/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.festive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.festive.FestiveTabel3Entry;
import ro.atreides.restaurant.logic.FestiveLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class FestiveTabel3
extends AbstractListPanel {
    private int idEvent;
    private double valEfectiva;
    private double diffValoare;
    private double valEfectivaDeriv;
    private JLabel valEfectivaInregLabel = new JLabel();
    private JLabel diffValoareLabel = new JLabel();
    private JLabel valEfectivaDerivatLabel = new JLabel();

    public FestiveTabel3(int idEvent) {
        this.idEvent = idEvent;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.produs, "Cant normata", "Cant normala", "Pret inreg", "Pret nou", "Cant consumata", "Pret inreg vechi", "Val pret inreg efectiva", "Pret derivat", "Val pret derivat", "Dif cant efectiva"};
    }

    private String getValueAtRow(Object row, int columnIndex) {
        FestiveTabel3Entry e = (FestiveTabel3Entry)row;
        switch (columnIndex) {
            case 0: {
                return e.getProdus();
            }
            case 1: {
                return Utils.getString3Decimals(e.getCantNormata());
            }
            case 2: {
                return Utils.getString3Decimals(e.getCantNormala());
            }
            case 3: {
                return Utils.getString2Decimals(e.getPretInreg());
            }
            case 4: {
                return Utils.getString2Decimals(e.getPretNou());
            }
            case 5: {
                return Utils.getString3Decimals(e.getCantConsumata());
            }
            case 6: {
                return Utils.getString2Decimals(e.getPretInreg());
            }
            case 7: {
                return Utils.getString2Decimals(e.getValInregEfectiva());
            }
            case 8: {
                return Utils.getString2Decimals(e.getPretDerivat());
            }
            case 9: {
                return Utils.getString2Decimals(e.getValPrDerivatCantEfectiva());
            }
            case 10: {
                return Utils.getString2Decimals(e.getDiffValoare());
            }
        }
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FestiveTabel3Entry e = (FestiveTabel3Entry)data.elementAt(rowIndex);
                return FestiveTabel3.this.getValueAtRow(e, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        JButton print = new JButton(LangRoAll.print);
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                final Hashtable printCriteria = new Hashtable();
                ReportInterface reportInterface = new ReportInterface(){

                    @Override
                    public int getColumnCount() {
                        return FestiveTabel3.this.buildColumns().length;
                    }

                    @Override
                    public int getColumnSize(int column) {
                        return 1;
                    }

                    @Override
                    public String getColumnName(int column) {
                        return FestiveTabel3.this.buildColumns()[column];
                    }

                    @Override
                    public String getReportTitle() {
                        return "Tabel 3 - Lista inventar";
                    }

                    @Override
                    public Hashtable getCriteria() {
                        return printCriteria;
                    }

                    @Override
                    public boolean isLandscape() {
                        return true;
                    }

                    @Override
                    public String getCellContent(Object row, int column) {
                        return FestiveTabel3.this.getValueAtRow(row, column);
                    }

                    @Override
                    public String getTotal(int column) {
                        switch (column) {
                            case 0: {
                                return LangRoAll.total;
                            }
                            case 7: {
                                return FestiveTabel3.this.valEfectivaInregLabel.getText();
                            }
                            case 9: {
                                return FestiveTabel3.this.valEfectivaDerivatLabel.getText();
                            }
                            case 10: {
                                return FestiveTabel3.this.diffValoareLabel.getText();
                            }
                        }
                        return "";
                    }
                };
                String pdfFile = PrintLogic.getInstance().buildReportPdfText(FestiveTabel3.this.tm.getData(), reportInterface);
                PrintLogic.getInstance().printPreview(pdfFile);
            }
        });
        result.add((Component)print, c);
        c.weightx = 1.0;
        ++c.gridx;
        result.add((Component)new JLabel("Total valoare efectiva inregistrare"), c);
        ++c.gridx;
        result.add((Component)this.valEfectivaInregLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total valoare efectiva derivata"), c);
        ++c.gridx;
        result.add((Component)this.valEfectivaDerivatLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Dif valoare efectiva"), c);
        ++c.gridx;
        result.add((Component)this.diffValoareLabel, c);
        return result;
    }

    @Override
    public Vector buildData() {
        Vector v = FestiveLogic.getInstance().getFestive3ForEveniment(this.idEvent);
        this.valEfectiva = 0.0;
        this.diffValoare = 0.0;
        this.valEfectivaDeriv = 0.0;
        for (int i = 0; i < v.size(); ++i) {
            FestiveTabel3Entry o = (FestiveTabel3Entry)v.elementAt(i);
            this.valEfectiva += o.getValInregEfectiva();
            this.diffValoare += o.getDiffValoare();
            this.valEfectivaDeriv += o.getValPrDerivatCantEfectiva();
        }
        this.diffValoareLabel.setText(Utils.getString2Decimals(this.diffValoare));
        this.valEfectivaInregLabel.setText(Utils.getString2Decimals(this.valEfectiva));
        this.valEfectivaDerivatLabel.setText(Utils.getString2Decimals(this.valEfectivaDeriv));
        return v;
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display(true);
    }
}

