/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.hotel;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.hotel.HotelGrupPanel;
import ro.atreides.restaurant.modules.rezervari.HotelGroup;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.restaurant.modules.rezervari.ListaCamereView;
import ro.atreides.restaurant.modules.rezervari.RezervareBean;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.restaurant.modules.rezervari.RezervariMeseView;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class EditRezervarePanel
extends JPanel {
    public static final String BLOCHEAZA_TEXT = "Blocheaza Tarif";
    public static final String DEBLOCHEAZA_TEXT = "Deblocheaza Tarif";
    private JTextArea comentarii;
    private XComboBox clienti;
    private FilterableComboBoxModel clientsComboModel;
    private XComboBox agentii;
    private FilterableComboBoxModel agentiiComboModel;
    private JComboBox sex;
    private JComboBox group;
    private JTextField adresa;
    private JTextField tarifActual1;
    private MDateEntryField _startDayTextField;
    private MDateEntryField _stopDayTextField;
    private JTextField numarPersoane;
    private int idCalendar = -1;
    private boolean tarifFieldsEnabled = true;
    private Insets buttonMargins = new Insets(1, 1, 1, 1);
    private JComboBox produse;
    private JComboBox promotie;
    private JButton tarife;
    private JButton modificaAgentie;
    private JButton addAgentieButton;
    private JButton promoNou;
    private JButton modificaTarifActual;
    private JButton blocheazaTarif;
    private JButton salveaza;
    private JButton renunta;
    private JButton factura;
    private JMultilineLabel camereSelectateLabel = new JMultilineLabel();
    private AbstractTM meseTm;
    private JTable meseTable;
    private JDialog parent;
    private JTextArea detaliiRezervareTA;
    private Vector<ListaCamereView> camereSelectate = new Vector();
    private User receptioner;
    private double avansFacturat;
    private RezervareBean rezervareBeanToEdit = null;

    public EditRezervarePanel(User receptioner) {
        this.receptioner = receptioner;
    }

    private void display() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow] [shrink 0]"));
        this.add((Component)this.getCamerePanel(), "span 2, growx, wrap");
        this.add((Component)this.getClientiPanel(), "");
        JTabbedPane tabs1 = new JTabbedPane();
        tabs1.addTab("Perioada", this.getPerioadaPanel());
        tabs1.addTab("Servicii", this.getServiciiPanel());
        this.add((Component)tabs1, "wrap");
        this.add((Component)this.getTarifePanel(), "growx");
        this.add((Component)this.getDetaliiPanel(), "growx,growy,wrap");
        this.add((Component)this.getButtonsPanel(), "span 2,growx, wrap");
        this.buildIstoricPanel();
    }

    private JPanel buildIstoricPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        this.comentarii = new JTextArea();
        this.comentarii.setText("");
        this.comentarii.setEditable(false);
        JScrollPane s1 = new JScrollPane(this.comentarii, 22, 32);
        result.add((Component)s1, "wrap");
        JButton addComment = new JButton("Adauga comentarii");
        addComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String com = DialogUtils.inputDialog(GuiUtils.currentFrame, "", "Comentariu despre client");
                if (Validators.correctString(com)) {
                    Client c = (Client)EditRezervarePanel.this.clienti.getSelectedItem();
                    String now = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                    ContracteLogic.getInstance().addComment(now + ": " + com, c.getId());
                    EditRezervarePanel.this.completeIstoric(c.getId());
                }
            }
        });
        result.add(addComment);
        result.setBorder(new TitledBorder("Istoric"));
        return result;
    }

    private void completeIstoric(int idClient) {
        StringBuffer c = new StringBuffer();
        Vector c1 = ContracteLogic.getInstance().getComments(idClient);
        for (int i = 0; i < c1.size(); ++i) {
            String s = (String)c1.elementAt(i);
            c.append(s);
            c.append("\n\n----\n\n");
        }
        this.comentarii.setText(c.toString());
    }

    private JPanel getCamerePanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        result.add(this.camereSelectateLabel);
        this.camereSelectateLabel.setMaxWidth(800);
        result.setBorder(new TitledBorder("Camere selectate"));
        return result;
    }

    private JPanel getClientiPanel() {
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        result.add(new JLabel(LangRoAll.grup));
        this.group = new JComboBox();
        result.add((Component)this.group, "grow");
        JButton modificaGrup = new JButton(LangRoAll.modifica);
        modificaGrup.setMargin(this.buttonMargins);
        modificaGrup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(EditRezervarePanel.this.group)) {
                    HotelGroup hg = (HotelGroup)EditRezervarePanel.this.group.getSelectedItem();
                    HotelGrupPanel hotelGrupPanel = new HotelGrupPanel(hg);
                    JDialog dialog = DialogUtils.getJDialogOKButton(hotelGrupPanel, GuiUtils.currentFrame, "Editare grup", 1.5);
                    dialog.setVisible(true);
                    hg = hotelGrupPanel.getDataAfterSave();
                    if (Validators.correctString(hg.getNume()) && hg.getIdAgentie() > 0) {
                        hg.setIdAgentie(hg.getIdAgentie());
                        hg.setNume(hg.getNume());
                        RezervariLogic.getInstance().updateHotelGroup(hg);
                        ComboUtils.replaceItemsForCombo(EditRezervarePanel.this.group, RezervariLogic.getInstance().getAllActiveGroups());
                        EditRezervarePanel.this.group.setSelectedItem(hg);
                    }
                }
            }
        });
        result.add((Component)modificaGrup, "");
        JButton grupNou = new JButton("+");
        grupNou.setMargin(this.buttonMargins);
        grupNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HotelGrupPanel hotelGrupPanel = new HotelGrupPanel(null);
                JDialog dialog = DialogUtils.getJDialogOKButton(hotelGrupPanel, GuiUtils.currentFrame, "Creare grup", 1.5);
                dialog.setVisible(true);
                HotelGroup res = hotelGrupPanel.getDataAfterSave();
                if (Validators.correctString(res.getNume()) && res.getIdAgentie() > 0) {
                    int id = RezervariLogic.getInstance().addHotelGroup(res.getNume(), res.getIdAgentie());
                    res.setIdGrup(id);
                    ComboUtils.replaceItemsForCombo(EditRezervarePanel.this.group, RezervariLogic.getInstance().getAllActiveGroups());
                    EditRezervarePanel.this.group.setSelectedItem(res);
                }
            }
        });
        result.add((Component)grupNou, "wrap");
        result.add((Component)new JLabel(LangRoAll.client), "");
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.clienti.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditRezervarePanel.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.clienti, "grow");
        JButton modifica = new JButton(LangRoAll.modifica);
        modifica.setMargin(this.buttonMargins);
        modifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(EditRezervarePanel.this.clienti)) {
                    Client client = (Client)EditRezervarePanel.this.clienti.getSelectedItem();
                    ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), client, false, provider);
                    int sel = cDia.getClientId();
                    Client c = ClientLogic.getInstance().getClientById(sel);
                    if (c != null) {
                        EditRezervarePanel.this.clienti.setSelectedItem(c);
                    }
                }
            }
        });
        result.add((Component)modifica, "");
        JButton clientNou = new JButton("+");
        clientNou.setMargin(this.buttonMargins);
        clientNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, false, provider);
                int sel = cDia.getClientId();
                Client c = ClientLogic.getInstance().getClientById(sel);
                if (c != null) {
                    EditRezervarePanel.this.clienti.setSelectedItem(c);
                }
            }
        });
        result.add((Component)clientNou, "wrap");
        this.sex = new JComboBox();
        result.add((Component)new JLabel("Adresa"), "");
        this.adresa = new JTextField(10);
        this.adresa.setEditable(false);
        result.add((Component)this.adresa, "grow, span 3");
        this.clienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(EditRezervarePanel.this.clienti)) {
                    Client c = (Client)EditRezervarePanel.this.clienti.getSelectedItem();
                    EditRezervarePanel.this.completeIstoric(c.getId());
                } else {
                    EditRezervarePanel.this.completeIstoric(-1);
                }
            }
        });
        this.clienti.requestFocus();
        result.setBorder(new TitledBorder(LangRoAll.client));
        ComboUtils.replaceItemsForCombo(this.group, RezervariLogic.getInstance().getAllActiveGroups());
        return result;
    }

    private JPanel getPerioadaPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        JLabel _startDayLabel = new JLabel("Sosire: ");
        this._startDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._startDayTextField.setValue(new Date());
        this._startDayTextField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this._startDayTextField.setConstraints((MDateSelectorConstraints)c1);
        this._startDayTextField.setToolTipText("Alege data sosire");
        this._startDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._startDayTextField.setShowTodayButton(true);
        JLabel _stopDayLabel = new JLabel("Plecare: ");
        this._stopDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._stopDayTextField.setValue(new Date());
        this._stopDayTextField.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 2;
        c2.changerStyle = 2;
        this._stopDayTextField.setConstraints((MDateSelectorConstraints)c2);
        this._stopDayTextField.setToolTipText("Alege data plecare");
        this._stopDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._stopDayTextField.setShowTodayButton(true);
        this.numarPersoane = new JTextField(5);
        result.add(_startDayLabel);
        result.add((Component)this._startDayTextField, "wrap");
        result.add(_stopDayLabel);
        result.add((Component)this._stopDayTextField, "wrap");
        result.add(new JLabel("Numar persoane:"));
        result.add((Component)this.numarPersoane, "growx,wrap");
        result.setBorder(new TitledBorder("Sejur"));
        return result;
    }

    private JPanel getDetaliiPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        this.detaliiRezervareTA = new JTextArea(9, 20);
        this.detaliiRezervareTA.setLineWrap(true);
        this.detaliiRezervareTA.setWrapStyleWord(false);
        JPanel wrapper = GuiUtils.buildJTextAreaWithWrapper(this.detaliiRezervareTA);
        result.add((Component)new JScrollPane(wrapper), "growx,growy");
        result.setBorder(new TitledBorder("Detalii"));
        return result;
    }

    private JPanel getTarifePanel() {
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        result.add((Component)new JLabel("Tip Tarif"), "");
        this.produse = new JComboBox();
        result.add((Component)this.produse, "span 3, growx, wrap 10");
        result.add((Component)new JLabel("Agentie / Societate"), "");
        this.agentiiComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllPersJuridiceSorted());
        this.agentii = new XComboBox(this.agentiiComboModel, true);
        this.agentii.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.agentii.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditRezervarePanel.this.agentii.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.agentii, "span 3,growx,wrap 1");
        result.add(new JLabel());
        this.tarife = new JButton("Tarife");
        this.tarife.setMargin(this.buttonMargins);
        this.tarife.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        result.add((Component)this.tarife, "");
        this.modificaAgentie = new JButton(LangRoAll.modifica);
        this.modificaAgentie.setMargin(this.buttonMargins);
        this.modificaAgentie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(EditRezervarePanel.this.agentii)) {
                    Client client = (Client)EditRezervarePanel.this.agentii.getSelectedItem();
                    ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), client, true, provider);
                    int sel = cDia.getClientId();
                    Client c = ClientLogic.getInstance().getClientById(sel);
                    if (c != null) {
                        EditRezervarePanel.this.agentii.setSelectedItem(c);
                    }
                }
            }
        });
        result.add((Component)this.modificaAgentie, "");
        this.addAgentieButton = new JButton("+");
        this.addAgentieButton.setMargin(this.buttonMargins);
        this.addAgentieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, true, provider);
                int sel = cDia.getClientId();
                Client c = ClientLogic.getInstance().getClientById(sel);
                if (c != null) {
                    EditRezervarePanel.this.agentii.setSelectedItem(c);
                }
            }
        });
        result.add((Component)this.addAgentieButton, "wmax pref, wrap 10");
        result.add((Component)new JLabel(LangRoAll.promotie), "");
        this.promotie = new JComboBox();
        result.add((Component)this.promotie, "span 2,growx");
        this.promoNou = new JButton("+ (*)");
        this.promoNou.setMargin(this.buttonMargins);
        this.promoNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        result.add((Component)this.promoNou, "wrap 10");
        result.add((Component)new JLabel("Tarif actual"), "");
        this.tarifActual1 = new JTextField(10);
        result.add((Component)this.tarifActual1, "");
        this.modificaTarifActual = new JButton(LangRoAll.modifica + " (*)");
        this.modificaTarifActual.setMargin(this.buttonMargins);
        this.blocheazaTarif = new JButton();
        this.blocheazaTarif.setMargin(this.buttonMargins);
        this.blocheazaTarif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditRezervarePanel.this.idCalendar > 0) {
                    RezervariLogic.getInstance().setTarifBlocat(EditRezervarePanel.this.idCalendar, EditRezervarePanel.this.tarifFieldsEnabled);
                }
            }
        });
        result.add((Component)this.blocheazaTarif, "wrap");
        result.setBorder(new TitledBorder("Tarif"));
        return result;
    }

    private JPanel getServiciiPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        String[] columns = new String[]{"Serviciu", "Nr persoane"};
        this.meseTm = new AbstractTM(columns, Utils.getStringClass(2), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RezervariMeseView rmv = (RezervariMeseView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return rmv.getProduct();
                    }
                    case 1: {
                        return rmv.getNrPersoane() + "";
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                RezervariMeseView rmv = (RezervariMeseView)data.elementAt(rowIndex);
                if (Validators.correctInteger(aValue.toString())) {
                    String s = (String)aValue;
                    int toSet = Integer.parseInt(s);
                    rmv.setNrPersoane(toSet);
                }
            }
        });
        this.meseTable = new JTable(this.meseTm);
        this.meseTm.refresh(new Vector());
        JScrollPane meseScroll = new JScrollPane(this.meseTable);
        result.add((Component)meseScroll, "w 200!, h 100!");
        return result;
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    public void newRezervation(Vector<ListaCamereView> selection, Date start, Date stop) {
        if (selection != null && selection.size() > 0) {
            this._startDayTextField.setValue(start);
            this._stopDayTextField.setValue(stop);
            this.camereSelectate.clear();
            this.camereSelectate.addAll(selection);
            this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(-1));
            this.refreshSelection();
            this.numarPersoane.setText("");
            this.promotie.setSelectedIndex(0);
            this.clienti.setSelectedItem(null);
            this.agentii.setSelectedItem(null);
        }
    }

    protected JPanel getButtonsPanel() {
        final EditRezervarePanel panel = this;
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        this.factura = new JButton("Factura avans");
        this.factura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditRezervarePanel.this.camereSelectate.size() > 1) {
                    DialogUtils.errorDialog(panel, "Factura de avans se poate face pe o singura camera . Daca e cazul, facturati avans pe rand pe fiecare camera !", LangRoAll.nuPotContinua);
                    return;
                }
                if (!ComboUtils.anythingButAllSelected(EditRezervarePanel.this.clienti)) {
                    DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                    return;
                }
                if (EditRezervarePanel.this.avansFacturat > 0.0 && !DialogUtils.confirmDialog(panel, "Exista deja avans facturat in valoare de " + Utils.getString2Decimals(EditRezervarePanel.this.avansFacturat) + " . Facturam inca o data avans ", LangRoAll.confirmare)) {
                    return;
                }
                String s = DialogUtils.inputDialog(panel, "", "Introduceti valoarea avansului");
                if (!Validators.correctDouble(s)) {
                    DialogUtils.errorDialog(panel, "Valoare incorecta", LangRoAll.nuPotContinua);
                    return;
                }
                Client c = (Client)EditRezervarePanel.this.clienti.getSelectedItem();
                double avansFacturamAcum = Utils.parseDouble(s);
                EditRezervarePanel.this.facturaAvans(avansFacturamAcum, c.getId());
            }
        });
        this.salveaza = new JButton(LangRoAll.salveaza);
        this.salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                Product p;
                if (!ComboUtils.anythingButAllSelected(EditRezervarePanel.this.clienti)) {
                    DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                    return;
                }
                Date start = null;
                Date stop = null;
                try {
                    start = EditRezervarePanel.this._startDayTextField.getValue();
                }
                catch (ParseException e) {
                    DialogUtils.errorDialog(panel, "Format data incorect", LangRoAll.nuPotContinua);
                    EditRezervarePanel.this._startDayTextField.setText("");
                    EditRezervarePanel.this._startDayTextField.requestFocus();
                    return;
                }
                try {
                    stop = EditRezervarePanel.this._stopDayTextField.getValue();
                }
                catch (ParseException e) {
                    DialogUtils.errorDialog(panel, "Format data incorect", LangRoAll.nuPotContinua);
                    EditRezervarePanel.this._stopDayTextField.setText("");
                    EditRezervarePanel.this._stopDayTextField.requestFocus();
                    return;
                }
                start = DateUtils.setTimeToDate(start, 12, 0, 0, 0);
                stop = DateUtils.setTimeToDate(stop, 11, 59, 59, 999);
                Date stop12H = DateUtils.setTimeToDate(stop, 12, 0, 0, 0);
                boolean sameDay = stop12H.equals(start);
                Timestamp startT = new Timestamp(start.getTime());
                Timestamp stopT = new Timestamp(stop.getTime());
                if (start.after(stop)) {
                    DialogUtils.errorDialog(panel, "Data de stop trebuie sa fie mai mare decat data de start", LangRoAll.nuPotContinua);
                    return;
                }
                Vector<Table> camere = RezervariLogic.getInstance().getCamere(EditRezervarePanel.this.camereSelectate);
                String verifica = RezervariLogic.getInstance().verificaRezervari(camere, startT, stopT, EditRezervarePanel.this.idCalendar, "<br><li>");
                if (verifica != null && verifica != null) {
                    DialogUtils.htmlOKDialog(EditRezervarePanel.this.parent, verifica, LangRoAll.nuPotContinua);
                    if (!DialogUtils.confirmDialog(panel, "Doriti sa efectuati rezervare DUBLA", LangRoAll.confirmare)) {
                        return;
                    }
                    User u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    if (u == null) {
                        DialogUtils.errorDialog(panel, "Operatia necesita autorizare", LangRoAll.nuPotContinua);
                        return;
                    }
                    String camereS = "PERIOADA : " + Formatters.DATE_FORMAT_RO.format(startT) + " - " + Formatters.DATE_FORMAT_RO.format(stopT) + " : ";
                    for (Table table : camere) {
                        camereS = camereS + table.getLabel() + ",";
                    }
                    UsersLogic.getInstance().addUserLogCommit(u.getId(), "Rezervare DUBLA : " + camereS);
                }
                if ((p = (Product)EditRezervarePanel.this.produse.getSelectedItem()) == null) {
                    DialogUtils.errorDialog(panel, "Configurati cel putin un tarif hotelier!", LangRoAll.nuPotContinua);
                    return;
                }
                int idProduct = p.getId();
                Client c = (Client)EditRezervarePanel.this.clienti.getSelectedItem();
                int idClient = c.getId();
                int agentie = -1;
                if (ComboUtils.anythingButAllSelected(EditRezervarePanel.this.agentii)) {
                    Client ag = (Client)EditRezervarePanel.this.agentii.getSelectedItem();
                    agentie = ag.getId();
                }
                int nrPer = 0;
                if (Validators.correctInteger(EditRezervarePanel.this.numarPersoane.getText())) {
                    nrPer = Integer.parseInt(EditRezervarePanel.this.numarPersoane.getText());
                }
                double tarif = 0.0;
                if (Validators.correctDouble(EditRezervarePanel.this.tarifActual1.getText())) {
                    tarif = Utils.parseDouble(EditRezervarePanel.this.tarifActual1.getText());
                }
                int idGrup = 0;
                if (ComboUtils.anythingButAllSelected(EditRezervarePanel.this.group)) {
                    HotelGroup hg = (HotelGroup)EditRezervarePanel.this.group.getSelectedItem();
                    idGrup = hg.getIdGrup();
                }
                String s = (String)EditRezervarePanel.this.sex.getSelectedItem();
                int sex = RezervariLogic.getInstance().getIdSexForString(s);
                Vector mese = EditRezervarePanel.this.meseTm.getData();
                boolean isCheckin = false;
                int idOrder = -1;
                int idWaiter = 1;
                int idPromo = -1;
                String detalii = EditRezervarePanel.this.detaliiRezervareTA.getText();
                if (EditRezervarePanel.this.idCalendar != -1) {
                    ListaCamereView lcv = (ListaCamereView)EditRezervarePanel.this.camereSelectate.get(0);
                    RezervariLogic.getInstance().modificareRezervare(EditRezervarePanel.this.idCalendar, startT, stopT, idClient, idProduct, idPromo, mese, isCheckin, idWaiter, lcv.getIdCamera(), false, sex, idOrder, agentie, nrPer, tarif, idGrup, detalii, EditRezervarePanel.this.avansFacturat);
                } else {
                    for (ListaCamereView listaCamereView : EditRezervarePanel.this.camereSelectate) {
                        int idTable = listaCamereView.getIdCamera();
                        RezervariLogic.getInstance().adaugaRezervare(idTable, detalii, idClient, startT, stopT, idProduct, idPromo, mese, isCheckin, idWaiter, sex, tarif, agentie, nrPer, idGrup, idOrder, EditRezervarePanel.this.avansFacturat);
                    }
                }
                EditRezervarePanel.this.parent.dispose();
            }
        });
        this.renunta = new JButton(LangRoAll.renunta);
        this.renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRezervarePanel.this.parent.dispose();
            }
        });
        result.add(this.factura);
        result.add(this.salveaza);
        result.add((Component)this.renunta, "wrap");
        return result;
    }

    private void facturaAvans(double total, int idClient) {
        Product p;
        Vector<NoteView> addData = new Vector<NoteView>();
        User emitent = this.receptioner;
        if (emitent == null) {
            emitent = UsersLogic.getInstance().requestReceptionerLogin(GuiUtils.currentFrame, true, true);
        }
        if (emitent == null) {
            DialogUtils.errorDialog(this.parent, "Receptioner neautentificat ! ", LangRoAll.confirmare);
            return;
        }
        int idCodProdusAvans = VpConfig.getInstance().hotelCodProdusAvans;
        if (idCodProdusAvans > 0) {
            p = NomeclaturaLogic.getInstance().getProductByCod(idCodProdusAvans);
            if (p == null) {
                DialogUtils.errorDialog(this.parent, "Produsul cu codul intern " + idCodProdusAvans + " nu a fost gasit ! ", LangRoAll.confirmare);
                return;
            }
        } else {
            DialogUtils.errorDialog(this.parent, "Configurati codul de produs pentru avans ! ", LangRoAll.confirmare);
            return;
        }
        NoteView nv = new NoteView();
        nv.setCantitate(1.0);
        nv.setProdus(p.getName());
        nv.setIdProdus(p.getId());
        nv.setSuma(total);
        nv.setIdOrder(-1);
        addData.add(nv);
        new AddFacturaDialog(true, this.parent, addData, idClient, emitent);
        if (DialogUtils.confirmDialog(this.parent, "Ati facturat ok?", LangRoAll.confirmare)) {
            this.detaliiRezervareTA.setText(this.detaliiRezervareTA.getText() + "\nAvans " + Utils.getString2Decimals(total) + " - " + Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(new Date()));
            this.avansFacturat += total;
            DialogUtils.okDialog(this.parent, "Nu uitati sa salvati, altfel avansul nu se va regasi in rezervare !! ", LangRoAll.atentie);
        }
    }

    private void refreshSelection() {
        String s = "";
        for (ListaCamereView lcv : this.camereSelectate) {
            s = s + lcv.getLabel() + ", ";
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 2);
        }
        this.camereSelectateLabel.setText(s);
    }

    public void doStuff() {
        this.display();
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditRezervare_persJuridice";
            }

            @Override
            public void dataChanged() {
                EditRezervarePanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllPersFiziceSorted());
            }
        }, 41);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditRezervare_persFizice";
            }

            @Override
            public void dataChanged() {
                EditRezervarePanel.this.agentiiComboModel.refresh(ClientLogic.getInstance().getAllPersJuridiceSorted());
            }
        }, 42);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.agentiiComboModel.refresh(ClientLogic.getInstance().getAllPersJuridiceSorted());
        ComboUtils.replaceItemsForCombo(this.sex, (Collection)RezervariLogic.getInstance().buildSexItems(), false);
        ComboUtils.replaceItemsForCombo(this.promotie, PromotionLogic.getInstance().getPromotions());
        String categorieTarife = VpConfig.getInstance().hotelCategorieTarife;
        Categorie categorie = NomeclaturaLogic.getInstance().getCategoryByName(categorieTarife);
        if (categorie != null) {
            ComboUtils.replaceItemsForCombo(this.produse, (Collection)NomeclaturaLogic.getInstance().getProductsForCategorie(categorie), false);
        }
        this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(-1));
        ComboUtils.replaceItemsForCombo(this.group, RezervariLogic.getInstance().getAllActiveGroups());
        this.enableTarifFields(this.tarifFieldsEnabled);
    }

    public void setToEdit(Vector<ListaCamereView> selection, ListaCamereCell cell) {
        RezervareBean bean;
        this._startDayTextField.setValue((Date)cell.getStart());
        this._stopDayTextField.setValue((Date)cell.getStop());
        Client c = cell.getClient();
        this.clienti.setSelectedItem(c);
        if (c != null) {
            this.completeIstoric(c.getId());
        }
        this.idCalendar = cell.getIdCalendar();
        this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(this.idCalendar));
        Product p = NomeclaturaLogic.getInstance().getProductById(cell.getIdProduct());
        this.produse.setSelectedItem(p);
        int idPromo = cell.getIdPromotion();
        if (idPromo > 0) {
            Promotion prom = PromotionLogic.getInstance().getPromotionById(idPromo);
            this.promotie.setSelectedItem(prom);
        } else {
            this.promotie.setSelectedIndex(0);
        }
        this.rezervareBeanToEdit = bean = cell.getInfo();
        this.numarPersoane.setText(bean.getNumarPersoane() + "");
        this.tarifActual1.setText(Utils.getString2Decimals(bean.getTarif()));
        int idAg = bean.getIdAgentie();
        if (idAg > 0) {
            Client ag = ClientLogic.getInstance().getClientById(idAg);
            this.agentii.setSelectedItem(ag);
        } else {
            this.agentii.setSelectedItem(null);
        }
        this.camereSelectate.clear();
        this.camereSelectate.addAll(selection);
        this.refreshSelection();
        this.enableTarifFields(this.tarifFieldsEnabled);
        String detalii = bean.getDetaliiRezervare();
        this.detaliiRezervareTA.setText(detalii);
        this.avansFacturat = cell.getInfo().getAvans();
        int idGrup = this.rezervareBeanToEdit.getIdGrup();
        HotelGroup hg = RezervariLogic.getInstance().getHotelGroupById(idGrup);
        if (hg != null) {
            this.group.setSelectedItem(hg);
        } else {
            this.group.setSelectedIndex(0);
        }
    }

    private void enableTarifFields(boolean enabled) {
        this.numarPersoane.setEnabled(enabled);
        this.agentii.setEnabled(enabled);
        this.promotie.setEnabled(enabled);
        this.produse.setEnabled(enabled);
        this.modificaAgentie.setEnabled(enabled);
        this.tarife.setEnabled(enabled);
        this.addAgentieButton.setEnabled(enabled);
        this.promoNou.setEnabled(enabled);
        this.modificaTarifActual.setEnabled(enabled);
        this.tarifActual1.setEnabled(enabled);
        this.meseTable.setEnabled(enabled);
        if (enabled) {
            this.blocheazaTarif.setText(BLOCHEAZA_TEXT);
        } else {
            this.blocheazaTarif.setText(DEBLOCHEAZA_TEXT);
        }
    }
}

