/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.hotel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.hotel.HotelCamerePanel;
import ro.atreides.restaurant.gui.hotel.HotelOrder;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.rezervari.CazariBean;
import ro.atreides.restaurant.modules.rezervari.HotelCazariCellRenderer;
import ro.atreides.restaurant.modules.rezervari.HotelGroup;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.restaurant.modules.rezervari.RezervariPanel;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Legenda;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class HotelCazariReport
extends AbstractReportPanel
implements CleanupRequired {
    private Hashtable printCriteria = new Hashtable();
    private static String[] columns = new String[]{"Camera / ID", "Perioada", "Status", "Tarif", "Turist / Pers", "Societate", "Avans", "Total", "Platit", "Nefacturat", "Neincasat", "Servicii/persoane"};
    private JComboBox locatii;
    private JComboBox status;
    private JComboBox grup;
    private XComboBox clienti;
    private RestLogic logic = RestLogic.getInstance();
    private RezervariPanel mainPanel;
    private JComponent parent;
    private FilterableComboBoxModel clientsComboModel;
    private User userLoggedIn;
    private static Comparator label_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return lcv1.getCamera().compareToIgnoreCase(lcv2.getCamera());
        }
    };
    private static Comparator perioada_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            Date start1 = lcv1.getStart();
            Date start2 = lcv2.getStart();
            Date end1 = lcv1.getStop();
            Date end2 = lcv2.getStop();
            if (start1.before(start2)) {
                return -1;
            }
            if (start1.after(start2)) {
                return 1;
            }
            return end1.compareTo(end2);
        }
    };
    private static Comparator status_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return lcv1.getStatusNume().compareToIgnoreCase(lcv2.getStatusNume());
        }
    };
    private static Comparator tarif_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return (int)(lcv1.getTarifValoare() - lcv2.getTarifValoare());
        }
    };
    private static Comparator turist_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return lcv1.getTurist().toString().compareToIgnoreCase(lcv2.getTurist().toString());
        }
    };
    private static Comparator societate_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            Client soc1 = lcv1.getSocietate();
            Client soc2 = lcv2.getSocietate();
            if (soc1 != null && soc2 != null) {
                return soc1.toString().compareToIgnoreCase(soc2.toString());
            }
            if (soc1 == null && soc2 == null) {
                return turist_sorter.compare(o1, o2);
            }
            if (soc1 == null) {
                return 1;
            }
            return -1;
        }
    };
    private static Comparator avans_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return (int)(lcv1.getAvans() - lcv2.getAvans());
        }
    };
    private static Comparator total_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return (int)(lcv1.getTotal() - lcv2.getTotal());
        }
    };
    private static Comparator platit_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return (int)(lcv1.getTotalPlatit() - lcv2.getTotalPlatit());
        }
    };
    private static Comparator nefacturat_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return (int)(lcv1.getTotalNefacturat() - lcv2.getTotalNefacturat());
        }
    };
    private static Comparator neincasat_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            CazariBean lcv1 = (CazariBean)o1;
            CazariBean lcv2 = (CazariBean)o2;
            return (int)(lcv1.getTotalNeincasat() - lcv2.getTotalNeincasat());
        }
    };

    public HotelCazariReport(RezervariPanel mainPanel, JComponent parent) {
        this.mainPanel = mainPanel;
        this.parent = parent;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        startDate = DateUtils.setTimeToDate(startDate, 12, 0, 0, 0);
        stopDate = DateUtils.setTimeToDate(stopDate, 11, 59, 59, 999);
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object locatie = this.locatii.getSelectedItem();
        if (locatie instanceof Location) {
            result.put(Constants.LOCATIE_KEY, locatie);
            this.printCriteria.put(Constants.LOCATIE_KEY, locatie);
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        Object c = this.clienti.getSelectedItem();
        if (c instanceof Client) {
            result.put(Constants.CLIENT_KEY, c);
            this.printCriteria.put(Constants.CLIENT_KEY, c);
        } else {
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.grup)) {
            HotelGroup hg = (HotelGroup)this.grup.getSelectedItem();
            result.put(Constants.GROUP_KEY, hg.getIdGrup());
            this.printCriteria.put(Constants.GROUP_KEY, hg);
        } else {
            this.printCriteria.remove(Constants.GROUP_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.status)) {
            int newStatus = 1;
            String stat = (String)this.status.getSelectedItem();
            if (stat.equalsIgnoreCase("Cazari")) {
                newStatus = 4;
            } else if (stat.equalsIgnoreCase("Rezervari")) {
                newStatus = 2;
            } else if (stat.equalsIgnoreCase("Sosiri")) {
                newStatus = 3;
            } else if (stat.equalsIgnoreCase("Checkout")) {
                newStatus = 5;
            } else if (stat.equalsIgnoreCase("Istoric")) {
                newStatus = 6;
            }
            result.put(RezervariLogic.STATUS_KEY, newStatus);
            this.printCriteria.put(RezervariLogic.STATUS_KEY, stat);
        } else {
            this.printCriteria.remove(RezervariLogic.STATUS_KEY);
        }
        return result;
    }

    @Override
    public void printReport() {
    }

    @Override
    public void printPreview() {
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RezervariLogic.getInstance().getListaCazariRezervari(criteria, this.parent);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    @Override
    public String getName() {
        return "Lista";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                CazariBean lcv = (CazariBean)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return lcv.getCamera() + " / " + lcv.getIdCalendar();
                    }
                    case 1: {
                        return lcv.getPerioada();
                    }
                    case 2: {
                        return lcv.getStatusNume();
                    }
                    case 3: {
                        return lcv.getTarifNume() + " / " + Utils.getString2Decimals(lcv.getTarifValoare());
                    }
                    case 4: {
                        return lcv.getTurist() + " / " + lcv.getNrPersoane();
                    }
                    case 5: {
                        return lcv.getSocietate();
                    }
                    case 6: {
                        return Utils.getString2Decimals(lcv.getAvans());
                    }
                    case 7: {
                        if (lcv.getTotal() > 0.0) {
                            return Utils.getString2Decimals(lcv.getTotal()) + "=" + Utils.getString2Decimals(lcv.getTotalCazare()) + "+" + Utils.getString2Decimals(lcv.getTotalServicii());
                        }
                        return "";
                    }
                    case 8: {
                        if (lcv.getTotalPlatit() > 0.0) {
                            return Utils.getString2Decimals(lcv.getTotalPlatit()) + "=" + Utils.getString2Decimals(lcv.getCazarePlatita()) + "+" + Utils.getString2Decimals(lcv.getServiciiPlatite());
                        }
                        return "";
                    }
                    case 9: {
                        if (lcv.getTotalNefacturat() > 0.0) {
                            return Utils.getString2Decimals(lcv.getTotalNefacturat()) + "=" + Utils.getString2Decimals(lcv.getValoareCazareNefacturata()) + "+" + Utils.getString2Decimals(lcv.getValoareServiciiNefacturate());
                        }
                        return "";
                    }
                    case 10: {
                        if (lcv.getTotalNeincasat() > 0.0) {
                            return Utils.getString2Decimals(lcv.getTotalNeincasat()) + "=" + Utils.getString2Decimals(lcv.getValoareCazareNeincasata()) + "+" + Utils.getString2Decimals(lcv.getValoareServiciiNeincasate());
                        }
                        return "";
                    }
                    case 11: {
                        return lcv.getServicii();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        JButton invertSelection = new JButton("Inverseaza selectia");
        invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HotelCazariReport.this.invertSelection();
            }
        });
        result.add(invertSelection);
        JButton clearSelection = new JButton("Sterge selectia");
        clearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HotelCazariReport.this.clearSelection();
            }
        });
        result.add(clearSelection);
        JButton factureaza = new JButton("Factureaza CAZARI pt camerele selectate");
        factureaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HotelCazariReport.this.factureazaSelectate();
            }
        });
        result.add(factureaza);
        final JButton login = new JButton(LangRoAll.login);
        login.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!login.getText().equalsIgnoreCase(LangRoAll.login)) {
                    login.setText(LangRoAll.login);
                    HotelCazariReport.this.userLoggedIn = null;
                    return;
                }
                User receptioner = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                if (receptioner == null) {
                    DialogUtils.errorDialog(HotelCazariReport.this.parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    return;
                }
                if (UsersLogic.getInstance().isUserInGroup(receptioner.getId(), "group_receptioneri")) {
                    login.setText(receptioner.toString());
                    HotelCazariReport.this.userLoggedIn = receptioner;
                    return;
                }
                DialogUtils.errorDialog(HotelCazariReport.this.parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
            }
        });
        result.add(login);
        JButton admin = new JButton(LangRoAll.administrare);
        admin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
            }
        });
        result.add(admin);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        Legenda l = new Legenda(new String[]{"Libera", "Rezervari", "Sosiri", "Cazari", "Checkout", "Istoric"}, new Color[]{Color.WHITE, Color.CYAN, Color.GREEN, Color.ORANGE, Color.RED, Color.LIGHT_GRAY}, 2);
        result.add((Component)l, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.locatie), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.locatii = new JComboBox();
        result.add((Component)this.locatii, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.clienti.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HotelCazariReport.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.clienti, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.status), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.status = new JComboBox();
        result.add((Component)this.status, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.grup = new JComboBox();
        result.add((Component)this.grup, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        Date d = new Date();
        Date d1 = DateUtils.setTimeToDate(d, 12, 0, 0, 0);
        d1 = DateUtils.addDaysToDate(d1, -30);
        Date d2 = DateUtils.addDaysToDate(d1, 30);
        this.dateSelector.setStartDate(d1);
        this.dateSelector.setStopDate(d2);
        this.dateSelector.selectPeriod();
        ComboUtils.replaceItemsForCombo(this.locatii, (Collection)this.logic.getLocations(2), true);
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "HotelCazariReport_PJ";
            }

            @Override
            public void dataChanged() {
                HotelCazariReport.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "HotelCazariReport_PF";
            }

            @Override
            public void dataChanged() {
                HotelCazariReport.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
        this.setFocusable(true);
        this.customParamsPanel.setFocusCycleRoot(true);
        this.status.addItem("All");
        this.status.addItem("Rezervari");
        this.status.addItem("Sosiri");
        this.status.addItem("Checkout");
        this.status.addItem("Cazari");
        this.status.addItem("Istoric");
        ComboUtils.replaceItemsForCombo(this.grup, RezervariLogic.getInstance().getAllActiveGroups());
        RezervariLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(HotelCazariReport.this.grup, RezervariLogic.getInstance().getAllActiveGroups());
            }

            @Override
            public String getName() {
                return "HotelCazariReport_groups";
            }
        }, 1101);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int columnIndex = t.columnAtPoint(p);
                final CazariBean cel = (CazariBean)HotelCazariReport.this.data.get(selRow);
                int modifiers = e.getModifiers();
                if (columnIndex == 0 && ((modifiers & 8) > 0 || (modifiers & 4) > 0)) {
                    cel.setSelected(!cel.isSelected());
                    HotelCazariReport.this.refreshTotalPanel();
                    HotelCazariReport.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else if ((modifiers & 8) > 0 || (modifiers & 4) > 0) {
                    final JPopupMenu popup = new JPopupMenu();
                    if (cel.getStatus() == 5 || cel.getStatus() == 4) {
                        JMenuItem editCazare = new JMenuItem("Modifica cazare");
                        popup.add(editCazare);
                        editCazare.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                HotelCazariReport.this.editCazare(cel);
                            }
                        });
                    }
                    popup.setInvoker(HotelCazariReport.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.updateJTableColumns(this.table, new HotelCazariCellRenderer(this.tm));
    }

    private void updateJTableColumns(JTable unu, DefaultTableCellRenderer renderer) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(renderer);
        }
    }

    @Override
    public void cleanup() {
    }

    private void editCazare(CazariBean cb) {
        if (this.userLoggedIn == null) {
            DialogUtils.errorDialog(this.parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
            return;
        }
        HotelCamerePanel main = new HotelCamerePanel();
        HotelOrder orderPanel = new HotelOrder(RestLogic.getInstance(), main, VpConfig.getInstance(), TouchMain2.sectii);
        Table t = RestLogic.getInstance().getTableById(cb.getIdCamera());
        int idOrder = cb.getIdOrder();
        Order order = RestLogic.getInstance().getOrderById(idOrder);
        orderPanel.setTable(t, this.userLoggedIn, order);
        JDialog dialog = DialogUtils.getJDialog(orderPanel, GuiUtils.currentFrame, "Modifica Cazare", 1.1);
        dialog.pack();
        dialog.setVisible(true);
        this.raport();
    }

    private void invertSelection() {
        for (int i = 0; i < this.data.size(); ++i) {
            CazariBean cb;
            cb.setSelected(!(cb = (CazariBean)this.data.elementAt(i)).isSelected());
        }
        this.tm.fireTableDataChanged();
    }

    private void clearSelection() {
        for (int i = 0; i < this.data.size(); ++i) {
            CazariBean cb = (CazariBean)this.data.elementAt(i);
            cb.setSelected(false);
        }
        this.tm.fireTableDataChanged();
    }

    private void factureazaSelectate() {
        if (this.userLoggedIn == null) {
            DialogUtils.errorDialog(this.parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
            return;
        }
        Hashtable<Integer, Integer> idGrupUnic = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> idSocietateAgentie = new Hashtable<Integer, Integer>();
        Vector<CazariBean> selectate = new Vector<CazariBean>();
        for (int i = 0; i < this.data.size(); ++i) {
            CazariBean cb = (CazariBean)this.data.elementAt(i);
            if (!cb.isSelected()) continue;
            int idGrup = cb.getIdGrup();
            idGrupUnic.put(idGrup, idGrup);
            idSocietateAgentie.put(cb.getIdSocietate(), cb.getIdSocietate());
            selectate.add(cb);
        }
        if (idGrupUnic.size() > 1) {
            DialogUtils.errorDialog(this.parent, "Nu putem factura pe grupuri diferite ! Selectati un singur grup !", LangRoAll.nuPotContinua);
            return;
        }
        if (idSocietateAgentie.size() > 1) {
            DialogUtils.errorDialog(this.parent, "Camerele nu au aceeasi societate / agentie selectata ! Selectati o singura societate / agentie !", LangRoAll.nuPotContinua);
            return;
        }
        if (idGrupUnic.size() == 1) {
            Integer idGrupFirst = (Integer)new Vector(idGrupUnic.values()).get(0);
            for (CazariBean cazariBean : selectate) {
                if (cazariBean.getStatus() == 4 || cazariBean.getStatus() == 5) continue;
                DialogUtils.errorDialog(this.parent, "Nu putem factura decat CAZATA sau CHECKOUT !", LangRoAll.nuPotContinua);
                return;
            }
            if (idSocietateAgentie.size() == 1) {
                int idSoc = (Integer)new Vector(idSocietateAgentie.values()).get(0);
                if (selectate.size() > 0 && RezervariLogic.getInstance().factureazaGrup(selectate, this.parent, this.userLoggedIn, idSoc)) {
                    this.raport();
                }
            }
        }
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return label_sorter;
            }
            case 1: {
                return perioada_sorter;
            }
            case 2: {
                return status_sorter;
            }
            case 3: {
                return tarif_sorter;
            }
            case 4: {
                return turist_sorter;
            }
            case 5: {
                return societate_sorter;
            }
            case 6: {
                return avans_sorter;
            }
            case 7: {
                return total_sorter;
            }
            case 8: {
                return platit_sorter;
            }
            case 9: {
                return nefacturat_sorter;
            }
            case 10: {
                return neincasat_sorter;
            }
        }
        return null;
    }

    public User getUserLoggedIn() {
        return this.userLoggedIn;
    }
}

