/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.hotel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.clienti.AltAct;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.IstoricClientPanel;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.facturi.Delegat;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.HotelOrderSaleInterface;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.OrdineServireDialog;
import ro.atreides.restaurant.gui.SeparaProduseDialog;
import ro.atreides.restaurant.gui.hotel.HotelCamerePanel;
import ro.atreides.restaurant.gui.hotel.HotelGrupPanel;
import ro.atreides.restaurant.gui.hotel.HotelNrNoptiZeroException;
import ro.atreides.restaurant.gui.hotel.SelectSaleInterface;
import ro.atreides.restaurant.gui.touch2.TipPlataPanelInterface;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.rezervari.AvansStornatInterface;
import ro.atreides.restaurant.modules.rezervari.CazariLipsaException;
import ro.atreides.restaurant.modules.rezervari.HotelGroup;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.restaurant.modules.rezervari.RezervareBean;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.restaurant.modules.rezervari.RezervariMeseView;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.AtrFloat;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.MultipleSelectionPanel;
import ro.atreides.utils.gui.keypad.VirtualKeypad2;
import ro.atreides.utils.gui.selector.DataProvider2;
import ro.atreides.utils.gui.selector.Selector2;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;

public class HotelOrder
extends TouchOrder2 {
    public static final String BLOCHEAZA_TEXT = "Blocheaza Tarif";
    public static final String DEBLOCHEAZA_TEXT = "Deblocheaza Tarif";
    public static final String DESFASURAT_TEXT = "Desfasurat";
    public static final String CUMULAT_TEXT = "Cumulat";
    private XComboBox clienti;
    private FilterableComboBoxModel clientsComboModel;
    private XComboBox agentii;
    private FilterableComboBoxModel agentiiComboModel;
    private JComboBox sex;
    private JComboBox grup;
    private JTextField adresa;
    private JTextField tarifActual;
    private JTextArea comentarii;
    private JComboBox produse;
    private JComboBox promotie;
    private MDateEntryField _startDayTextField;
    private MDateEntryField _stopDayTextField;
    private JTextField numarPersoane;
    private int idCalendar = -1;
    private int previousStatus = -1;
    private JTable meseTable;
    private AbstractTM meseTm;
    private JButton checkin;
    private Timestamp toEditStopT;
    private Timestamp toEditStartT;
    private Client toEditClient;
    private JButton desfasuratButton;
    private JButton factura;
    private JButton proforma;
    private JButton imparte;
    private JButton blocheazaTarif;
    private JButton tarife;
    private JButton modificaAgentie;
    private JButton addAgentieButton;
    private JButton promoNou;
    private JButton modificaTarifActual;
    private Insets buttonMargins = new Insets(1, 1, 1, 1);
    private boolean tarifFieldsEnabled = true;
    private boolean cumulat = true;
    private int calendarSource = -1;
    private Vector<RezervareBean> camereMultiple = new Vector();
    private RezervareBean currentRezervareBean = null;
    private JTextArea detaliiRezervareTA;

    public HotelOrder(RestLogic logic, HotelCamerePanel main, VpConfig config, Vector sectii) {
        super(logic, main, config, sectii, false, false);
        this.logic = logic;
        this.main = main;
        this.config = config;
        this.sectii = sectii;
        this.showTransferButton = true;
        this.showNumarPersoaneButton = false;
        this.showSchimbaOspatarButton = false;
    }

    private JPanel getInfosPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        this.detaliiRezervareTA = new JTextArea(9, 20);
        this.detaliiRezervareTA.setLineWrap(true);
        this.detaliiRezervareTA.setWrapStyleWord(false);
        JPanel wrapper = GuiUtils.buildJTextAreaWithWrapper(this.detaliiRezervareTA);
        result.add((Component)new JScrollPane(wrapper), "growx,growy");
        result.setBorder(new TitledBorder("Detalii"));
        return result;
    }

    private JPanel getRightPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("ins 0, gap 1px 3px", "[grow] [shrink 0]"));
        result.add((Component)this.getClientiPanel(), "grow");
        JTabbedPane tabs1 = new JTabbedPane();
        tabs1.addTab("Perioada", this.getPerioadaPanel());
        tabs1.addTab("Servicii", this.getServiciiPanel());
        result.add((Component)tabs1, "wrap");
        result.add((Component)this.getTarifePanel(), "spany 2, grow");
        result.add((Component)this.getInfosPanel(), "wrap");
        result.add((Component)this.getButtonsPanel(), "skip 1, wrap");
        this.buildIstoricPanel();
        JPanel selector = this.getSelectorPanel();
        result.add((Component)selector, "grow");
        this.kp = new VirtualKeypad2(VpConfig.getInstance().touchSelectorFontSize, true);
        result.add((Component)this.kp, "wrap");
        return result;
    }

    @Override
    protected void marcaj(boolean triggeredByNota, Component panel, boolean stayPut) {
        if (this.order != null) {
            super.marcaj(triggeredByNota, panel, true);
            this.salveazaTot(this, false);
        } else {
            DialogUtils.errorDialog(this, "Faceti Checkin Intai", LangRoAll.nuPotContinua);
        }
    }

    public void setToEdit(ListaCamereCell cell) {
        this._startDayTextField.setValue((Date)cell.getStart());
        this._stopDayTextField.setValue((Date)cell.getStop());
        Client c = cell.getClient();
        this.clienti.setSelectedItem(c);
        if (c != null) {
            this.completeIstoric(c.getId());
        }
        this.idCalendar = cell.getIdCalendar();
        this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(this.idCalendar));
        Product p = NomeclaturaLogic.getInstance().getProductById(cell.getIdProduct());
        this.produse.setSelectedItem(p);
        int idPromo = cell.getIdPromotion();
        if (idPromo > 0) {
            Promotion prom = PromotionLogic.getInstance().getPromotionById(idPromo);
            this.promotie.setSelectedItem(prom);
        } else {
            this.promotie.setSelectedIndex(0);
        }
        RezervareBean bean = cell.getInfo();
        this.numarPersoane.setText(bean.getNumarPersoane() + "");
        this.tarifActual.setText(Utils.getString2Decimals(bean.getTarif()));
        int idAg = bean.getIdAgentie();
        if (idAg > 0) {
            Client ag = ClientLogic.getInstance().getClientById(idAg);
            this.agentii.setSelectedItem(ag);
        } else {
            this.agentii.setSelectedItem(null);
        }
        this.enableTarifFields(this.tarifFieldsEnabled);
        this.detaliiRezervareTA.setText(cell.getInfo().getDetaliiRezervare());
        int idGrup = bean.getIdGrup();
        HotelGroup hg = RezervariLogic.getInstance().getHotelGroupById(idGrup);
        if (hg != null) {
            this.grup.setSelectedItem(hg);
        } else {
            this.grup.setSelectedIndex(0);
        }
    }

    @Override
    protected int checkNotaAlreadyOpened() {
        return 1;
    }

    @Override
    protected void setFields(Table t, User w) {
        super.setFields(t, w);
        boolean mustResetAll = true;
        ComboUtils.replaceItemsForCombo(this.grup, RezervariLogic.getInstance().getAllActiveGroups());
        if (this.order != null) {
            Client c = ClientLogic.getInstance().getClientById(this.order.getIdClient());
            this.clienti.setSelectedItem(c);
            if (c != null) {
                this.completeIstoric(c.getId());
            }
            this.currentRezervareBean = RezervariLogic.getInstance().getCurrentRezervareForOrder(this.order.getId(), this.table.getId());
            if (this.currentRezervareBean != null) {
                mustResetAll = false;
                this.toEditStopT = this.currentRezervareBean.getStop();
                this.toEditStartT = this.currentRezervareBean.getStart();
                this.toEditClient = c;
                this.idCalendar = this.currentRezervareBean.getIdCalendar();
                this._startDayTextField.setValue((Date)this.currentRezervareBean.getStart());
                this._stopDayTextField.setValue((Date)this.currentRezervareBean.getStop());
                this.previousStatus = this.currentRezervareBean.getStatus();
                String sex1 = RezervariLogic.getInstance().getLongStringForSex(this.currentRezervareBean.getIdSex());
                Product p = NomeclaturaLogic.getInstance().getProductById(this.currentRezervareBean.getIdProduct());
                this.produse.setSelectedItem(p);
                if (this.currentRezervareBean.getIdPromo() > 0) {
                    Promotion prom = PromotionLogic.getInstance().getPromotionById(this.currentRezervareBean.getIdPromo());
                    this.promotie.setSelectedItem(prom);
                } else {
                    this.promotie.setSelectedIndex(0);
                }
                this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(this.idCalendar));
                this.numarPersoane.setText(this.currentRezervareBean.getNumarPersoane() + "");
                this.tarifActual.setText(Utils.getString2Decimals(this.currentRezervareBean.getTarif()));
                int idAg = this.currentRezervareBean.getIdAgentie();
                if (idAg > 0) {
                    Client ag = ClientLogic.getInstance().getClientById(idAg);
                    this.agentii.setSelectedItem(ag);
                } else {
                    this.agentii.setSelectedItem(null);
                }
                this.tarifFieldsEnabled = !this.currentRezervareBean.isTarifBlocat();
                this.camereMultiple = RezervariLogic.getInstance().getCamereAsociate(this.currentRezervareBean.getIdCalendar());
                this.camereMultiple.add(this.currentRezervareBean);
                this.detaliiRezervareTA.setText(this.currentRezervareBean.getDetaliiRezervare());
                int idGrup = this.currentRezervareBean.getIdGrup();
                HotelGroup hg = RezervariLogic.getInstance().getHotelGroupById(idGrup);
                if (hg != null) {
                    this.grup.setSelectedItem(hg);
                } else {
                    this.grup.setSelectedIndex(0);
                }
            } else {
                mustResetAll = true;
            }
        }
        if (mustResetAll) {
            this.tarifFieldsEnabled = true;
            this.idCalendar = -1;
            this.previousStatus = -1;
            this._startDayTextField.setValue(new Date());
            this._stopDayTextField.setValue(new Date());
            this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(this.idCalendar));
            this.promotie.setSelectedIndex(0);
            this.toEditStopT = null;
            this.toEditStartT = null;
            this.toEditClient = null;
            this.agentii.setSelectedItem(null);
            this.numarPersoane.setText("");
            this.tarifActual.setText("");
            this.camereMultiple = new Vector();
            this.detaliiRezervareTA.setText("");
            if (this.idCalendar <= 0) {
                this.grup.setSelectedIndex(0);
            }
        }
        this.enableTarifFields(this.tarifFieldsEnabled);
        Vector<Plata> plati = this.getPlatiForCurrentView();
    }

    private void enableTarifFields(boolean enabled) {
        this.numarPersoane.setEnabled(enabled);
        this.agentii.setEnabled(enabled);
        this.promotie.setEnabled(enabled);
        this.produse.setEnabled(enabled);
        this.modificaAgentie.setEnabled(enabled);
        this.tarife.setEnabled(enabled);
        this.addAgentieButton.setEnabled(enabled);
        this.promoNou.setEnabled(enabled);
        this.modificaTarifActual.setEnabled(enabled);
        this.tarifActual.setEnabled(enabled);
        this.meseTable.setEnabled(enabled);
        if (enabled) {
            this.blocheazaTarif.setToolTipText(BLOCHEAZA_TEXT);
        } else {
            this.blocheazaTarif.setToolTipText(DEBLOCHEAZA_TEXT);
        }
    }

    @Override
    protected void goToMese() {
        super.goToMese();
        this.clienti.setSelectedItem(null);
        this.sex.setSelectedIndex(0);
    }

    @Override
    protected JPanel getSelectorPanel() {
        DataProvider2 fullDataProvider = new DataProvider2(){

            @Override
            public int getLinesPerPage(int level) {
                switch (level) {
                    case 0: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level2LinesPerPage;
                    }
                    case 1: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level3LinesPerPage;
                    }
                }
                return 0;
            }

            @Override
            public int getItemsPerLine(int level) {
                switch (level) {
                    case 0: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level2ItemsPerLine;
                    }
                    case 1: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level3ItemsPerLine;
                    }
                }
                return 0;
            }

            @Override
            public int getFontSize(int level) {
                switch (level) {
                    case 0: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level2FontSize;
                    }
                    case 1: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level3FontSize;
                    }
                }
                return 0;
            }

            @Override
            public int getFontStyle(int level) {
                return 1;
            }

            @Override
            public int getMaxLevels() {
                return 2;
            }

            @Override
            public String getTitle(int level) {
                switch (level) {
                    case 0: {
                        return LangRoAll.categorii;
                    }
                    case 1: {
                        return LangRoAll.produse;
                    }
                }
                return "";
            }

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        if (HotelOrder.this.sectii == null || HotelOrder.this.sectii.size() <= 0) {
                            return HotelOrder.this.getSubcategoriesRow(selection);
                        }
                        return NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(HotelOrder.this.sectii);
                    }
                    case 1: {
                        return HotelOrder.this.getProductsRow(selection);
                    }
                    case 2: {
                        HotelOrder.this.productChosen(selection, GuiUtils.currentFrame);
                        return null;
                    }
                }
                return new Vector();
            }

            @Override
            public int getMinBtnHeight(int level) {
                switch (level) {
                    case 0: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level1MinHeight;
                    }
                    case 1: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level2MinHeight;
                    }
                    case 2: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level3MinHeight;
                    }
                }
                return 0;
            }

            @Override
            public int getMinBtnWidth(int level) {
                switch (level) {
                    case 0: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level1MinWidth;
                    }
                    case 1: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level2MinWidth;
                    }
                    case 2: {
                        return ((HotelOrder)HotelOrder.this).config.selector2Level3MinWidth;
                    }
                }
                return 0;
            }
        };
        this.produsePrincipaleSelector = new Selector2(fullDataProvider);
        return this.produsePrincipaleSelector;
    }

    @Override
    protected void productChosen(Object selection, Component panel) {
        if (this.tarifFieldsEnabled) {
            DialogUtils.errorDialog(this, "Tarif neblocat", LangRoAll.nuPotContinua);
            return;
        }
        Product toAddProduct = (Product)selection;
        double pret = this.logic.getPriceForProductCommit(toAddProduct.getId());
        String detaliiProdus = "";
        long now = System.currentTimeMillis();
        boolean addOneByOne = false;
        Product tipTarif = (Product)this.produse.getSelectedItem();
        if (tipTarif.getIdCategorie() == toAddProduct.getIdCategorie()) {
            int codProdusIntrerupereSejur = this.config.hotelCodProdusIntrerupereSejur;
            if (toAddProduct.getCod() == codProdusIntrerupereSejur) {
                pret = 0.0;
            } else {
                toAddProduct = tipTarif;
                pret = Utils.parseDouble(this.tarifActual.getText());
            }
            addOneByOne = true;
        }
        double cantitateCurenta = 1.0;
        if (this.kp.getValue() > 0.0) {
            cantitateCurenta = this.kp.getValue();
        }
        this.kp.reset();
        if (addOneByOne) {
            while (cantitateCurenta > 0.0) {
                double cantToAdd = cantitateCurenta >= 1.0 ? 1.0 : cantitateCurenta;
                try {
                    int newSlot = this.getRightTimeForMarcatProduct(toAddProduct);
                    if (newSlot < 0) {
                        return;
                    }
                    now = this.getDate(newSlot);
                    detaliiProdus = " " + Formatters.DATE_FORMAT_RO.format(new Date(now)) + " ";
                    this.addLaPrecomanda(toAddProduct, cantToAdd, pret, panel, detaliiProdus, now);
                    cantitateCurenta -= cantToAdd;
                }
                catch (CazariLipsaException e) {
                    RezervariLogic.showCazariLipsaError(e);
                }
            }
        } else {
            this.addLaPrecomanda(toAddProduct, cantitateCurenta, pret, panel, detaliiProdus, now);
        }
    }

    private int getRightTimeForMarcatProduct(Product p) throws CazariLipsaException {
        try {
            Date cazareStop = this._stopDayTextField.getValue();
            Date cazareStart = this._startDayTextField.getValue();
            return RezervariLogic.getInstance().getRightTimeForMarcatProduct(p, this.order, cazareStart, cazareStop, this.preorderTm.getAllSales(), -1, this.table);
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
            return -1;
        }
    }

    private long getDate(int days) {
        try {
            Date cazareStart = this._startDayTextField.getValue();
            return RezervariLogic.getInstance().getDate(days, cazareStart);
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
            return -1L;
        }
    }

    private int getNrDays() throws ParseException {
        Vector<Date> daysBetween;
        int nrOfDays = 0;
        for (RezervareBean rezervareBean : this.camereMultiple) {
            daysBetween = DateUtils.getDaysInPerioada(rezervareBean.getStart(), rezervareBean.getStop());
            nrOfDays += daysBetween.size();
        }
        Date start = this._stopDayTextField.getValue();
        Date stop = this._startDayTextField.getValue();
        daysBetween = DateUtils.getDaysInPerioada(start, stop);
        return nrOfDays += daysBetween.size();
    }

    private void clearSelection() {
        for (Sale sale : this.orderTm.getAllSales()) {
            sale.setSelectedForIntermediara(false);
        }
    }

    @Override
    protected void display() {
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 1px 3px", "grow", "[] [grow]"));
        this.add((Component)this.getDetaliiPanel(), "wrap");
        JSplitPane splitPane = new JSplitPane(1, this.getTabs(), this.getRightPanel());
        splitPane.setDividerLocation(0.5);
        this.add((Component)splitPane, "grow, growx, growy");
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditRezervare_persJuridice";
            }

            @Override
            public void dataChanged() {
                HotelOrder.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllPersFiziceSorted());
            }
        }, 41);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditRezervare_persFizice";
            }

            @Override
            public void dataChanged() {
                HotelOrder.this.agentiiComboModel.refresh(ClientLogic.getInstance().getAllPersJuridiceSorted());
            }
        }, 42);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.agentiiComboModel.refresh(ClientLogic.getInstance().getAllPersJuridiceSorted());
        ComboUtils.replaceItemsForCombo(this.sex, (Collection)RezervariLogic.getInstance().buildSexItems(), false);
        ComboUtils.replaceItemsForCombo(this.promotie, PromotionLogic.getInstance().getPromotions());
        String categorieTarife = VpConfig.getInstance().hotelCategorieTarife;
        Categorie categorie = NomeclaturaLogic.getInstance().getCategoryByName(categorieTarife);
        if (categorie != null) {
            ComboUtils.replaceItemsForCombo(this.produse, (Collection)NomeclaturaLogic.getInstance().getProductsForCategorie(categorie), false);
        }
        this.meseTm.refresh(RezervariLogic.getInstance().getRezervariMeseViews(-1));
        ComboUtils.replaceItemsForCombo(this.grup, RezervariLogic.getInstance().getAllActiveGroups());
        this.imparte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (HotelOrder.this.order != null) {
                    User supervizor = null;
                    if (((HotelOrder)HotelOrder.this).config.passwordForSeparaProduse) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (!(supervizor == null && ((HotelOrder)HotelOrder.this).config.passwordForSeparaProduse || HotelOrder.this.order == null)) {
                        SeparaProduseDialog dialog = new SeparaProduseDialog(HotelOrder.this.logic, HotelOrder.this.table);
                        HotelOrder.this.refreshOrderSales();
                        HotelOrder.this.updateOrderTotal();
                        HotelOrder.this.changeTabs(HotelOrder.this.order);
                        HotelOrder.this.scrollOrderJTable();
                    }
                }
            }
        });
        TableColumnModel colModel = this.preorderJTable.getColumnModel();
        colModel.getColumn(0).setMaxWidth(0);
        colModel = this.orderJTable.getColumnModel();
        colModel.getColumn(0).setMaxWidth(0);
    }

    @Override
    protected void refreshOrderSales() {
        Vector<Object> sales = new Vector();
        if (this.camereMultiple.size() <= 0) {
            sales = this.logic.getSales(this.order.getId(), this.cumulat, -1, new HotelOrderSaleInterface(), this.clientFilter1);
            for (Sale sale : sales) {
                if (this.cumulat) {
                    sale.setModPreparare(null);
                }
                if (this.currentRezervareBean == null) continue;
                sale.setIdCalendar(this.currentRezervareBean.getIdCalendar());
            }
        } else {
            sales = this.getSalesForCamereMultiple(this.camereMultiple);
        }
        this.orderTm.updateTable(sales);
        this.clearSelection();
    }

    private Vector<Sale> getSalesForCamereMultiple(Vector<RezervareBean> camereMultiple) {
        Vector<Sale> allSales = new Vector<Sale>();
        for (RezervareBean rb : camereMultiple) {
            Vector<Sale> sales = this.logic.getSales(rb.getIdOrder(), this.cumulat, -1, new HotelOrderSaleInterface(), -1);
            for (Sale sale : sales) {
                String mp;
                String detalii = rb.getNumeCamera();
                if (!this.cumulat && Validators.correctString(mp = sale.getModPreparare())) {
                    detalii = rb.getNumeCamera() + " - " + mp;
                }
                sale.setModPreparare(detalii);
                sale.setIdCalendar(rb.getIdCalendar());
            }
            allSales.addAll(sales);
        }
        Collections.sort(allSales, new Comparator<Sale>(){

            @Override
            public int compare(Sale o1, Sale o2) {
                int c1 = o1.getModPreparare().compareToIgnoreCase(o2.getModPreparare());
                if (c1 == 0) {
                    return o1.getProductName().compareToIgnoreCase(o2.getProductName());
                }
                return c1;
            }
        });
        return allSales;
    }

    @Override
    protected JPanel getDetaliiPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        Font font = new Font(null, 1, VpConfig.getInstance().touch2ClientFontSize);
        result.add(new JLabel(LangRoAll.operator + ": "));
        this.ospatarText = new JLabel();
        this.add((Component)this.ospatarText, "");
        this.ospatarText.setForeground(Color.RED);
        this.ospatarText.setFont(font);
        result.add((Component)this.ospatarText, "");
        result.add(new JLabel("Camera: "));
        this.tableText = new JLabel();
        this.add((Component)this.tableText, "");
        this.tableText.setForeground(Color.RED);
        this.tableText.setFont(font);
        result.add((Component)this.tableText, "");
        result.add(new JLabel(LangRoAll.client + ": "));
        this.clientText = new JLabel();
        this.add((Component)this.clientText, "");
        this.clientText.setForeground(Color.RED);
        this.clientText.setFont(font);
        result.add((Component)this.clientText, "");
        result.add(new JLabel(LangRoAll.promotie + ": "));
        this.promoText = new JLabel();
        this.add((Component)this.promoText, "");
        this.promoText.setForeground(Color.RED);
        this.promoText.setFont(font);
        result.add((Component)this.promoText, "");
        return result;
    }

    private String getPerioadaForPrint() {
        String start = this._startDayTextField.getText();
        String stop = this._stopDayTextField.getText();
        return "(" + start + " - " + stop + ")";
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        final HotelOrder panel = this;
        this.desfasuratButton = new JButton(DESFASURAT_TEXT);
        this.desfasuratButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HotelOrder.this.cumulat = !HotelOrder.this.cumulat;
                HotelOrder.this.refreshOrderSales();
                HotelOrder.this.updateOrderTotal();
                if (HotelOrder.this.cumulat) {
                    HotelOrder.this.desfasuratButton.setText(HotelOrder.DESFASURAT_TEXT);
                } else {
                    HotelOrder.this.desfasuratButton.setText(HotelOrder.CUMULAT_TEXT);
                }
            }
        });
        this.checkin = new JButton("Checkin");
        this.checkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HotelOrder.this.salveazaTot(panel, true);
            }
        });
        this.factura = new JButton(LangRoAll.factura);
        this.factura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HotelOrder.this.order != null) {
                    if (HotelOrder.this.order.getIdClient() > 0) {
                        Vector selectedForIntermediara = new Vector();
                        Vector<Sale> selectedSales = new Vector<Sale>();
                        AtrFloat value = new AtrFloat();
                        HotelOrder.this.setSelectedVectors(selectedForIntermediara, selectedSales, value, new SelectSaleInterface(){

                            @Override
                            public boolean canSelectSale(Sale s) {
                                return !s.isFacturata();
                            }

                            @Override
                            public String errorMessageSelectionNoResults() {
                                return "Toate produsele selectate sunt deja facturate";
                            }

                            @Override
                            public String prequisitesNotMet(Sale s) {
                                if (!VpConfig.getInstance().hotelSaleFacturataBeforeIncasata && !s.isPrinted()) {
                                    return "Produsul " + s.getProductName() + " nu este achitat. Continuam";
                                }
                                return null;
                            }
                        });
                        if (selectedSales.size() > 0) {
                            try {
                                String result;
                                Vector<NoteView> newData = RezervariLogic.getInstance().getFacturaItemsWrapper(HotelOrder.this.order.getId(), selectedSales, panel, HotelOrder.this.currentRezervareBean, new AvansStornatInterface(){

                                    @Override
                                    public boolean isAvansStornat(RezervareBean bean) {
                                        return bean.isStornatAvansFactura();
                                    }
                                });
                                User emitent = HotelOrder.this.waiter;
                                if (((HotelOrder)HotelOrder.this).config.touch2FacturaRequestEmitent) {
                                    emitent = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, true, true);
                                }
                                int idClient = HotelOrder.this.order.getIdClient();
                                if (ComboUtils.anythingButAllSelected(HotelOrder.this.agentii)) {
                                    Client agentie = (Client)HotelOrder.this.agentii.getSelectedItem();
                                    idClient = agentie.getId();
                                }
                                ClientPersFizica cpf = (ClientPersFizica)ClientLogic.getInstance().getClientById(HotelOrder.this.order.getIdClient());
                                Delegat delegat = new Delegat();
                                String perioada = HotelOrder.this.getPerioadaForPrint();
                                delegat.setLabel(cpf.toString() + " " + HotelOrder.this.table.getLabel() + " " + perioada);
                                delegat.setIdPersFizica(cpf.getIdPersFizica());
                                int idBi = cpf.getIdBuletin();
                                if (idBi > 0) {
                                    BiCi bi = ClientLogic.getInstance().getBiCiById(idBi);
                                    delegat.setNrBi(bi.getNumarul());
                                    delegat.setSerBi(bi.getSeria());
                                    delegat.setPolitia(bi.getSectia());
                                } else {
                                    int idAct = cpf.getIdPassport();
                                    if (idAct > 0) {
                                        AltAct altAct = ClientLogic.getInstance().getPassportById(idAct);
                                        delegat.setNrBi(altAct.getSeria());
                                        delegat.setSerBi(altAct.getTipAct());
                                    }
                                }
                                String modPlata = "Neachitat";
                                modPlata = VpConfig.getInstance().hotelSaleFacturataBeforeIncasata ? (result = DialogUtils.inputDialog(panel, "Neachitat", "Introduceti tipul de plata in forma <tip plata>=<suma>")) : RezervariLogic.getInstance().buildModPlata(selectedSales);
                                if (emitent != null) {
                                    new AddFacturaDialog(true, panel, newData, idClient, emitent, delegat, modPlata);
                                }
                                if (DialogUtils.confirmDialog(panel, "Ati Facturat ok", LangRoAll.confirmare)) {
                                    HotelOrder.this.logic.setSalesFacturate(selectedSales);
                                    RezervariLogic.getInstance().setAvansStornatFactura(HotelOrder.this.currentRezervareBean.getIdCalendar());
                                    HotelOrder.this.currentRezervareBean.setStornatAvansFactura(true);
                                    HotelOrder.this.refreshOrderSales();
                                }
                            }
                            catch (HotelNrNoptiZeroException e1) {
                                Logger.logException("HotelOrder", (Exception)e1);
                            }
                        }
                    } else {
                        DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(panel, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                }
            }
        });
        this.proforma = new JButton(LangRoAll.proforma);
        this.nota.setText("Incasat");
        this.incasat.setText("Checkout");
        this.marcaj.setText(LangRoAll.salveaza);
        this.plan.setText(LangRoAll.inapoi);
        this.optiuni.setText(LangRoAll.optiuni);
        this.logout.setText(LangRoAll.logout);
        this.imparte = new JButton(LangRoAll.imparteNota);
    }

    @Override
    protected JPanel getButtonsPanel() {
        this.initButtons();
        JPanel result = new JPanel((LayoutManager)new MigLayout("ins 0, gap 1px 3px"));
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        result.add((Component)this.checkin, "grow");
        result.add((Component)this.marcaj, "wrap");
        result.add((Component)this.factura, "grow");
        result.add((Component)this.optiuni, "wrap");
        result.add((Component)this.desfasuratButton, "grow");
        result.add((Component)this.proforma, "wrap");
        result.add((Component)this.plan, "grow");
        result.add((Component)this.incasat, "wrap");
        return result;
    }

    @Override
    protected JButton getServireButton() {
        JButton servireButton = new JButton(LangRoAll.grupare);
        servireButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<OrdineServire> os = HotelOrder.this.logic.getOrdineServire(-1);
                if (os.size() > 0) {
                    OrdineServireDialog dia = new OrdineServireDialog(5, os);
                    HotelOrder.this.idServire = dia.getIdServire();
                    dia.dispose();
                    HotelOrder.this.setServireButtonText();
                }
            }
        });
        return servireButton;
    }

    private void setCamereSecundare(Vector<RezervareBean> camereSecundare) {
        this.camereMultiple = camereSecundare;
        RezervariLogic.getInstance().setCameraAsociate(this.idCalendar, camereSecundare);
    }

    @Override
    protected JPopupMenu buildOptiuniPopup() {
        final HotelOrder panel = this;
        Font bonItemFont = new Font(null, 1, this.config.touchKeypadFontSize + 6);
        JPopupMenu popup = new JPopupMenu();
        try {
            JMenuItem contButton;
            TipCont tipCont;
            int i;
            JMenuItem platesteSiAlteCamere = new JMenuItem("Plateste si alte camere");
            platesteSiAlteCamere.setFont(bonItemFont);
            popup.add(platesteSiAlteCamere);
            platesteSiAlteCamere.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Vector<Sale> sales = HotelOrder.this.logic.getSales(HotelOrder.this.order.getId(), HotelOrder.this.cumulat, -1, new HotelOrderSaleInterface(), HotelOrder.this.clientFilter1);
                    if (sales.size() <= 0) {
                        DialogUtils.errorDialog(panel, "Camera curenta nu are nici un serviciu.", LangRoAll.nuPotContinua);
                        return;
                    }
                    Vector<RezervareBean> cazariActive = RezervariLogic.getInstance().getCazariActive(-1);
                    cazariActive.remove(HotelOrder.this.currentRezervareBean);
                    Vector<RezervareBean> camereSecundare = new Vector<RezervareBean>();
                    for (RezervareBean bean : HotelOrder.this.camereMultiple) {
                        camereSecundare.add(bean);
                    }
                    camereSecundare.remove(HotelOrder.this.currentRezervareBean);
                    MultipleSelectionPanel msp = new MultipleSelectionPanel(cazariActive, 6, camereSecundare);
                    JDialog dialog = DialogUtils.getJDialogOKButton(new JScrollPane(msp), GuiUtils.currentFrame, "Adaugam camerele", 1.05);
                    dialog.setVisible(true);
                    Vector selected = msp.getSelectedItems();
                    if (selected.size() <= 0) {
                        DialogUtils.errorDialog(panel, "Nu ati ales nici o camera. Daca ati gresit repetati.", LangRoAll.nuPotContinua);
                    }
                    HotelOrder.this.setCamereSecundare(selected);
                    HotelOrder.this.setFields(HotelOrder.this.table, HotelOrder.this.waiter);
                    HotelOrder.this.refreshOrderSales();
                }
            });
            Vector<TipCont> conturi = ClientLogic.getInstance().getAllConturi();
            for (i = 0; i < conturi.size(); ++i) {
                tipCont = conturi.elementAt(i);
                contButton = new JMenuItem(LangRoAll.incarca + " " + tipCont.getLabel());
                contButton.setFont(bonItemFont);
                popup.add(contButton);
                contButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Vector<RezervareBean> cazariActive;
                        if (HotelOrder.this.order == null) {
                            return;
                        }
                        if (HotelOrder.this.order.getIdClient() == -1) {
                            DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        User supervizor = null;
                        if (((HotelOrder)HotelOrder.this).config.passwordForIncarcareCont) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            DialogUtils.okFocusEaterDialog("Autentificare reusita !", LangRoAll.alimentareCont);
                        }
                        int idClient = HotelOrder.this.order.getIdClient();
                        Vector<ValoareContClient> conturiClient = ClientLogic.getInstance().getConturiClient(idClient, tipCont.getId());
                        double suma = 0.0;
                        for (ValoareContClient valoareContClient : conturiClient) {
                            suma += valoareContClient.getValoare();
                        }
                        boolean maiMulteCamere = false;
                        if (suma != 0.0 && (cazariActive = RezervariLogic.getInstance().getCazariActive(idClient)).size() > 1) {
                            if (!DialogUtils.confirmDialog(panel, "Acest client are " + cazariActive.size() + " camere cazate !! Continuam ?", LangRoAll.atentie)) {
                                return;
                            }
                            maiMulteCamere = true;
                        }
                        if (suma < 0.0) {
                            double dePlataIntai = -suma;
                            DialogUtils.okDialog(panel, "Exista datorii anterioare in valoare de " + Utils.getString2Decimals(dePlataIntai), LangRoAll.atentie);
                            if (DialogUtils.confirmDialog(panel, "Incasam datoria anterioara ", LangRoAll.confirmare)) {
                                boolean somethingToDo = false;
                                somethingToDo = tipCont.getProdusFictiv() > 0 ? HotelOrder.this.printBonFiscalAlimentareCont(panel, tipCont.getProdusFictiv(), dePlataIntai, HotelOrder.this.table, HotelOrder.this.waiter.getId(), HotelOrder.this.order.getIdClient()) : true;
                                if (somethingToDo) {
                                    ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), HotelOrder.this.order.getIdClient(), dePlataIntai, "Incasat datorie anterioara");
                                }
                            } else if (DialogUtils.confirmDialog(panel, "Uitam de datoria anterioara", LangRoAll.confirmare)) {
                                ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), HotelOrder.this.order.getIdClient(), dePlataIntai, "Uitam de datoria anterioara");
                            }
                        } else if (suma > 0.0) {
                            DialogUtils.okDialog(panel, "Exista credit anterior in valoare de " + Utils.getString2Decimals(suma), LangRoAll.atentie);
                            if (DialogUtils.confirmDialog(panel, "Anulam creditul anterior", LangRoAll.confirmare)) {
                                ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), HotelOrder.this.order.getIdClient(), -suma, "Anulare credit anterior");
                            }
                        }
                        if (supervizor != null || !((HotelOrder)HotelOrder.this).config.passwordForIncarcareCont) {
                            DialogUtils.okDialog(panel, "Introduceti suma de incarcat sau lasati liber pentru a renunta", LangRoAll.alimentareCont);
                            String valueS = "";
                            if (tipCont.getProdusFictiv() > 0) {
                                double value = HotelOrder.this.logic.getPriceForProductCommit(tipCont.getProdusFictiv());
                                valueS = Utils.getString2Decimals(value);
                            }
                            String input = DialogUtils.inputDialog(panel, valueS, LangRoAll.valoare);
                            try {
                                boolean printBF;
                                if (!Validators.correctDouble(input)) {
                                    return;
                                }
                                double deIncarcat = Utils.parseDouble(input);
                                boolean somethingToDo = false;
                                somethingToDo = deIncarcat < 0.0 ? true : (tipCont.getProdusFictiv() > 0 ? ((printBF = DialogUtils.confirmDialog(panel, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare)) ? HotelOrder.this.printBonFiscalAlimentareCont(panel, tipCont.getProdusFictiv(), deIncarcat, HotelOrder.this.table, HotelOrder.this.waiter.getId(), HotelOrder.this.order.getIdClient()) : true) : true);
                                if (somethingToDo) {
                                    ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), HotelOrder.this.order.getIdClient(), deIncarcat, "Alimentare cont");
                                }
                                HotelOrder.this.setClientText();
                            }
                            catch (NumberFormatException e) {
                                Logger.logException(this, (Exception)e);
                            }
                        }
                    }
                });
                contButton.setFocusable(false);
            }
            for (i = 0; i < conturi.size(); ++i) {
                tipCont = conturi.elementAt(i);
                contButton = new JMenuItem("Incaseaza diferenta " + tipCont.getLabel());
                contButton.setFont(bonItemFont);
                popup.add(contButton);
                contButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (HotelOrder.this.order == null) {
                            return;
                        }
                        int idClient = HotelOrder.this.order.getIdClient();
                        if (idClient <= 0) {
                            DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        Vector<ValoareContClient> conturiClient = ClientLogic.getInstance().getConturiClient(idClient, tipCont.getId());
                        double suma = 0.0;
                        for (ValoareContClient valoareContClient : conturiClient) {
                            suma += valoareContClient.getValoare();
                        }
                        double dePlataIntai = -suma;
                        if (suma < 0.0) {
                            DialogUtils.okDialog(panel, "Sold neachitat : " + Utils.getString2Decimals(dePlataIntai), LangRoAll.atentie);
                            if (DialogUtils.confirmDialog(panel, "Incasam Soldul ", LangRoAll.confirmare)) {
                                int cod = VpConfig.getInstance().hotelCodProdusDiferentaRestaurant;
                                Product produsMasaServita = NomeclaturaLogic.getInstance().getProductByCod(cod);
                                if (cod <= 0) {
                                    DialogUtils.errorDialog(panel, "Cod produs diferenta neconfigurat", LangRoAll.confirmare);
                                    return;
                                }
                                HotelOrder.this.addLaPrecomanda(produsMasaServita, 1.0, dePlataIntai, panel, "");
                                HotelOrder.this.marcaj.doClick();
                                ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), idClient, dePlataIntai, "Incasat datorie anterioara");
                            }
                        } else if (suma > 0.0) {
                            ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), idClient, -suma, "Corectie sold la zero");
                        }
                        HotelOrder.this.setClientText();
                        HotelOrder.this.updateOrderTotal();
                    }
                });
            }
            if (VpConfig.getInstance().showProtocolButton) {
                JMenuItem protocol = new JMenuItem(LangRoAll.protocol);
                protocol.setFont(bonItemFont);
                popup.add(protocol);
                protocol.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (((HotelOrder)HotelOrder.this).config.passwordForProtocol) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !((HotelOrder)HotelOrder.this).config.passwordForProtocol) {
                            HotelOrder.this.createOrderIfNull();
                            if (!HotelOrder.this.order.isLaPlata() && !HotelOrder.this.order.isIncasat()) {
                                boolean isProtocol = HotelOrder.this.order.isProtocol();
                                boolean newState = !isProtocol;
                                HotelOrder.this.logic.setProtocolForOrder(HotelOrder.this.order, newState);
                                HotelOrder.this.order.setProtocol(newState);
                                HotelOrder.this.setPromotionText();
                            }
                        }
                    }
                });
            }
            if (this.logic.getCashRegister().numerarInputReady()) {
                JMenuItem btn = new JMenuItem(LangRoAll.incarcaCasa);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String s = DialogUtils.inputDialog(panel, "0", LangRoAll.valoareIncarcaCasa);
                        if (!Validators.correctDouble(s)) {
                            DialogUtils.errorDialog(panel, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            return;
                        }
                        double value = Utils.parseDouble(s);
                        HotelOrder.this.logic.introduNumerar(value);
                    }
                });
            }
            JMenuItem transfer = new JMenuItem(this.transferSource == null ? this.transferString : this.transferStringStop);
            transfer.setFont(bonItemFont);
            popup.add(transfer);
            transfer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (HotelOrder.this.transferSource == null) {
                        if (HotelOrder.this.idCalendar != -1) {
                            if (HotelOrder.this.order != null && (HotelOrder.this.order.isLaPlata() || HotelOrder.this.order.isIncasat()) && !((HotelOrder)HotelOrder.this).config.allowTransferAfterNota) {
                                DialogUtils.errorDialog(panel, LangRoAll.nuPutetiEfectuaTransferDupaNota, LangRoAll.nuPotContinua);
                                return;
                            }
                            if (HotelOrder.this.order != null) {
                                HotelOrder.this.transferSource = HotelOrder.this.table;
                                HotelOrder.this.calendarSource = HotelOrder.this.idCalendar;
                                HotelOrder.this.goToMese();
                            }
                        } else {
                            DialogUtils.errorDialog(panel, "Nimic de transferat", LangRoAll.nuPotContinua);
                        }
                    } else {
                        if (HotelOrder.this.table.getId().equals(HotelOrder.this.transferSource.getId())) {
                            DialogUtils.errorDialog(panel, "Aceeasi camera!", LangRoAll.nuPotContinua);
                            return;
                        }
                        if (HotelOrder.this.order != null) {
                            DialogUtils.errorDialog(panel, "Camera " + HotelOrder.this.table.getLabel() + " deja ocupata", LangRoAll.confirmare);
                            return;
                        }
                        if (!DialogUtils.confirmDialog(panel, "Mutam toate serviciile din camera " + HotelOrder.this.transferSource.getLabel() + " la camera " + HotelOrder.this.table.getLabel(), LangRoAll.confirmare)) {
                            return;
                        }
                        Order sourceOrder = RezervariLogic.getInstance().getOpenOrderAtTable(HotelOrder.this.transferSource);
                        if (sourceOrder != null) {
                            RestLogic.getInstance().updateTableForOrder(HotelOrder.this.table.getId(), sourceOrder.getId());
                        }
                        RezervariLogic.getInstance().mutaRezervare(HotelOrder.this.calendarSource, HotelOrder.this.table.getId());
                        HotelOrder.this.transferSource = null;
                        HotelOrder.this.calendarSource = -1;
                        HotelOrder.this.main.tableSelected(HotelOrder.this.table);
                    }
                }
            });
            Location loc = this.logic.getLocationById(this.table.getIdLocatie());
            JMenuItem asociereCard = new JMenuItem(LangRoAll.asociereCard);
            asociereCard.setFont(bonItemFont);
            popup.add(asociereCard);
            asociereCard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = null;
                    if (((HotelOrder)HotelOrder.this).config.hotelPasswordForAsociereCard) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !((HotelOrder)HotelOrder.this).config.hotelPasswordForAsociereCard) {
                        CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().hotelCodCamereLength);
                        dialog.setVisible(true);
                        HotelOrder.this.main.requestFocus();
                        String cod = dialog.getCodAutentificare();
                        if (Validators.correctString(cod)) {
                            HotelOrder.this.logic.asociereCardToTable(HotelOrder.this.table.getId(), cod);
                        } else {
                            DialogUtils.errorDialog(panel, LangRoAll.codIncorect, LangRoAll.nuPotContinua);
                        }
                    }
                }
            });
            JMenuItem printAsocieri = new JMenuItem(LangRoAll.printCoduriCamere);
            printAsocieri.setFont(bonItemFont);
            popup.add(printAsocieri);
            printAsocieri.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    if (supervizor != null) {
                        HotelOrder.this.logic.printCoduriForTables();
                    }
                }
            });
            JMenuItem addComment = new JMenuItem("Adauga comentariu");
            addComment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String com = DialogUtils.inputDialog(GuiUtils.currentFrame, "", "Comentariu despre client");
                    if (Validators.correctString(com)) {
                        Client c = (Client)HotelOrder.this.clienti.getSelectedItem();
                        String now = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                        ContracteLogic.getInstance().addComment(now + ": " + com, c.getId());
                    }
                }
            });
            addComment.setFont(bonItemFont);
            popup.add(addComment);
            JMenuItem detaliiNota = this.getDetaliiNotaMenuItem(panel);
            detaliiNota.setFont(bonItemFont);
            popup.add(detaliiNota);
            final int optiuneButton = VpConfig.getInstance().showReducereValoricaButton;
            if (optiuneButton == 1 || optiuneButton == 2) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.reducereValorica));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (optiuneButton == 1 && (supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true)) == null) {
                            return;
                        }
                        String reducereValorica = DialogUtils.inputDialog(panel, "", LangRoAll.reducereValorica);
                        if (reducereValorica != null && Validators.correctDouble(reducereValorica)) {
                            double reducereValoricaFloat = Utils.parseDouble(reducereValorica);
                            RestLogic.getInstance().applyAndSetReducereValoricaToOrder(HotelOrder.this.order, reducereValoricaFloat);
                            HotelOrder.this.order.setReducereValorica(reducereValoricaFloat);
                        } else {
                            DialogUtils.errorDialog(panel, "Introduceti o valoare corecta", LangRoAll.nuPotContinua);
                        }
                        HotelOrder.this.refreshOrderSales();
                        HotelOrder.this.updateOrderTotal();
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
            JMenuItem adaugaCazareSuplimentara = new JMenuItem("Adauga cazare suplimentara");
            adaugaCazareSuplimentara.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    DialogUtils.errorDialog(panel, "Folosit functia checkin din Diagrama", LangRoAll.nuPotContinua);
                }
            });
            adaugaCazareSuplimentara.setFont(bonItemFont);
            popup.add(adaugaCazareSuplimentara);
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return popup;
    }

    @Override
    protected void logout() {
        this.idServire = -1;
        this.main.logout(this.order);
    }

    @Override
    protected JPanel displayOrderPanel(JScrollPane scroll, JLabel totalLabel, JPanel platiPanel) {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "", "[grow] [shrink 0] [shrink 0]"));
        result.add((Component)scroll, "span 2,growx,growy,wrap");
        result.add((Component)totalLabel, "");
        result.add((Component)this.totalOrder, "wrap,growx");
        result.add((Component)platiPanel, "span 2,growx, wrap");
        return result;
    }

    @Override
    protected JPanel displayPreorderPanel(JLabel t1, JScrollPane preorderScroll) {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "", "[grow] [shrink 0]"));
        result.add((Component)preorderScroll, "span 2, growx, growy, wrap");
        result.add((Component)t1, "");
        result.add((Component)this.totalPreorder, "wrap");
        return result;
    }

    private void setSelectedVectors(Vector<Integer> selectedForIntermediara, Vector<Sale> selectedSales, AtrFloat value, SelectSaleInterface selectSaleInterface) {
        Vector<Integer> ids;
        String warning;
        Sale sale;
        int i;
        boolean tryBySelection = false;
        for (i = 0; i < this.orderTm.getAllSales().size(); ++i) {
            sale = (Sale)this.orderTm.getAllSales().elementAt(i);
            if (!sale.isSelectedForIntermediara()) continue;
            tryBySelection = true;
            if (!selectSaleInterface.canSelectSale(sale)) continue;
            warning = selectSaleInterface.prequisitesNotMet(sale);
            if (warning != null && !DialogUtils.confirmDialog(this, warning, LangRoAll.confirmare)) {
                return;
            }
            ids = sale.getIdSales();
            selectedForIntermediara.addAll(ids);
            selectedSales.add(sale);
            value.setValue(value.getValue() + sale.getTotal());
        }
        if (tryBySelection && selectedSales.size() <= 0) {
            DialogUtils.errorDialog(this, selectSaleInterface.errorMessageSelectionNoResults(), LangRoAll.nuPotContinua);
            return;
        }
        if (selectedForIntermediara.size() == 0) {
            for (i = 0; i < this.orderTm.getAllSales().size(); ++i) {
                sale = (Sale)this.orderTm.getAllSales().elementAt(i);
                if (!selectSaleInterface.canSelectSale(sale)) continue;
                warning = selectSaleInterface.prequisitesNotMet(sale);
                if (warning != null && !DialogUtils.confirmDialog(this, warning, LangRoAll.confirmare)) {
                    return;
                }
                ids = sale.getIdSales();
                selectedForIntermediara.addAll(ids);
                selectedSales.add(sale);
                value.setValue(value.getValue() + sale.getTotal());
            }
        }
    }

    private Vector<Plata> getPlatiForCurrentView() {
        Vector<Plata> result = new Vector<Plata>();
        if (this.camereMultiple == null || this.camereMultiple.size() <= 0) {
            Vector<Object> toadd = new Vector();
            if (this.order != null) {
                toadd = this.logic.getPlatiForOrder(this.order.getId(), this.clientFilter1);
            }
            result.addAll(toadd);
        } else {
            for (RezervareBean rezervareBean : this.camereMultiple) {
                Vector<Plata> toadd = this.logic.getPlatiForOrder(rezervareBean.getIdOrder(), this.clientFilter1);
                result.addAll(toadd);
            }
        }
        return result;
    }

    private double getTotalForCurrentView() {
        double result = 0.0;
        if (this.camereMultiple == null || this.camereMultiple.size() <= 0) {
            double toAdd = RestLogic.getInstance().getTotal(this.order, this.clientFilter1);
            result += toAdd;
        } else {
            for (RezervareBean rezervareBean : this.camereMultiple) {
                double toAdd = RestLogic.getInstance().getTotal(rezervareBean.getIdOrder(), this.clientFilter1);
                result += toAdd;
            }
        }
        return result;
    }

    private Vector<Sale> convertToSale(Vector<NoteView> note) {
        Vector<Sale> result = new Vector<Sale>();
        for (NoteView view : note) {
            Sale s = new Sale();
            s.setCantitateMarcata(view.getCantitate());
            s.setProductName(view.getProdus());
            double pret = view.getSuma() / view.getCantitate();
            s.setPpuOriginal(pret);
            s.setPrice(pret);
            s.setIdProduct(view.getIdProdus());
            Vector<Integer> idSales = view.getIdSales();
            if (idSales != null) {
                s.addIdSales(idSales);
            }
            s.setIdCategorie(view.getIdCategorie());
            result.add(s);
        }
        return result;
    }

    @Override
    protected void incasat(boolean f) {
        Vector<Sale> sales;
        boolean ok = false;
        if (this.config.passwordForIncasat) {
            User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            if (supervizor != null) {
                ok = true;
            }
        } else {
            ok = true;
        }
        if (!ok) {
            return;
        }
        if (this.currentRezervareBean != null && (sales = this.logic.getSales(this.currentRezervareBean.getIdOrder(), true, -1, new ScreenSaleInterface())).size() == 0) {
            RezervariLogic.getInstance().stergeRezervareGoala(this.currentRezervareBean.getIdCalendar());
        }
        this.logic.closeOrder(this.order);
        this.marcaj.setEnabled(true);
        this.incasat.setEnabled(false);
        this.order = null;
        this.idServire = -1;
        this.platiPanel.cleanPlatiLabel();
        RestLogic.getInstance().switchAfisajClientOrderCommit(-1);
        this.refreshQuickTable();
    }

    @Override
    protected boolean checkBeforeIncasat(Component parent) {
        boolean result = true;
        for (Sale sale : this.orderTm.getAllSales()) {
            result = result && sale.isPrinted();
        }
        if (!result) {
            DialogUtils.errorDialog(parent, "Exista produse neachitate", LangRoAll.nuPotContinua);
        } else {
            result = DialogUtils.confirmDialog(parent, "Operatia de Checkout NU se poate anula. Sunteti sigur ca doriti CHECKOUT ", LangRoAll.confirmare);
        }
        return result;
    }

    @Override
    protected DefaultTableCellRenderer getOrderCellRenderer() {
        DefaultTableCellRenderer orderCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    value = "";
                }
                this.setText(String.valueOf(value));
                Color bgColor = Color.WHITE;
                Color fgColor = Color.BLACK;
                int salesSize = HotelOrder.this.orderTm.getRowCount();
                if (row < salesSize) {
                    Sale s = HotelOrder.this.orderTm.getEntryAtRow(row);
                    boolean bgColorSet = false;
                    if (s.isPrinted()) {
                        bgColor = Color.WHITE;
                        bgColorSet = true;
                        if (s.isFacturata()) {
                            bgColor = Color.GREEN;
                            bgColorSet = true;
                        }
                    }
                    if (s.isFacturata()) {
                        bgColor = Color.GREEN;
                        bgColorSet = true;
                        if (!s.isPrinted()) {
                            bgColor = Color.RED;
                            bgColorSet = true;
                        }
                    }
                    if (s.isSelectedForIntermediara()) {
                        bgColor = Color.YELLOW;
                        bgColorSet = true;
                    }
                    if (column == 3 && !bgColorSet) {
                        bgColor = new Color(204, 204, 204);
                    }
                }
                this.setBackground(bgColor);
                this.setForeground(fgColor);
                return this;
            }
        };
        return orderCellRenderer;
    }

    @Override
    protected MouseAdapter getOrderMouseListener(final Component panel) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = HotelOrder.this.orderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 0: {
                        Vector<OrdineServire> os = HotelOrder.this.logic.getOrdineServire(-1);
                        if (os.size() <= 0) break;
                        OrdineServireDialog dia = new OrdineServireDialog(5, os);
                        int idServire = dia.getIdServire();
                        s.setIdServire(idServire);
                        HotelOrder.this.logic.setServireToSale(s);
                        break;
                    }
                    case 2: {
                        if (HotelOrder.this.order != null && (HotelOrder.this.order.isLaPlata() || HotelOrder.this.order.isIncasat()) && !((HotelOrder)HotelOrder.this).config.allowStergereAfterNota) {
                            DialogUtils.errorDialog(panel, LangRoAll.nuPutetiEfectuaReturDupaNota, LangRoAll.nuPotContinua);
                            return;
                        }
                        if (!((HotelOrder)HotelOrder.this).config.allowRetur) break;
                        double toDelete = s.getCantitateMarcata();
                        if (HotelOrder.this.kp.getValue() > 0.0) {
                            toDelete = HotelOrder.this.kp.getValue();
                            HotelOrder.this.kp.reset();
                        }
                        if (toDelete > s.getCantitateMarcata()) {
                            toDelete = s.getCantitateMarcata();
                        }
                        if (s.getIdPlatou() > 0 && HotelOrder.this.deleteAllPlateau) {
                            HotelOrder.this.deleteAllPlateau(toDelete, panel, s);
                            break;
                        }
                        HotelOrder.this.deleteSingleProduct(toDelete, panel, s, selRow);
                        break;
                    }
                    case 3: {
                        if (s.isPrinted() && s.isFacturata()) break;
                        s.setSelectedForIntermediara(!s.isSelectedForIntermediara());
                        HotelOrder.this.orderTm.fireTableRowsUpdated(selRow, selRow);
                        HotelOrder.this.computeSelectedValues();
                    }
                }
            }
        };
    }

    @Override
    protected MouseAdapter getPreorderMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = HotelOrder.this.preorderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 0: {
                        Vector<OrdineServire> os = HotelOrder.this.logic.getOrdineServire(-1);
                        if (os.size() <= 0) break;
                        OrdineServireDialog dia = new OrdineServireDialog(5, os);
                        int idServire = dia.getIdServire();
                        s.setIdServire(idServire);
                        break;
                    }
                    case 1: {
                        String s1 = s.getModPreparare();
                        if (s1 == null) {
                            s1 = "";
                        }
                        String modPreparare = DialogUtils.inputDialog(GuiUtils.currentFrame, s1, LangRoAll.detalii);
                        s.setModPreparare(modPreparare);
                        break;
                    }
                    case 2: {
                        double toRemain;
                        double toDelete = s.getCantitateNoua();
                        if (HotelOrder.this.kp.getValue() > 0.0) {
                            toDelete = HotelOrder.this.kp.getValue();
                            HotelOrder.this.kp.reset();
                        }
                        if ((toRemain = s.getCantitateNoua() - toDelete) < 0.0) {
                            toRemain = 0.0;
                        }
                        s.setCantitateNoua(toRemain);
                        HotelOrder.this.removeZeroQuantityPresales();
                        HotelOrder.this.refreshPreOrderSales();
                        HotelOrder.this.updateTotalPreorder();
                        break;
                    }
                    case 3: {
                        String newPrice = HotelOrder.this.kp.getValueS();
                        if (Validators.correctDouble(newPrice)) {
                            double price = HotelOrder.this.kp.getValue();
                            s.setPrice(price);
                            s.setPpuOriginal(price);
                            HotelOrder.this.updateTotalPreorder();
                        } else {
                            double originalPrice = HotelOrder.this.logic.getPriceForProductCommit(s.getIdProduct());
                            s.setPrice(originalPrice);
                            s.setPpuOriginal(originalPrice);
                            HotelOrder.this.updateTotalPreorder();
                        }
                        HotelOrder.this.kp.reset();
                        break;
                    }
                }
            }
        };
    }

    @Override
    protected void updateOrderTotal() {
        int idClient;
        double totalValue = 0.0;
        double incasatValue = 0.0;
        double neincasatValue = 0.0;
        double selectedValue = 0.0;
        boolean totulPlatit = true;
        Product productCazare = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelCodProdusCazare);
        if (productCazare == null) {
            DialogUtils.errorDialog(this, "Produs Cazare neconfigurat", LangRoAll.nuPotContinua);
            return;
        }
        int idCazareCateg = productCazare.getIdCategorie();
        int nrProduseCazare = 0;
        for (Sale element : this.orderTm.getAllSales()) {
            totalValue += element.getTotal();
            if (element.isPrinted()) {
                incasatValue += element.getTotal();
            } else {
                neincasatValue += element.getTotal();
                totulPlatit = false;
            }
            if (element.isSelectedForIntermediara()) {
                selectedValue += element.getTotal();
            }
            if (element.getIdCategorie() != productCazare.getIdCategorie()) continue;
            nrProduseCazare = (int)((double)nrProduseCazare + element.getCantitateMarcata());
        }
        if (this.order != null && (idClient = this.order.getIdClient()) > 0) {
            Vector<ValoareContClient> conturiClient = ClientLogic.getInstance().getConturiClient(idClient, -1);
            double suma = 0.0;
            for (ValoareContClient valoareContClient : conturiClient) {
                suma += valoareContClient.getValoare();
            }
            if (suma != 0.0) {
                totulPlatit = false;
            }
        }
        String newTotal = ": " + Utils.getString2Decimals(totalValue);
        newTotal = newTotal + " / Incasat: " + Utils.getString2Decimals(incasatValue) + " / Neincasat: " + Utils.getString2Decimals(neincasatValue) + " / Selectat: " + Utils.getString2Decimals(selectedValue);
        this.totalOrder.setText(newTotal);
        if (this.currentRezervareBean != null) {
            Map<RezervariLogic.CHECKOUT_ERROR, String> checkout_errorStringMap = null;
            if (this.currentRezervareBean.getIdGrup() > 0) {
                checkout_errorStringMap = RezervariLogic.getInstance().canCheckoutGroup(this.currentRezervareBean.getIdGrup(), this);
            }
            if (checkout_errorStringMap != null && checkout_errorStringMap.size() != 0) {
                this.incasat.setEnabled(false);
                return;
            }
        }
        try {
            boolean toateZileleCuProdusCazare;
            int nrDays = this.getNrDays();
            boolean bl = toateZileleCuProdusCazare = nrProduseCazare == nrDays;
            if (!toateZileleCuProdusCazare) {
                System.out.println("nu toate zilele au cazare " + nrProduseCazare + " nrDays : " + nrDays + " !!");
            }
            this.incasat.setEnabled(totulPlatit && toateZileleCuProdusCazare);
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    protected void computeSelectedValues() {
        this.updateOrderTotal();
    }

    private JPanel getClientiPanel() {
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        JPanel result = new JPanel((LayoutManager)new MigLayout("ins 0, gap 1px 3px", "[grow][][]", ""));
        ImageIcon editIcon = Utils.getImageResource("edit16px.png");
        ImageIcon addIcon = Utils.getImageResource("add16px.png");
        ImageIcon istoricIcon = Utils.getImageResource("exportAs16px.gif");
        result.add((Component)new JLabel(LangRoAll.grup), "wrap");
        this.grup = new JComboBox();
        result.add((Component)this.grup, "grow");
        JButton modificaGrup = new JButton();
        modificaGrup.setIcon(editIcon);
        modificaGrup.setMargin(this.buttonMargins);
        modificaGrup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(HotelOrder.this.grup)) {
                    HotelGroup hg = (HotelGroup)HotelOrder.this.grup.getSelectedItem();
                    HotelGrupPanel hotelGrupPanel = new HotelGrupPanel(hg);
                    JDialog dialog = DialogUtils.getJDialogOKButton(hotelGrupPanel, GuiUtils.currentFrame, "Editare grup", 1.5);
                    dialog.setVisible(true);
                    hg = hotelGrupPanel.getDataAfterSave();
                    if (Validators.correctString(hg.getNume()) && hg.getIdAgentie() > 0) {
                        hg.setIdAgentie(hg.getIdAgentie());
                        hg.setNume(hg.getNume());
                        RezervariLogic.getInstance().updateHotelGroup(hg);
                        ComboUtils.replaceItemsForCombo(HotelOrder.this.grup, RezervariLogic.getInstance().getAllActiveGroups());
                        HotelOrder.this.grup.setSelectedItem(hg);
                    }
                }
            }
        });
        JButton grupNou = new JButton();
        grupNou.setIcon(addIcon);
        grupNou.setMargin(this.buttonMargins);
        grupNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HotelGrupPanel hotelGrupPanel = new HotelGrupPanel(null);
                JDialog dialog = DialogUtils.getJDialogOKButton(hotelGrupPanel, GuiUtils.currentFrame, "Creare grup", 1.5);
                dialog.setVisible(true);
                HotelGroup res = hotelGrupPanel.getDataAfterSave();
                if (Validators.correctString(res.getNume()) && res.getIdAgentie() > 0) {
                    int id = RezervariLogic.getInstance().addHotelGroup(res.getNume(), res.getIdAgentie());
                    res.setIdGrup(id);
                    ComboUtils.replaceItemsForCombo(HotelOrder.this.grup, RezervariLogic.getInstance().getAllActiveGroups());
                    HotelOrder.this.grup.setSelectedItem(res);
                }
            }
        });
        result.add((Component)grupNou, "");
        result.add((Component)modificaGrup, "wrap");
        result.add((Component)new JLabel(LangRoAll.client), "wrap");
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllPersFiziceSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.clienti.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HotelOrder.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.clienti, "grow");
        JButton modifica = new JButton(editIcon);
        modifica.setMargin(this.buttonMargins);
        modifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(HotelOrder.this.clienti)) {
                    Client client = (Client)HotelOrder.this.clienti.getSelectedItem();
                    ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), client, false, provider);
                    int sel = cDia.getClientId();
                    Client c = ClientLogic.getInstance().getClientById(sel);
                    if (c != null) {
                        HotelOrder.this.clienti.setSelectedItem(c);
                    }
                }
            }
        });
        JButton clientNou = new JButton();
        clientNou.setIcon(addIcon);
        clientNou.setMargin(this.buttonMargins);
        clientNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, false, provider);
                int sel = cDia.getClientId();
                Client c = ClientLogic.getInstance().getClientById(sel);
                if (c != null) {
                    HotelOrder.this.clienti.setSelectedItem(c);
                }
            }
        });
        result.add((Component)clientNou, "");
        result.add((Component)modifica, "wrap");
        this.sex = new JComboBox();
        result.add((Component)new JLabel("Adresa"), "wrap");
        this.adresa = new JTextField(10);
        this.adresa.setEditable(false);
        result.add((Component)this.adresa, "grow, span 2");
        final HotelOrder panel = this;
        JButton istoric = new JButton();
        istoric.setToolTipText("Istoric");
        istoric.setIcon(istoricIcon);
        istoric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client c = (Client)HotelOrder.this.clienti.getSelectedItem();
                if (c != null) {
                    ClientPersFizica cazat = (ClientPersFizica)c;
                    IstoricClientPanel istoricClientPanel = new IstoricClientPanel(cazat, RestLogic.getInstance());
                    JDialog dialog = DialogUtils.getJDialog(istoricClientPanel, GuiUtils.currentFrame, "Istoric oaspete", 1.1);
                    dialog.setVisible(true);
                } else {
                    DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)istoric, "grow");
        this.clienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(HotelOrder.this.clienti)) {
                    Client c = (Client)HotelOrder.this.clienti.getSelectedItem();
                    HotelOrder.this.completeIstoric(c.getId());
                } else {
                    HotelOrder.this.completeIstoric(-1);
                }
            }
        });
        this.clienti.requestFocus();
        result.setBorder(new TitledBorder(LangRoAll.client));
        return result;
    }

    private JPanel buildIstoricPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        this.comentarii = new JTextArea();
        this.comentarii.setText("");
        this.comentarii.setEditable(false);
        JScrollPane s1 = new JScrollPane(this.comentarii, 22, 32);
        result.add((Component)s1, "wrap");
        JButton addComment = new JButton("Adauga comentarii");
        addComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String com = DialogUtils.inputDialog(GuiUtils.currentFrame, "", "Comentariu despre client");
                if (Validators.correctString(com)) {
                    Client c = (Client)HotelOrder.this.clienti.getSelectedItem();
                    String now = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                    ContracteLogic.getInstance().addComment(now + ": " + com, c.getId());
                    HotelOrder.this.completeIstoric(c.getId());
                }
            }
        });
        result.add(addComment);
        result.setBorder(new TitledBorder("Istoric"));
        return result;
    }

    private void completeIstoric(int idClient) {
        StringBuffer c = new StringBuffer();
        Vector c1 = ContracteLogic.getInstance().getComments(idClient);
        for (int i = 0; i < c1.size(); ++i) {
            String s = (String)c1.elementAt(i);
            c.append(s);
            c.append("\n\n----\n\n");
        }
        this.comentarii.setText(c.toString());
    }

    private JPanel getPerioadaPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("ins 0, gap 1px 3px"));
        JLabel _startDayLabel = new JLabel("Sosire: ");
        this._startDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._startDayTextField.setValue(new Date());
        this._startDayTextField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this._startDayTextField.setConstraints((MDateSelectorConstraints)c1);
        this._startDayTextField.setToolTipText("Alege data sosire");
        this._startDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._startDayTextField.setShowTodayButton(true);
        JLabel _stopDayLabel = new JLabel("Plecare: ");
        this._stopDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._stopDayTextField.setValue(new Date());
        this._stopDayTextField.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 2;
        c2.changerStyle = 2;
        this._stopDayTextField.setConstraints((MDateSelectorConstraints)c2);
        this._stopDayTextField.setToolTipText("Alege data plecare");
        this._stopDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._stopDayTextField.setShowTodayButton(true);
        this.numarPersoane = new JTextField(5);
        result.add(_startDayLabel);
        result.add((Component)this._startDayTextField, "wrap");
        result.add(_stopDayLabel);
        result.add((Component)this._stopDayTextField, "wrap");
        result.add(new JLabel("Persoane:"));
        result.add((Component)this.numarPersoane, "growx,wrap");
        result.setBorder(new TitledBorder("Sejur"));
        return result;
    }

    private JPanel getTarifePanel() {
        ImageIcon editIcon = Utils.getImageResource("edit16px.png");
        ImageIcon addIcon = Utils.getImageResource("add16px.png");
        ImageIcon lockUnlockIcon = Utils.getImageResource("key16px.png");
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        final JPanel result = new JPanel((LayoutManager)new MigLayout("ins 0, gap 1px 3px", "[grow][][]", ""));
        result.add((Component)new JLabel("Tip Tarif"), "wrap");
        this.produse = new JComboBox();
        result.add((Component)this.produse, "growx,wrap");
        this.produse.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (HotelOrder.this.tarifFieldsEnabled) {
                    double tarifActualD;
                    Product p = (Product)HotelOrder.this.produse.getSelectedItem();
                    if (p == null) {
                        return;
                    }
                    double tarifProdus = RestLogic.getInstance().getPriceForProductCommit(p.getId());
                    String tarifActualS = HotelOrder.this.tarifActual.getText();
                    boolean replace = true;
                    if (Validators.correctDouble(tarifActualS) && tarifProdus != (tarifActualD = Double.parseDouble(tarifActualS))) {
                        replace = DialogUtils.confirmDialog(result, "Inlocuim tariful modificat (" + Utils.getString2Decimals(tarifActualD) + ") cu cel original (" + Utils.getString2Decimals(tarifProdus) + ")", LangRoAll.confirmare);
                    }
                    if (replace) {
                        HotelOrder.this.tarifActual.setText(Utils.getString2Decimals(tarifProdus));
                    }
                }
            }
        });
        result.add((Component)new JLabel("Agentie / Societate"), "wrap");
        this.agentiiComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllPersJuridiceSorted());
        this.agentii = new XComboBox(this.agentiiComboModel, true);
        this.agentii.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.agentii.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HotelOrder.this.agentii.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.agentii, "growx");
        this.tarife = new JButton("Tarife");
        this.tarife.setMargin(this.buttonMargins);
        this.tarife.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.modificaAgentie = new JButton();
        this.modificaAgentie.setIcon(editIcon);
        this.modificaAgentie.setToolTipText(LangRoAll.modifica);
        this.modificaAgentie.setMargin(this.buttonMargins);
        this.modificaAgentie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(HotelOrder.this.agentii)) {
                    Client client = (Client)HotelOrder.this.agentii.getSelectedItem();
                    ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), client, true, provider);
                    int sel = cDia.getClientId();
                    Client c = ClientLogic.getInstance().getClientById(sel);
                    if (c != null) {
                        HotelOrder.this.agentii.setSelectedItem(c);
                    }
                }
            }
        });
        this.addAgentieButton = new JButton();
        this.addAgentieButton.setIcon(addIcon);
        this.addAgentieButton.setMargin(this.buttonMargins);
        this.addAgentieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, true, provider);
                int sel = cDia.getClientId();
                Client c = ClientLogic.getInstance().getClientById(sel);
                if (c != null) {
                    HotelOrder.this.agentii.setSelectedItem(c);
                }
            }
        });
        result.add((Component)this.addAgentieButton, "");
        result.add((Component)this.modificaAgentie, "wrap");
        result.add((Component)new JLabel(LangRoAll.promotie), "wrap");
        this.promotie = new JComboBox();
        result.add((Component)this.promotie, "growx");
        this.promoNou = new JButton();
        this.promoNou.setIcon(addIcon);
        this.promoNou.setMargin(this.buttonMargins);
        this.promoNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        result.add((Component)this.promoNou, "wrap 10");
        result.add((Component)new JLabel("Tarif actual"), "wrap");
        this.tarifActual = new JTextField(10);
        result.add((Component)this.tarifActual, "grow");
        this.modificaTarifActual = new JButton(LangRoAll.modifica + " (*)");
        this.modificaTarifActual.setMargin(this.buttonMargins);
        this.blocheazaTarif = new JButton();
        this.blocheazaTarif.setIcon(lockUnlockIcon);
        this.blocheazaTarif.setMargin(this.buttonMargins);
        this.blocheazaTarif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HotelOrder.this.idCalendar > 0) {
                    if (HotelOrder.this.tarifFieldsEnabled && HotelOrder.this.order != null) {
                        HotelOrder.this.marcaj.doClick();
                    }
                    RezervariLogic.getInstance().setTarifBlocat(HotelOrder.this.idCalendar, HotelOrder.this.tarifFieldsEnabled);
                    HotelOrder.this.setFields(HotelOrder.this.table, HotelOrder.this.waiter);
                }
            }
        });
        result.add((Component)this.blocheazaTarif, "span 2,wrap");
        result.setBorder(new TitledBorder("Tarif"));
        final HotelOrder panel = this;
        this.tarifActual.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HotelOrder.this.computeTarif(panel);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        return result;
    }

    private void computeTarif(Component panel) {
        Client c = (Client)this.clienti.getSelectedItem();
        if (c != null) {
            ClientPersFizica clientPersFizica = (ClientPersFizica)c;
        } else {
            DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            this.clienti.requestFocus();
        }
    }

    private JPanel getServiciiPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        String[] columns = new String[]{"Serviciu", "Nr persoane"};
        this.meseTm = new AbstractTM(columns, Utils.getStringClass(2), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RezervariMeseView rmv = (RezervariMeseView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return rmv.getProduct();
                    }
                    case 1: {
                        return rmv.getNrPersoane() + "";
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                RezervariMeseView rmv = (RezervariMeseView)data.elementAt(rowIndex);
                if (Validators.correctInteger(aValue.toString())) {
                    String s = (String)aValue;
                    int toSet = Integer.parseInt(s);
                    rmv.setNrPersoane(toSet);
                }
            }
        });
        this.meseTable = new JTable(this.meseTm);
        this.meseTm.refresh(new Vector());
        JScrollPane meseScroll = new JScrollPane(this.meseTable);
        result.add((Component)meseScroll, "w 200!, h 100!");
        return result;
    }

    private void tiparesteFisaClient(Client c, String camera, boolean fisaTratament, boolean legitimatieMasa) {
        Date start = null;
        Date stop = null;
        try {
            start = this._startDayTextField.getValue();
            stop = this._stopDayTextField.getValue();
            String cod = "";
            if (c instanceof ClientPersFizica) {
                ClientPersFizica cpf = (ClientPersFizica)c;
                int idBiCi = cpf.getIdBuletin();
                BiCi bici = ClientLogic.getInstance().getBiCiById(idBiCi);
                if (bici != null) {
                    cod = bici.getCnp();
                }
            } else {
                ClientPersJuridica cpj = (ClientPersJuridica)c;
                cod = cpj.getCui();
            }
            int numarFisa = RezervariLogic.getInstance().getNumarFisa(this.idCalendar);
            if (fisaTratament) {
                RezervariLogic.getInstance().tiparesteFisaTratament(numarFisa, new Date(), camera, c.toString(), cod, start, stop, c.getId());
            }
            if (legitimatieMasa) {
                RezervariLogic.getInstance().tiparesteLegitimatieMasa(numarFisa, new Date(), camera, c.toString(), cod, start, stop, c.getId());
            }
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private String verifyCameraLibere(Component panel) {
        String result = "";
        Vector<Order> orders = RestLogic.getInstance().getAllOpenOrdersAtTable(this.table);
        if (this.order == null) {
            if (orders.size() > 0) {
                if (!DialogUtils.confirmDialog(panel, " Camera " + this.table.getLabel() + " ocupata; Sunteti sigur ca doriti checkin suplimentar ", LangRoAll.nuPotContinua)) {
                    result = result + " Camera " + this.table.getLabel() + " ocupata; ";
                } else if (VpConfig.getInstance().hotelPasswordForCheckinSuplimentar) {
                    User u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    if (u == null) {
                        DialogUtils.errorDialog(panel, "Operatia necesita autorizare", LangRoAll.nuPotContinua);
                        result = result + " Camera " + this.table.getLabel() + " ocupata SI LIPSA AUTORIZARE CHECKIN SUPLIMENTAR; ";
                    } else {
                        UsersLogic.getInstance().addUserLogCommit(u.getId(), "Autorizat Checkout suplimentar  la camera " + this.table.getLabel());
                    }
                } else {
                    UsersLogic.getInstance().addUserLogCommit(this.waiter.getId(), "Checkout suplimentar la camera " + this.table.getLabel() + " fara autentificare suplimentara");
                }
            }
        } else {
            boolean found = false;
            for (Order order1 : orders) {
                if (order1.getId() != this.order.getId()) continue;
                found = true;
                break;
            }
            if (!found) {
                result = result + " Camera " + this.table.getLabel() + " ocupata; si idOrder " + this.order.getId() + " negasit !";
            }
        }
        return result;
    }

    private void salveazaTot(Component panel, boolean isCheckin) {
        if (isCheckin) {
            switch (this.previousStatus) {
                case 4: 
                case 5: 
                case 6: {
                    DialogUtils.errorDialog(panel, "Nu pot efectua Checkin.", LangRoAll.nuPotContinua);
                    return;
                }
            }
            String checkCamere = this.verifyCameraLibere(panel);
            if (Validators.correctString(checkCamere)) {
                DialogUtils.errorDialog(panel, checkCamere, LangRoAll.nuPotContinua);
                return;
            }
        } else {
            switch (this.previousStatus) {
                case 6: {
                    DialogUtils.errorDialog(panel, "Nu puteti modifica in istoric", LangRoAll.nuPotContinua);
                    return;
                }
            }
        }
        if (!ComboUtils.anythingButAllSelected(this.clienti)) {
            DialogUtils.errorDialog(panel, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            return;
        }
        Date start = null;
        Date stop = null;
        try {
            start = this._startDayTextField.getValue();
        }
        catch (ParseException e) {
            DialogUtils.errorDialog(panel, "Format data incorect", LangRoAll.nuPotContinua);
            this._startDayTextField.setText("");
            this._startDayTextField.requestFocus();
            return;
        }
        try {
            stop = this._stopDayTextField.getValue();
        }
        catch (ParseException e) {
            DialogUtils.errorDialog(panel, "Format data incorect", LangRoAll.nuPotContinua);
            this._stopDayTextField.setText("");
            this._stopDayTextField.requestFocus();
            return;
        }
        start = DateUtils.setTimeToDate(start, 12, 0, 0, 0);
        stop = DateUtils.setTimeToDate(stop, 11, 59, 59, 999);
        Date stop12H = DateUtils.setTimeToDate(stop, 12, 0, 0, 0);
        boolean sameDay = stop12H.equals(start);
        Timestamp startT = new Timestamp(start.getTime());
        Timestamp stopT = new Timestamp(stop.getTime());
        if (!(!start.after(stop) || this.table.isVirtuala() && sameDay)) {
            DialogUtils.errorDialog(panel, "Data de stop trebuie sa fie mai mare decat data de start", LangRoAll.nuPotContinua);
            return;
        }
        Vector<Table> selection1 = new Vector<Table>();
        selection1.add(this.table);
        String verifica = RezervariLogic.getInstance().verificaRezervari(selection1, startT, stopT, this.idCalendar, "<br><li>");
        Product p = (Product)this.produse.getSelectedItem();
        if (p == null) {
            DialogUtils.errorDialog(panel, "Configurati cel putin un tarif hotelier!", LangRoAll.nuPotContinua);
            return;
        }
        int idProduct = p.getId();
        Client c = (Client)this.clienti.getSelectedItem();
        int idClient = c.getId();
        int agentie = -1;
        if (ComboUtils.anythingButAllSelected(this.agentii)) {
            Client ag = (Client)this.agentii.getSelectedItem();
            agentie = ag.getId();
        }
        int nrPer = 0;
        if (Validators.correctInteger(this.numarPersoane.getText())) {
            nrPer = Integer.parseInt(this.numarPersoane.getText());
        }
        double tarif = 0.0;
        if (Validators.correctDouble(this.tarifActual.getText())) {
            tarif = Utils.parseDouble(this.tarifActual.getText());
        }
        int idGrup = 0;
        HotelGroup hg = null;
        if (ComboUtils.anythingButAllSelected(this.grup)) {
            hg = (HotelGroup)this.grup.getSelectedItem();
            idGrup = hg.getIdGrup();
        }
        if (isCheckin) {
            Date currentDate1200 = RezervariLogic.getStartZiHoteliera(new Date());
            if (startT.getTime() != currentDate1200.getTime()) {
                if (DialogUtils.confirmDialog(panel, "Data de start checkin este diferita de data curenta. Continuam", LangRoAll.confirmare)) {
                    if (VpConfig.getInstance().hotelPasswordForCheckInNotToday) {
                        User u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        if (u == null) {
                            DialogUtils.errorDialog(panel, "Operatia necesita autorizare", LangRoAll.nuPotContinua);
                            return;
                        }
                        UsersLogic.getInstance().addUserLogCommit(u.getId(), "Data checkin diferita de data curenta");
                    }
                } else {
                    DialogUtils.errorDialog(panel, "Operatie anulata", LangRoAll.nuPotContinua);
                    return;
                }
            }
            this.createOrderIfNull();
        } else if (this.previousStatus == 4 || this.previousStatus == 5) {
            User u;
            if (this.toEditStopT != null && stopT.before(this.toEditStopT)) {
                if (DialogUtils.confirmDialog(panel, "Micsoram data de checkout", LangRoAll.confirmare)) {
                    if (VpConfig.getInstance().hotelPasswordForCheckoutModifyInMinus) {
                        u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        if (u == null) {
                            DialogUtils.errorDialog(panel, "Operatia necesita autorizare", LangRoAll.nuPotContinua);
                            return;
                        }
                        UsersLogic.getInstance().addUserLogCommit(u.getId(), "Modificare cazare checkout in minus");
                    }
                } else {
                    DialogUtils.errorDialog(panel, "Operatie anulata", LangRoAll.nuPotContinua);
                    return;
                }
            }
            if (this.toEditClient != null && !this.toEditClient.equals(c) || this.toEditStartT != null && !startT.equals(this.toEditStartT)) {
                if (DialogUtils.confirmDialog(panel, "Modificam detalii checkin", LangRoAll.confirmare)) {
                    if (VpConfig.getInstance().hotelPasswordForCheckinModifyDetails) {
                        u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        if (u == null) {
                            DialogUtils.errorDialog(panel, "Operatia necesita autorizare", LangRoAll.nuPotContinua);
                            return;
                        }
                        UsersLogic.getInstance().addUserLogCommit(u.getId(), "Modificare detalii checkin");
                    }
                } else {
                    DialogUtils.errorDialog(panel, "Operatie anulata", LangRoAll.nuPotContinua);
                    return;
                }
            }
        }
        int idPromo = -1;
        if (ComboUtils.anythingButAllSelected(this.promotie)) {
            Promotion promo = (Promotion)this.promotie.getSelectedItem();
            idPromo = promo.getId();
        }
        RestLogic.getInstance().setClientAndPromotionForOrder(this.order, idClient, idPromo);
        String s = (String)this.sex.getSelectedItem();
        int sex = RezervariLogic.getInstance().getIdSexForString(s);
        Vector mese = this.meseTm.getData();
        String detalii = this.detaliiRezervareTA.getText();
        if (this.idCalendar != -1) {
            RezervareBean oldValue = RezervariLogic.getInstance().getRezervareBeanById(this.idCalendar);
            if (oldValue == null) {
                DialogUtils.errorDialog(panel, "Nu am gasit rezervarea cu id-ul " + this.idCalendar, LangRoAll.nuPotContinua);
                return;
            }
            int idGrupVechi = oldValue.getIdGrup();
            if (idGrupVechi != idGrup && idGrupVechi > 0 && VpConfig.getInstance().hotelPasswordForGroupModifyDetails) {
                User u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                if (u == null) {
                    DialogUtils.errorDialog(panel, "Operatia necesita autorizare", LangRoAll.nuPotContinua);
                    return;
                }
                HotelGroup grupVechi = RezervariLogic.getInstance().getHotelGroupById(idGrupVechi);
                UsersLogic.getInstance().addUserLogCommit(u.getId(), "Modificare grup : GRUP VECHI : " + grupVechi + " GRUP NOU :" + hg);
            }
            RezervariLogic.getInstance().modificareRezervare(this.idCalendar, startT, stopT, idClient, idProduct, idPromo, mese, isCheckin, this.waiter.getId(), this.table.getId(), this.previousStatus == 5 || this.previousStatus == 4, sex, this.order.getId(), agentie, nrPer, tarif, idGrup, detalii, oldValue.getAvans());
        } else {
            RezervariLogic.getInstance().adaugaRezervare(this.table.getId(), detalii, idClient, startT, stopT, idProduct, idPromo, mese, isCheckin, this.waiter.getId(), sex, tarif, agentie, nrPer, idGrup, this.order.getId(), 0.0);
        }
        if (isCheckin && VpConfig.getInstance().hotelPrintFisaClientAtCheckIn) {
            boolean fisaTratament = DialogUtils.confirmDialog(panel, "Tiparim fisa tratament", LangRoAll.confirmare);
            boolean legitimatieMasa = DialogUtils.confirmDialog(panel, "Tiparim legitimatie masa", LangRoAll.confirmare);
            if (fisaTratament || legitimatieMasa) {
                this.tiparesteFisaClient(c, this.table.getLabel(), fisaTratament, legitimatieMasa);
            }
        }
        this.setFields(this.table, this.waiter);
    }

    @Override
    protected TipPlataPanelInterface buildPlatiInterface() {
        return new TipPlataPanelInterface(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void editSuma(TipPlata tipPlata2, Component panel) {
                Vector selectedForIntermediara = new Vector();
                Vector<Sale> selectedSales = new Vector<Sale>();
                AtrFloat value = new AtrFloat();
                HotelOrder.this.setSelectedVectors(selectedForIntermediara, selectedSales, value, new SelectSaleInterface(){

                    @Override
                    public boolean canSelectSale(Sale s) {
                        if (VpConfig.getInstance().hotelSaleFacturataBeforeIncasata) {
                            return !s.isPrinted() && s.isFacturata();
                        }
                        return !s.isPrinted();
                    }

                    @Override
                    public String errorMessageSelectionNoResults() {
                        return "Toate produsele selectate sunt deja incasate";
                    }

                    @Override
                    public String prequisitesNotMet(Sale s) {
                        return null;
                    }
                });
                boolean selectedContainsIntrerupereSejur = false;
                boolean selectedContainsRealProducts = false;
                for (Sale sale : selectedSales) {
                    Product p = NomeclaturaLogic.getInstance().getProductById(sale.getIdProduct());
                    if (p == null) continue;
                    int codProdusIntrerupereSejur = ((HotelOrder)HotelOrder.this).config.hotelCodProdusIntrerupereSejur;
                    if (p.getCod() == codProdusIntrerupereSejur) {
                        selectedContainsIntrerupereSejur = true;
                        continue;
                    }
                    selectedContainsRealProducts = true;
                }
                if (selectedContainsIntrerupereSejur) {
                    if (selectedContainsRealProducts) {
                        DialogUtils.errorDialog(panel, "Selectie invalida. Separati produsele dupa tip.", LangRoAll.nuPotContinua);
                        return;
                    }
                    HotelOrder.this.logic.setSalesPrinted(selectedSales);
                    HotelOrder.this.refreshOrderSales();
                    HotelOrder.this.updateOrderTotal();
                    return;
                }
                if (!DialogUtils.confirmDialog(panel, "Platim " + Utils.getString2Decimals(value.getValue()) + " cu " + tipPlata2.getLabel() + " ", LangRoAll.confirmare)) {
                    DialogUtils.errorDialog(panel, LangRoAll.operatieEsuata, LangRoAll.nuPotContinua);
                    return;
                }
                User supervizor = null;
                if (tipPlata2.isRequestPassword()) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (tipPlata2.isRequestPassword()) {
                    if (supervizor == null) return;
                }
                int idTipPlata = tipPlata2.getId();
                int idTipCont = tipPlata2.getIdTipCont();
                if (idTipCont != -1) {
                    int idClient = HotelOrder.this.order.getIdClient();
                    if (idClient <= 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                        return;
                    }
                    Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(idClient, idTipCont);
                    if (contValues.size() <= 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.contInexistentPtClient, LangRoAll.nuPotContinua);
                        return;
                    }
                    double val = contValues.get(0).getValoare();
                    if (val < 0.0 && !((HotelOrder)HotelOrder.this).config.incarcareContAllowStartOnMinus) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.soldPeMinus, LangRoAll.nuPotContinua);
                        return;
                    }
                }
                String comment = "";
                boolean commentSet = false;
                while (tipPlata2.isRequestComment() && !commentSet) {
                    if (((HotelOrder)HotelOrder.this).config.tipPlataDetaliiKeypad) {
                        String s = DialogUtils.virtualKeyboardInputDialog(GuiUtils.currentFrame, LangRoAll.detalii, 3.0, VpConfig.getInstance().touchSelectorFontSize, false);
                        commentSet = true;
                        comment = s;
                        continue;
                    }
                    String s = DialogUtils.inputDialog(panel, "", LangRoAll.detalii);
                    if (!Validators.correctString(s)) continue;
                    commentSet = true;
                    comment = s;
                }
                try {
                    Vector<NoteView> newData = RezervariLogic.getInstance().getFacturaItemsWrapper(HotelOrder.this.order.getId(), selectedSales, panel, HotelOrder.this.currentRezervareBean, new AvansStornatInterface(){

                        @Override
                        public boolean isAvansStornat(RezervareBean bean) {
                            return bean.isStornatAvansBF();
                        }
                    });
                    Vector newSales = HotelOrder.this.convertToSale(newData);
                    int maxItems = ((HotelOrder)HotelOrder.this).config.ecrMaxItems;
                    if (maxItems > 0 && newSales.size() > maxItems) {
                        DialogUtils.okDialog(panel, LangRoAll.maxProducts1 + maxItems + LangRoAll.maxProducts2, LangRoAll.atentie);
                        return;
                    }
                    HotelOrder.this.logic.notaIntermediaraForTipPlata(HotelOrder.this.order, HotelOrder.this.table, null, newSales);
                    HotelOrder.this.refreshOrderSales();
                    HotelOrder.this.updateOrderTotal();
                    if (value.getValue() >= 0.0) {
                        int clientIndex = HotelOrder.this.getClientIndexForAdaugare(HotelOrder.this.clientFilter1);
                        Plata plata = new Plata(idTipPlata, value.getValue(), tipPlata2.getEcrMapping(), tipPlata2.getLabel(), comment, clientIndex);
                        HotelOrder.this.logic.addPlataToOrderForHotel(HotelOrder.this.order, plata, newSales);
                        Vector<Plata> plati = new Vector<Plata>();
                        plati.add(plata);
                        if (value.getValue() > 0.0) {
                            Logger.logDebug(this, "BonFiscal: Start printing BF for order id=" + HotelOrder.this.order.getId());
                            String perioada = HotelOrder.this.getPerioadaForPrint();
                            HotelOrder.this.order.setAdresaLivrare(perioada);
                            RestLogic.getInstance().printBonFiscal(HotelOrder.this.order, newSales, plati, clientIndex);
                            RezervariLogic.getInstance().setAvansStornatBF(HotelOrder.this.currentRezervareBean.getIdCalendar());
                            HotelOrder.this.currentRezervareBean.setStornatAvansBF(true);
                        }
                    } else {
                        Logger.logDebug(this, "BonFiscal: Nimic de tiparit (value<0)");
                    }
                    Vector plati2 = HotelOrder.this.getPlatiForCurrentView();
                    return;
                }
                catch (HotelNrNoptiZeroException e) {
                    Logger.logException(this, (Exception)e);
                }
            }

            @Override
            public int getMargins() {
                return 10;
            }

            @Override
            public boolean showLabels() {
                return false;
            }

            @Override
            public int getFontSize() {
                return Config.getInstance().getInt("touch2TipPlataFontSize", 10);
            }

            @Override
            public boolean allowTipPlata(TipPlata tp) {
                return HotelOrder.this.isTipPlataAllowed(tp, "hotelTipuriDePlata");
            }

            @Override
            public void afterEditSuma() {
                HotelOrder.this.kp.reset();
                HotelOrder.this.platiPanel.cleanPlatiLabel();
                HotelOrder.this.updateOrderTotal();
            }

            @Override
            public boolean canEditSuma() {
                return HotelOrder.this.order != null;
            }

            @Override
            public int getIdClient(boolean contAsociat) {
                if (HotelOrder.this.order == null) {
                    return -1;
                }
                return HotelOrder.this.order.getIdClient();
            }

            @Override
            public Vector<Plata> getExistingPlati() {
                if (HotelOrder.this.order != null) {
                    Vector<Plata> existingPlati = HotelOrder.this.logic.getPlatiForOrder(HotelOrder.this.order.getId(), HotelOrder.this.clientFilter1);
                    return existingPlati;
                }
                return new Vector<Plata>();
            }

            @Override
            public void addPlataToOrder(TipPlata tipPlata2, double value, String comment) {
                if (HotelOrder.this.order != null) {
                    int clientIndex = HotelOrder.this.getClientIndexForAdaugare(HotelOrder.this.clientFilter1);
                    Plata plata = new Plata(tipPlata2.getId(), value, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), comment, clientIndex);
                    HotelOrder.this.logic.addPlataToOrder(HotelOrder.this.order, plata);
                    Logger.logDebug(this, "Adaugat plata " + plata + " la order " + HotelOrder.this.order);
                }
            }

            @Override
            public double getValueForPlata(TipPlata tipPlata2) {
                if (HotelOrder.this.order != null) {
                    if (tipPlata2.getIdPromo() > 0) {
                        HotelOrder.this.logic.setClientAndPromotionForOrder(HotelOrder.this.getOrder(), HotelOrder.this.getOrder().getIdClient(), tipPlata2.getIdPromo());
                        HotelOrder.this.setPromotionText();
                        HotelOrder.this.logic.recomputePrices(HotelOrder.this.order);
                        HotelOrder.this.refreshOrderSales();
                        HotelOrder.this.updateOrderTotal();
                    }
                    double total = RestLogic.getInstance().getTotal(HotelOrder.this.order, HotelOrder.this.clientFilter1);
                    double value = HotelOrder.this.logic.getSumaForPlataNoPlataSkip(HotelOrder.this.order, tipPlata2.getId(), total, HotelOrder.this.clientFilter1);
                    String valueS = HotelOrder.this.kp.getValueS();
                    if (Validators.correctDouble(valueS)) {
                        value = HotelOrder.this.kp.getValue();
                    }
                    return value;
                }
                return 0.0;
            }
        };
    }
}

