/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.livrari;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersFizicaAddEditPanelShort;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.livrari.ClientButtonPressedInterface;
import ro.atreides.restaurant.gui.livrari.LivrariOrderPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.asterisk.AsteriskEventInterface;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.users.WaiterSelection2Interface;
import ro.atreides.users.gui.WaitersSelection2;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.PointerLaFunctieInterface;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.TransparentButton;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class LivrariMainPanel
extends ReflectedJPanel
implements CleanupRequired,
WaiterSelection2Interface,
AsteriskEventInterface {
    protected RestLogic logic;
    protected User currentUser;
    private Table table;
    private JLabel waiterName;
    public static Vector locationsAsNames;
    public static Vector sectii;
    public static boolean controllerMode;
    public static boolean autoMarcaj;
    public static boolean deleteAllPlateau;
    protected Vector locations = new Vector();
    protected int idClient = -1;
    protected JTable ordersTable;
    protected JSplitPane split;
    protected LivrariOrderPanel orderPanel;
    protected JPanel emptyPanel = new JPanel();
    protected AbstractTM tm;
    private JButton hangUp;
    private JButton comandaNoua;
    private JButton logout;
    protected JButton clientButton;
    public static String extensie;
    public static String livrariDisabledButtons;
    String _callerId = "";
    private boolean loggedIn = false;
    public static boolean marcajOnly;
    public static boolean livrariRefresh;
    public static boolean showImportButton;
    private Order currentOrder = null;
    private String adresaLivrare = null;
    public static String importOrdersGetUrl;
    public static String importOrdersFeedbackUrl;

    public LivrariMainPanel() {
        this.logic = RestLogic.getInstance();
        this.locations = this.logic.getLocationsByLocationNames(locationsAsNames);
        if (this.locations.size() == 0) {
            this.locations = this.logic.getLocations();
        }
        Logger.logDebug(this, "Ascultam eventuri asterisk pe extensia " + extensie);
        RestLogic.getInstance().addAsteriskEventListener(extensie, this);
    }

    private void display2() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.split = new JSplitPane(1);
        this.split.setDividerLocation(0.25);
        this.buildOrderPanel();
        RestLogic.getInstance().addScaleConsumer(this.orderPanel);
        this.split.setRightComponent(this.emptyPanel);
        this.split.setLeftComponent(this.getLeftPanel());
        this.add((Component)this.split, c);
        if (livrariRefresh) {
            Thread refreshOrdersTable = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        LivrariMainPanel.this.refreshOrders(LivrariMainPanel.this.currentOrder, false, true);
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            refreshOrdersTable.setName("LivrariMainPanel.refreshOrders");
            refreshOrdersTable.start();
        }
        this.loggedIn = true;
    }

    protected void buildOrderPanel() {
        this.orderPanel = new LivrariOrderPanel(this.logic, this, VpConfig.getInstance(), sectii, autoMarcaj, deleteAllPlateau, marcajOnly);
    }

    protected JPanel getOpenOrdersPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.tm = new AbstractTM(new String[]{"Comenzi in lucru"}, new Class[]{String.class}, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Order o = (Order)data.get(rowIndex);
                int idCLient = o.getIdClient();
                long started = o.getStartTime();
                Timestamp d = new Timestamp(started);
                Timestamp now = DateUtils.getCurrentTimestamp();
                String dateAndTime = "<html>";
                dateAndTime = DateUtils.sameDay(d, now) ? dateAndTime + Formatters.TIME_FORMAT.format(d) : dateAndTime + Formatters.SHORT_DATE_AND_TIME_FORMAT.format(d);
                String client = o.getId() + " ";
                if (idCLient > 0) {
                    Client c = ClientLogic.getInstance().getClientById(idCLient);
                    if (c != null) {
                        dateAndTime = dateAndTime + " " + o.getAdresaLivrare() + "<br>";
                        client = client + c.toString();
                        dateAndTime = dateAndTime + " " + client;
                    }
                    dateAndTime = dateAndTime + " = " + Utils.getString2Decimals(LivrariMainPanel.this.logic.getTotal(o));
                    dateAndTime = dateAndTime + "</html>";
                }
                return dateAndTime;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        this.ordersTable = new JTable(this.tm);
        this.ordersTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Order o = (Order)LivrariMainPanel.this.tm.getObjectAt(selRow);
                LivrariMainPanel.this.selectOrder(o, false, false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        final Font f = this.ordersTable.getFont();
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Order order1 = (Order)LivrariMainPanel.this.tm.getData().get(row);
                if (order1.getUser() == LivrariMainPanel.this.currentUser.getId()) {
                    this.setFont(new Font(null, 1, f.getSize()));
                } else {
                    this.setFont(new Font(null, 0, f.getSize()));
                }
                Color c = null;
                c = order1.isLaPlata() ? Color.BLUE : (LivrariMainPanel.this.isOrderUrgent(order1) ? Color.RED : (LivrariMainPanel.this.isOrderWarning(order1) ? Color.MAGENTA : Color.BLACK));
                this.setForeground(c);
                return this;
            }
        };
        TableColumnModel colModel = this.ordersTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRenderer);
        }
        GuiUtils.updateJTableRowSize(this.ordersTable, (int)((double)VpConfig.getInstance().touchTableFontSize * 1.5));
        JScrollPane scroll = new JScrollPane(this.ordersTable, 20, 30);
        result.add((Component)scroll, c);
        return result;
    }

    private boolean isOrderUrgent(Order o) {
        int urgentMinutes = VpConfig.getInstance().livrariUrgentMinutes;
        if (o.isLaPlata()) {
            return false;
        }
        long deadline = o.getStartTime() + (long)(60000 * urgentMinutes);
        return deadline < System.currentTimeMillis();
    }

    private boolean isOrderWarning(Order o) {
        int warningMunites = VpConfig.getInstance().livrariWarningMinutes;
        if (o.isLaPlata()) {
            return false;
        }
        long deadline = o.getStartTime() + (long)(60000 * warningMunites);
        return deadline < System.currentTimeMillis();
    }

    protected void selectOrder(Order o, boolean fromMarcaj, boolean fromRefresh) {
        if (o != null) {
            Table t1 = this.logic.getTableById(o.getTable());
            int userId = o.getUser();
            User u = UsersLogic.getInstance().getUserById(userId);
            this.orderPanel.setTable(t1, u, o, fromMarcaj, fromRefresh);
        }
        if (o != null) {
            if (this.split.getRightComponent() == this.emptyPanel) {
                this.split.remove(this.emptyPanel);
                this.split.setRightComponent(this.orderPanel);
            }
        } else if (this.split.getRightComponent() == this.orderPanel) {
            this.split.remove(this.orderPanel);
            this.split.setRightComponent(this.emptyPanel);
        }
        this.currentOrder = o;
    }

    private int getIdUser() {
        if (this.currentUser != null) {
            return this.currentUser.getId();
        }
        return -1;
    }

    protected Vector<Order> refreshOrders(Order o, boolean fromMarcaj, boolean fromRefresh) {
        Vector<Order> orders = new Vector<Order>();
        for (int i = 0; i < this.locations.size(); ++i) {
            Location location = (Location)this.locations.elementAt(i);
            Vector v1 = RestLogic.getInstance().getOpenOrders(this.idClient, -1, location.getId());
            orders.addAll(v1);
        }
        Collections.sort(orders, new Comparator(){

            public int compare(Object o1, Object o2) {
                Order or1 = (Order)o1;
                Order or2 = (Order)o2;
                int score1 = LivrariMainPanel.this.getSortScore(or1);
                int score2 = LivrariMainPanel.this.getSortScore(or2);
                return score1 - score2;
            }
        });
        this.tm.refresh(orders);
        this.selectOrder(o, fromMarcaj, fromRefresh);
        return orders;
    }

    private int getSortScore(Order or1) {
        int minutesPerYear = 525600;
        int score1 = 0;
        if (this.isOrderUrgent(or1)) {
            score1 -= 1000 * minutesPerYear;
        }
        if (this.isOrderWarning(or1)) {
            score1 -= 100 * minutesPerYear;
        }
        long l1 = or1.getStartTime() / 1000L / 60L;
        int minutes = (int)(l1 %= (long)minutesPerYear);
        score1 += minutes;
        if (or1.isLaPlata()) {
            score1 += 10 * minutesPerYear;
        }
        return score1;
    }

    String showAdresaPopup(Client c) {
        if (c != null) {
            String s = (String)DialogUtils.getItemChooserDialog(c.getAdrese(), 1, false);
            return s;
        }
        return null;
    }

    protected ClientEditDialog getClientEditDialogGeneric(JFrame parent, ClientLogic logic, Client client, boolean persJuridica, ClientEditPanelProvider panelProvider, String telefonMobilAdd, String adresaAdd, String numeAdd, String emailAdd) {
        return new ClientEditDialog(parent, logic, client, persJuridica, panelProvider, telefonMobilAdd, adresaAdd, numeAdd, emailAdd);
    }

    protected void showClientSelectDialog(ClientButtonPressedInterface inter, String callerId, String callerAdresa, String numeAdd, String emailAdd, Component parent, Order order) {
        ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanelShort();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame, callerId);
        String adresa = "";
        int sel = dia.getSelected();
        Client c = dia.getSelectedClient();
        if (sel != -1) {
            adresa = dia.getSelectedAdresa();
            if (dia.isMustEdit() || VpConfig.getInstance().showClientEditDialogAtClientSelection) {
                ClientEditDialog cDia = this.getClientEditDialogGeneric(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider, callerId, callerAdresa, numeAdd, emailAdd);
                if (order != null) {
                    int idClient = cDia.getClientId();
                    Client c1 = ClientLogic.getInstance().getClientById(idClient);
                    adresa = this.showAdresaPopup(c1);
                }
            }
        } else if (dia.isMustAdd()) {
            String phoneNumber = dia.getPhoneNumber1();
            boolean pf = true;
            if (VpConfig.getInstance().livrariAddClientPersJuridicaChoice) {
                pf = DialogUtils.confirmDialog(parent, LangRoAll.adaugamPersFizica, LangRoAll.persFizicaJuridica);
            }
            ClientEditDialog cDia = this.getClientEditDialogGeneric(GuiUtils.currentFrame, ClientLogic.getInstance(), null, !pf, provider, phoneNumber, callerAdresa, numeAdd, emailAdd);
            sel = cDia.getClientId();
        }
        if (sel != -1) {
            String allAddresses;
            Vector all;
            Client client = ClientLogic.getInstance().getClientById(sel);
            if (!Validators.correctString(adresa) && (all = Utils.splitString(allAddresses = client.getAddress1(), '|')).size() > 0) {
                adresa = (String)all.get(0);
            }
            inter.setClient(client, adresa);
        } else {
            inter.setClient(null, null);
        }
    }

    private JPanel getLeftPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        final LivrariMainPanel parent = this;
        c.weighty = 0.0;
        c.gridwidth = 3;
        this.waiterName = new JLabel(LangRoAll.neautentificat);
        this.waiterName.setFocusable(true);
        this.waiterName.setForeground(Color.RED);
        this.waiterName.setFont(new Font(null, 1, VpConfig.getInstance().touchSelectorFontSize));
        if (VpConfig.getInstance().piratMode) {
            this.whatToPrint = 2;
            this.updateWaiterFont();
            GuiUtilsRest.addPiratGuiMouseListenerForLabels(this.waiterName, new PointerLaFunctieInterface(){

                @Override
                public void doStuff() {
                    LivrariMainPanel.this.switchMode();
                    parent.requestFocus();
                }
            });
        }
        result.add((Component)this.waiterName, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.clientButton = new JButton("");
        final LivrariMainPanel current = this;
        this.clientButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LivrariMainPanel.this.showClientSelectDialog(new ClientButtonPressedInterface(){

                    @Override
                    public void setClient(Client client, String adresaLivrare) {
                        current.setClient(client, adresaLivrare);
                    }
                }, LivrariMainPanel.this._callerId, "", "", "", current, null);
            }
        });
        result.add((Component)this.clientButton, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.logout = new JButton(LangRoAll.logout);
        this.logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LivrariMainPanel.this.logout();
            }
        });
        result.add((Component)this.logout, c);
        ++c.gridx;
        this.hangUp = new JButton("Inchide client");
        this.hangUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LivrariMainPanel.this.inchideClient();
            }
        });
        result.add((Component)this.hangUp, c);
        ++c.gridx;
        this.comandaNoua = new JButton("Comanda noua");
        this.comandaNoua.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LivrariMainPanel.this.doComandaNoua();
            }
        });
        result.add((Component)this.comandaNoua, c);
        c.gridwidth = 3;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)this.getOpenOrdersPanel(), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridx = 0;
        TransparentButton xButton = new TransparentButton("<html><center>Raport X</center></html>");
        xButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User user = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                boolean isAdmin = false;
                boolean isWaiter = false;
                if (user != null) {
                    boolean canPrint = false;
                    if (user != null) {
                        if (UsersLogic.getInstance().isUserInGroup(user.getId(), "group_bo_users")) {
                            isAdmin = true;
                        }
                        if (!isAdmin && VpConfig.getInstance().touch2AllowXReportByWaiters) {
                            isWaiter = true;
                        }
                        if (isWaiter || isAdmin) {
                            canPrint = true;
                        }
                    }
                    if (canPrint) {
                        try {
                            int w1 = LivrariMainPanel.this.whatToPrint;
                            if (VpConfig.getInstance().piratMode && VpConfig.getInstance().dualModeAllowFullXReport) {
                                w1 = 1;
                            }
                            LivrariMainPanel.this.logic.printXnou(w1, user, parent, isAdmin, isWaiter);
                            if (VpConfig.getInstance().piratMode) {
                                LivrariMainPanel.this.whatToPrint = 2;
                                LivrariMainPanel.this.updateWaiterFont();
                            }
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                    } else {
                        DialogUtils.errorDialog(parent, LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)xButton, c);
        ++c.gridx;
        TransparentButton searaButton = new TransparentButton("<html><center>Inchidere zi<br></center></html>");
        searaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                boolean canPrint = false;
                if (supervizor != null) {
                    if (UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users") || VpConfig.getInstance().touch2AllowSearaReportByWaiters) {
                        canPrint = true;
                    }
                } else {
                    DialogUtils.okFocusEaterDialog(LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    return;
                }
                if (canPrint) {
                    GuiUtilsRest.searaButtonPressed(parent, LivrariMainPanel.this.logic, LivrariMainPanel.this.whatToPrint, supervizor);
                    if (VpConfig.getInstance().piratMode) {
                        LivrariMainPanel.this.whatToPrint = 2;
                        LivrariMainPanel.this.updateWaiterFont();
                    }
                } else {
                    DialogUtils.okFocusEaterDialog(LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)searaButton, c);
        ++c.gridx;
        TransparentButton admin = new TransparentButton("<html><center>" + LangRoAll.administrare + "<br></center></html>");
        admin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VpConfig.getInstance().touch2InhibitAdminButton) {
                    DialogUtils.errorDialog(parent, LangRoAll.achizitionatiModululDeGestiune, LangRoAll.nuPotContinua);
                } else {
                    GuiUtilsRest.doAdminLogin(LivrariMainPanel.this.logic);
                }
            }
        });
        result.add((Component)admin, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        TransparentButton exit = new TransparentButton("<html><center>" + LangRoAll.exit + "<br></center></html>");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = null;
                if (VpConfig.getInstance().touch2PasswordForExit) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if ((supervizor != null || !VpConfig.getInstance().touch2PasswordForExit) && DialogUtils.confirmDialog(parent, LangRoAll.doritiSaInchidetiProgramul, LangRoAll.confirmare)) {
                    Utils.systemExit();
                }
            }
        });
        result.add((Component)exit, c);
        if (marcajOnly) {
            xButton.setEnabled(false);
            searaButton.setEnabled(false);
            admin.setEnabled(false);
        }
        return result;
    }

    protected void doComandaNoua() {
        Client c;
        if (VpConfig.getInstance().livrariAdresaPopupAtComandaNoua && (c = ClientLogic.getInstance().getClientById(this.idClient)) != null) {
            this.adresaLivrare = this.showAdresaPopup(c);
        }
        this.comandaNoua(this.idClient, this.adresaLivrare);
    }

    public void inchideClient() {
        this.setClient(null, null);
        this._callerId = "";
        this.updateWaiterAndCallerId();
    }

    protected void comandaNoua(int idClient, String adresaLivrare) {
        Vector locs = new Vector();
        if (this.locations.size() > 0) {
            locs.addAll(this.locations);
        } else {
            locs = RestLogic.getInstance().getLocations();
        }
        if (VpConfig.getInstance().livrariAskForLocation) {
            Location chosen = (Location)DialogUtils.getItemChooserDialog(locs, 4, false);
            locs.clear();
            locs.add(chosen);
        }
        this.table = this.logic.getFirstFreeTable(locs);
        Order o = RestLogic.getInstance().newOrder(this.table.getId(), this.getIdUser());
        this.orderPanel.setTable(this.table, this.currentUser, o, false, false);
        if (idClient > 0) {
            RestLogic.getInstance().setClientForOrder(o, idClient, adresaLivrare);
        }
        this.refreshOrders(o, false, false);
    }

    static boolean showIstoricInformations(Order order, Client c, Component parent) {
        Date stopDate = DateUtils.getEndOfDay(new Date());
        Date startDate = DateUtils.addDaysToDate(stopDate, -365);
        startDate = DateUtils.getStartOfDay(startDate);
        double totalBonCurent = 0.0;
        if (order != null) {
            totalBonCurent = RestLogic.getInstance().getTotal(order);
        }
        double total = RestLogic.getInstance().getTotalIncasariClient(c, startDate, stopDate);
        int count = RestLogic.getInstance().getCountIncasariClient(c, startDate, stopDate);
        String perioada = Formatters.DATE_FORMAT_RO.format(startDate) + " - " + Formatters.DATE_FORMAT_RO.format(stopDate);
        Vector<String> linesForIstoric = new Vector<String>();
        linesForIstoric.add("TOTAL : " + Utils.getString2DecimalsNoTrunc(totalBonCurent + total));
        linesForIstoric.add("Numar comenzi : " + count);
        linesForIstoric.add("Observatii : ");
        Vector c1 = ContracteLogic.getInstance().getComments(c.getId());
        for (int i = 0; i < c1.size(); ++i) {
            String s = (String)c1.elementAt(i);
            linesForIstoric.add(s);
        }
        String text = Utils.getStringForJDialogList("Perioada : " + perioada, "Nu exista inregistrari in istoric", linesForIstoric);
        DialogUtils.okDialog(parent, text, "Istoric comenzi pe 1 an ; Observatii");
        return DialogUtils.confirmDialog(parent, "Acceptam clientul", LangRoAll.confirmare);
    }

    public void setClient(Client selected, String adresaLivrare) {
        String s = null;
        s = selected != null ? "<font color=\"red\">" + selected.toString() + "</font>" : LangRoAll.client;
        String clientButtonText = "<html><center>" + s + "</center></html>";
        this.clientButton.setText(clientButtonText);
        if (selected != null) {
            this.idClient = selected.getId();
            this.hangUp.setEnabled(true);
            LivrariMainPanel.showIstoricInformations(this.orderPanel.getOrder(), selected, this);
        } else {
            this.idClient = -1;
            this.hangUp.setEnabled(false);
        }
        this.adresaLivrare = adresaLivrare;
        this.refreshOrders(null, false, false);
    }

    @Override
    public void doStuff() {
        this.setLayout(new GridBagLayout());
        this.loginSequence();
    }

    public void loginSequence() {
        this.loggedIn = false;
        this.setVisible(false);
        this.removeAll();
        WaitersSelection2 waitersPanel = new WaitersSelection2(this, controllerMode, VpConfig.getInstance().requestPasswordForWaitersSelection, VpConfig.getInstance().allowPasswords, VpConfig.getInstance().waitersPerLine, VpConfig.getInstance().codAutentificareLength, VpConfig.getInstance().touchSelectorFontSize);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        waitersPanel.setTipLocatie(1);
        waitersPanel.refreshButtons();
        this.add((Component)waitersPanel, c);
        this.setVisible(true);
    }

    @Override
    public void cleanup() {
    }

    public void nota(Order o) {
        this.refreshOrders(null, false, false);
        this.inchideClient();
    }

    private void updateWaiterFont() {
        Font f = this.waiterName.getFont();
        Font f1 = null;
        switch (this.whatToPrint) {
            case 1: {
                f1 = new Font(f.getName(), 1, f.getSize());
                break;
            }
            case 2: {
                f1 = new Font(f.getName(), 0, f.getSize());
                break;
            }
            case 3: {
                f1 = new Font(f.getName(), 2, f.getSize());
                break;
            }
        }
        this.waiterName.setFont(f1);
    }

    private void logout() {
        this.orderPanel.tryLogout(this.orderPanel);
        this.loginSequence();
    }

    @Override
    public void waiterSelected(User loginUser) {
        System.out.println("S-a logat: " + loginUser);
        if (loginUser != null) {
            this.setVisible(false);
            this.removeAll();
            this.display2();
            this.setVisible(true);
            this.setUser(loginUser);
            this.inchideClient();
        }
    }

    private void setUser(User loginUser) {
        this.currentUser = loginUser;
        this.updateWaiterAndCallerId();
    }

    private void updateWaiterAndCallerId() {
        String waiterName1 = LangRoAll.neautentificat;
        if (this.currentUser != null) {
            waiterName1 = this.currentUser.getLogin();
        }
        waiterName1 = waiterName1 + " / " + this._callerId;
        this.waiterName.setText(waiterName1);
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public void hangup(String phone, String extension) {
        System.out.println("HANGUP : phone = " + phone + " extension = " + extension);
        this._callerId = "";
        this.updateWaiterAndCallerId();
    }

    @Override
    public void pickup(String phone, String extension) {
        System.out.println("PICKUP : phone = " + phone + " extension = " + extension);
        this._callerId = phone;
        if (this.loggedIn) {
            this.updateWaiterAndCallerId();
        }
    }

    static {
        extensie = "";
        livrariDisabledButtons = "";
        showImportButton = false;
        importOrdersGetUrl = null;
        importOrdersFeedbackUrl = null;
    }
}

