/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.meniuri;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.meniuri.MeniuriChooserBean;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.keypad.VirtualKeypad4;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class MeniuriChoosePanel
extends JPanel {
    private Map<String, Vector<MeniuriChooserBean>> products;
    private boolean saveAndQuit;
    private boolean saveAndContinue;
    private boolean cancel;
    private int quantity;
    private JDialog parent;

    public MeniuriChoosePanel(Map products, int quantity) {
        this.products = products;
        this.quantity = quantity;
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    public Map<String, Vector<MeniuriChooserBean>> getProducts() {
        return this.products;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean isSaveAndQuit() {
        return this.saveAndQuit;
    }

    public boolean isSaveAndContinue() {
        return this.saveAndContinue;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void display() {
        Insets insets;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.getItemsPanel(), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.gridx = 0;
        c.weighty = 0.0;
        this.add((Component)this.getBottomPanel(), c);
    }

    private JPanel getItemsPanel() {
        Insets insets;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        Set<String> set = this.products.keySet();
        String[] columns = new String[set.size()];
        int i = 0;
        Iterator<String> i$ = set.iterator();
        while (i$.hasNext()) {
            String column;
            columns[i] = column = i$.next();
            ++i;
        }
        for (i = 0; i < columns.length; ++i) {
            String optiune = columns[i];
            Dimension d = this.getSize();
            JComponent p = this.getPanelForOptiune(optiune, this.products.get(optiune), (int)(d.getWidth() / (double)columns.length), (int)(d.getHeight() * 0.9));
            result.add((Component)p, c);
            ++c.gridx;
        }
        return result;
    }

    private JPanel getBottomPanel() {
        Insets insets;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        Insets buttonMargins = new Insets(5, 5, 5, 5);
        Insets buttonInsets = new Insets(5, 5, 5, 5);
        final VirtualKeypad4 kp = new VirtualKeypad4(VpConfig.getInstance().touchSelectorFontSize, true, buttonMargins, buttonInsets, 2);
        Dimension d = new Dimension(200, 150);
        kp.setMinimumSize(d);
        kp.setMaximumSize(d);
        kp.setPreferredSize(d);
        result.add((Component)kp, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        JButton saveAndQuitB = new JButton("<html><center>" + LangRoAll.salveaza + "<br>&nbsp;</center></html>");
        saveAndQuitB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String s = kp.getValueS();
                if (Validators.correctInteger(s)) {
                    MeniuriChoosePanel.this.quantity = Integer.parseInt(s);
                } else {
                    MeniuriChoosePanel.this.quantity = 1;
                }
                MeniuriChoosePanel.this.saveAndQuit = true;
                MeniuriChoosePanel.this.parent.dispose();
            }
        });
        result.add((Component)saveAndQuitB, c);
        ++c.gridy;
        JButton saveAndCopyB = new JButton("<html><center>Salveaza si adauga<br>&nbsp;</center></html>");
        saveAndCopyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MeniuriChoosePanel.this.saveAndContinue = true;
                String s = kp.getValueS();
                if (Validators.correctInteger(s)) {
                    MeniuriChoosePanel.this.quantity = Integer.parseInt(s);
                } else {
                    MeniuriChoosePanel.this.quantity = 1;
                }
                MeniuriChoosePanel.this.parent.dispose();
            }
        });
        result.add((Component)saveAndCopyB, c);
        ++c.gridy;
        JButton renuntaB = new JButton("<html><center>" + LangRoAll.renunta + "<br>&nbsp;</center></html>");
        renuntaB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MeniuriChoosePanel.this.cancel = true;
                MeniuriChoosePanel.this.parent.dispose();
            }
        });
        result.add((Component)renuntaB, c);
        return result;
    }

    private JComponent getPanelForOptiune(final String optiune, final Vector<MeniuriChooserBean> produse, int width, int height) {
        final AbstractListPanel alp = new AbstractListPanel(){

            @Override
            public AbstractTM buildTableModel() {
                return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        MeniuriChooserBean mb = (MeniuriChooserBean)data.elementAt(rowIndex);
                        return "";
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                return produse;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{optiune};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public void doStuff() {
                this.display();
                this.table.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        Object o = tm.getObjectAt(selRow);
                        MeniuriChooserBean current = (MeniuriChooserBean)o;
                        MeniuriChoosePanel.this.selectItem(produse, current);
                        int modifiers = e.getModifiers();
                        if ((modifiers & 8) > 0 || (modifiers & 4) > 0 || e.getClickCount() >= 2) {
                            String mp = GuiUtilsRest.chooseModPreparare(current.getIdProduct(), current.getNumeProdus(), current.getOptiuni());
                            current.setOptiuni(mp);
                        }
                        tm.fireTableDataChanged();
                    }
                });
            }
        };
        alp.doStuff();
        JTable t = alp.getJTable();
        int fontSize = VpConfig.getInstance().touch2TotalFontSize;
        Font font = new Font(null, 0, fontSize);
        t.setFont(font);
        alp.setPreferredSize(new Dimension(width, height));
        GuiUtils.updateJTableRowSize(t, (int)((double)VpConfig.getInstance().touchTableFontSize * 1.5));
        t.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                MeniuriChooserBean mb = (MeniuriChooserBean)alp.getTm().getObjectAt(row);
                return MeniuriChoosePanel.this.getPanelForTable(mb);
            }
        });
        JScrollPane scroll = new JScrollPane(alp, 20, 30);
        scroll.setPreferredSize(new Dimension(width, height));
        scroll.setMinimumSize(new Dimension(width, height));
        scroll.setMaximumSize(new Dimension(width, height));
        int SCROLLBAR_SIZE = 20;
        GuiUtils.setScrollSize(scroll, SCROLLBAR_SIZE);
        if (produse.size() == 1) {
            MeniuriChooserBean current = produse.get(0);
            this.selectItem(produse, current);
        }
        return scroll;
    }

    private JPanel getPanelForTable(MeniuriChooserBean mb) {
        Insets insets;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        JMultilineLabel numeProdus = new JMultilineLabel();
        numeProdus.setMargin(insets);
        numeProdus.setText(mb.getNumeProdus());
        result.add((Component)numeProdus, c);
        if (mb.isSelected()) {
            result.setBackground(Color.YELLOW);
            result.setForeground(Color.BLACK);
        } else {
            result.setBackground(Color.WHITE);
            result.setForeground(Color.BLACK);
        }
        String optiuni = mb.getOptiuni();
        if (optiuni != null) {
            ++c.gridy;
            JMultilineLabel o = new JMultilineLabel();
            o.setMargin(insets);
            o.setText(optiuni);
            result.add((Component)o, c);
        }
        ++c.gridy;
        c.weighty = 1.0;
        result.add((Component)new JLabel(), c);
        return result;
    }

    private void selectItem(Vector<MeniuriChooserBean> items, MeniuriChooserBean toSelect) {
        for (MeniuriChooserBean item : items) {
            if (item.equals(toSelect)) {
                item.setSelected(true);
                continue;
            }
            item.setSelected(false);
        }
    }
}

