/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.orders;

import java.awt.Font;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;

public class ProductTreePanel {
    private static DefaultMutableTreeNode _rootNode;
    private TreePath oldPath;
    private JTree _productsList;
    private Font font;

    public ProductTreePanel(Vector allowedSectii) {
        this(allowedSectii, null);
    }

    public ProductTreePanel(Vector allowedSectii, Font font) {
        this.font = font;
        this.buildProductList(allowedSectii);
    }

    public JTree getProductTree() {
        return this._productsList;
    }

    public void refreshProductList(Vector allowedSectii) {
        _rootNode = null;
        this.oldPath = null;
        this._productsList = null;
        this.buildProductList(allowedSectii);
    }

    private void buildProductList(Vector allowedSectii) {
        if (_rootNode == null) {
            _rootNode = new DefaultMutableTreeNode();
            this.addNodes(_rootNode, allowedSectii);
        }
        this._productsList = new JTree(_rootNode);
        if (this.font != null) {
            this._productsList.setFont(this.font);
        }
        this._productsList.getSelectionModel().setSelectionMode(1);
        this._productsList.setRootVisible(false);
        this._productsList.setToggleClickCount(1);
        this._productsList.setShowsRootHandles(false);
        this._productsList.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                boolean collapse = VpConfig.getInstance().productTreeCollapse;
                if (ProductTreePanel.this.oldPath != null && collapse) {
                    ProductTreePanel.this._productsList.collapsePath(ProductTreePanel.this.oldPath);
                }
                ProductTreePanel.this.oldPath = event.getPath();
                ProductTreePanel.this._productsList.scrollPathToVisible(event.getPath());
            }
        });
    }

    private void addNodes(DefaultMutableTreeNode rootTableNode, Vector allowedSectii) {
        Vector subcat = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1);
        for (Categorie sc : subcat) {
            Sectie sectie = NomeclaturaLogic.getInstance().getSectieByCategoryId(sc.getId());
            if (allowedSectii != null && allowedSectii.size() != 0 && !allowedSectii.contains(sectie.getName())) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(sc);
            Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(sc);
            for (Product p : products) {
                DefaultMutableTreeNode dp = new DefaultMutableTreeNode(p);
                node.add(dp);
            }
            if (products.size() <= 0) continue;
            rootTableNode.add(node);
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

