/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.AdaosReportEntry;
import ro.atreides.restaurant.gui.reports.AdaosReportCellRenderer;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NotEnoughIngredientsException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class AdaosReportPanel
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.produs, Utils.getTranslation(LangRoAll.pretVz, new String[0]), Utils.getTranslation(LangRoAll.valoareIngrediente), Utils.getTranslation(LangRoAll.suma), Utils.getTranslation(LangRoAll.adaosCoeficient), Utils.getTranslation(LangRoAll.adaosProcentual)};
    private ReportInterface reportInterface;
    private AbstractTM tm;
    private JButton stergeSelectia;
    private JButton preturiCfAdaos;
    private JButton invertSelection;
    private Vector selectedItems = new Vector();
    private JLabel selectateLabel;
    private AdaosReportCellRenderer cellRenderer;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable result = new Hashtable();
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        Vector result = RestLogic.getInstance().getAdaosReport(criteria);
        this.clearSelection();
        return result;
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    AdaosReportEntry entry = (AdaosReportEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(1, row, entry.getPretVanzare()));
                        sheet.addCell((WritableCell)new Number(2, row, entry.getValIngrediente()));
                        sheet.addCell((WritableCell)new Number(3, row, entry.getDiffValoare()));
                        sheet.addCell((WritableCell)new Number(4, row, entry.getAdaosCoef()));
                        sheet.addCell((WritableCell)new Number(5, row, entry.getAdaosProcent()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return AdaosReportPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, new Hashtable());
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.raportAdaos, new String[0]);
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                AdaosReportEntry e = (AdaosReportEntry)data.elementAt(rowIndex);
                String s = (String)aValue;
                if (!Validators.correctDouble(s)) {
                    return;
                }
                double value = Utils.parseDouble(s);
                switch (columnIndex) {
                    case 1: {
                        e.computeByPretVanzare(value);
                        break;
                    }
                    case 3: {
                        e.computeByAdaosDiferenta(value);
                        break;
                    }
                    case 4: {
                        e.computeByAdaosCoeficient(value);
                        break;
                    }
                    case 5: {
                        e.computeByAdaosProcent(value);
                    }
                }
                AdaosReportPanel.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                RestLogic.getInstance().setPriceForRetetaProduct(e.getIdReteta(), value, true);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 1: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                    case 4: {
                        return true;
                    }
                    case 5: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                AdaosReportEntry e = (AdaosReportEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getProdus();
                    }
                    case 1: {
                        return e.isCompleted() ? Utils.getString2Decimals(e.getPretVanzare()) : "";
                    }
                    case 2: {
                        return e.isCompleted() ? Utils.getString2Decimals(e.getValIngrediente()) : "";
                    }
                    case 3: {
                        return e.isCompleted() ? Utils.getString2Decimals(e.getDiffValoare()) : "";
                    }
                    case 4: {
                        return e.isCompleted() ? Utils.getString2Decimals(e.getAdaosCoef()) : "";
                    }
                    case 5: {
                        return e.isCompleted() ? Utils.getString2Decimals(e.getAdaosProcent()) : "";
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.selectate, new String[0])), c);
        ++c.gridx;
        this.selectateLabel = new JLabel("");
        result.add((Component)this.selectateLabel, c);
        ++c.gridx;
        this.invertSelection = new JButton(Utils.getTranslation(LangRoAll.inverseazaSelectia, new String[0]));
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                for (int i = 0; i < AdaosReportPanel.this.data.size(); ++i) {
                    AdaosReportEntry pve = (AdaosReportEntry)AdaosReportPanel.this.data.elementAt(i);
                    if (pve.isSelected()) {
                        pve.setSelected(false);
                        AdaosReportPanel.this.selectedItems.remove(pve);
                        continue;
                    }
                    AdaosReportPanel.this.selectedItems.add(pve);
                    pve.setSelected(true);
                }
                AdaosReportPanel.this.selectateLabel.setText(AdaosReportPanel.this.selectedItems.size() + "");
                AdaosReportPanel.this.tm.fireTableDataChanged();
            }
        });
        result.add((Component)this.invertSelection, c);
        ++c.gridx;
        this.stergeSelectia = new JButton(Utils.getTranslation(LangRoAll.stergeSelectia));
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AdaosReportPanel.this.clearSelection();
            }
        });
        result.add((Component)this.stergeSelectia, c);
        final AdaosReportPanel panel = this;
        ++c.gridx;
        this.preturiCfAdaos = new JButton(Utils.getTranslation(LangRoAll.modificaPreturiCfAdaos, new String[0]));
        this.preturiCfAdaos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.confirmareModificamPreturi, new String[0]), LangRoAll.confirmare)) {
                    return;
                }
                String adaosNou = DialogUtils.inputDialog(panel, "", Utils.getTranslation(LangRoAll.noulAdaos, new String[0]));
                if (!Validators.correctDouble(adaosNou)) {
                    DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.adaosNaN, new String[0]), LangRoAll.nuPotContinua);
                    return;
                }
                String nrZecimale = DialogUtils.inputDialog(panel, "2", Utils.getTranslation(LangRoAll.zecimaleRotunjire, new String[0]));
                if (!Validators.correctInteger(nrZecimale)) {
                    DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.integerRequired, new String[0]), LangRoAll.nuPotContinua);
                    return;
                }
                for (int i = 0; i < AdaosReportPanel.this.selectedItems.size(); ++i) {
                    AdaosReportEntry adaosReportEntry = (AdaosReportEntry)AdaosReportPanel.this.selectedItems.elementAt(i);
                    AdaosReportPanel.this.modificaPreturiDupaAdaos(adaosReportEntry, Utils.parseDouble(adaosNou), Integer.parseInt(nrZecimale));
                }
                AdaosReportPanel.this.tm.fireTableDataChanged();
                AdaosReportPanel.this.clearSelection();
            }
        });
        result.add((Component)this.preturiCfAdaos, c);
        return result;
    }

    private void modificaPreturiDupaAdaos(AdaosReportEntry entry, double adaos, int nrZecimaleRotunjire) {
        entry.computeByAdaosProcent(adaos);
        double pretNou = entry.getPretVanzare();
        pretNou = FloatUtils.roundFloat(pretNou, nrZecimaleRotunjire);
        entry.computeByPretVanzare(pretNou);
        if (entry.getIdReteta() > 0) {
            RestLogic.getInstance().setPriceForRetetaProduct(entry.getIdReteta(), entry.getPretVanzare(), false);
        } else if (entry.getIdStock() > 0) {
            StockLogic.getInstance().updatePriceForStock(entry.getIdStock(), pretNou);
        }
    }

    private void clearSelection() {
        this.selectedItems.clear();
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                AdaosReportEntry stockViewEntry = (AdaosReportEntry)this.data.elementAt(i);
                stockViewEntry.setSelected(false);
            }
        }
        this.tm.fireTableDataChanged();
        this.selectateLabel.setText("0");
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.cellRenderer = new AdaosReportCellRenderer(this.tm);
        this.updateJTableColumns(this.table);
        this.table.setSelectionMode(0);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return Utils.getTranslation(LangRoAll.raportAdaos, new String[0]);
            }

            @Override
            public Hashtable getCriteria() {
                return new Hashtable();
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                AdaosReportEntry e = (AdaosReportEntry)row;
                switch (column) {
                    case 0: {
                        return e.getProdus();
                    }
                    case 1: {
                        return Utils.getString2Decimals(e.getPretVanzare());
                    }
                    case 2: {
                        return Utils.getString2Decimals(e.getValIngrediente());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getDiffValoare());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getAdaosCoef());
                    }
                    case 5: {
                        return Utils.getString2Decimals(e.getAdaosProcent());
                    }
                }
                return null;
            }
        };
        final AdaosReportPanel parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final AdaosReportEntry entry = (AdaosReportEntry)AdaosReportPanel.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    if (!entry.isSelected()) {
                        AdaosReportPanel.this.selectedItems.add(entry);
                    } else {
                        AdaosReportPanel.this.selectedItems.remove(entry);
                    }
                    entry.setSelected(!entry.isSelected());
                    AdaosReportPanel.this.tm.fireTableRowsUpdated(selRow, selRow);
                    AdaosReportPanel.this.selectateLabel.setText(AdaosReportPanel.this.selectedItems.size() + "");
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem verifica = new JMenuItem(LangRoAll.verifica);
                popup.add(verifica);
                verifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Vector stack = new Vector();
                            RestLogic.getInstance().getPretIngredienteCommit(entry.getIdReteta(), new NotEnoughIngredientsException(), stack);
                            DialogUtils.okDialog(parent, Utils.getTranslation(LangRoAll.toateIngredienteleSuntPeStoc, new String[0]), LangRoAll.succes);
                        }
                        catch (NotEnoughIngredientsException e1) {
                            Vector missing = e1.getMissing();
                            String adaosText = RestLogic.getInstance().getAdaosNecesar(missing);
                            DialogUtils.errorDialog(parent, adaosText, LangRoAll.nuPotContinua);
                            return;
                        }
                        popup.setVisible(false);
                    }
                });
                popup.setInvoker(AdaosReportPanel.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(this.cellRenderer);
        }
    }
}

