/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.WriteException;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.SalesExcelProcessor;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class CentralizareComenziReport
extends AbstractReportPanel
implements CleanupRequired {
    protected JLabel _categoryLabel;
    protected JLabel _subcategoryLabel;
    protected JLabel _productsLabel;
    protected JLabel locatieLabel;
    protected JComboBox _categoryComboBox;
    protected JComboBox _subCategoryComboBox;
    protected JComboBox _productsComboBox;
    protected JComboBox locatieCombo;
    protected JMultilineLabel _salesTotalLabel;
    private RestLogic logic;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JButton creareBonTransfer;
    private JButton stergeSelectia;
    private JButton selectAll;
    private JButton stergeProduse;
    private static final String[] columns = new String[]{LangRoAll.sectie, LangRoAll.categorie, LangRoAll.produs, LangRoAll.unitati, LangRoAll.pret, LangRoAll.valoare};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, Double.class, Double.class, Double.class};
    private static Comparator category_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getCategory();
            String c2 = ((SalesEntry)o2).getCategory();
            return c1.compareTo(c2);
        }
    };
    private static Comparator subcategory_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getSubcategory();
            String c2 = ((SalesEntry)o2).getSubcategory();
            return c1.compareTo(c2);
        }
    };
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getProduct();
            String c2 = ((SalesEntry)o2).getProduct();
            return c1.compareTo(c2);
        }
    };
    private static Comparator quantity_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((SalesEntry)o1).getQuantity());
            Double c2 = new Double(((SalesEntry)o2).getQuantity());
            return c1.compareTo(c2);
        }
    };
    private static Comparator value_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((SalesEntry)o1).getTotalValue());
            Double c2 = new Double(((SalesEntry)o2).getTotalValue());
            return c1.compareTo(c2);
        }
    };
    private static Comparator price_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((SalesEntry)o1).getPrice());
            Double c2 = new Double(((SalesEntry)o2).getPrice());
            return c1.compareTo(c2);
        }
    };

    public CentralizareComenziReport() {
        this.logic = RestLogic.getInstance();
    }

    protected void buildAddObjects() {
        this._categoryLabel = new JLabel(LangRoAll.sectie);
        this._categoryComboBox = new JComboBox();
        this._subcategoryLabel = new JLabel(LangRoAll.categorie);
        this._subCategoryComboBox = new JComboBox();
        this._productsLabel = new JLabel(LangRoAll.produs);
        this._productsComboBox = new JComboBox();
        this._productsComboBox.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.locatieCombo = new JComboBox();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this._categoryComboBox)) {
            Sectie cat = (Sectie)this._categoryComboBox.getSelectedItem();
            result.put("category", cat);
            this.printCriteria.put(LangRoAll.sectie, cat.getName());
        } else {
            this.printCriteria.remove(LangRoAll.sectie);
        }
        if (ComboUtils.anythingButAllSelected(this._subCategoryComboBox)) {
            Categorie subcat = (Categorie)this._subCategoryComboBox.getSelectedItem();
            result.put("subcategory", subcat);
            this.printCriteria.put(LangRoAll.categorie, subcat.getName());
        } else {
            this.printCriteria.remove(LangRoAll.categorie);
        }
        if (ComboUtils.anythingButAllSelected(this._productsComboBox)) {
            Product p = (Product)this._productsComboBox.getSelectedItem();
            result.put("product", p.getId());
            this.printCriteria.put(LangRoAll.produs, p.getName());
        } else {
            this.printCriteria.remove(LangRoAll.produs);
        }
        if (ComboUtils.anythingButAllSelected(this.locatieCombo)) {
            Location l = (Location)this.locatieCombo.getSelectedItem();
            result.put(Constants.LOCATIE_KEY, l.getId());
            this.printCriteria.put(Constants.LOCATIE_KEY, l.getName());
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        result.put("Tip_Order", (Object)Order.TIP_ORDER.COMANDA);
        this.printCriteria.put("Tip_Order", Order.TIP_ORDER.COMANDA);
        result.put(Constants.GRUPARE_KEY, "Dupa id sale");
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getSalesReport(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new SalesExcelProcessor(), this.printCriteria);
        }
        catch (WriteException e2) {
            Logger.logException(this, (Exception)((Object)e2));
        }
        catch (IOException e1) {
            Logger.logException(this, (Exception)e1);
        }
    }

    @Override
    public String getName() {
        return LangRoAll.vanzari;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                SalesEntry se = (SalesEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getCategory();
                    }
                    case 1: {
                        return se.getSubcategory();
                    }
                    case 2: {
                        return se.getProduct();
                    }
                    case 3: {
                        return new Double(se.getQuantity());
                    }
                    case 4: {
                        return new Double(se.getPrice());
                    }
                    case 5: {
                        return new Double(se.getTotalValue());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public void exportToXml() {
        String inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xml");
        if (inputFile != null) {
            this.logic.exportSalesToXml(this.printCriteria, this.tm.getData(), inputFile, 0.0, 0, System.currentTimeMillis(), "");
            DialogUtils.okDialog(this, LangRoAll.operatieExecutata, LangRoAll.succes);
        }
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this._salesTotalLabel = new JMultilineLabel();
        this._salesTotalLabel.setText(LangRoAll.total);
        result.add((Component)this._salesTotalLabel, c);
        final CentralizareComenziReport parent = this;
        ++c.gridx;
        this.creareBonTransfer = new JButton("Creare bon transfer");
        this.creareBonTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!DialogUtils.confirmDialog(parent, "Cream bon transfer pentru produsele selectate", LangRoAll.confirmare)) {
                    return;
                }
                Vector<StockTransferItem> toAdd = new Vector<StockTransferItem>();
                for (int i : CentralizareComenziReport.this.table.getSelectedRows()) {
                    SalesEntry se = (SalesEntry)CentralizareComenziReport.this.data.elementAt(i);
                    StockTransferItem bci = new StockTransferItem();
                    bci.setQuantity(se.getQuantity());
                    bci.setDenumire(se.getProduct());
                    int idProduct = se.getIdProduct();
                    int idStock = CentralizareComenziReport.this.logic.getIdStock(idProduct);
                    if (idStock <= 0) continue;
                    bci.setIdStock(idStock);
                    double pretIesire = StockLogic.getInstance().getCatalogPriceForStock(idStock);
                    if (pretIesire < 0.0) {
                        pretIesire = 0.0;
                    }
                    bci.setSellPrice(pretIesire);
                    bci.setBuyPrice(0.0);
                    toAdd.add(bci);
                }
                StockLogic.getInstance().getAddTransferPanel().addEntries(toAdd);
                DialogUtils.okDialog(parent, "Produsele au fost adaugate in ecranul \"Stocuri - Adauga transfer\". Setati corect magaziile !!", LangRoAll.succes);
            }
        });
        result.add((Component)this.creareBonTransfer, c);
        ++c.gridx;
        this.stergeSelectia = new JButton(LangRoAll.stergeSelectia);
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CentralizareComenziReport.this.table.clearSelection();
            }
        });
        result.add((Component)this.stergeSelectia, c);
        ++c.gridx;
        this.selectAll = new JButton(LangRoAll.selecteazaToate);
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CentralizareComenziReport.this.table.selectAll();
            }
        });
        result.add((Component)this.selectAll, c);
        ++c.gridx;
        this.stergeProduse = new JButton(LangRoAll.sterge);
        this.stergeProduse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = CentralizareComenziReport.this.table.getSelectedRows();
                if (DialogUtils.confirmDialog(parent, "Stergem " + selected.length + " produse", LangRoAll.confirmare)) {
                    CentralizareComenziReport.this.logic.deleteComanda(selected, CentralizareComenziReport.this.data);
                    CentralizareComenziReport.this.raport();
                }
            }
        });
        result.add((Component)this.stergeProduse, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        this.buildAddObjects();
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        categPanel.add((Component)this._categoryLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._categoryComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this._subcategoryLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._subCategoryComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this._productsLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._productsComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.locatieLabel = new JLabel(LangRoAll.locatie);
        categPanel.add((Component)this.locatieLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.locatieCombo, c);
        return categPanel;
    }

    @Override
    public void refreshTotalPanel() {
        String newLabel = LangRoAll.valoareTotala + ": " + Utils.getString2Decimals(this.getTotalValue());
        this._salesTotalLabel.setText(newLabel);
    }

    @Override
    public void doStuff() {
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 1;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 5: {
                        return Utils.getString2Decimals(CentralizareComenziReport.this.getTotalValue());
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return CentralizareComenziReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CentralizareComenziReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                SalesEntry ie = (SalesEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getCategory();
                    }
                    case 1: {
                        return ie.getSubcategory();
                    }
                    case 2: {
                        return ie.getProduct();
                    }
                    case 3: {
                        return Utils.getString3Decimals(ie.getQuantity());
                    }
                    case 4: {
                        return Utils.getString2Decimals(ie.getPrice());
                    }
                    case 5: {
                        return Utils.getString2Decimals(ie.getTotalValue());
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                if (column == 0) {
                    double totalValue = CentralizareComenziReport.this.getTotalValue();
                    String s = "";
                    s = s + LangRoAll.total.toUpperCase() + Utils.getString2Decimals(totalValue);
                    return s;
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return CentralizareComenziReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CentralizareComenziReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                if (column == 0) {
                    SalesEntry se = (SalesEntry)row;
                    String product = se.getProduct();
                    double quantity = se.getQuantity();
                    String total = Utils.getString2Decimals(se.getTotalValue());
                    return product + "|" + Utils.getString3Decimals(quantity) + "|" + total;
                }
                return "";
            }
        };
        ComboUtils.replaceItemsForCombo(this.locatieCombo, RestLogic.getInstance().getLocations());
        ComboUtils.replaceItemsForCombo(this._categoryComboBox, RestLogic.getInstance().getSectii());
        ComboUtils.replaceItemsForCombo(this._subCategoryComboBox, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1));
        this.rebuildAllProducts();
        this._categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(CentralizareComenziReport.this._categoryComboBox)) {
                    Sectie cat = (Sectie)CentralizareComenziReport.this._categoryComboBox.getSelectedItem();
                    Vector subcats = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(cat.getId());
                    ComboUtils.replaceItemsForCombo(CentralizareComenziReport.this._subCategoryComboBox, subcats);
                } else {
                    ComboUtils.replaceItemsForCombo(CentralizareComenziReport.this._subCategoryComboBox, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1));
                }
            }
        });
        this._subCategoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(CentralizareComenziReport.this._subCategoryComboBox)) {
                    Categorie subcat = (Categorie)CentralizareComenziReport.this._subCategoryComboBox.getSelectedItem();
                    Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(subcat);
                    ComboUtils.replaceItemsForCombo(CentralizareComenziReport.this._productsComboBox, products);
                } else {
                    CentralizareComenziReport.this.rebuildAllProducts();
                }
            }
        });
        this.table.setSelectionMode(2);
    }

    private void rebuildAllProducts() {
        Vector<Product> all = NomeclaturaLogic.getInstance().getAllProducts(1);
        Collections.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = ((Product)o1).getName();
                String c2 = ((Product)o2).getName();
                return c1.compareToIgnoreCase(c2);
            }
        });
        ComboUtils.replaceItemsForCombo(this._productsComboBox, all);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return category_sorter;
            }
            case 1: {
                return subcategory_sorter;
            }
            case 2: {
                return product_sorter;
            }
            case 3: {
                return quantity_sorter;
            }
            case 4: {
                return price_sorter;
            }
            case 5: {
                return value_sorter;
            }
        }
        return null;
    }

    private double getTotalValue() {
        double totalValue = 0.0;
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            totalValue += ((SalesEntry)i.next()).getTotalValue();
        }
        return totalValue;
    }

    @Override
    public void cleanup() {
    }
}

