/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IncasareClientView;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ClientiIncasariReport
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.client, LangRoAll.data, Utils.getTranslation(LangRoAll.incasari), LangRoAll.discount};
    private JComboBox clientiAll;
    private JComboBox angajati;
    private RestLogic logic;
    private JLabel totalSuma;
    private JLabel totalDiscount;
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();

    public ClientiIncasariReport() {
        this.logic = RestLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object client = this.clientiAll.getSelectedItem();
        if (client instanceof ClientPersJuridica) {
            result.put("client_pj", client);
            if (ComboUtils.anythingButAllSelected(this.angajati)) {
                Object c2 = this.angajati.getSelectedItem();
                result.put("client_pf", c2);
            }
        } else if (client instanceof ClientPersFizica) {
            result.put("client_pf", client);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientiAll = new JComboBox();
        result.add((Component)this.clientiAll, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.angajat), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.angajati = new JComboBox();
        result.add((Component)this.angajati, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IncasareClientView v = (IncasareClientView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return v.getClient();
                    }
                    case 1: {
                        return v.getData();
                    }
                    case 2: {
                        return Utils.getString2Decimals(v.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(v.getDiscount());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalSuma = new JLabel("");
        result.add((Component)this.totalSuma, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.discount)), c);
        ++c.gridx;
        this.totalDiscount = new JLabel("");
        result.add((Component)this.totalDiscount, c);
        return result;
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.incasariClienti, new String[0]);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getIncasariClienti(criteria, this.whatToPrint);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    public void updateTotals(Vector items) {
        double suma = 0.0;
        double discount = 0.0;
        for (IncasareClientView element : items) {
            suma += element.getTotal();
            discount += element.getDiscount();
        }
        this.totalSuma.setText(Utils.getString2Decimals(suma));
        this.totalDiscount.setText(Utils.getString2Decimals(discount));
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    IncasareClientView v = (IncasareClientView)o;
                    try {
                        Label label = new Label(0, row, v.getClient());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, v.getData());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(2, row, v.getTotal()));
                        sheet.addCell((WritableCell)new Number(3, row, v.getDiscount()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return ClientiIncasariReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.clientiAll, ClientLogic.getInstance().getAllClientsSorted());
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return ClientiIncasariReport.this.totalSuma.getText();
                    }
                    case 3: {
                        return ClientiIncasariReport.this.totalDiscount.getText();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return ClientiIncasariReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ClientiIncasariReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                IncasareClientView v = (IncasareClientView)row;
                switch (column) {
                    case 0: {
                        return v.getClient();
                    }
                    case 1: {
                        return v.getData();
                    }
                    case 2: {
                        return Utils.getString2Decimals(v.getTotal());
                    }
                    case 3: {
                        return Utils.getString2Decimals(v.getDiscount());
                    }
                }
                return null;
            }
        };
        final ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "ClientiIncasariReport_persJuridice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(ClientiIncasariReport.this.clientiAll, ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "ClientiIncasariReport_persFizice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(ClientiIncasariReport.this.clientiAll, ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
        this.clientiAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(ClientiIncasariReport.this.clientiAll)) {
                    Client c = (Client)ClientiIncasariReport.this.clientiAll.getSelectedItem();
                    if (c instanceof ClientPersJuridica) {
                        ClientPersJuridica c1 = (ClientPersJuridica)c;
                        Vector angajatiForCompanie = clientLogic.getAnjagati(c1.getIdPersJuridica());
                        ComboUtils.replaceItemsForCombo(ClientiIncasariReport.this.angajati, angajatiForCompanie);
                    } else {
                        ComboUtils.replaceItemsForCombo(ClientiIncasariReport.this.angajati, new Vector());
                    }
                } else {
                    ComboUtils.replaceItemsForCombo(ClientiIncasariReport.this.angajati, new Vector());
                }
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

